% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_list_types}
\alias{cloudformation_list_types}
\title{Returns summary information about types that have been registered with
CloudFormation}
\usage{
cloudformation_list_types(Visibility, ProvisioningType,
  DeprecatedStatus, Type, MaxResults, NextToken)
}
\arguments{
\item{Visibility}{The scope at which the type is visible and usable in CloudFormation
operations.

Valid values include:
\itemize{
\item \code{PRIVATE}: The type is only visible and usable within the account in
which it is registered. Currently, AWS CloudFormation marks any
types you create as \code{PRIVATE}.
\item \code{PUBLIC}: The type is publically visible and usable within any
Amazon account.
}

The default is \code{PRIVATE}.}

\item{ProvisioningType}{The provisioning behavior of the type. AWS CloudFormation determines the
provisioning type during registration, based on the types of handlers in
the schema handler package submitted.

Valid values include:
\itemize{
\item \code{FULLY_MUTABLE}: The type includes an update handler to process
updates to the type during stack update operations.
\item \code{IMMUTABLE}: The type does not include an update handler, so the
type cannot be updated and must instead be replaced during stack
update operations.
\item \code{NON_PROVISIONABLE}: The type does not include create, read, and
delete handlers, and therefore cannot actually be provisioned.
}}

\item{DeprecatedStatus}{The deprecation status of the types that you want to get summary
information about.

Valid values include:
\itemize{
\item \code{LIVE}: The type is registered for use in CloudFormation operations.
\item \code{DEPRECATED}: The type has been deregistered and can no longer be
used in CloudFormation operations.
}}

\item{Type}{The type of extension.}

\item{MaxResults}{The maximum number of results to be returned with a single call. If the
number of available results exceeds this maximum, the response includes
a \code{NextToken} value that you can assign to the \code{NextToken} request
parameter to get the next set of results.}

\item{NextToken}{If the previous paginated request didn't return all of the remaining
results, the response object's \code{NextToken} parameter value is set to a
token. To retrieve the next set of results, call this action again and
assign that token to the request object's \code{NextToken} parameter. If
there are no remaining results, the previous response object's
\code{NextToken} parameter is set to \code{null}.}
}
\value{
A list with the following syntax:\preformatted{list(
  TypeSummaries = list(
    list(
      Type = "RESOURCE"|"MODULE",
      TypeName = "string",
      DefaultVersionId = "string",
      TypeArn = "string",
      LastUpdated = as.POSIXct(
        "2015-01-01"
      ),
      Description = "string"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Returns summary information about types that have been registered with
CloudFormation.
}
\section{Request syntax}{
\preformatted{svc$list_types(
  Visibility = "PUBLIC"|"PRIVATE",
  ProvisioningType = "NON_PROVISIONABLE"|"IMMUTABLE"|"FULLY_MUTABLE",
  DeprecatedStatus = "LIVE"|"DEPRECATED",
  Type = "RESOURCE"|"MODULE",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
