% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_label_parameter_version}
\alias{ssm_label_parameter_version}
\title{A parameter label is a user-defined alias to help you manage different
versions of a parameter}
\usage{
ssm_label_parameter_version(Name, ParameterVersion, Labels)
}
\arguments{
\item{Name}{[required] The parameter name on which you want to attach one or more labels.}

\item{ParameterVersion}{The specific version of the parameter on which you want to attach one or
more labels. If no version is specified, the system attaches the label
to the latest version.)}

\item{Labels}{[required] One or more labels to attach to the specified parameter version.}
}
\description{
A parameter label is a user-defined alias to help you manage different
versions of a parameter. When you modify a parameter, Systems Manager
automatically saves a new version and increments the version number by
one. A label can help you remember the purpose of a parameter when there
are multiple versions.
}
\details{
Parameter labels have the following requirements and restrictions.
\itemize{
\item A version of a parameter can have a maximum of 10 labels.
\item You can't attach the same label to different versions of the same
parameter. For example, if version 1 has the label Production, then
you can't attach Production to version 2.
\item You can move a label from one version of a parameter to another.
\item You can't create a label when you create a new parameter. You must
attach a label to a specific version of a parameter.
\item You can't delete a parameter label. If you no longer want to use a
parameter label, then you must move it to a different version of a
parameter.
\item A label can have a maximum of 100 characters.
\item Labels can contain letters (case sensitive), numbers, periods (.),
hyphens (-), or underscores (\_).
\item Labels can't begin with a number, "aws," or "ssm" (not case
sensitive). If a label fails to meet these requirements, then the
label is not associated with a parameter and the system displays it
in the list of InvalidLabels.
}
}
\section{Request syntax}{
\preformatted{svc$label_parameter_version(
  Name = "string",
  ParameterVersion = 123,
  Labels = list(
    "string"
  )
)
}
}

\keyword{internal}
