# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include licensemanager_service.R
NULL

#' Creates a new license configuration object
#'
#' Creates a new license configuration object. A license configuration is
#' an abstraction of a customer license agreement that can be consumed and
#' enforced by License Manager. Components include specifications for the
#' license type (licensing by instance, socket, CPU, or VCPU), tenancy
#' (shared tenancy, Amazon EC2 Dedicated Instance, Amazon EC2 Dedicated
#' Host, or any of these), host affinity (how long a VM must be associated
#' with a host), the number of licenses purchased and used.
#'
#' @usage
#' licensemanager_create_license_configuration(Name, Description,
#'   LicenseCountingType, LicenseCount, LicenseCountHardLimit, LicenseRules,
#'   Tags)
#'
#' @param Name &#91;required&#93; Name of the license configuration.
#' @param Description Human-friendly description of the license configuration.
#' @param LicenseCountingType &#91;required&#93; Dimension to use to track the license inventory.
#' @param LicenseCount Number of licenses managed by the license configuration.
#' @param LicenseCountHardLimit Flag indicating whether hard or soft license enforcement is used.
#' Exceeding a hard limit results in the blocked deployment of new
#' instances.
#' @param LicenseRules Array of configured License Manager rules.
#' @param Tags The tags to apply to the resources during launch. You can only tag
#' instances and volumes on launch. The specified tags are applied to all
#' instances or volumes that are created during launch. To tag a resource
#' after it has been created, see CreateTags .
#'
#' @section Request syntax:
#' ```
#' svc$create_license_configuration(
#'   Name = "string",
#'   Description = "string",
#'   LicenseCountingType = "vCPU"|"Instance"|"Core"|"Socket",
#'   LicenseCount = 123,
#'   LicenseCountHardLimit = TRUE|FALSE,
#'   LicenseRules = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_create_license_configuration
licensemanager_create_license_configuration <- function(Name, Description = NULL, LicenseCountingType, LicenseCount = NULL, LicenseCountHardLimit = NULL, LicenseRules = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$create_license_configuration_input(Name = Name, Description = Description, LicenseCountingType = LicenseCountingType, LicenseCount = LicenseCount, LicenseCountHardLimit = LicenseCountHardLimit, LicenseRules = LicenseRules, Tags = Tags)
  output <- .licensemanager$create_license_configuration_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$create_license_configuration <- licensemanager_create_license_configuration

#' Deletes an existing license configuration
#'
#' Deletes an existing license configuration. This action fails if the
#' configuration is in use.
#'
#' @usage
#' licensemanager_delete_license_configuration(LicenseConfigurationArn)
#'
#' @param LicenseConfigurationArn &#91;required&#93; Unique ID of the configuration object to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_license_configuration(
#'   LicenseConfigurationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_delete_license_configuration
licensemanager_delete_license_configuration <- function(LicenseConfigurationArn) {
  op <- new_operation(
    name = "DeleteLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$delete_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn)
  output <- .licensemanager$delete_license_configuration_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$delete_license_configuration <- licensemanager_delete_license_configuration

#' Returns a detailed description of a license configuration
#'
#' Returns a detailed description of a license configuration.
#'
#' @usage
#' licensemanager_get_license_configuration(LicenseConfigurationArn)
#'
#' @param LicenseConfigurationArn &#91;required&#93; ARN of the license configuration being requested.
#'
#' @section Request syntax:
#' ```
#' svc$get_license_configuration(
#'   LicenseConfigurationArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_license_configuration
licensemanager_get_license_configuration <- function(LicenseConfigurationArn) {
  op <- new_operation(
    name = "GetLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$get_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn)
  output <- .licensemanager$get_license_configuration_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_license_configuration <- licensemanager_get_license_configuration

#' Gets License Manager settings for a region
#'
#' Gets License Manager settings for a region. Exposes the configured S3
#' bucket, SNS topic, etc., for inspection.
#'
#' @usage
#' licensemanager_get_service_settings()
#'
#' @section Request syntax:
#' ```
#' svc$get_service_settings()
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_get_service_settings
licensemanager_get_service_settings <- function() {
  op <- new_operation(
    name = "GetServiceSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$get_service_settings_input()
  output <- .licensemanager$get_service_settings_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$get_service_settings <- licensemanager_get_service_settings

#' Lists the resource associations for a license configuration
#'
#' Lists the resource associations for a license configuration. Resource
#' associations need not consume licenses from a license configuration. For
#' example, an AMI or a stopped instance may not consume a license
#' (depending on the license rules). Use this operation to find all
#' resources associated with a license configuration.
#'
#' @usage
#' licensemanager_list_associations_for_license_configuration(
#'   LicenseConfigurationArn, MaxResults, NextToken)
#'
#' @param LicenseConfigurationArn &#91;required&#93; ARN of a `LicenseConfiguration` object.
#' @param MaxResults Maximum number of results to return in a single call. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken Token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_associations_for_license_configuration(
#'   LicenseConfigurationArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_associations_for_license_configuration
licensemanager_list_associations_for_license_configuration <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociationsForLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_associations_for_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_associations_for_license_configuration_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_associations_for_license_configuration <- licensemanager_list_associations_for_license_configuration

#' Lists license configuration objects for an account, each containing the
#' name, description, license type, and other license terms modeled from a
#' license agreement
#'
#' Lists license configuration objects for an account, each containing the
#' name, description, license type, and other license terms modeled from a
#' license agreement.
#'
#' @usage
#' licensemanager_list_license_configurations(LicenseConfigurationArns,
#'   MaxResults, NextToken, Filters)
#'
#' @param LicenseConfigurationArns An array of ARNs for the calling account's license configurations.
#' @param MaxResults Maximum number of results to return in a single call. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken Token for the next set of results.
#' @param Filters One or more filters.
#'
#' @section Request syntax:
#' ```
#' svc$list_license_configurations(
#'   LicenseConfigurationArns = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_configurations
licensemanager_list_license_configurations <- function(LicenseConfigurationArns = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListLicenseConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_license_configurations_input(LicenseConfigurationArns = LicenseConfigurationArns, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_license_configurations_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_configurations <- licensemanager_list_license_configurations

#' Returns the license configuration for a resource
#'
#' Returns the license configuration for a resource.
#'
#' @usage
#' licensemanager_list_license_specifications_for_resource(ResourceArn,
#'   MaxResults, NextToken)
#'
#' @param ResourceArn &#91;required&#93; ARN of an AMI or Amazon EC2 instance that has an associated license
#' configuration.
#' @param MaxResults Maximum number of results to return in a single call. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken Token for the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_license_specifications_for_resource(
#'   ResourceArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_license_specifications_for_resource
licensemanager_list_license_specifications_for_resource <- function(ResourceArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListLicenseSpecificationsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_license_specifications_for_resource_input(ResourceArn = ResourceArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .licensemanager$list_license_specifications_for_resource_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_license_specifications_for_resource <- licensemanager_list_license_specifications_for_resource

#' Returns a detailed list of resources
#'
#' Returns a detailed list of resources.
#'
#' @usage
#' licensemanager_list_resource_inventory(MaxResults, NextToken, Filters)
#'
#' @param MaxResults Maximum number of results to return in a single call. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken Token for the next set of results.
#' @param Filters One or more filters.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_inventory(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Condition = "EQUALS"|"NOT_EQUALS"|"BEGINS_WITH"|"CONTAINS",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_resource_inventory
licensemanager_list_resource_inventory <- function(MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListResourceInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_resource_inventory_input(MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_resource_inventory_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_resource_inventory <- licensemanager_list_resource_inventory

#' Lists tags attached to a resource
#'
#' Lists tags attached to a resource.
#'
#' @usage
#' licensemanager_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; ARN for the resource.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_tags_for_resource
licensemanager_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .licensemanager$list_tags_for_resource_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_tags_for_resource <- licensemanager_list_tags_for_resource

#' Lists all license usage records for a license configuration, displaying
#' license consumption details by resource at a selected point in time
#'
#' Lists all license usage records for a license configuration, displaying
#' license consumption details by resource at a selected point in time. Use
#' this action to audit the current license consumption for any license
#' inventory and configuration.
#'
#' @usage
#' licensemanager_list_usage_for_license_configuration(
#'   LicenseConfigurationArn, MaxResults, NextToken, Filters)
#'
#' @param LicenseConfigurationArn &#91;required&#93; ARN of the targeted `LicenseConfiguration` object.
#' @param MaxResults Maximum number of results to return in a single call. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken Token for the next set of results.
#' @param Filters List of filters to apply.
#'
#' @section Request syntax:
#' ```
#' svc$list_usage_for_license_configuration(
#'   LicenseConfigurationArn = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_list_usage_for_license_configuration
licensemanager_list_usage_for_license_configuration <- function(LicenseConfigurationArn, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListUsageForLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$list_usage_for_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .licensemanager$list_usage_for_license_configuration_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$list_usage_for_license_configuration <- licensemanager_list_usage_for_license_configuration

#' Attach one of more tags to any resource
#'
#' Attach one of more tags to any resource.
#'
#' @usage
#' licensemanager_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; Resource of the ARN to be tagged.
#' @param Tags &#91;required&#93; Names of the tags to attach to the resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_tag_resource
licensemanager_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .licensemanager$tag_resource_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$tag_resource <- licensemanager_tag_resource

#' Remove tags from a resource
#'
#' Remove tags from a resource.
#'
#' @usage
#' licensemanager_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; ARN of the resource.
#' @param TagKeys &#91;required&#93; List keys identifying tags to remove.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_untag_resource
licensemanager_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .licensemanager$untag_resource_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$untag_resource <- licensemanager_untag_resource

#' Modifies the attributes of an existing license configuration object
#'
#' Modifies the attributes of an existing license configuration object. A
#' license configuration is an abstraction of a customer license agreement
#' that can be consumed and enforced by License Manager. Components include
#' specifications for the license type (Instances, cores, sockets, VCPUs),
#' tenancy (shared or Dedicated Host), host affinity (how long a VM is
#' associated with a host), the number of licenses purchased and used.
#'
#' @usage
#' licensemanager_update_license_configuration(LicenseConfigurationArn,
#'   LicenseConfigurationStatus, LicenseRules, LicenseCount,
#'   LicenseCountHardLimit, Name, Description)
#'
#' @param LicenseConfigurationArn &#91;required&#93; ARN for a license configuration.
#' @param LicenseConfigurationStatus New status of the license configuration (`ACTIVE` or `INACTIVE`).
#' @param LicenseRules List of flexible text strings designating license rules.
#' @param LicenseCount New number of licenses managed by the license configuration.
#' @param LicenseCountHardLimit Sets the number of available licenses as a hard limit.
#' @param Name New name of the license configuration.
#' @param Description New human-friendly description of the license configuration.
#'
#' @section Request syntax:
#' ```
#' svc$update_license_configuration(
#'   LicenseConfigurationArn = "string",
#'   LicenseConfigurationStatus = "AVAILABLE"|"DISABLED",
#'   LicenseRules = list(
#'     "string"
#'   ),
#'   LicenseCount = 123,
#'   LicenseCountHardLimit = TRUE|FALSE,
#'   Name = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_license_configuration
licensemanager_update_license_configuration <- function(LicenseConfigurationArn, LicenseConfigurationStatus = NULL, LicenseRules = NULL, LicenseCount = NULL, LicenseCountHardLimit = NULL, Name = NULL, Description = NULL) {
  op <- new_operation(
    name = "UpdateLicenseConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$update_license_configuration_input(LicenseConfigurationArn = LicenseConfigurationArn, LicenseConfigurationStatus = LicenseConfigurationStatus, LicenseRules = LicenseRules, LicenseCount = LicenseCount, LicenseCountHardLimit = LicenseCountHardLimit, Name = Name, Description = Description)
  output <- .licensemanager$update_license_configuration_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_license_configuration <- licensemanager_update_license_configuration

#' Adds or removes license configurations for a specified AWS resource
#'
#' Adds or removes license configurations for a specified AWS resource.
#' This operation currently supports updating the license specifications of
#' AMIs, instances, and hosts. Launch templates and AWS CloudFormation
#' templates are not managed from this operation as those resources send
#' the license configurations directly to a resource creation operation,
#' such as `RunInstances`.
#'
#' @usage
#' licensemanager_update_license_specifications_for_resource(ResourceArn,
#'   AddLicenseSpecifications, RemoveLicenseSpecifications)
#'
#' @param ResourceArn &#91;required&#93; ARN for an AWS server resource.
#' @param AddLicenseSpecifications License configuration ARNs to be added to a resource.
#' @param RemoveLicenseSpecifications License configuration ARNs to be removed from a resource.
#'
#' @section Request syntax:
#' ```
#' svc$update_license_specifications_for_resource(
#'   ResourceArn = "string",
#'   AddLicenseSpecifications = list(
#'     list(
#'       LicenseConfigurationArn = "string"
#'     )
#'   ),
#'   RemoveLicenseSpecifications = list(
#'     list(
#'       LicenseConfigurationArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_license_specifications_for_resource
licensemanager_update_license_specifications_for_resource <- function(ResourceArn, AddLicenseSpecifications = NULL, RemoveLicenseSpecifications = NULL) {
  op <- new_operation(
    name = "UpdateLicenseSpecificationsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$update_license_specifications_for_resource_input(ResourceArn = ResourceArn, AddLicenseSpecifications = AddLicenseSpecifications, RemoveLicenseSpecifications = RemoveLicenseSpecifications)
  output <- .licensemanager$update_license_specifications_for_resource_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_license_specifications_for_resource <- licensemanager_update_license_specifications_for_resource

#' Updates License Manager service settings
#'
#' Updates License Manager service settings.
#'
#' @usage
#' licensemanager_update_service_settings(S3BucketArn, SnsTopicArn,
#'   OrganizationConfiguration, EnableCrossAccountsDiscovery)
#'
#' @param S3BucketArn ARN of the Amazon S3 bucket where License Manager information is stored.
#' @param SnsTopicArn ARN of the Amazon SNS topic used for License Manager alerts.
#' @param OrganizationConfiguration Integrates AWS Organizations with License Manager for cross-account
#' discovery.
#' @param EnableCrossAccountsDiscovery Activates cross-account discovery.
#'
#' @section Request syntax:
#' ```
#' svc$update_service_settings(
#'   S3BucketArn = "string",
#'   SnsTopicArn = "string",
#'   OrganizationConfiguration = list(
#'     EnableIntegration = TRUE|FALSE
#'   ),
#'   EnableCrossAccountsDiscovery = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname licensemanager_update_service_settings
licensemanager_update_service_settings <- function(S3BucketArn = NULL, SnsTopicArn = NULL, OrganizationConfiguration = NULL, EnableCrossAccountsDiscovery = NULL) {
  op <- new_operation(
    name = "UpdateServiceSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .licensemanager$update_service_settings_input(S3BucketArn = S3BucketArn, SnsTopicArn = SnsTopicArn, OrganizationConfiguration = OrganizationConfiguration, EnableCrossAccountsDiscovery = EnableCrossAccountsDiscovery)
  output <- .licensemanager$update_service_settings_output()
  svc <- .licensemanager$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.licensemanager$operations$update_service_settings <- licensemanager_update_service_settings
