% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_describe_ops_items}
\alias{ssm_describe_ops_items}
\title{Query a set of OpsItems}
\usage{
ssm_describe_ops_items(OpsItemFilters, MaxResults, NextToken)
}
\arguments{
\item{OpsItemFilters}{One or more filters to limit the reponse.
\itemize{
\item Key: CreatedTime

Operations: GreaterThan, LessThan
\item Key: LastModifiedBy

Operations: Contains, Equals
\item Key: LastModifiedTime

Operations: GreaterThan, LessThan
\item Key: Priority

Operations: Equals
\item Key: Source

Operations: Contains, Equals
\item Key: Status

Operations: Equals
\item Key: Title

Operations: Contains
\item Key: OperationalData*

Operations: Equals
\item Key: OperationalDataKey

Operations: Equals
\item Key: OperationalDataValue

Operations: Equals, Contains
\item Key: OpsItemId

Operations: Equals
\item Key: ResourceId

Operations: Contains
\item Key: AutomationId

Operations: Equals
}

*If you filter the response by using the OperationalData operator,
specify a key-value pair by using the following JSON format:
{"key":"key\_name","value":"a\_value"}}

\item{MaxResults}{The maximum number of items to return for this call. The call also
returns a token that you can specify in a subsequent call to get the
next set of results.}

\item{NextToken}{A token to start the list. Use this token to get the next set of
results.}
}
\description{
Query a set of OpsItems. You must have permission in AWS Identity and
Access Management (IAM) to query a list of OpsItems. For more
information, see \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html}{Getting Started with OpsCenter}
in the \emph{AWS Systems Manager User Guide}.
}
\details{
Operations engineers and IT professionals use OpsCenter to view,
investigate, and remediate operational issues impacting the performance
and health of their AWS resources. For more information, see \href{http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html}{AWS Systems Manager OpsCenter}
in the \emph{AWS Systems Manager User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_ops_items(
  OpsItemFilters = list(
    list(
      Key = "Status"|"CreatedBy"|"Source"|"Priority"|"Title"|"OpsItemId"|"CreatedTime"|"LastModifiedTime"|"OperationalData"|"OperationalDataKey"|"OperationalDataValue"|"ResourceId"|"AutomationId",
      Values = list(
        "string"
      ),
      Operator = "Equal"|"Contains"|"GreaterThan"|"LessThan"
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
