% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_describe_alarms_for_metric}
\alias{cloudwatch_describe_alarms_for_metric}
\title{Retrieves the alarms for the specified metric}
\usage{
cloudwatch_describe_alarms_for_metric(MetricName, Namespace, Statistic,
  ExtendedStatistic, Dimensions, Period, Unit)
}
\arguments{
\item{MetricName}{[required] The name of the metric.}

\item{Namespace}{[required] The namespace of the metric.}

\item{Statistic}{The statistic for the metric, other than percentiles. For percentile
statistics, use \code{ExtendedStatistics}.}

\item{ExtendedStatistic}{The percentile statistic for the metric. Specify a value between p0.0
and p100.}

\item{Dimensions}{The dimensions associated with the metric. If the metric has any
associated dimensions, you must specify them in order for the call to
succeed.}

\item{Period}{The period, in seconds, over which the statistic is applied.}

\item{Unit}{The unit for the metric.}
}
\description{
Retrieves the alarms for the specified metric. To filter the results,
specify a statistic, period, or unit.
}
\section{Request syntax}{
\preformatted{svc$describe_alarms_for_metric(
  MetricName = "string",
  Namespace = "string",
  Statistic = "SampleCount"|"Average"|"Sum"|"Minimum"|"Maximum",
  ExtendedStatistic = "string",
  Dimensions = list(
    list(
      Name = "string",
      Value = "string"
    )
  ),
  Period = 123,
  Unit = "Seconds"|"Microseconds"|"Milliseconds"|"Bytes"|"Kilobytes"|"Megabytes"|"Gigabytes"|"Terabytes"|"Bits"|"Kilobits"|"Megabits"|"Gigabits"|"Terabits"|"Percent"|"Count"|"Bytes/Second"|"Kilobytes/Second"|"Megabytes/Second"|"Gigabytes/Second"|"Terabytes/Second"|"Bits/Second"|"Kilobits/Second"|"Megabits/Second"|"Gigabits/Second"|"Terabits/Second"|"Count/Second"|"None"
)
}
}

\keyword{internal}
