% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatch_operations.R
\name{cloudwatch_describe_anomaly_detectors}
\alias{cloudwatch_describe_anomaly_detectors}
\title{Lists the anomaly detection models that you have created in your account}
\usage{
cloudwatch_describe_anomaly_detectors(NextToken, MaxResults, Namespace,
  MetricName, Dimensions)
}
\arguments{
\item{NextToken}{Use the token returned by the previous operation to request the next
page of results.}

\item{MaxResults}{The maximum number of results to return in one operation. The maximum
value you can specify is 10.

To retrieve the remaining results, make another call with the returned
\code{NextToken} value.}

\item{Namespace}{Limits the results to only the anomaly detection models that are
associated with the specified namespace.}

\item{MetricName}{Limits the results to only the anomaly detection models that are
associated with the specified metric name. If there are multiple metrics
with this name in different namespaces that have anomaly detection
models, they\'re all returned.}

\item{Dimensions}{Limits the results to only the anomaly detection models that are
associated with the specified metric dimensions. If there are multiple
metrics that have these dimensions and have anomaly detection models
associated, they\'re all returned.}
}
\description{
Lists the anomaly detection models that you have created in your
account. You can list all models in your account or filter the results
to only the models that are related to a certain namespace, metric name,
or metric dimension.
}
\section{Request syntax}{
\preformatted{svc$describe_anomaly_detectors(
  NextToken = "string",
  MaxResults = 123,
  Namespace = "string",
  MetricName = "string",
  Dimensions = list(
    list(
      Name = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
