% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_describe_compliance_by_resource}
\alias{configservice_describe_compliance_by_resource}
\title{Indicates whether the specified AWS resources are compliant}
\usage{
configservice_describe_compliance_by_resource(ResourceType, ResourceId,
  ComplianceTypes, Limit, NextToken)
}
\arguments{
\item{ResourceType}{The types of AWS resources for which you want compliance information
(for example, \verb{AWS::EC2::Instance}). For this action, you can specify
that the resource type is an AWS account by specifying \verb{AWS::::Account}.}

\item{ResourceId}{The ID of the AWS resource for which you want compliance information.
You can specify only one resource ID. If you specify a resource ID, you
must also specify a type for \code{ResourceType}.}

\item{ComplianceTypes}{Filters the results by compliance.

The allowed values are \code{COMPLIANT}, \code{NON_COMPLIANT}, and
\code{INSUFFICIENT_DATA}.}

\item{Limit}{The maximum number of evaluation results returned on each page. The
default is 10. You cannot specify a number greater than 100. If you
specify 0, AWS Config uses the default.}

\item{NextToken}{The \code{nextToken} string returned on a previous page that you use to get
the next page of results in a paginated response.}
}
\description{
Indicates whether the specified AWS resources are compliant. If a
resource is noncompliant, this action returns the number of AWS Config
rules that the resource does not comply with.
}
\details{
A resource is compliant if it complies with all the AWS Config rules
that evaluate it. It is noncompliant if it does not comply with one or
more of these rules.

If AWS Config has no current evaluation results for the resource, it
returns \code{INSUFFICIENT_DATA}. This result might indicate one of the
following conditions about the rules that evaluate the resource:
\itemize{
\item AWS Config has never invoked an evaluation for the rule. To check
whether it has, use the \code{DescribeConfigRuleEvaluationStatus} action
to get the \code{LastSuccessfulInvocationTime} and
\code{LastFailedInvocationTime}.
\item The rule\'s AWS Lambda function is failing to send evaluation
results to AWS Config. Verify that the role that you assigned to
your configuration recorder includes the \code{config:PutEvaluations}
permission. If the rule is a custom rule, verify that the AWS Lambda
execution role includes the \code{config:PutEvaluations} permission.
\item The rule\'s AWS Lambda function has returned \code{NOT_APPLICABLE} for
all evaluation results. This can occur if the resources were deleted
or removed from the rule\'s scope.
}
}
\section{Request syntax}{
\preformatted{svc$describe_compliance_by_resource(
  ResourceType = "string",
  ResourceId = "string",
  ComplianceTypes = list(
    "COMPLIANT"|"NON_COMPLIANT"|"NOT_APPLICABLE"|"INSUFFICIENT_DATA"
  ),
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
