% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_get_conformance_pack_compliance_details}
\alias{configservice_get_conformance_pack_compliance_details}
\title{Returns compliance details of a conformance pack for all AWS resources
that are monitered by conformance pack}
\usage{
configservice_get_conformance_pack_compliance_details(
  ConformancePackName, Filters, Limit, NextToken)
}
\arguments{
\item{ConformancePackName}{[required] Name of the conformance pack.}

\item{Filters}{A \code{ConformancePackEvaluationFilters} object.}

\item{Limit}{The maximum number of evaluation results returned on each page. If you
do no specify a number, AWS Config uses the default. The default is 100.}

\item{NextToken}{The \code{nextToken} string returned in a previous request that you use to
request the next page of results in a paginated response.}
}
\description{
Returns compliance details of a conformance pack for all AWS resources
that are monitered by conformance pack.
}
\section{Request syntax}{
\preformatted{svc$get_conformance_pack_compliance_details(
  ConformancePackName = "string",
  Filters = list(
    ConfigRuleNames = list(
      "string"
    ),
    ComplianceType = "COMPLIANT"|"NON_COMPLIANT",
    ResourceType = "string",
    ResourceIds = list(
      "string"
    )
  ),
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
