% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/health_operations.R
\name{health_describe_event_types}
\alias{health_describe_event_types}
\title{Returns the event types that meet the specified filter criteria}
\usage{
health_describe_event_types(filter, locale, nextToken, maxResults)
}
\arguments{
\item{filter}{Values to narrow the results returned.}

\item{locale}{The locale (language) to return information in. English (en) is the
default and the only supported value at this time.}

\item{nextToken}{If the results of a search are large, only a portion of the results are
returned, and a \code{nextToken} pagination token is returned in the
response. To retrieve the next batch of results, reissue the search
request and include the returned token. When all results have been
returned, the response does not contain a pagination token value.}

\item{maxResults}{The maximum number of items to return in one batch, between 10 and 100,
inclusive.}
}
\description{
Returns the event types that meet the specified filter criteria. If no
filter criteria are specified, all event types are returned, in no
particular order.
}
\section{Request syntax}{
\preformatted{svc$describe_event_types(
  filter = list(
    eventTypeCodes = list(
      "string"
    ),
    services = list(
      "string"
    ),
    eventTypeCategories = list(
      "issue"|"accountNotification"|"scheduledChange"|"investigation"
    )
  ),
  locale = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
