% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/opsworks_operations.R
\name{opsworks_delete_stack}
\alias{opsworks_delete_stack}
\title{Deletes a specified stack}
\usage{
opsworks_delete_stack(StackId)
}
\arguments{
\item{StackId}{[required] The stack ID.}
}
\description{
Deletes a specified stack. You must first delete all instances, layers,
and apps or deregister registered instances. For more information, see
\href{https://docs.aws.amazon.com/opsworks/latest/userguide/workingstacks-shutting.html}{Shut Down a Stack}.
}
\details{
\strong{Required Permissions}: To use this action, an IAM user must have a
Manage permissions level for the stack, or an attached policy that
explicitly grants permissions. For more information on user permissions,
see \href{https://docs.aws.amazon.com/opsworks/latest/userguide/opsworks-security-users.html}{Managing User Permissions}.
}
\section{Request syntax}{
\preformatted{svc$delete_stack(
  StackId = "string"
)
}
}

\keyword{internal}
