% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pi_operations.R
\name{pi_get_resource_metrics}
\alias{pi_get_resource_metrics}
\title{Retrieve Performance Insights metrics for a set of data sources, over a
time period}
\usage{
pi_get_resource_metrics(ServiceType, Identifier, MetricQueries,
  StartTime, EndTime, PeriodInSeconds, MaxResults, NextToken)
}
\arguments{
\item{ServiceType}{[required] The AWS service for which Performance Insights will return metrics. The
only valid value for \emph{ServiceType} is: \code{RDS}}

\item{Identifier}{[required] An immutable, AWS Region-unique identifier for a data source.
Performance Insights gathers metrics from this data source.

To use an Amazon RDS instance as a data source, you specify its
\code{DbiResourceId} value - for example: \code{db-FAIHNTYBKTGAUSUZQYPDS2GW4A}}

\item{MetricQueries}{[required] An array of one or more queries to perform. Each query must specify a
Performance Insights metric, and can optionally specify aggregation and
filtering criteria.}

\item{StartTime}{[required] The date and time specifying the beginning of the requested time series
data. You can\'t specify a \code{StartTime} that\'s earlier than 7 days ago.
The value specified is \emph{inclusive} - data points equal to or greater
than \code{StartTime} will be returned.

The value for \code{StartTime} must be earlier than the value for \code{EndTime}.}

\item{EndTime}{[required] The date and time specifiying the end of the requested time series data.
The value specified is \emph{exclusive} - data points less than (but not
equal to) \code{EndTime} will be returned.

The value for \code{EndTime} must be later than the value for \code{StartTime}.}

\item{PeriodInSeconds}{The granularity, in seconds, of the data points returned from
Performance Insights. A period can be as short as one second, or as long
as one day (86400 seconds). Valid values are:
\itemize{
\item \code{1} (one second)
\item \code{60} (one minute)
\item \code{300} (five minutes)
\item \code{3600} (one hour)
\item \code{86400} (twenty-four hours)
}

If you don\'t specify \code{PeriodInSeconds}, then Performance Insights will
choose a value for you, with a goal of returning roughly 100-200 data
points in the response.}

\item{MaxResults}{The maximum number of items to return in the response. If more items
exist than the specified \code{MaxRecords} value, a pagination token is
included in the response so that the remaining results can be retrieved.}

\item{NextToken}{An optional pagination token provided by a previous request. If this
parameter is specified, the response includes only records beyond the
token, up to the value specified by \code{MaxRecords}.}
}
\description{
Retrieve Performance Insights metrics for a set of data sources, over a
time period. You can provide specific dimension groups and dimensions,
and provide aggregation and filtering criteria for each group.
}
\section{Request syntax}{
\preformatted{svc$get_resource_metrics(
  ServiceType = "RDS",
  Identifier = "string",
  MetricQueries = list(
    list(
      Metric = "string",
      GroupBy = list(
        Group = "string",
        Dimensions = list(
          "string"
        ),
        Limit = 123
      ),
      Filter = list(
        "string"
      )
    )
  ),
  StartTime = as.POSIXct(
    "2015-01-01"
  ),
  EndTime = as.POSIXct(
    "2015-01-01"
  ),
  PeriodInSeconds = 123,
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
