# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ssm_service.R
NULL

#' Adds or overwrites one or more tags for the specified resource
#'
#' Adds or overwrites one or more tags for the specified resource. Tags are
#' metadata that you can assign to your documents, managed instances,
#' maintenance windows, Parameter Store parameters, and patch baselines.
#' Tags enable you to categorize your resources in different ways, for
#' example, by purpose, owner, or environment. Each tag consists of a key
#' and an optional value, both of which you define. For example, you could
#' define a set of tags for your account\'s managed instances that helps
#' you track each instance\'s owner and stack level. For example: Key=Owner
#' and Value=DbAdmin, SysAdmin, or Dev. Or Key=Stack and Value=Production,
#' Pre-Production, or Test.
#' 
#' Each resource can have a maximum of 50 tags.
#' 
#' We recommend that you devise a set of tag keys that meets your needs for
#' each resource type. Using a consistent set of tag keys makes it easier
#' for you to manage your resources. You can search and filter the
#' resources based on the tags you add. Tags don\'t have any semantic
#' meaning to Amazon EC2 and are interpreted strictly as a string of
#' characters.
#' 
#' For more information about tags, see [Tagging Your Amazon EC2
#' Resources](http://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon EC2 User Guide*.
#'
#' @usage
#' ssm_add_tags_to_resource(ResourceType, ResourceId, Tags)
#'
#' @param ResourceType &#91;required&#93; Specifies the type of resource you are tagging.
#' 
#' The ManagedInstance type for this API action is for on-premises managed
#' instances. You must specify the name of the managed instance in the
#' following format: mi-ID\\_number. For example, mi-1a2b3c4d5e6f.
#' @param ResourceId &#91;required&#93; The resource ID you want to tag.
#' 
#' Use the ID of the resource. Here are some examples:
#' 
#' ManagedInstance: mi-012345abcde
#' 
#' MaintenanceWindow: mw-012345abcde
#' 
#' PatchBaseline: pb-012345abcde
#' 
#' For the Document and Parameter values, use the name of the resource.
#' 
#' The ManagedInstance type for this API action is only for on-premises
#' managed instances. You must specify the name of the managed instance in
#' the following format: mi-ID\\_number. For example, mi-1a2b3c4d5e6f.
#' @param Tags &#91;required&#93; One or more tags. The value parameter is required, but if you don\'t
#' want the tag to have a value, specify the parameter with no value, and
#' we set the value to an empty string.
#' 
#' Do not enter personally identifiable information in this field.
#'
#' @section Request syntax:
#' ```
#' svc$add_tags_to_resource(
#'   ResourceType = "Document"|"ManagedInstance"|"MaintenanceWindow"|"Parameter"|"PatchBaseline"|"OpsItem",
#'   ResourceId = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_add_tags_to_resource
ssm_add_tags_to_resource <- function(ResourceType, ResourceId, Tags) {
  op <- new_operation(
    name = "AddTagsToResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$add_tags_to_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, Tags = Tags)
  output <- .ssm$add_tags_to_resource_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$add_tags_to_resource <- ssm_add_tags_to_resource

#' Attempts to cancel the command specified by the Command ID
#'
#' Attempts to cancel the command specified by the Command ID. There is no
#' guarantee that the command will be terminated and the underlying process
#' stopped.
#'
#' @usage
#' ssm_cancel_command(CommandId, InstanceIds)
#'
#' @param CommandId &#91;required&#93; The ID of the command you want to cancel.
#' @param InstanceIds (Optional) A list of instance IDs on which you want to cancel the
#' command. If not provided, the command is canceled on every instance on
#' which it was requested.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_command(
#'   CommandId = "string",
#'   InstanceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_cancel_command
ssm_cancel_command <- function(CommandId, InstanceIds = NULL) {
  op <- new_operation(
    name = "CancelCommand",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$cancel_command_input(CommandId = CommandId, InstanceIds = InstanceIds)
  output <- .ssm$cancel_command_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$cancel_command <- ssm_cancel_command

#' Stops a maintenance window execution that is already in progress and
#' cancels any tasks in the window that have not already starting running
#'
#' Stops a maintenance window execution that is already in progress and
#' cancels any tasks in the window that have not already starting running.
#' (Tasks already in progress will continue to completion.)
#'
#' @usage
#' ssm_cancel_maintenance_window_execution(WindowExecutionId)
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution to stop.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_maintenance_window_execution(
#'   WindowExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_cancel_maintenance_window_execution
ssm_cancel_maintenance_window_execution <- function(WindowExecutionId) {
  op <- new_operation(
    name = "CancelMaintenanceWindowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$cancel_maintenance_window_execution_input(WindowExecutionId = WindowExecutionId)
  output <- .ssm$cancel_maintenance_window_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$cancel_maintenance_window_execution <- ssm_cancel_maintenance_window_execution

#' Registers your on-premises server or virtual machine with Amazon EC2 so
#' that you can manage these resources using Run Command
#'
#' Registers your on-premises server or virtual machine with Amazon EC2 so
#' that you can manage these resources using Run Command. An on-premises
#' server or virtual machine that has been registered with EC2 is called a
#' managed instance. For more information about activations, see [Setting
#' Up AWS Systems Manager for Hybrid
#' Environments](http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-managedinstances.html).
#'
#' @usage
#' ssm_create_activation(Description, DefaultInstanceName, IamRole,
#'   RegistrationLimit, ExpirationDate, Tags)
#'
#' @param Description A user-defined description of the resource that you want to register
#' with Amazon EC2.
#' 
#' Do not enter personally identifiable information in this field.
#' @param DefaultInstanceName The name of the registered, managed instance as it will appear in the
#' Amazon EC2 console or when you use the AWS command line tools to list
#' EC2 resources.
#' 
#' Do not enter personally identifiable information in this field.
#' @param IamRole &#91;required&#93; The Amazon Identity and Access Management (IAM) role that you want to
#' assign to the managed instance.
#' @param RegistrationLimit Specify the maximum number of managed instances you want to register.
#' The default value is 1 instance.
#' @param ExpirationDate The date by which this activation request should expire. The default
#' value is 24 hours.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag an activation to
#' identify which servers or virtual machines (VMs) in your on-premises
#' environment you intend to activate. In this case, you could specify the
#' following key name/value pairs:
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' When you install SSM Agent on your on-premises servers and VMs, you
#' specify an activation ID and code. When you specify the activation ID
#' and code, tags assigned to the activation are automatically applied to
#' the on-premises servers or VMs.
#' 
#' You can\'t add tags to or delete tags from an existing activation. You
#' can tag your on-premises servers and VMs after they connect to Systems
#' Manager for the first time and are assigned a managed instance ID. This
#' means they are listed in the AWS Systems Manager console with an ID that
#' is prefixed with \"mi-\". For information about how to add tags to your
#' managed instances, see AddTagsToResource. For information about how to
#' remove tags from your managed instances, see RemoveTagsFromResource.
#'
#' @section Request syntax:
#' ```
#' svc$create_activation(
#'   Description = "string",
#'   DefaultInstanceName = "string",
#'   IamRole = "string",
#'   RegistrationLimit = 123,
#'   ExpirationDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_activation
ssm_create_activation <- function(Description = NULL, DefaultInstanceName = NULL, IamRole, RegistrationLimit = NULL, ExpirationDate = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateActivation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_activation_input(Description = Description, DefaultInstanceName = DefaultInstanceName, IamRole = IamRole, RegistrationLimit = RegistrationLimit, ExpirationDate = ExpirationDate, Tags = Tags)
  output <- .ssm$create_activation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_activation <- ssm_create_activation

#' Associates the specified Systems Manager document with the specified
#' instances or targets
#'
#' Associates the specified Systems Manager document with the specified
#' instances or targets.
#' 
#' When you associate a document with one or more instances using instance
#' IDs or tags, SSM Agent running on the instance processes the document
#' and configures the instance as specified.
#' 
#' If you associate a document with an instance that already has an
#' associated document, the system returns the AssociationAlreadyExists
#' exception.
#'
#' @usage
#' ssm_create_association(Name, DocumentVersion, InstanceId, Parameters,
#'   Targets, ScheduleExpression, OutputLocation, AssociationName,
#'   AutomationTargetParameterName, MaxErrors, MaxConcurrency,
#'   ComplianceSeverity)
#'
#' @param Name &#91;required&#93; The name of the SSM document that contains the configuration information
#' for the instance. You can specify Command or Automation documents.
#' 
#' You can specify AWS-predefined documents, documents you created, or a
#' document that is shared with you from another account.
#' 
#' For SSM documents that are shared with you from other AWS accounts, you
#' must specify the complete SSM document ARN, in the following format:
#' 
#' `arn:<i>partition</i>:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> `
#' 
#' For example:
#' 
#' `arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document`
#' 
#' For AWS-predefined documents and SSM documents you created in your
#' account, you only need to specify the document name. For example,
#' `AWS-ApplyPatchBaseline` or `My-Document`.
#' @param DocumentVersion The document version you want to associate with the target(s). Can be a
#' specific version or the default version.
#' @param InstanceId The instance ID.
#' 
#' `InstanceId` has been deprecated. To specify an instance ID for an
#' association, use the `Targets` parameter. Requests that include the
#' parameter `InstanceID` with SSM documents that use schema version 2.0 or
#' later will fail. In addition, if you use the parameter `InstanceId`, you
#' cannot use the parameters `AssociationName`, `DocumentVersion`,
#' `MaxErrors`, `MaxConcurrency`, `OutputLocation`, or
#' `ScheduleExpression`. To use these parameters, you must use the
#' `Targets` parameter.
#' @param Parameters The parameters for the runtime configuration of the document.
#' @param Targets The targets (either instances or tags) for the association. You must
#' specify a value for `Targets` if you don\'t specify a value for
#' `InstanceId`.
#' @param ScheduleExpression A cron expression when the association will be applied to the target(s).
#' @param OutputLocation An Amazon S3 bucket where you want to store the output details of the
#' request.
#' @param AssociationName Specify a descriptive name for the association.
#' @param AutomationTargetParameterName Specify the target for the association. This target is required for
#' associations that use an Automation document and target resources by
#' using rate controls.
#' @param MaxErrors The number of errors that are allowed before the system stops sending
#' requests to run the association on additional targets. You can specify
#' either an absolute number of errors, for example 10, or a percentage of
#' the target set, for example 10%. If you specify 3, for example, the
#' system stops sending requests when the fourth error is received. If you
#' specify 0, then the system stops sending requests after the first error
#' is returned. If you run an association on 50 instances and set MaxError
#' to 10%, then the system stops sending the request when the sixth error
#' is received.
#' 
#' Executions that are already running an association when MaxErrors is
#' reached are allowed to complete, but some of these executions may fail
#' as well. If you need to ensure that there won\'t be more than max-errors
#' failed executions, set MaxConcurrency to 1 so that executions proceed
#' one at a time.
#' @param MaxConcurrency The maximum number of targets allowed to run the association at the same
#' time. You can specify a number, for example 10, or a percentage of the
#' target set, for example 10%. The default value is 100%, which means all
#' targets run the association at the same time.
#' 
#' If a new instance starts and attempts to run an association while
#' Systems Manager is running MaxConcurrency associations, the association
#' is allowed to run. During the next association interval, the new
#' instance will process its association within the limit specified for
#' MaxConcurrency.
#' @param ComplianceSeverity The severity level to assign to the association.
#'
#' @section Request syntax:
#' ```
#' svc$create_association(
#'   Name = "string",
#'   DocumentVersion = "string",
#'   InstanceId = "string",
#'   Parameters = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ScheduleExpression = "string",
#'   OutputLocation = list(
#'     S3Location = list(
#'       OutputS3Region = "string",
#'       OutputS3BucketName = "string",
#'       OutputS3KeyPrefix = "string"
#'     )
#'   ),
#'   AssociationName = "string",
#'   AutomationTargetParameterName = "string",
#'   MaxErrors = "string",
#'   MaxConcurrency = "string",
#'   ComplianceSeverity = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"UNSPECIFIED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_association
ssm_create_association <- function(Name, DocumentVersion = NULL, InstanceId = NULL, Parameters = NULL, Targets = NULL, ScheduleExpression = NULL, OutputLocation = NULL, AssociationName = NULL, AutomationTargetParameterName = NULL, MaxErrors = NULL, MaxConcurrency = NULL, ComplianceSeverity = NULL) {
  op <- new_operation(
    name = "CreateAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_association_input(Name = Name, DocumentVersion = DocumentVersion, InstanceId = InstanceId, Parameters = Parameters, Targets = Targets, ScheduleExpression = ScheduleExpression, OutputLocation = OutputLocation, AssociationName = AssociationName, AutomationTargetParameterName = AutomationTargetParameterName, MaxErrors = MaxErrors, MaxConcurrency = MaxConcurrency, ComplianceSeverity = ComplianceSeverity)
  output <- .ssm$create_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_association <- ssm_create_association

#' Associates the specified Systems Manager document with the specified
#' instances or targets
#'
#' Associates the specified Systems Manager document with the specified
#' instances or targets.
#' 
#' When you associate a document with one or more instances using instance
#' IDs or tags, SSM Agent running on the instance processes the document
#' and configures the instance as specified.
#' 
#' If you associate a document with an instance that already has an
#' associated document, the system returns the AssociationAlreadyExists
#' exception.
#'
#' @usage
#' ssm_create_association_batch(Entries)
#'
#' @param Entries &#91;required&#93; One or more associations.
#'
#' @section Request syntax:
#' ```
#' svc$create_association_batch(
#'   Entries = list(
#'     list(
#'       Name = "string",
#'       InstanceId = "string",
#'       Parameters = list(
#'         list(
#'           "string"
#'         )
#'       ),
#'       AutomationTargetParameterName = "string",
#'       DocumentVersion = "string",
#'       Targets = list(
#'         list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       ScheduleExpression = "string",
#'       OutputLocation = list(
#'         S3Location = list(
#'           OutputS3Region = "string",
#'           OutputS3BucketName = "string",
#'           OutputS3KeyPrefix = "string"
#'         )
#'       ),
#'       AssociationName = "string",
#'       MaxErrors = "string",
#'       MaxConcurrency = "string",
#'       ComplianceSeverity = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"UNSPECIFIED"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_association_batch
ssm_create_association_batch <- function(Entries) {
  op <- new_operation(
    name = "CreateAssociationBatch",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_association_batch_input(Entries = Entries)
  output <- .ssm$create_association_batch_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_association_batch <- ssm_create_association_batch

#' Creates a Systems Manager document
#'
#' Creates a Systems Manager document.
#' 
#' After you create a document, you can use CreateAssociation to associate
#' it with one or more running instances.
#'
#' @usage
#' ssm_create_document(Content, Requires, Attachments, Name, VersionName,
#'   DocumentType, DocumentFormat, TargetType, Tags)
#'
#' @param Content &#91;required&#93; A valid JSON or YAML string.
#' @param Requires A list of SSM documents required by a document. For example, an
#' `ApplicationConfiguration` document requires an
#' `ApplicationConfigurationSchema` document.
#' @param Attachments A list of key and value pairs that describe attachments to a version of
#' a document.
#' @param Name &#91;required&#93; A name for the Systems Manager document.
#' 
#' Do not use the following to begin the names of documents you create.
#' They are reserved by AWS for use as document prefixes:
#' 
#' -   `aws`
#' 
#' -   `amazon`
#' 
#' -   `amzn`
#' @param VersionName An optional field specifying the version of the artifact you are
#' creating with the document. For example, \"Release 12, Update 6\". This
#' value is unique across all versions of a document, and cannot be
#' changed.
#' @param DocumentType The type of document to create. Valid document types include: `Command`,
#' `Policy`, `Automation`, `Session`, and `Package`.
#' @param DocumentFormat Specify the document format for the request. The document format can be
#' JSON, YAML, or TEXT. JSON is the default format.
#' @param TargetType Specify a target type to define the kinds of resources the document can
#' run on. For example, to run a document on EC2 instances, specify the
#' following value: /AWS::EC2::Instance. If you specify a value of \'/\'
#' the document can run on all types of resources. If you don\'t specify a
#' value, the document can\'t run on any resources. For a list of valid
#' resource types, see [AWS Resource Types
#' Reference](http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-template-resource-type-ref.html)
#' in the *AWS CloudFormation User Guide*.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag an SSM document to
#' identify the types of targets or the environment where it will run. In
#' this case, you could specify the following key name/value pairs:
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' To add tags to an existing SSM document, use the AddTagsToResource
#' action.
#'
#' @section Request syntax:
#' ```
#' svc$create_document(
#'   Content = "string",
#'   Requires = list(
#'     list(
#'       Name = "string",
#'       Version = "string"
#'     )
#'   ),
#'   Attachments = list(
#'     list(
#'       Key = "SourceUrl"|"S3FileUrl"|"AttachmentReference",
#'       Values = list(
#'         "string"
#'       ),
#'       Name = "string"
#'     )
#'   ),
#'   Name = "string",
#'   VersionName = "string",
#'   DocumentType = "Command"|"Policy"|"Automation"|"Session"|"Package"|"ApplicationConfiguration"|"ApplicationConfigurationSchema"|"DeploymentStrategy"|"ChangeCalendar",
#'   DocumentFormat = "YAML"|"JSON"|"TEXT",
#'   TargetType = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_document
ssm_create_document <- function(Content, Requires = NULL, Attachments = NULL, Name, VersionName = NULL, DocumentType = NULL, DocumentFormat = NULL, TargetType = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_document_input(Content = Content, Requires = Requires, Attachments = Attachments, Name = Name, VersionName = VersionName, DocumentType = DocumentType, DocumentFormat = DocumentFormat, TargetType = TargetType, Tags = Tags)
  output <- .ssm$create_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_document <- ssm_create_document

#' Creates a new maintenance window
#'
#' Creates a new maintenance window.
#' 
#' The value you specify for `Duration` determines the specific end time
#' for the maintenance window based on the time it begins. No maintenance
#' window tasks are permitted to start after the resulting endtime minus
#' the number of hours you specify for `Cutoff`. For example, if the
#' maintenance window starts at 3 PM, the duration is three hours, and the
#' value you specify for `Cutoff` is one hour, no maintenance window tasks
#' can start after 5 PM.
#'
#' @usage
#' ssm_create_maintenance_window(Name, Description, StartDate, EndDate,
#'   Schedule, ScheduleTimezone, Duration, Cutoff, AllowUnassociatedTargets,
#'   ClientToken, Tags)
#'
#' @param Name &#91;required&#93; The name of the maintenance window.
#' @param Description An optional description for the maintenance window. We recommend
#' specifying a description to help you organize your maintenance windows.
#' @param StartDate The date and time, in ISO-8601 Extended format, for when you want the
#' maintenance window to become active. StartDate allows you to delay
#' activation of the maintenance window until the specified future date.
#' @param EndDate The date and time, in ISO-8601 Extended format, for when you want the
#' maintenance window to become inactive. EndDate allows you to set a date
#' and time in the future when the maintenance window will no longer run.
#' @param Schedule &#91;required&#93; The schedule of the maintenance window in the form of a cron or rate
#' expression.
#' @param ScheduleTimezone The time zone that the scheduled maintenance window executions are based
#' on, in Internet Assigned Numbers Authority (IANA) format. For example:
#' \"America/Los\\_Angeles\", \"etc/UTC\", or \"Asia/Seoul\". For more
#' information, see the [Time Zone
#' Database](https://www.iana.org/time-zones) on the IANA website.
#' @param Duration &#91;required&#93; The duration of the maintenance window in hours.
#' @param Cutoff &#91;required&#93; The number of hours before the end of the maintenance window that
#' Systems Manager stops scheduling new tasks for execution.
#' @param AllowUnassociatedTargets &#91;required&#93; Enables a maintenance window task to run on managed instances, even if
#' you have not registered those instances as targets. If enabled, then you
#' must specify the unregistered instances (by instance ID) when you
#' register a task with the maintenance window.
#' 
#' If you don\'t enable this option, then you must specify
#' previously-registered targets when you register a task with the
#' maintenance window.
#' @param ClientToken User-provided idempotency token.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag a maintenance window to
#' identify the type of tasks it will run, the types of targets, and the
#' environment it will run in. In this case, you could specify the
#' following key name/value pairs:
#' 
#' -   `Key=TaskType,Value=AgentUpdate`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=Environment,Value=Production`
#' 
#' To add tags to an existing maintenance window, use the AddTagsToResource
#' action.
#'
#' @section Request syntax:
#' ```
#' svc$create_maintenance_window(
#'   Name = "string",
#'   Description = "string",
#'   StartDate = "string",
#'   EndDate = "string",
#'   Schedule = "string",
#'   ScheduleTimezone = "string",
#'   Duration = 123,
#'   Cutoff = 123,
#'   AllowUnassociatedTargets = TRUE|FALSE,
#'   ClientToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_maintenance_window
ssm_create_maintenance_window <- function(Name, Description = NULL, StartDate = NULL, EndDate = NULL, Schedule, ScheduleTimezone = NULL, Duration, Cutoff, AllowUnassociatedTargets, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_maintenance_window_input(Name = Name, Description = Description, StartDate = StartDate, EndDate = EndDate, Schedule = Schedule, ScheduleTimezone = ScheduleTimezone, Duration = Duration, Cutoff = Cutoff, AllowUnassociatedTargets = AllowUnassociatedTargets, ClientToken = ClientToken, Tags = Tags)
  output <- .ssm$create_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_maintenance_window <- ssm_create_maintenance_window

#' Creates a new OpsItem
#'
#' Creates a new OpsItem. You must have permission in AWS Identity and
#' Access Management (IAM) to create a new OpsItem. For more information,
#' see [Getting Started with
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' Operations engineers and IT professionals use OpsCenter to view,
#' investigate, and remediate operational issues impacting the performance
#' and health of their AWS resources. For more information, see [AWS
#' Systems Manager
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
#' in the *AWS Systems Manager User Guide*.
#'
#' @usage
#' ssm_create_ops_item(Description, OperationalData, Notifications,
#'   Priority, RelatedOpsItems, Source, Title, Tags, Category, Severity)
#'
#' @param Description &#91;required&#93; Information about the OpsItem.
#' @param OperationalData Operational data is custom data that provides useful reference details
#' about the OpsItem. For example, you can specify log files, error
#' strings, license keys, troubleshooting tips, or other relevant data. You
#' enter operational data as key-value pairs. The key has a maximum length
#' of 128 characters. The value has a maximum size of 20 KB.
#' 
#' Operational data keys *can\'t* begin with the following: amazon, aws,
#' amzn, ssm, /amazon, /aws, /amzn, /ssm.
#' 
#' You can choose to make the data searchable by other users in the account
#' or you can restrict search access. Searchable data means that all users
#' with access to the OpsItem Overview page (as provided by the
#' DescribeOpsItems API action) can view and search on the specified data.
#' Operational data that is not searchable is only viewable by users who
#' have access to the OpsItem (as provided by the GetOpsItem API action).
#' 
#' Use the `/aws/resources` key in OperationalData to specify a related
#' resource in the request. Use the `/aws/automations` key in
#' OperationalData to associate an Automation runbook with the OpsItem. To
#' view AWS CLI example commands that use these keys, see [Creating
#' OpsItems
#' Manually](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems)
#' in the *AWS Systems Manager User Guide*.
#' @param Notifications The Amazon Resource Name (ARN) of an SNS topic where notifications are
#' sent when this OpsItem is edited or changed.
#' @param Priority The importance of this OpsItem in relation to other OpsItems in the
#' system.
#' @param RelatedOpsItems One or more OpsItems that share something in common with the current
#' OpsItems. For example, related OpsItems can include OpsItems with
#' similar error messages, impacted resources, or statuses for the impacted
#' resource.
#' @param Source &#91;required&#93; The origin of the OpsItem, such as Amazon EC2 or AWS Systems Manager.
#' @param Title &#91;required&#93; A short heading that describes the nature of the OpsItem and the
#' impacted resource.
#' @param Tags Optional metadata that you assign to a resource. You can restrict access
#' to OpsItems by using an inline IAM policy that specifies tags. For more
#' information, see [Getting Started with
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html#OpsCenter-getting-started-user-permissions)
#' in the *AWS Systems Manager User Guide*.
#' 
#' Tags use a key-value pair. For example:
#' 
#' `Key=Department,Value=Finance`
#' 
#' To add tags to an existing OpsItem, use the AddTagsToResource action.
#' @param Category Specify a category to assign to an OpsItem.
#' @param Severity Specify a severity to assign to an OpsItem.
#'
#' @section Request syntax:
#' ```
#' svc$create_ops_item(
#'   Description = "string",
#'   OperationalData = list(
#'     list(
#'       Value = "string",
#'       Type = "SearchableString"|"String"
#'     )
#'   ),
#'   Notifications = list(
#'     list(
#'       Arn = "string"
#'     )
#'   ),
#'   Priority = 123,
#'   RelatedOpsItems = list(
#'     list(
#'       OpsItemId = "string"
#'     )
#'   ),
#'   Source = "string",
#'   Title = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Category = "string",
#'   Severity = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_ops_item
ssm_create_ops_item <- function(Description, OperationalData = NULL, Notifications = NULL, Priority = NULL, RelatedOpsItems = NULL, Source, Title, Tags = NULL, Category = NULL, Severity = NULL) {
  op <- new_operation(
    name = "CreateOpsItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_ops_item_input(Description = Description, OperationalData = OperationalData, Notifications = Notifications, Priority = Priority, RelatedOpsItems = RelatedOpsItems, Source = Source, Title = Title, Tags = Tags, Category = Category, Severity = Severity)
  output <- .ssm$create_ops_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_ops_item <- ssm_create_ops_item

#' Creates a patch baseline
#'
#' Creates a patch baseline.
#' 
#' For information about valid key and value pairs in `PatchFilters` for
#' each supported operating system type, see
#' [PatchFilter](http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
#'
#' @usage
#' ssm_create_patch_baseline(OperatingSystem, Name, GlobalFilters,
#'   ApprovalRules, ApprovedPatches, ApprovedPatchesComplianceLevel,
#'   ApprovedPatchesEnableNonSecurity, RejectedPatches,
#'   RejectedPatchesAction, Description, Sources, ClientToken, Tags)
#'
#' @param OperatingSystem Defines the operating system the patch baseline applies to. The Default
#' value is WINDOWS.
#' @param Name &#91;required&#93; The name of the patch baseline.
#' @param GlobalFilters A set of global filters used to include patches in the baseline.
#' @param ApprovalRules A set of rules used to include patches in the baseline.
#' @param ApprovedPatches A list of explicitly approved patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [Package Name Formats for Approved and Rejected
#' Patch
#' Lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *AWS Systems Manager User Guide*.
#' @param ApprovedPatchesComplianceLevel Defines the compliance level for approved patches. This means that if an
#' approved patch is reported as missing, this is the severity of the
#' compliance violation. The default value is UNSPECIFIED.
#' @param ApprovedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security
#' updates that should be applied to the instances. The default value is
#' \'false\'. Applies to Linux instances only.
#' @param RejectedPatches A list of explicitly rejected patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [Package Name Formats for Approved and Rejected
#' Patch
#' Lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *AWS Systems Manager User Guide*.
#' @param RejectedPatchesAction The action for Patch Manager to take on patches included in the
#' RejectedPackages list.
#' 
#' -   **ALLOW\\_AS\\_DEPENDENCY**: A package in the Rejected patches list is
#'     installed only if it is a dependency of another package. It is
#'     considered compliant with the patch baseline, and its status is
#'     reported as *InstalledOther*. This is the default action if no
#'     option is specified.
#' 
#' -   **BLOCK**: Packages in the RejectedPatches list, and packages that
#'     include them as dependencies, are not installed under any
#'     circumstances. If a package was installed before it was added to the
#'     Rejected patches list, it is considered non-compliant with the patch
#'     baseline, and its status is reported as *InstalledRejected*.
#' @param Description A description of the patch baseline.
#' @param Sources Information about the patches to use to update the instances, including
#' target operating systems and source repositories. Applies to Linux
#' instances only.
#' @param ClientToken User-provided idempotency token.
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag a patch baseline to
#' identify the severity level of patches it specifies and the operating
#' system family it applies to. In this case, you could specify the
#' following key name/value pairs:
#' 
#' -   `Key=PatchSeverity,Value=Critical`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' To add tags to an existing patch baseline, use the AddTagsToResource
#' action.
#'
#' @section Request syntax:
#' ```
#' svc$create_patch_baseline(
#'   OperatingSystem = "WINDOWS"|"AMAZON_LINUX"|"AMAZON_LINUX_2"|"UBUNTU"|"REDHAT_ENTERPRISE_LINUX"|"SUSE"|"CENTOS",
#'   Name = "string",
#'   GlobalFilters = list(
#'     PatchFilters = list(
#'       list(
#'         Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
#'         Values = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   ApprovalRules = list(
#'     PatchRules = list(
#'       list(
#'         PatchFilterGroup = list(
#'           PatchFilters = list(
#'             list(
#'               Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
#'               Values = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         ),
#'         ComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
#'         ApproveAfterDays = 123,
#'         EnableNonSecurity = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   ApprovedPatches = list(
#'     "string"
#'   ),
#'   ApprovedPatchesComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
#'   ApprovedPatchesEnableNonSecurity = TRUE|FALSE,
#'   RejectedPatches = list(
#'     "string"
#'   ),
#'   RejectedPatchesAction = "ALLOW_AS_DEPENDENCY"|"BLOCK",
#'   Description = "string",
#'   Sources = list(
#'     list(
#'       Name = "string",
#'       Products = list(
#'         "string"
#'       ),
#'       Configuration = "string"
#'     )
#'   ),
#'   ClientToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_patch_baseline
ssm_create_patch_baseline <- function(OperatingSystem = NULL, Name, GlobalFilters = NULL, ApprovalRules = NULL, ApprovedPatches = NULL, ApprovedPatchesComplianceLevel = NULL, ApprovedPatchesEnableNonSecurity = NULL, RejectedPatches = NULL, RejectedPatchesAction = NULL, Description = NULL, Sources = NULL, ClientToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_patch_baseline_input(OperatingSystem = OperatingSystem, Name = Name, GlobalFilters = GlobalFilters, ApprovalRules = ApprovalRules, ApprovedPatches = ApprovedPatches, ApprovedPatchesComplianceLevel = ApprovedPatchesComplianceLevel, ApprovedPatchesEnableNonSecurity = ApprovedPatchesEnableNonSecurity, RejectedPatches = RejectedPatches, RejectedPatchesAction = RejectedPatchesAction, Description = Description, Sources = Sources, ClientToken = ClientToken, Tags = Tags)
  output <- .ssm$create_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_patch_baseline <- ssm_create_patch_baseline

#' A resource data sync helps you view data from multiple sources in a
#' single location
#'
#' A resource data sync helps you view data from multiple sources in a
#' single location. Systems Manager offers two types of resource data sync:
#' `SyncToDestination` and `SyncFromSource`.
#' 
#' You can configure Systems Manager Inventory to use the
#' `SyncToDestination` type to synchronize Inventory data from multiple AWS
#' Regions to a single Amazon S3 bucket. For more information, see
#' [Configuring Resource Data Sync for
#' Inventory](http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-inventory-datasync.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' You can configure Systems Manager Explorer to use the
#' `SyncToDestination` type to synchronize operational work items
#' (OpsItems) and operational data (OpsData) from multiple AWS Regions to a
#' single Amazon S3 bucket. You can also configure Explorer to use the
#' `SyncFromSource` type. This type synchronizes OpsItems and OpsData from
#' multiple AWS accounts and Regions by using AWS Organizations. For more
#' information, see [Setting Up Explorer to Display Data from Multiple
#' Accounts and
#' Regions](http://docs.aws.amazon.com/systems-manager/latest/userguide/Explorer-resource-data-sync.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' A resource data sync is an asynchronous operation that returns
#' immediately. After a successful initial sync is completed, the system
#' continuously syncs data. To check the status of a sync, use the
#' ListResourceDataSync.
#' 
#' By default, data is not encrypted in Amazon S3. We strongly recommend
#' that you enable encryption in Amazon S3 to ensure secure data storage.
#' We also recommend that you secure access to the Amazon S3 bucket by
#' creating a restrictive bucket policy.
#'
#' @usage
#' ssm_create_resource_data_sync(SyncName, S3Destination, SyncType,
#'   SyncSource)
#'
#' @param SyncName &#91;required&#93; A name for the configuration.
#' @param S3Destination Amazon S3 configuration details for the sync.
#' @param SyncType Specify `SyncToDestination` to create a resource data sync that
#' synchronizes data from multiple AWS Regions to an Amazon S3 bucket.
#' Specify `SyncFromSource` to synchronize data from multiple AWS accounts
#' and Regions, as listed in AWS Organizations.
#' @param SyncSource Specify information about the data sources to synchronize.
#'
#' @section Request syntax:
#' ```
#' svc$create_resource_data_sync(
#'   SyncName = "string",
#'   S3Destination = list(
#'     BucketName = "string",
#'     Prefix = "string",
#'     SyncFormat = "JsonSerDe",
#'     Region = "string",
#'     AWSKMSKeyARN = "string"
#'   ),
#'   SyncType = "string",
#'   SyncSource = list(
#'     SourceType = "string",
#'     AwsOrganizationsSource = list(
#'       OrganizationSourceType = "string",
#'       OrganizationalUnits = list(
#'         list(
#'           OrganizationalUnitId = "string"
#'         )
#'       )
#'     ),
#'     SourceRegions = list(
#'       "string"
#'     ),
#'     IncludeFutureRegions = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_create_resource_data_sync
ssm_create_resource_data_sync <- function(SyncName, S3Destination = NULL, SyncType = NULL, SyncSource = NULL) {
  op <- new_operation(
    name = "CreateResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$create_resource_data_sync_input(SyncName = SyncName, S3Destination = S3Destination, SyncType = SyncType, SyncSource = SyncSource)
  output <- .ssm$create_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$create_resource_data_sync <- ssm_create_resource_data_sync

#' Deletes an activation
#'
#' Deletes an activation. You are not required to delete an activation. If
#' you delete an activation, you can no longer use it to register
#' additional managed instances. Deleting an activation does not
#' de-register managed instances. You must manually de-register managed
#' instances.
#'
#' @usage
#' ssm_delete_activation(ActivationId)
#'
#' @param ActivationId &#91;required&#93; The ID of the activation that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_activation(
#'   ActivationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_activation
ssm_delete_activation <- function(ActivationId) {
  op <- new_operation(
    name = "DeleteActivation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_activation_input(ActivationId = ActivationId)
  output <- .ssm$delete_activation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_activation <- ssm_delete_activation

#' Disassociates the specified Systems Manager document from the specified
#' instance
#'
#' Disassociates the specified Systems Manager document from the specified
#' instance.
#' 
#' When you disassociate a document from an instance, it does not change
#' the configuration of the instance. To change the configuration state of
#' an instance after you disassociate a document, you must create a new
#' document with the desired configuration and associate it with the
#' instance.
#'
#' @usage
#' ssm_delete_association(Name, InstanceId, AssociationId)
#'
#' @param Name The name of the Systems Manager document.
#' @param InstanceId The ID of the instance.
#' @param AssociationId The association ID that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_association(
#'   Name = "string",
#'   InstanceId = "string",
#'   AssociationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_association
ssm_delete_association <- function(Name = NULL, InstanceId = NULL, AssociationId = NULL) {
  op <- new_operation(
    name = "DeleteAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_association_input(Name = Name, InstanceId = InstanceId, AssociationId = AssociationId)
  output <- .ssm$delete_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_association <- ssm_delete_association

#' Deletes the Systems Manager document and all instance associations to
#' the document
#'
#' Deletes the Systems Manager document and all instance associations to
#' the document.
#' 
#' Before you delete the document, we recommend that you use
#' DeleteAssociation to disassociate all instances that are associated with
#' the document.
#'
#' @usage
#' ssm_delete_document(Name, DocumentVersion, VersionName, Force)
#'
#' @param Name &#91;required&#93; The name of the document.
#' @param DocumentVersion The version of the document that you want to delete. If not provided,
#' all versions of the document are deleted.
#' @param VersionName The version name of the document that you want to delete. If not
#' provided, all versions of the document are deleted.
#' @param Force Some SSM document types require that you specify a `Force` flag before
#' you can delete the document. For example, you must specify a `Force`
#' flag to delete a document of type `ApplicationConfigurationSchema`. You
#' can restrict access to the `Force` flag in an AWS Identity and Access
#' Management (IAM) policy.
#'
#' @section Request syntax:
#' ```
#' svc$delete_document(
#'   Name = "string",
#'   DocumentVersion = "string",
#'   VersionName = "string",
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_document
ssm_delete_document <- function(Name, DocumentVersion = NULL, VersionName = NULL, Force = NULL) {
  op <- new_operation(
    name = "DeleteDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_document_input(Name = Name, DocumentVersion = DocumentVersion, VersionName = VersionName, Force = Force)
  output <- .ssm$delete_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_document <- ssm_delete_document

#' Delete a custom inventory type, or the data associated with a custom
#' Inventory type
#'
#' Delete a custom inventory type, or the data associated with a custom
#' Inventory type. Deleting a custom inventory type is also referred to as
#' deleting a custom inventory schema.
#'
#' @usage
#' ssm_delete_inventory(TypeName, SchemaDeleteOption, DryRun, ClientToken)
#'
#' @param TypeName &#91;required&#93; The name of the custom inventory type for which you want to delete
#' either all previously collected data, or the inventory type itself.
#' @param SchemaDeleteOption Use the `SchemaDeleteOption` to delete a custom inventory type (schema).
#' If you don\'t choose this option, the system only deletes existing
#' inventory data associated with the custom inventory type. Choose one of
#' the following options:
#' 
#' DisableSchema: If you choose this option, the system ignores all
#' inventory data for the specified version, and any earlier versions. To
#' enable this schema again, you must call the `PutInventory` action for a
#' version greater than the disabled version.
#' 
#' DeleteSchema: This option deletes the specified custom type from the
#' Inventory service. You can recreate the schema later, if you want.
#' @param DryRun Use this option to view a summary of the deletion request without
#' deleting any data or the data type. This option is useful when you only
#' want to understand what will be deleted. Once you validate that the data
#' to be deleted is what you intend to delete, you can run the same command
#' without specifying the `DryRun` option.
#' @param ClientToken User-provided idempotency token.
#'
#' @section Request syntax:
#' ```
#' svc$delete_inventory(
#'   TypeName = "string",
#'   SchemaDeleteOption = "DisableSchema"|"DeleteSchema",
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_inventory
ssm_delete_inventory <- function(TypeName, SchemaDeleteOption = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "DeleteInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_inventory_input(TypeName = TypeName, SchemaDeleteOption = SchemaDeleteOption, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ssm$delete_inventory_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_inventory <- ssm_delete_inventory

#' Deletes a maintenance window
#'
#' Deletes a maintenance window.
#'
#' @usage
#' ssm_delete_maintenance_window(WindowId)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_maintenance_window(
#'   WindowId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_maintenance_window
ssm_delete_maintenance_window <- function(WindowId) {
  op <- new_operation(
    name = "DeleteMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_maintenance_window_input(WindowId = WindowId)
  output <- .ssm$delete_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_maintenance_window <- ssm_delete_maintenance_window

#' Delete a parameter from the system
#'
#' Delete a parameter from the system.
#'
#' @usage
#' ssm_delete_parameter(Name)
#'
#' @param Name &#91;required&#93; The name of the parameter to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_parameter(
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_parameter
ssm_delete_parameter <- function(Name) {
  op <- new_operation(
    name = "DeleteParameter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_parameter_input(Name = Name)
  output <- .ssm$delete_parameter_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_parameter <- ssm_delete_parameter

#' Delete a list of parameters
#'
#' Delete a list of parameters.
#'
#' @usage
#' ssm_delete_parameters(Names)
#'
#' @param Names &#91;required&#93; The names of the parameters to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_parameters(
#'   Names = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_parameters
ssm_delete_parameters <- function(Names) {
  op <- new_operation(
    name = "DeleteParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_parameters_input(Names = Names)
  output <- .ssm$delete_parameters_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_parameters <- ssm_delete_parameters

#' Deletes a patch baseline
#'
#' Deletes a patch baseline.
#'
#' @usage
#' ssm_delete_patch_baseline(BaselineId)
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_patch_baseline(
#'   BaselineId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_patch_baseline
ssm_delete_patch_baseline <- function(BaselineId) {
  op <- new_operation(
    name = "DeletePatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_patch_baseline_input(BaselineId = BaselineId)
  output <- .ssm$delete_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_patch_baseline <- ssm_delete_patch_baseline

#' Deletes a Resource Data Sync configuration
#'
#' Deletes a Resource Data Sync configuration. After the configuration is
#' deleted, changes to data on managed instances are no longer synced to or
#' from the target. Deleting a sync configuration does not delete data.
#'
#' @usage
#' ssm_delete_resource_data_sync(SyncName, SyncType)
#'
#' @param SyncName &#91;required&#93; The name of the configuration to delete.
#' @param SyncType Specify the type of resource data sync to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_resource_data_sync(
#'   SyncName = "string",
#'   SyncType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_delete_resource_data_sync
ssm_delete_resource_data_sync <- function(SyncName, SyncType = NULL) {
  op <- new_operation(
    name = "DeleteResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$delete_resource_data_sync_input(SyncName = SyncName, SyncType = SyncType)
  output <- .ssm$delete_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$delete_resource_data_sync <- ssm_delete_resource_data_sync

#' Removes the server or virtual machine from the list of registered
#' servers
#'
#' Removes the server or virtual machine from the list of registered
#' servers. You can reregister the instance again at any time. If you
#' don\'t plan to use Run Command on the server, we suggest uninstalling
#' SSM Agent first.
#'
#' @usage
#' ssm_deregister_managed_instance(InstanceId)
#'
#' @param InstanceId &#91;required&#93; The ID assigned to the managed instance when you registered it using the
#' activation process.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_managed_instance(
#'   InstanceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_managed_instance
ssm_deregister_managed_instance <- function(InstanceId) {
  op <- new_operation(
    name = "DeregisterManagedInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_managed_instance_input(InstanceId = InstanceId)
  output <- .ssm$deregister_managed_instance_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_managed_instance <- ssm_deregister_managed_instance

#' Removes a patch group from a patch baseline
#'
#' Removes a patch group from a patch baseline.
#'
#' @usage
#' ssm_deregister_patch_baseline_for_patch_group(BaselineId, PatchGroup)
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to deregister the patch group from.
#' @param PatchGroup &#91;required&#93; The name of the patch group that should be deregistered from the patch
#' baseline.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_patch_baseline_for_patch_group(
#'   BaselineId = "string",
#'   PatchGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_patch_baseline_for_patch_group
ssm_deregister_patch_baseline_for_patch_group <- function(BaselineId, PatchGroup) {
  op <- new_operation(
    name = "DeregisterPatchBaselineForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_patch_baseline_for_patch_group_input(BaselineId = BaselineId, PatchGroup = PatchGroup)
  output <- .ssm$deregister_patch_baseline_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_patch_baseline_for_patch_group <- ssm_deregister_patch_baseline_for_patch_group

#' Removes a target from a maintenance window
#'
#' Removes a target from a maintenance window.
#'
#' @usage
#' ssm_deregister_target_from_maintenance_window(WindowId, WindowTargetId,
#'   Safe)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the target should be removed from.
#' @param WindowTargetId &#91;required&#93; The ID of the target definition to remove.
#' @param Safe The system checks if the target is being referenced by a task. If the
#' target is being referenced, the system returns an error and does not
#' deregister the target from the maintenance window.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_target_from_maintenance_window(
#'   WindowId = "string",
#'   WindowTargetId = "string",
#'   Safe = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_target_from_maintenance_window
ssm_deregister_target_from_maintenance_window <- function(WindowId, WindowTargetId, Safe = NULL) {
  op <- new_operation(
    name = "DeregisterTargetFromMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_target_from_maintenance_window_input(WindowId = WindowId, WindowTargetId = WindowTargetId, Safe = Safe)
  output <- .ssm$deregister_target_from_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_target_from_maintenance_window <- ssm_deregister_target_from_maintenance_window

#' Removes a task from a maintenance window
#'
#' Removes a task from a maintenance window.
#'
#' @usage
#' ssm_deregister_task_from_maintenance_window(WindowId, WindowTaskId)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the task should be removed from.
#' @param WindowTaskId &#91;required&#93; The ID of the task to remove from the maintenance window.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_task_from_maintenance_window(
#'   WindowId = "string",
#'   WindowTaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_deregister_task_from_maintenance_window
ssm_deregister_task_from_maintenance_window <- function(WindowId, WindowTaskId) {
  op <- new_operation(
    name = "DeregisterTaskFromMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$deregister_task_from_maintenance_window_input(WindowId = WindowId, WindowTaskId = WindowTaskId)
  output <- .ssm$deregister_task_from_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$deregister_task_from_maintenance_window <- ssm_deregister_task_from_maintenance_window

#' Describes details about the activation, such as the date and time the
#' activation was created, its expiration date, the IAM role assigned to
#' the instances in the activation, and the number of instances registered
#' by using this activation
#'
#' Describes details about the activation, such as the date and time the
#' activation was created, its expiration date, the IAM role assigned to
#' the instances in the activation, and the number of instances registered
#' by using this activation.
#'
#' @usage
#' ssm_describe_activations(Filters, MaxResults, NextToken)
#'
#' @param Filters A filter to view information about your activations.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_activations(
#'   Filters = list(
#'     list(
#'       FilterKey = "ActivationIds"|"DefaultInstanceName"|"IamRole",
#'       FilterValues = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_activations
ssm_describe_activations <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeActivations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_activations_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_activations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_activations <- ssm_describe_activations

#' Describes the association for the specified target or instance
#'
#' Describes the association for the specified target or instance. If you
#' created the association by using the `Targets` parameter, then you must
#' retrieve the association by using the association ID. If you created the
#' association by specifying an instance ID and a Systems Manager document,
#' then you retrieve the association by specifying the document name and
#' the instance ID.
#'
#' @usage
#' ssm_describe_association(Name, InstanceId, AssociationId,
#'   AssociationVersion)
#'
#' @param Name The name of the Systems Manager document.
#' @param InstanceId The instance ID.
#' @param AssociationId The association ID for which you want information.
#' @param AssociationVersion Specify the association version to retrieve. To view the latest version,
#' either specify `$LATEST` for this parameter, or omit this parameter. To
#' view a list of all associations for an instance, use ListAssociations.
#' To get a list of versions for a specific association, use
#' ListAssociationVersions.
#'
#' @section Request syntax:
#' ```
#' svc$describe_association(
#'   Name = "string",
#'   InstanceId = "string",
#'   AssociationId = "string",
#'   AssociationVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_association
ssm_describe_association <- function(Name = NULL, InstanceId = NULL, AssociationId = NULL, AssociationVersion = NULL) {
  op <- new_operation(
    name = "DescribeAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_association_input(Name = Name, InstanceId = InstanceId, AssociationId = AssociationId, AssociationVersion = AssociationVersion)
  output <- .ssm$describe_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_association <- ssm_describe_association

#' Use this API action to view information about a specific execution of a
#' specific association
#'
#' Use this API action to view information about a specific execution of a
#' specific association.
#'
#' @usage
#' ssm_describe_association_execution_targets(AssociationId, ExecutionId,
#'   Filters, MaxResults, NextToken)
#'
#' @param AssociationId &#91;required&#93; The association ID that includes the execution for which you want to
#' view details.
#' @param ExecutionId &#91;required&#93; The execution ID for which you want to view details.
#' @param Filters Filters for the request. You can specify the following filters and
#' values.
#' 
#' Status (EQUAL)
#' 
#' ResourceId (EQUAL)
#' 
#' ResourceType (EQUAL)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_association_execution_targets(
#'   AssociationId = "string",
#'   ExecutionId = "string",
#'   Filters = list(
#'     list(
#'       Key = "Status"|"ResourceId"|"ResourceType",
#'       Value = "string"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_association_execution_targets
ssm_describe_association_execution_targets <- function(AssociationId, ExecutionId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAssociationExecutionTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_association_execution_targets_input(AssociationId = AssociationId, ExecutionId = ExecutionId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_association_execution_targets_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_association_execution_targets <- ssm_describe_association_execution_targets

#' Use this API action to view all executions for a specific association ID
#'
#' Use this API action to view all executions for a specific association
#' ID.
#'
#' @usage
#' ssm_describe_association_executions(AssociationId, Filters, MaxResults,
#'   NextToken)
#'
#' @param AssociationId &#91;required&#93; The association ID for which you want to view execution history details.
#' @param Filters Filters for the request. You can specify the following filters and
#' values.
#' 
#' ExecutionId (EQUAL)
#' 
#' Status (EQUAL)
#' 
#' CreatedTime (EQUAL, GREATER\\_THAN, LESS\\_THAN)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_association_executions(
#'   AssociationId = "string",
#'   Filters = list(
#'     list(
#'       Key = "ExecutionId"|"Status"|"CreatedTime",
#'       Value = "string",
#'       Type = "EQUAL"|"LESS_THAN"|"GREATER_THAN"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_association_executions
ssm_describe_association_executions <- function(AssociationId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAssociationExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_association_executions_input(AssociationId = AssociationId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_association_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_association_executions <- ssm_describe_association_executions

#' Provides details about all active and terminated Automation executions
#'
#' Provides details about all active and terminated Automation executions.
#'
#' @usage
#' ssm_describe_automation_executions(Filters, MaxResults, NextToken)
#'
#' @param Filters Filters used to limit the scope of executions that are requested.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_automation_executions(
#'   Filters = list(
#'     list(
#'       Key = "DocumentNamePrefix"|"ExecutionStatus"|"ExecutionId"|"ParentExecutionId"|"CurrentAction"|"StartTimeBefore"|"StartTimeAfter"|"AutomationType"|"TagKey",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_automation_executions
ssm_describe_automation_executions <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAutomationExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_automation_executions_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_automation_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_automation_executions <- ssm_describe_automation_executions

#' Information about all active and terminated step executions in an
#' Automation workflow
#'
#' Information about all active and terminated step executions in an
#' Automation workflow.
#'
#' @usage
#' ssm_describe_automation_step_executions(AutomationExecutionId, Filters,
#'   NextToken, MaxResults, ReverseOrder)
#'
#' @param AutomationExecutionId &#91;required&#93; The Automation execution ID for which you want step execution
#' descriptions.
#' @param Filters One or more filters to limit the number of step executions returned by
#' the request.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param ReverseOrder A boolean that indicates whether to list step executions in reverse
#' order by start time. The default value is false.
#'
#' @section Request syntax:
#' ```
#' svc$describe_automation_step_executions(
#'   AutomationExecutionId = "string",
#'   Filters = list(
#'     list(
#'       Key = "StartTimeBefore"|"StartTimeAfter"|"StepExecutionStatus"|"StepExecutionId"|"StepName"|"Action",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ReverseOrder = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_automation_step_executions
ssm_describe_automation_step_executions <- function(AutomationExecutionId, Filters = NULL, NextToken = NULL, MaxResults = NULL, ReverseOrder = NULL) {
  op <- new_operation(
    name = "DescribeAutomationStepExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_automation_step_executions_input(AutomationExecutionId = AutomationExecutionId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, ReverseOrder = ReverseOrder)
  output <- .ssm$describe_automation_step_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_automation_step_executions <- ssm_describe_automation_step_executions

#' Lists all patches eligible to be included in a patch baseline
#'
#' Lists all patches eligible to be included in a patch baseline.
#'
#' @usage
#' ssm_describe_available_patches(Filters, MaxResults, NextToken)
#'
#' @param Filters Filters used to scope down the returned patches.
#' @param MaxResults The maximum number of patches to return (per page).
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_available_patches(
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_available_patches
ssm_describe_available_patches <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAvailablePatches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_available_patches_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_available_patches_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_available_patches <- ssm_describe_available_patches

#' Describes the specified Systems Manager document
#'
#' Describes the specified Systems Manager document.
#'
#' @usage
#' ssm_describe_document(Name, DocumentVersion, VersionName)
#'
#' @param Name &#91;required&#93; The name of the Systems Manager document.
#' @param DocumentVersion The document version for which you want information. Can be a specific
#' version or the default version.
#' @param VersionName An optional field specifying the version of the artifact associated with
#' the document. For example, \"Release 12, Update 6\". This value is
#' unique across all versions of a document, and cannot be changed.
#'
#' @section Request syntax:
#' ```
#' svc$describe_document(
#'   Name = "string",
#'   DocumentVersion = "string",
#'   VersionName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_document
ssm_describe_document <- function(Name, DocumentVersion = NULL, VersionName = NULL) {
  op <- new_operation(
    name = "DescribeDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_document_input(Name = Name, DocumentVersion = DocumentVersion, VersionName = VersionName)
  output <- .ssm$describe_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_document <- ssm_describe_document

#' Describes the permissions for a Systems Manager document
#'
#' Describes the permissions for a Systems Manager document. If you created
#' the document, you are the owner. If a document is shared, it can either
#' be shared privately (by specifying a user\'s AWS account ID) or publicly
#' (*All*).
#'
#' @usage
#' ssm_describe_document_permission(Name, PermissionType)
#'
#' @param Name &#91;required&#93; The name of the document for which you are the owner.
#' @param PermissionType &#91;required&#93; The permission type for the document. The permission type can be
#' *Share*.
#'
#' @section Request syntax:
#' ```
#' svc$describe_document_permission(
#'   Name = "string",
#'   PermissionType = "Share"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_document_permission
ssm_describe_document_permission <- function(Name, PermissionType) {
  op <- new_operation(
    name = "DescribeDocumentPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_document_permission_input(Name = Name, PermissionType = PermissionType)
  output <- .ssm$describe_document_permission_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_document_permission <- ssm_describe_document_permission

#' All associations for the instance(s)
#'
#' All associations for the instance(s).
#'
#' @usage
#' ssm_describe_effective_instance_associations(InstanceId, MaxResults,
#'   NextToken)
#'
#' @param InstanceId &#91;required&#93; The instance ID for which you want to view all associations.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_effective_instance_associations(
#'   InstanceId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_effective_instance_associations
ssm_describe_effective_instance_associations <- function(InstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEffectiveInstanceAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_effective_instance_associations_input(InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_effective_instance_associations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_effective_instance_associations <- ssm_describe_effective_instance_associations

#' Retrieves the current effective patches (the patch and the approval
#' state) for the specified patch baseline
#'
#' Retrieves the current effective patches (the patch and the approval
#' state) for the specified patch baseline. Note that this API applies only
#' to Windows patch baselines.
#'
#' @usage
#' ssm_describe_effective_patches_for_patch_baseline(BaselineId,
#'   MaxResults, NextToken)
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to retrieve the effective patches for.
#' @param MaxResults The maximum number of patches to return (per page).
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_effective_patches_for_patch_baseline(
#'   BaselineId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_effective_patches_for_patch_baseline
ssm_describe_effective_patches_for_patch_baseline <- function(BaselineId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEffectivePatchesForPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_effective_patches_for_patch_baseline_input(BaselineId = BaselineId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_effective_patches_for_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_effective_patches_for_patch_baseline <- ssm_describe_effective_patches_for_patch_baseline

#' The status of the associations for the instance(s)
#'
#' The status of the associations for the instance(s).
#'
#' @usage
#' ssm_describe_instance_associations_status(InstanceId, MaxResults,
#'   NextToken)
#'
#' @param InstanceId &#91;required&#93; The instance IDs for which you want association status information.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_associations_status(
#'   InstanceId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_associations_status
ssm_describe_instance_associations_status <- function(InstanceId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceAssociationsStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_instance_associations_status_input(InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_instance_associations_status_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_associations_status <- ssm_describe_instance_associations_status

#' Describes one or more of your instances
#'
#' Describes one or more of your instances. You can use this to get
#' information about instances like the operating system platform, the SSM
#' Agent version (Linux), status etc. If you specify one or more instance
#' IDs, it returns information for those instances. If you do not specify
#' instance IDs, it returns information for all your instances. If you
#' specify an instance ID that is not valid or an instance that you do not
#' own, you receive an error.
#' 
#' The IamRole field for this API action is the Amazon Identity and Access
#' Management (IAM) role assigned to on-premises instances. This call does
#' not return the IAM role for Amazon EC2 instances.
#'
#' @usage
#' ssm_describe_instance_information(InstanceInformationFilterList,
#'   Filters, MaxResults, NextToken)
#'
#' @param InstanceInformationFilterList This is a legacy method. We recommend that you don\'t use this method.
#' Instead, use the InstanceInformationFilter action. The
#' `InstanceInformationFilter` action enables you to return instance
#' information by using tags that are specified as a key-value mapping.
#' 
#' If you do use this method, then you can\'t use the
#' `InstanceInformationFilter` action. Using this method and the
#' `InstanceInformationFilter` action causes an exception error.
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' instances. You can filter on Amazon EC2 tag. Specify tags by using a
#' key-value mapping.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_information(
#'   InstanceInformationFilterList = list(
#'     list(
#'       key = "InstanceIds"|"AgentVersion"|"PingStatus"|"PlatformTypes"|"ActivationIds"|"IamRole"|"ResourceType"|"AssociationStatus",
#'       valueSet = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_information
ssm_describe_instance_information <- function(InstanceInformationFilterList = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceInformation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_instance_information_input(InstanceInformationFilterList = InstanceInformationFilterList, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_instance_information_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_information <- ssm_describe_instance_information

#' Retrieves the high-level patch state of one or more instances
#'
#' Retrieves the high-level patch state of one or more instances.
#'
#' @usage
#' ssm_describe_instance_patch_states(InstanceIds, NextToken, MaxResults)
#'
#' @param InstanceIds &#91;required&#93; The ID of the instance whose patch state information should be
#' retrieved.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of instances to return (per page).
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_patch_states(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_patch_states
ssm_describe_instance_patch_states <- function(InstanceIds, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInstancePatchStates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_instance_patch_states_input(InstanceIds = InstanceIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_instance_patch_states_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_patch_states <- ssm_describe_instance_patch_states

#' Retrieves the high-level patch state for the instances in the specified
#' patch group
#'
#' Retrieves the high-level patch state for the instances in the specified
#' patch group.
#'
#' @usage
#' ssm_describe_instance_patch_states_for_patch_group(PatchGroup, Filters,
#'   NextToken, MaxResults)
#'
#' @param PatchGroup &#91;required&#93; The name of the patch group for which the patch state information should
#' be retrieved.
#' @param Filters Each entry in the array is a structure containing:
#' 
#' Key (string between 1 and 200 characters)
#' 
#' Values (array containing a single string)
#' 
#' Type (string \"Equal\", \"NotEqual\", \"LessThan\", \"GreaterThan\")
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of patches to return (per page).
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_patch_states_for_patch_group(
#'   PatchGroup = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Type = "Equal"|"NotEqual"|"LessThan"|"GreaterThan"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_patch_states_for_patch_group
ssm_describe_instance_patch_states_for_patch_group <- function(PatchGroup, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInstancePatchStatesForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_instance_patch_states_for_patch_group_input(PatchGroup = PatchGroup, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_instance_patch_states_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_patch_states_for_patch_group <- ssm_describe_instance_patch_states_for_patch_group

#' Retrieves information about the patches on the specified instance and
#' their state relative to the patch baseline being used for the instance
#'
#' Retrieves information about the patches on the specified instance and
#' their state relative to the patch baseline being used for the instance.
#'
#' @usage
#' ssm_describe_instance_patches(InstanceId, Filters, NextToken,
#'   MaxResults)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance whose patch state information should be
#' retrieved.
#' @param Filters An array of structures. Each entry in the array is a structure
#' containing a Key, Value combination. Valid values for Key are
#' `Classification` \\| `KBId` \\| `Severity` \\| `State`.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of patches to return (per page).
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_patches(
#'   InstanceId = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_instance_patches
ssm_describe_instance_patches <- function(InstanceId, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInstancePatches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_instance_patches_input(InstanceId = InstanceId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_instance_patches_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_instance_patches <- ssm_describe_instance_patches

#' Describes a specific delete inventory operation
#'
#' Describes a specific delete inventory operation.
#'
#' @usage
#' ssm_describe_inventory_deletions(DeletionId, NextToken, MaxResults)
#'
#' @param DeletionId Specify the delete inventory ID for which you want information. This ID
#' was returned by the `DeleteInventory` action.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_inventory_deletions(
#'   DeletionId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_inventory_deletions
ssm_describe_inventory_deletions <- function(DeletionId = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInventoryDeletions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_inventory_deletions_input(DeletionId = DeletionId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$describe_inventory_deletions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_inventory_deletions <- ssm_describe_inventory_deletions

#' Retrieves the individual task executions (one per target) for a
#' particular task run as part of a maintenance window execution
#'
#' Retrieves the individual task executions (one per target) for a
#' particular task run as part of a maintenance window execution.
#'
#' @usage
#' ssm_describe_maintenance_window_execution_task_invocations(
#'   WindowExecutionId, TaskId, Filters, MaxResults, NextToken)
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution the task is part of.
#' @param TaskId &#91;required&#93; The ID of the specific task in the maintenance window task that should
#' be retrieved.
#' @param Filters Optional filters used to scope down the returned task invocations. The
#' supported filter key is STATUS with the corresponding values PENDING,
#' IN\\_PROGRESS, SUCCESS, FAILED, TIMED\\_OUT, CANCELLING, and CANCELLED.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_window_execution_task_invocations(
#'   WindowExecutionId = "string",
#'   TaskId = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_execution_task_invocations
ssm_describe_maintenance_window_execution_task_invocations <- function(WindowExecutionId, TaskId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowExecutionTaskInvocations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_window_execution_task_invocations_input(WindowExecutionId = WindowExecutionId, TaskId = TaskId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_execution_task_invocations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_execution_task_invocations <- ssm_describe_maintenance_window_execution_task_invocations

#' For a given maintenance window execution, lists the tasks that were run
#'
#' For a given maintenance window execution, lists the tasks that were run.
#'
#' @usage
#' ssm_describe_maintenance_window_execution_tasks(WindowExecutionId,
#'   Filters, MaxResults, NextToken)
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution whose task executions should
#' be retrieved.
#' @param Filters Optional filters used to scope down the returned tasks. The supported
#' filter key is STATUS with the corresponding values PENDING,
#' IN\\_PROGRESS, SUCCESS, FAILED, TIMED\\_OUT, CANCELLING, and CANCELLED.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_window_execution_tasks(
#'   WindowExecutionId = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_execution_tasks
ssm_describe_maintenance_window_execution_tasks <- function(WindowExecutionId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowExecutionTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_window_execution_tasks_input(WindowExecutionId = WindowExecutionId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_execution_tasks_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_execution_tasks <- ssm_describe_maintenance_window_execution_tasks

#' Lists the executions of a maintenance window
#'
#' Lists the executions of a maintenance window. This includes information
#' about when the maintenance window was scheduled to be active, and
#' information about tasks registered and run with the maintenance window.
#'
#' @usage
#' ssm_describe_maintenance_window_executions(WindowId, Filters,
#'   MaxResults, NextToken)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window whose executions should be retrieved.
#' @param Filters Each entry in the array is a structure containing:
#' 
#' Key (string, between 1 and 128 characters)
#' 
#' Values (array of strings, each string is between 1 and 256 characters)
#' 
#' The supported Keys are ExecutedBefore and ExecutedAfter with the value
#' being a date/time string such as 2016-11-04T05:00:00Z.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_window_executions(
#'   WindowId = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_executions
ssm_describe_maintenance_window_executions <- function(WindowId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowExecutions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_window_executions_input(WindowId = WindowId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_executions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_executions <- ssm_describe_maintenance_window_executions

#' Retrieves information about upcoming executions of a maintenance window
#'
#' Retrieves information about upcoming executions of a maintenance window.
#'
#' @usage
#' ssm_describe_maintenance_window_schedule(WindowId, Targets,
#'   ResourceType, Filters, MaxResults, NextToken)
#'
#' @param WindowId The ID of the maintenance window to retrieve information about.
#' @param Targets The instance ID or key/value pair to retrieve information about.
#' @param ResourceType The type of resource you want to retrieve information about. For
#' example, \"INSTANCE\".
#' @param Filters Filters used to limit the range of results. For example, you can limit
#' maintenance window executions to only those scheduled before or after a
#' certain date and time.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_window_schedule(
#'   WindowId = "string",
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ResourceType = "INSTANCE"|"RESOURCE_GROUP",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_schedule
ssm_describe_maintenance_window_schedule <- function(WindowId = NULL, Targets = NULL, ResourceType = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowSchedule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_window_schedule_input(WindowId = WindowId, Targets = Targets, ResourceType = ResourceType, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_schedule_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_schedule <- ssm_describe_maintenance_window_schedule

#' Lists the targets registered with the maintenance window
#'
#' Lists the targets registered with the maintenance window.
#'
#' @usage
#' ssm_describe_maintenance_window_targets(WindowId, Filters, MaxResults,
#'   NextToken)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window whose targets should be retrieved.
#' @param Filters Optional filters that can be used to narrow down the scope of the
#' returned window targets. The supported filter keys are Type,
#' WindowTargetId and OwnerInformation.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_window_targets(
#'   WindowId = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_targets
ssm_describe_maintenance_window_targets <- function(WindowId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_window_targets_input(WindowId = WindowId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_targets_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_targets <- ssm_describe_maintenance_window_targets

#' Lists the tasks in a maintenance window
#'
#' Lists the tasks in a maintenance window.
#'
#' @usage
#' ssm_describe_maintenance_window_tasks(WindowId, Filters, MaxResults,
#'   NextToken)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window whose tasks should be retrieved.
#' @param Filters Optional filters used to narrow down the scope of the returned tasks.
#' The supported filter keys are WindowTaskId, TaskArn, Priority, and
#' TaskType.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_window_tasks(
#'   WindowId = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_window_tasks
ssm_describe_maintenance_window_tasks <- function(WindowId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_window_tasks_input(WindowId = WindowId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_window_tasks_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_window_tasks <- ssm_describe_maintenance_window_tasks

#' Retrieves the maintenance windows in an AWS account
#'
#' Retrieves the maintenance windows in an AWS account.
#'
#' @usage
#' ssm_describe_maintenance_windows(Filters, MaxResults, NextToken)
#'
#' @param Filters Optional filters used to narrow down the scope of the returned
#' maintenance windows. Supported filter keys are **Name** and **Enabled**.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_windows(
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_windows
ssm_describe_maintenance_windows <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindows",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_windows_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_windows_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_windows <- ssm_describe_maintenance_windows

#' Retrieves information about the maintenance window targets or tasks that
#' an instance is associated with
#'
#' Retrieves information about the maintenance window targets or tasks that
#' an instance is associated with.
#'
#' @usage
#' ssm_describe_maintenance_windows_for_target(Targets, ResourceType,
#'   MaxResults, NextToken)
#'
#' @param Targets &#91;required&#93; The instance ID or key/value pair to retrieve information about.
#' @param ResourceType &#91;required&#93; The type of resource you want to retrieve information about. For
#' example, \"INSTANCE\".
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_maintenance_windows_for_target(
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ResourceType = "INSTANCE"|"RESOURCE_GROUP",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_maintenance_windows_for_target
ssm_describe_maintenance_windows_for_target <- function(Targets, ResourceType, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeMaintenanceWindowsForTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_maintenance_windows_for_target_input(Targets = Targets, ResourceType = ResourceType, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_maintenance_windows_for_target_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_maintenance_windows_for_target <- ssm_describe_maintenance_windows_for_target

#' Query a set of OpsItems
#'
#' Query a set of OpsItems. You must have permission in AWS Identity and
#' Access Management (IAM) to query a list of OpsItems. For more
#' information, see [Getting Started with
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' Operations engineers and IT professionals use OpsCenter to view,
#' investigate, and remediate operational issues impacting the performance
#' and health of their AWS resources. For more information, see [AWS
#' Systems Manager
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
#' in the *AWS Systems Manager User Guide*.
#'
#' @usage
#' ssm_describe_ops_items(OpsItemFilters, MaxResults, NextToken)
#'
#' @param OpsItemFilters One or more filters to limit the reponse.
#' 
#' -   Key: CreatedTime
#' 
#'     Operations: GreaterThan, LessThan
#' 
#' -   Key: LastModifiedBy
#' 
#'     Operations: Contains, Equals
#' 
#' -   Key: LastModifiedTime
#' 
#'     Operations: GreaterThan, LessThan
#' 
#' -   Key: Priority
#' 
#'     Operations: Equals
#' 
#' -   Key: Source
#' 
#'     Operations: Contains, Equals
#' 
#' -   Key: Status
#' 
#'     Operations: Equals
#' 
#' -   Key: Title
#' 
#'     Operations: Contains
#' 
#' -   Key: OperationalData*
#' 
#'     Operations: Equals
#' 
#' -   Key: OperationalDataKey
#' 
#'     Operations: Equals
#' 
#' -   Key: OperationalDataValue
#' 
#'     Operations: Equals, Contains
#' 
#' -   Key: OpsItemId
#' 
#'     Operations: Equals
#' 
#' -   Key: ResourceId
#' 
#'     Operations: Contains
#' 
#' -   Key: AutomationId
#' 
#'     Operations: Equals
#' 
#' *If you filter the response by using the OperationalData operator,
#' specify a key-value pair by using the following JSON format:
#' \{\"key\":\"key\\_name\",\"value\":\"a\\_value\"\}
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_ops_items(
#'   OpsItemFilters = list(
#'     list(
#'       Key = "Status"|"CreatedBy"|"Source"|"Priority"|"Title"|"OpsItemId"|"CreatedTime"|"LastModifiedTime"|"OperationalData"|"OperationalDataKey"|"OperationalDataValue"|"ResourceId"|"AutomationId"|"Category"|"Severity",
#'       Values = list(
#'         "string"
#'       ),
#'       Operator = "Equal"|"Contains"|"GreaterThan"|"LessThan"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_ops_items
ssm_describe_ops_items <- function(OpsItemFilters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeOpsItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_ops_items_input(OpsItemFilters = OpsItemFilters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_ops_items_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_ops_items <- ssm_describe_ops_items

#' Get information about a parameter
#'
#' Get information about a parameter.
#' 
#' Request results are returned on a best-effort basis. If you specify
#' `MaxResults` in the request, the response includes information up to the
#' limit specified. The number of items returned, however, can be between
#' zero and the value of `MaxResults`. If the service reaches an internal
#' limit while processing the results, it stops the operation and returns
#' the matching values up to that point and a `NextToken`. You can specify
#' the `NextToken` in a subsequent call to get the next set of results.
#'
#' @usage
#' ssm_describe_parameters(Filters, ParameterFilters, MaxResults,
#'   NextToken)
#'
#' @param Filters This data type is deprecated. Instead, use `ParameterFilters`.
#' @param ParameterFilters Filters to limit the request results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_parameters(
#'   Filters = list(
#'     list(
#'       Key = "Name"|"Type"|"KeyId",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ParameterFilters = list(
#'     list(
#'       Key = "string",
#'       Option = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_parameters
ssm_describe_parameters <- function(Filters = NULL, ParameterFilters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_parameters_input(Filters = Filters, ParameterFilters = ParameterFilters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_parameters_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_parameters <- ssm_describe_parameters

#' Lists the patch baselines in your AWS account
#'
#' Lists the patch baselines in your AWS account.
#'
#' @usage
#' ssm_describe_patch_baselines(Filters, MaxResults, NextToken)
#'
#' @param Filters Each element in the array is a structure containing:
#' 
#' Key: (string, \"NAME\\_PREFIX\" or \"OWNER\")
#' 
#' Value: (array of strings, exactly 1 entry, between 1 and 255 characters)
#' @param MaxResults The maximum number of patch baselines to return (per page).
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_patch_baselines(
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_baselines
ssm_describe_patch_baselines <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePatchBaselines",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_patch_baselines_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_patch_baselines_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_baselines <- ssm_describe_patch_baselines

#' Returns high-level aggregated patch compliance state for a patch group
#'
#' Returns high-level aggregated patch compliance state for a patch group.
#'
#' @usage
#' ssm_describe_patch_group_state(PatchGroup)
#'
#' @param PatchGroup &#91;required&#93; The name of the patch group whose patch snapshot should be retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$describe_patch_group_state(
#'   PatchGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_group_state
ssm_describe_patch_group_state <- function(PatchGroup) {
  op <- new_operation(
    name = "DescribePatchGroupState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_patch_group_state_input(PatchGroup = PatchGroup)
  output <- .ssm$describe_patch_group_state_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_group_state <- ssm_describe_patch_group_state

#' Lists all patch groups that have been registered with patch baselines
#'
#' Lists all patch groups that have been registered with patch baselines.
#'
#' @usage
#' ssm_describe_patch_groups(MaxResults, Filters, NextToken)
#'
#' @param MaxResults The maximum number of patch groups to return (per page).
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_patch_groups(
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_groups
ssm_describe_patch_groups <- function(MaxResults = NULL, Filters = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePatchGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_patch_groups_input(MaxResults = MaxResults, Filters = Filters, NextToken = NextToken)
  output <- .ssm$describe_patch_groups_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_groups <- ssm_describe_patch_groups

#' Lists the properties of available patches organized by product, product
#' family, classification, severity, and other properties of available
#' patches
#'
#' Lists the properties of available patches organized by product, product
#' family, classification, severity, and other properties of available
#' patches. You can use the reported properties in the filters you specify
#' in requests for actions such as CreatePatchBaseline,
#' UpdatePatchBaseline, DescribeAvailablePatches, and
#' DescribePatchBaselines.
#' 
#' The following section lists the properties that can be used in filters
#' for each major operating system type:
#' 
#' ### WINDOWS
#' 
#' Valid properties: PRODUCT, PRODUCT\\_FAMILY, CLASSIFICATION,
#' MSRC\\_SEVERITY
#' 
#' ### AMAZON\\_LINUX
#' 
#' Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
#' 
#' ### AMAZON\\_LINUX\\_2
#' 
#' Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
#' 
#' ### UBUNTU
#' 
#' Valid properties: PRODUCT, PRIORITY
#' 
#' ### REDHAT\\_ENTERPRISE\\_LINUX
#' 
#' Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
#' 
#' ### SUSE
#' 
#' Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
#' 
#' ### CENTOS
#' 
#' Valid properties: PRODUCT, CLASSIFICATION, SEVERITY
#'
#' @usage
#' ssm_describe_patch_properties(OperatingSystem, Property, PatchSet,
#'   MaxResults, NextToken)
#'
#' @param OperatingSystem &#91;required&#93; The operating system type for which to list patches.
#' @param Property &#91;required&#93; The patch property for which you want to view patch details.
#' @param PatchSet Indicates whether to list patches for the Windows operating system or
#' for Microsoft applications. Not applicable for Linux operating systems.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_patch_properties(
#'   OperatingSystem = "WINDOWS"|"AMAZON_LINUX"|"AMAZON_LINUX_2"|"UBUNTU"|"REDHAT_ENTERPRISE_LINUX"|"SUSE"|"CENTOS",
#'   Property = "PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PRIORITY"|"SEVERITY",
#'   PatchSet = "OS"|"APPLICATION",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_patch_properties
ssm_describe_patch_properties <- function(OperatingSystem, Property, PatchSet = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePatchProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_patch_properties_input(OperatingSystem = OperatingSystem, Property = Property, PatchSet = PatchSet, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$describe_patch_properties_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_patch_properties <- ssm_describe_patch_properties

#' Retrieves a list of all active sessions (both connected and
#' disconnected) or terminated sessions from the past 30 days
#'
#' Retrieves a list of all active sessions (both connected and
#' disconnected) or terminated sessions from the past 30 days.
#'
#' @usage
#' ssm_describe_sessions(State, MaxResults, NextToken, Filters)
#'
#' @param State &#91;required&#93; The session status to retrieve a list of sessions for. For example,
#' \"Active\".
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param Filters One or more filters to limit the type of sessions returned by the
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_sessions(
#'   State = "Active"|"History",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       key = "InvokedAfter"|"InvokedBefore"|"Target"|"Owner"|"Status",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_describe_sessions
ssm_describe_sessions <- function(State, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeSessions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$describe_sessions_input(State = State, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ssm$describe_sessions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$describe_sessions <- ssm_describe_sessions

#' Get detailed information about a particular Automation execution
#'
#' Get detailed information about a particular Automation execution.
#'
#' @usage
#' ssm_get_automation_execution(AutomationExecutionId)
#'
#' @param AutomationExecutionId &#91;required&#93; The unique identifier for an existing automation execution to examine.
#' The execution ID is returned by StartAutomationExecution when the
#' execution of an Automation document is initiated.
#'
#' @section Request syntax:
#' ```
#' svc$get_automation_execution(
#'   AutomationExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_automation_execution
ssm_get_automation_execution <- function(AutomationExecutionId) {
  op <- new_operation(
    name = "GetAutomationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_automation_execution_input(AutomationExecutionId = AutomationExecutionId)
  output <- .ssm$get_automation_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_automation_execution <- ssm_get_automation_execution

#' Gets the state of the AWS Systems Manager Change Calendar at an
#' optional, specified time
#'
#' Gets the state of the AWS Systems Manager Change Calendar at an
#' optional, specified time. If you specify a time, `GetCalendarState`
#' returns the state of the calendar at a specific time, and returns the
#' next time that the Change Calendar state will transition. If you do not
#' specify a time, `GetCalendarState` assumes the current time. Change
#' Calendar entries have two possible states: `OPEN` or `CLOSED`. For more
#' information about Systems Manager Change Calendar, see [AWS Systems
#' Manager Change
#' Calendar](https://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-change-calendar.html)
#' in the *AWS Systems Manager User Guide*.
#'
#' @usage
#' ssm_get_calendar_state(CalendarNames, AtTime)
#'
#' @param CalendarNames &#91;required&#93; The names or Amazon Resource Names (ARNs) of the Systems Manager
#' documents that represent the calendar entries for which you want to get
#' the state.
#' @param AtTime (Optional) The specific time for which you want to get calendar state
#' information, in [ISO 8601](https://en.wikipedia.org/wiki/ISO_8601)
#' format. If you do not add `AtTime`, the current time is assumed.
#'
#' @section Request syntax:
#' ```
#' svc$get_calendar_state(
#'   CalendarNames = list(
#'     "string"
#'   ),
#'   AtTime = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_calendar_state
ssm_get_calendar_state <- function(CalendarNames, AtTime = NULL) {
  op <- new_operation(
    name = "GetCalendarState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_calendar_state_input(CalendarNames = CalendarNames, AtTime = AtTime)
  output <- .ssm$get_calendar_state_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_calendar_state <- ssm_get_calendar_state

#' Returns detailed information about command execution for an invocation
#' or plugin
#'
#' Returns detailed information about command execution for an invocation
#' or plugin.
#'
#' @usage
#' ssm_get_command_invocation(CommandId, InstanceId, PluginName)
#'
#' @param CommandId &#91;required&#93; (Required) The parent command ID of the invocation plugin.
#' @param InstanceId &#91;required&#93; (Required) The ID of the managed instance targeted by the command. A
#' managed instance can be an Amazon EC2 instance or an instance in your
#' hybrid environment that is configured for Systems Manager.
#' @param PluginName (Optional) The name of the plugin for which you want detailed results.
#' If the document contains only one plugin, the name can be omitted and
#' the details will be returned.
#'
#' @section Request syntax:
#' ```
#' svc$get_command_invocation(
#'   CommandId = "string",
#'   InstanceId = "string",
#'   PluginName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_command_invocation
ssm_get_command_invocation <- function(CommandId, InstanceId, PluginName = NULL) {
  op <- new_operation(
    name = "GetCommandInvocation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_command_invocation_input(CommandId = CommandId, InstanceId = InstanceId, PluginName = PluginName)
  output <- .ssm$get_command_invocation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_command_invocation <- ssm_get_command_invocation

#' Retrieves the Session Manager connection status for an instance to
#' determine whether it is connected and ready to receive Session Manager
#' connections
#'
#' Retrieves the Session Manager connection status for an instance to
#' determine whether it is connected and ready to receive Session Manager
#' connections.
#'
#' @usage
#' ssm_get_connection_status(Target)
#'
#' @param Target &#91;required&#93; The ID of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$get_connection_status(
#'   Target = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_connection_status
ssm_get_connection_status <- function(Target) {
  op <- new_operation(
    name = "GetConnectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_connection_status_input(Target = Target)
  output <- .ssm$get_connection_status_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_connection_status <- ssm_get_connection_status

#' Retrieves the default patch baseline
#'
#' Retrieves the default patch baseline. Note that Systems Manager supports
#' creating multiple default patch baselines. For example, you can create a
#' default patch baseline for each operating system.
#' 
#' If you do not specify an operating system value, the default patch
#' baseline for Windows is returned.
#'
#' @usage
#' ssm_get_default_patch_baseline(OperatingSystem)
#'
#' @param OperatingSystem Returns the default patch baseline for the specified operating system.
#'
#' @section Request syntax:
#' ```
#' svc$get_default_patch_baseline(
#'   OperatingSystem = "WINDOWS"|"AMAZON_LINUX"|"AMAZON_LINUX_2"|"UBUNTU"|"REDHAT_ENTERPRISE_LINUX"|"SUSE"|"CENTOS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_default_patch_baseline
ssm_get_default_patch_baseline <- function(OperatingSystem = NULL) {
  op <- new_operation(
    name = "GetDefaultPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_default_patch_baseline_input(OperatingSystem = OperatingSystem)
  output <- .ssm$get_default_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_default_patch_baseline <- ssm_get_default_patch_baseline

#' Retrieves the current snapshot for the patch baseline the instance uses
#'
#' Retrieves the current snapshot for the patch baseline the instance uses.
#' This API is primarily used by the AWS-RunPatchBaseline Systems Manager
#' document.
#'
#' @usage
#' ssm_get_deployable_patch_snapshot_for_instance(InstanceId, SnapshotId)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance for which the appropriate patch snapshot should
#' be retrieved.
#' @param SnapshotId &#91;required&#93; The user-defined snapshot ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_deployable_patch_snapshot_for_instance(
#'   InstanceId = "string",
#'   SnapshotId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_deployable_patch_snapshot_for_instance
ssm_get_deployable_patch_snapshot_for_instance <- function(InstanceId, SnapshotId) {
  op <- new_operation(
    name = "GetDeployablePatchSnapshotForInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_deployable_patch_snapshot_for_instance_input(InstanceId = InstanceId, SnapshotId = SnapshotId)
  output <- .ssm$get_deployable_patch_snapshot_for_instance_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_deployable_patch_snapshot_for_instance <- ssm_get_deployable_patch_snapshot_for_instance

#' Gets the contents of the specified Systems Manager document
#'
#' Gets the contents of the specified Systems Manager document.
#'
#' @usage
#' ssm_get_document(Name, VersionName, DocumentVersion, DocumentFormat)
#'
#' @param Name &#91;required&#93; The name of the Systems Manager document.
#' @param VersionName An optional field specifying the version of the artifact associated with
#' the document. For example, \"Release 12, Update 6\". This value is
#' unique across all versions of a document, and cannot be changed.
#' @param DocumentVersion The document version for which you want information.
#' @param DocumentFormat Returns the document in the specified format. The document format can be
#' either JSON or YAML. JSON is the default format.
#'
#' @section Request syntax:
#' ```
#' svc$get_document(
#'   Name = "string",
#'   VersionName = "string",
#'   DocumentVersion = "string",
#'   DocumentFormat = "YAML"|"JSON"|"TEXT"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_document
ssm_get_document <- function(Name, VersionName = NULL, DocumentVersion = NULL, DocumentFormat = NULL) {
  op <- new_operation(
    name = "GetDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_document_input(Name = Name, VersionName = VersionName, DocumentVersion = DocumentVersion, DocumentFormat = DocumentFormat)
  output <- .ssm$get_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_document <- ssm_get_document

#' Query inventory information
#'
#' Query inventory information.
#'
#' @usage
#' ssm_get_inventory(Filters, Aggregators, ResultAttributes, NextToken,
#'   MaxResults)
#'
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param Aggregators Returns counts of inventory types based on one or more expressions. For
#' example, if you aggregate by using an expression that uses the
#' `AWS:InstanceInformation.PlatformType` type, you can see a count of how
#' many Windows and Linux instances exist in your inventoried fleet.
#' @param ResultAttributes The list of inventory item types to return.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$get_inventory(
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
#'     )
#'   ),
#'   Aggregators = list(
#'     list(
#'       Expression = "string",
#'       Aggregators = list(),
#'       Groups = list(
#'         list(
#'           Name = "string",
#'           Filters = list(
#'             list(
#'               Key = "string",
#'               Values = list(
#'                 "string"
#'               ),
#'               Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   ResultAttributes = list(
#'     list(
#'       TypeName = "string"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_inventory
ssm_get_inventory <- function(Filters = NULL, Aggregators = NULL, ResultAttributes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_inventory_input(Filters = Filters, Aggregators = Aggregators, ResultAttributes = ResultAttributes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$get_inventory_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_inventory <- ssm_get_inventory

#' Return a list of inventory type names for the account, or return a list
#' of attribute names for a specific Inventory item type
#'
#' Return a list of inventory type names for the account, or return a list
#' of attribute names for a specific Inventory item type.
#'
#' @usage
#' ssm_get_inventory_schema(TypeName, NextToken, MaxResults, Aggregator,
#'   SubType)
#'
#' @param TypeName The type of inventory item to return.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param Aggregator Returns inventory schemas that support aggregation. For example, this
#' call returns the `AWS:InstanceInformation` type, because it supports
#' aggregation based on the `PlatformName`, `PlatformType`, and
#' `PlatformVersion` attributes.
#' @param SubType Returns the sub-type schema for a specified inventory type.
#'
#' @section Request syntax:
#' ```
#' svc$get_inventory_schema(
#'   TypeName = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Aggregator = TRUE|FALSE,
#'   SubType = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_inventory_schema
ssm_get_inventory_schema <- function(TypeName = NULL, NextToken = NULL, MaxResults = NULL, Aggregator = NULL, SubType = NULL) {
  op <- new_operation(
    name = "GetInventorySchema",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_inventory_schema_input(TypeName = TypeName, NextToken = NextToken, MaxResults = MaxResults, Aggregator = Aggregator, SubType = SubType)
  output <- .ssm$get_inventory_schema_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_inventory_schema <- ssm_get_inventory_schema

#' Retrieves a maintenance window
#'
#' Retrieves a maintenance window.
#'
#' @usage
#' ssm_get_maintenance_window(WindowId)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window for which you want to retrieve
#' information.
#'
#' @section Request syntax:
#' ```
#' svc$get_maintenance_window(
#'   WindowId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window
ssm_get_maintenance_window <- function(WindowId) {
  op <- new_operation(
    name = "GetMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_input(WindowId = WindowId)
  output <- .ssm$get_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window <- ssm_get_maintenance_window

#' Retrieves details about a specific a maintenance window execution
#'
#' Retrieves details about a specific a maintenance window execution.
#'
#' @usage
#' ssm_get_maintenance_window_execution(WindowExecutionId)
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution that includes the task.
#'
#' @section Request syntax:
#' ```
#' svc$get_maintenance_window_execution(
#'   WindowExecutionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_execution
ssm_get_maintenance_window_execution <- function(WindowExecutionId) {
  op <- new_operation(
    name = "GetMaintenanceWindowExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_execution_input(WindowExecutionId = WindowExecutionId)
  output <- .ssm$get_maintenance_window_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_execution <- ssm_get_maintenance_window_execution

#' Retrieves the details about a specific task run as part of a maintenance
#' window execution
#'
#' Retrieves the details about a specific task run as part of a maintenance
#' window execution.
#'
#' @usage
#' ssm_get_maintenance_window_execution_task(WindowExecutionId, TaskId)
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution that includes the task.
#' @param TaskId &#91;required&#93; The ID of the specific task execution in the maintenance window task
#' that should be retrieved.
#'
#' @section Request syntax:
#' ```
#' svc$get_maintenance_window_execution_task(
#'   WindowExecutionId = "string",
#'   TaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_execution_task
ssm_get_maintenance_window_execution_task <- function(WindowExecutionId, TaskId) {
  op <- new_operation(
    name = "GetMaintenanceWindowExecutionTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_execution_task_input(WindowExecutionId = WindowExecutionId, TaskId = TaskId)
  output <- .ssm$get_maintenance_window_execution_task_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_execution_task <- ssm_get_maintenance_window_execution_task

#' Retrieves information about a specific task running on a specific target
#'
#' Retrieves information about a specific task running on a specific
#' target.
#'
#' @usage
#' ssm_get_maintenance_window_execution_task_invocation(WindowExecutionId,
#'   TaskId, InvocationId)
#'
#' @param WindowExecutionId &#91;required&#93; The ID of the maintenance window execution for which the task is a part.
#' @param TaskId &#91;required&#93; The ID of the specific task in the maintenance window task that should
#' be retrieved.
#' @param InvocationId &#91;required&#93; The invocation ID to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_maintenance_window_execution_task_invocation(
#'   WindowExecutionId = "string",
#'   TaskId = "string",
#'   InvocationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_execution_task_invocation
ssm_get_maintenance_window_execution_task_invocation <- function(WindowExecutionId, TaskId, InvocationId) {
  op <- new_operation(
    name = "GetMaintenanceWindowExecutionTaskInvocation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_execution_task_invocation_input(WindowExecutionId = WindowExecutionId, TaskId = TaskId, InvocationId = InvocationId)
  output <- .ssm$get_maintenance_window_execution_task_invocation_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_execution_task_invocation <- ssm_get_maintenance_window_execution_task_invocation

#' Lists the tasks in a maintenance window
#'
#' Lists the tasks in a maintenance window.
#'
#' @usage
#' ssm_get_maintenance_window_task(WindowId, WindowTaskId)
#'
#' @param WindowId &#91;required&#93; The maintenance window ID that includes the task to retrieve.
#' @param WindowTaskId &#91;required&#93; The maintenance window task ID to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_maintenance_window_task(
#'   WindowId = "string",
#'   WindowTaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_maintenance_window_task
ssm_get_maintenance_window_task <- function(WindowId, WindowTaskId) {
  op <- new_operation(
    name = "GetMaintenanceWindowTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_maintenance_window_task_input(WindowId = WindowId, WindowTaskId = WindowTaskId)
  output <- .ssm$get_maintenance_window_task_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_maintenance_window_task <- ssm_get_maintenance_window_task

#' Get information about an OpsItem by using the ID
#'
#' Get information about an OpsItem by using the ID. You must have
#' permission in AWS Identity and Access Management (IAM) to view
#' information about an OpsItem. For more information, see [Getting Started
#' with
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' Operations engineers and IT professionals use OpsCenter to view,
#' investigate, and remediate operational issues impacting the performance
#' and health of their AWS resources. For more information, see [AWS
#' Systems Manager
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
#' in the *AWS Systems Manager User Guide*.
#'
#' @usage
#' ssm_get_ops_item(OpsItemId)
#'
#' @param OpsItemId &#91;required&#93; The ID of the OpsItem that you want to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_ops_item(
#'   OpsItemId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_ops_item
ssm_get_ops_item <- function(OpsItemId) {
  op <- new_operation(
    name = "GetOpsItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_ops_item_input(OpsItemId = OpsItemId)
  output <- .ssm$get_ops_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_ops_item <- ssm_get_ops_item

#' View a summary of OpsItems based on specified filters and aggregators
#'
#' View a summary of OpsItems based on specified filters and aggregators.
#'
#' @usage
#' ssm_get_ops_summary(SyncName, Filters, Aggregators, ResultAttributes,
#'   NextToken, MaxResults)
#'
#' @param SyncName Specify the name of a resource data sync to get.
#' @param Filters Optional filters used to scope down the returned OpsItems.
#' @param Aggregators Optional aggregators that return counts of OpsItems based on one or more
#' expressions.
#' @param ResultAttributes The OpsItem data type to return.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$get_ops_summary(
#'   SyncName = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
#'     )
#'   ),
#'   Aggregators = list(
#'     list(
#'       AggregatorType = "string",
#'       TypeName = "string",
#'       AttributeName = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Filters = list(
#'         list(
#'           Key = "string",
#'           Values = list(
#'             "string"
#'           ),
#'           Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
#'         )
#'       ),
#'       Aggregators = list()
#'     )
#'   ),
#'   ResultAttributes = list(
#'     list(
#'       TypeName = "string"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_ops_summary
ssm_get_ops_summary <- function(SyncName = NULL, Filters = NULL, Aggregators = NULL, ResultAttributes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetOpsSummary",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_ops_summary_input(SyncName = SyncName, Filters = Filters, Aggregators = Aggregators, ResultAttributes = ResultAttributes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$get_ops_summary_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_ops_summary <- ssm_get_ops_summary

#' Get information about a parameter by using the parameter name
#'
#' Get information about a parameter by using the parameter name. Don\'t
#' confuse this API action with the GetParameters API action.
#'
#' @usage
#' ssm_get_parameter(Name, WithDecryption)
#'
#' @param Name &#91;required&#93; The name of the parameter you want to query.
#' @param WithDecryption Return decrypted values for secure string parameters. This flag is
#' ignored for String and StringList parameter types.
#'
#' @section Request syntax:
#' ```
#' svc$get_parameter(
#'   Name = "string",
#'   WithDecryption = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameter
ssm_get_parameter <- function(Name, WithDecryption = NULL) {
  op <- new_operation(
    name = "GetParameter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_parameter_input(Name = Name, WithDecryption = WithDecryption)
  output <- .ssm$get_parameter_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameter <- ssm_get_parameter

#' Query a list of all parameters used by the AWS account
#'
#' Query a list of all parameters used by the AWS account.
#'
#' @usage
#' ssm_get_parameter_history(Name, WithDecryption, MaxResults, NextToken)
#'
#' @param Name &#91;required&#93; The name of a parameter you want to query.
#' @param WithDecryption Return decrypted values for secure string parameters. This flag is
#' ignored for String and StringList parameter types.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$get_parameter_history(
#'   Name = "string",
#'   WithDecryption = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameter_history
ssm_get_parameter_history <- function(Name, WithDecryption = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetParameterHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_parameter_history_input(Name = Name, WithDecryption = WithDecryption, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$get_parameter_history_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameter_history <- ssm_get_parameter_history

#' Get details of a parameter
#'
#' Get details of a parameter. Don\'t confuse this API action with the
#' GetParameter API action.
#'
#' @usage
#' ssm_get_parameters(Names, WithDecryption)
#'
#' @param Names &#91;required&#93; Names of the parameters for which you want to query information.
#' @param WithDecryption Return decrypted secure string value. Return decrypted values for secure
#' string parameters. This flag is ignored for String and StringList
#' parameter types.
#'
#' @section Request syntax:
#' ```
#' svc$get_parameters(
#'   Names = list(
#'     "string"
#'   ),
#'   WithDecryption = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameters
ssm_get_parameters <- function(Names, WithDecryption = NULL) {
  op <- new_operation(
    name = "GetParameters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_parameters_input(Names = Names, WithDecryption = WithDecryption)
  output <- .ssm$get_parameters_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameters <- ssm_get_parameters

#' Retrieve information about one or more parameters in a specific
#' hierarchy
#'
#' Retrieve information about one or more parameters in a specific
#' hierarchy.
#' 
#' Request results are returned on a best-effort basis. If you specify
#' `MaxResults` in the request, the response includes information up to the
#' limit specified. The number of items returned, however, can be between
#' zero and the value of `MaxResults`. If the service reaches an internal
#' limit while processing the results, it stops the operation and returns
#' the matching values up to that point and a `NextToken`. You can specify
#' the `NextToken` in a subsequent call to get the next set of results.
#'
#' @usage
#' ssm_get_parameters_by_path(Path, Recursive, ParameterFilters,
#'   WithDecryption, MaxResults, NextToken)
#'
#' @param Path &#91;required&#93; The hierarchy for the parameter. Hierarchies start with a forward slash
#' (/) and end with the parameter name. A parameter name hierarchy can have
#' a maximum of 15 levels. Here is an example of a hierarchy:
#' `/Finance/Prod/IAD/WinServ2016/license33`
#' @param Recursive Retrieve all parameters within a hierarchy.
#' 
#' If a user has access to a path, then the user can access all levels of
#' that path. For example, if a user has permission to access path `/a`,
#' then the user can also access `/a/b`. Even if a user has explicitly been
#' denied access in IAM for parameter `/a/b`, they can still call the
#' GetParametersByPath API action recursively for `/a` and view `/a/b`.
#' @param ParameterFilters Filters to limit the request results.
#' @param WithDecryption Retrieve all parameters in a hierarchy with their value decrypted.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$get_parameters_by_path(
#'   Path = "string",
#'   Recursive = TRUE|FALSE,
#'   ParameterFilters = list(
#'     list(
#'       Key = "string",
#'       Option = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   WithDecryption = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_parameters_by_path
ssm_get_parameters_by_path <- function(Path, Recursive = NULL, ParameterFilters = NULL, WithDecryption = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetParametersByPath",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_parameters_by_path_input(Path = Path, Recursive = Recursive, ParameterFilters = ParameterFilters, WithDecryption = WithDecryption, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$get_parameters_by_path_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_parameters_by_path <- ssm_get_parameters_by_path

#' Retrieves information about a patch baseline
#'
#' Retrieves information about a patch baseline.
#'
#' @usage
#' ssm_get_patch_baseline(BaselineId)
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to retrieve.
#'
#' @section Request syntax:
#' ```
#' svc$get_patch_baseline(
#'   BaselineId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_patch_baseline
ssm_get_patch_baseline <- function(BaselineId) {
  op <- new_operation(
    name = "GetPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_patch_baseline_input(BaselineId = BaselineId)
  output <- .ssm$get_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_patch_baseline <- ssm_get_patch_baseline

#' Retrieves the patch baseline that should be used for the specified patch
#' group
#'
#' Retrieves the patch baseline that should be used for the specified patch
#' group.
#'
#' @usage
#' ssm_get_patch_baseline_for_patch_group(PatchGroup, OperatingSystem)
#'
#' @param PatchGroup &#91;required&#93; The name of the patch group whose patch baseline should be retrieved.
#' @param OperatingSystem Returns he operating system rule specified for patch groups using the
#' patch baseline.
#'
#' @section Request syntax:
#' ```
#' svc$get_patch_baseline_for_patch_group(
#'   PatchGroup = "string",
#'   OperatingSystem = "WINDOWS"|"AMAZON_LINUX"|"AMAZON_LINUX_2"|"UBUNTU"|"REDHAT_ENTERPRISE_LINUX"|"SUSE"|"CENTOS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_patch_baseline_for_patch_group
ssm_get_patch_baseline_for_patch_group <- function(PatchGroup, OperatingSystem = NULL) {
  op <- new_operation(
    name = "GetPatchBaselineForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_patch_baseline_for_patch_group_input(PatchGroup = PatchGroup, OperatingSystem = OperatingSystem)
  output <- .ssm$get_patch_baseline_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_patch_baseline_for_patch_group <- ssm_get_patch_baseline_for_patch_group

#' ServiceSetting is an account-level setting for an AWS service
#'
#' `ServiceSetting` is an account-level setting for an AWS service. This
#' setting defines how a user interacts with or uses a service or a feature
#' of a service. For example, if an AWS service charges money to the
#' account based on feature or service usage, then the AWS service team
#' might create a default setting of \"false\". This means the user can\'t
#' use this feature unless they change the setting to \"true\" and
#' intentionally opt in for a paid feature.
#' 
#' Services map a `SettingId` object to a setting value. AWS services teams
#' define the default value for a `SettingId`. You can\'t create a new
#' `SettingId`, but you can overwrite the default value if you have the
#' `ssm:UpdateServiceSetting` permission for the setting. Use the
#' UpdateServiceSetting API action to change the default setting. Or use
#' the ResetServiceSetting to change the value back to the original value
#' defined by the AWS service team.
#' 
#' Query the current service setting for the account.
#'
#' @usage
#' ssm_get_service_setting(SettingId)
#'
#' @param SettingId &#91;required&#93; The ID of the service setting to get.
#'
#' @section Request syntax:
#' ```
#' svc$get_service_setting(
#'   SettingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_get_service_setting
ssm_get_service_setting <- function(SettingId) {
  op <- new_operation(
    name = "GetServiceSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$get_service_setting_input(SettingId = SettingId)
  output <- .ssm$get_service_setting_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$get_service_setting <- ssm_get_service_setting

#' A parameter label is a user-defined alias to help you manage different
#' versions of a parameter
#'
#' A parameter label is a user-defined alias to help you manage different
#' versions of a parameter. When you modify a parameter, Systems Manager
#' automatically saves a new version and increments the version number by
#' one. A label can help you remember the purpose of a parameter when there
#' are multiple versions.
#' 
#' Parameter labels have the following requirements and restrictions.
#' 
#' -   A version of a parameter can have a maximum of 10 labels.
#' 
#' -   You can\'t attach the same label to different versions of the same
#'     parameter. For example, if version 1 has the label Production, then
#'     you can\'t attach Production to version 2.
#' 
#' -   You can move a label from one version of a parameter to another.
#' 
#' -   You can\'t create a label when you create a new parameter. You must
#'     attach a label to a specific version of a parameter.
#' 
#' -   You can\'t delete a parameter label. If you no longer want to use a
#'     parameter label, then you must move it to a different version of a
#'     parameter.
#' 
#' -   A label can have a maximum of 100 characters.
#' 
#' -   Labels can contain letters (case sensitive), numbers, periods (.),
#'     hyphens (-), or underscores (\\_).
#' 
#' -   Labels can\'t begin with a number, \"aws,\" or \"ssm\" (not case
#'     sensitive). If a label fails to meet these requirements, then the
#'     label is not associated with a parameter and the system displays it
#'     in the list of InvalidLabels.
#'
#' @usage
#' ssm_label_parameter_version(Name, ParameterVersion, Labels)
#'
#' @param Name &#91;required&#93; The parameter name on which you want to attach one or more labels.
#' @param ParameterVersion The specific version of the parameter on which you want to attach one or
#' more labels. If no version is specified, the system attaches the label
#' to the latest version.
#' @param Labels &#91;required&#93; One or more labels to attach to the specified parameter version.
#'
#' @section Request syntax:
#' ```
#' svc$label_parameter_version(
#'   Name = "string",
#'   ParameterVersion = 123,
#'   Labels = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_label_parameter_version
ssm_label_parameter_version <- function(Name, ParameterVersion = NULL, Labels) {
  op <- new_operation(
    name = "LabelParameterVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$label_parameter_version_input(Name = Name, ParameterVersion = ParameterVersion, Labels = Labels)
  output <- .ssm$label_parameter_version_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$label_parameter_version <- ssm_label_parameter_version

#' Retrieves all versions of an association for a specific association ID
#'
#' Retrieves all versions of an association for a specific association ID.
#'
#' @usage
#' ssm_list_association_versions(AssociationId, MaxResults, NextToken)
#'
#' @param AssociationId &#91;required&#93; The association ID for which you want to view all versions.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#'
#' @section Request syntax:
#' ```
#' svc$list_association_versions(
#'   AssociationId = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_association_versions
ssm_list_association_versions <- function(AssociationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociationVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_association_versions_input(AssociationId = AssociationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_association_versions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_association_versions <- ssm_list_association_versions

#' Lists the associations for the specified Systems Manager document or
#' instance
#'
#' Lists the associations for the specified Systems Manager document or
#' instance.
#'
#' @usage
#' ssm_list_associations(AssociationFilterList, MaxResults, NextToken)
#'
#' @param AssociationFilterList One or more filters. Use a filter to return a more specific list of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$list_associations(
#'   AssociationFilterList = list(
#'     list(
#'       key = "InstanceId"|"Name"|"AssociationId"|"AssociationStatusName"|"LastExecutedBefore"|"LastExecutedAfter"|"AssociationName",
#'       value = "string"
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_associations
ssm_list_associations <- function(AssociationFilterList = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_associations_input(AssociationFilterList = AssociationFilterList, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_associations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_associations <- ssm_list_associations

#' An invocation is copy of a command sent to a specific instance
#'
#' An invocation is copy of a command sent to a specific instance. A
#' command can apply to one or more instances. A command invocation applies
#' to one instance. For example, if a user runs SendCommand against three
#' instances, then a command invocation is created for each requested
#' instance ID. ListCommandInvocations provide status about command
#' execution.
#'
#' @usage
#' ssm_list_command_invocations(CommandId, InstanceId, MaxResults,
#'   NextToken, Filters, Details)
#'
#' @param CommandId (Optional) The invocations for a specific command ID.
#' @param InstanceId (Optional) The command execution details for a specific instance ID.
#' @param MaxResults (Optional) The maximum number of items to return for this call. The call
#' also returns a token that you can specify in a subsequent call to get
#' the next set of results.
#' @param NextToken (Optional) The token for the next set of items to return. (You received
#' this token from a previous call.)
#' @param Filters (Optional) One or more filters. Use a filter to return a more specific
#' list of results. Note that the `DocumentName` filter is not supported
#' for ListCommandInvocations.
#' @param Details (Optional) If set this returns the response of the command executions
#' and any command output. By default this is set to False.
#'
#' @section Request syntax:
#' ```
#' svc$list_command_invocations(
#'   CommandId = "string",
#'   InstanceId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       key = "InvokedAfter"|"InvokedBefore"|"Status"|"ExecutionStage"|"DocumentName",
#'       value = "string"
#'     )
#'   ),
#'   Details = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_command_invocations
ssm_list_command_invocations <- function(CommandId = NULL, InstanceId = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, Details = NULL) {
  op <- new_operation(
    name = "ListCommandInvocations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_command_invocations_input(CommandId = CommandId, InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, Details = Details)
  output <- .ssm$list_command_invocations_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_command_invocations <- ssm_list_command_invocations

#' Lists the commands requested by users of the AWS account
#'
#' Lists the commands requested by users of the AWS account.
#'
#' @usage
#' ssm_list_commands(CommandId, InstanceId, MaxResults, NextToken, Filters)
#'
#' @param CommandId (Optional) If provided, lists only the specified command.
#' @param InstanceId (Optional) Lists commands issued against this instance ID.
#' @param MaxResults (Optional) The maximum number of items to return for this call. The call
#' also returns a token that you can specify in a subsequent call to get
#' the next set of results.
#' @param NextToken (Optional) The token for the next set of items to return. (You received
#' this token from a previous call.)
#' @param Filters (Optional) One or more filters. Use a filter to return a more specific
#' list of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_commands(
#'   CommandId = "string",
#'   InstanceId = "string",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       key = "InvokedAfter"|"InvokedBefore"|"Status"|"ExecutionStage"|"DocumentName",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_commands
ssm_list_commands <- function(CommandId = NULL, InstanceId = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "ListCommands",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_commands_input(CommandId = CommandId, InstanceId = InstanceId, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ssm$list_commands_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_commands <- ssm_list_commands

#' For a specified resource ID, this API action returns a list of
#' compliance statuses for different resource types
#'
#' For a specified resource ID, this API action returns a list of
#' compliance statuses for different resource types. Currently, you can
#' only specify one resource ID per call. List results depend on the
#' criteria specified in the filter.
#'
#' @usage
#' ssm_list_compliance_items(Filters, ResourceIds, ResourceTypes,
#'   NextToken, MaxResults)
#'
#' @param Filters One or more compliance filters. Use a filter to return a more specific
#' list of results.
#' @param ResourceIds The ID for the resources from which to get compliance information.
#' Currently, you can only specify one resource ID.
#' @param ResourceTypes The type of resource from which to get compliance information.
#' Currently, the only supported resource type is `ManagedInstance`.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_compliance_items(
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Type = "EQUAL"|"NOT_EQUAL"|"BEGIN_WITH"|"LESS_THAN"|"GREATER_THAN"
#'     )
#'   ),
#'   ResourceIds = list(
#'     "string"
#'   ),
#'   ResourceTypes = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_compliance_items
ssm_list_compliance_items <- function(Filters = NULL, ResourceIds = NULL, ResourceTypes = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComplianceItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_compliance_items_input(Filters = Filters, ResourceIds = ResourceIds, ResourceTypes = ResourceTypes, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_compliance_items_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_compliance_items <- ssm_list_compliance_items

#' Returns a summary count of compliant and non-compliant resources for a
#' compliance type
#'
#' Returns a summary count of compliant and non-compliant resources for a
#' compliance type. For example, this call can return State Manager
#' associations, patches, or custom compliance types according to the
#' filter criteria that you specify.
#'
#' @usage
#' ssm_list_compliance_summaries(Filters, NextToken, MaxResults)
#'
#' @param Filters One or more compliance or inventory filters. Use a filter to return a
#' more specific list of results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. Currently, you can
#' specify null or 50. The call also returns a token that you can specify
#' in a subsequent call to get the next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_compliance_summaries(
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Type = "EQUAL"|"NOT_EQUAL"|"BEGIN_WITH"|"LESS_THAN"|"GREATER_THAN"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_compliance_summaries
ssm_list_compliance_summaries <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComplianceSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_compliance_summaries_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_compliance_summaries_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_compliance_summaries <- ssm_list_compliance_summaries

#' List all versions for a document
#'
#' List all versions for a document.
#'
#' @usage
#' ssm_list_document_versions(Name, MaxResults, NextToken)
#'
#' @param Name &#91;required&#93; The name of the document. You can specify an Amazon Resource Name (ARN).
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$list_document_versions(
#'   Name = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_document_versions
ssm_list_document_versions <- function(Name, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDocumentVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_document_versions_input(Name = Name, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_document_versions_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_document_versions <- ssm_list_document_versions

#' Describes one or more of your Systems Manager documents
#'
#' Describes one or more of your Systems Manager documents.
#'
#' @usage
#' ssm_list_documents(DocumentFilterList, Filters, MaxResults, NextToken)
#'
#' @param DocumentFilterList One or more filters. Use a filter to return a more specific list of
#' results.
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#'
#' @section Request syntax:
#' ```
#' svc$list_documents(
#'   DocumentFilterList = list(
#'     list(
#'       key = "Name"|"Owner"|"PlatformTypes"|"DocumentType",
#'       value = "string"
#'     )
#'   ),
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_documents
ssm_list_documents <- function(DocumentFilterList = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListDocuments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_documents_input(DocumentFilterList = DocumentFilterList, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ssm$list_documents_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_documents <- ssm_list_documents

#' A list of inventory items returned by the request
#'
#' A list of inventory items returned by the request.
#'
#' @usage
#' ssm_list_inventory_entries(InstanceId, TypeName, Filters, NextToken,
#'   MaxResults)
#'
#' @param InstanceId &#91;required&#93; The instance ID for which you want inventory information.
#' @param TypeName &#91;required&#93; The type of inventory item for which you want information.
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a previous call.)
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_inventory_entries(
#'   InstanceId = "string",
#'   TypeName = "string",
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Type = "Equal"|"NotEqual"|"BeginWith"|"LessThan"|"GreaterThan"|"Exists"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_inventory_entries
ssm_list_inventory_entries <- function(InstanceId, TypeName, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListInventoryEntries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_inventory_entries_input(InstanceId = InstanceId, TypeName = TypeName, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_inventory_entries_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_inventory_entries <- ssm_list_inventory_entries

#' Returns a resource-level summary count
#'
#' Returns a resource-level summary count. The summary includes information
#' about compliant and non-compliant statuses and detailed compliance-item
#' severity counts, according to the filter criteria you specify.
#'
#' @usage
#' ssm_list_resource_compliance_summaries(Filters, NextToken, MaxResults)
#'
#' @param Filters One or more filters. Use a filter to return a more specific list of
#' results.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_compliance_summaries(
#'   Filters = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       ),
#'       Type = "EQUAL"|"NOT_EQUAL"|"BEGIN_WITH"|"LESS_THAN"|"GREATER_THAN"
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_resource_compliance_summaries
ssm_list_resource_compliance_summaries <- function(Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListResourceComplianceSummaries",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_resource_compliance_summaries_input(Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_resource_compliance_summaries_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_resource_compliance_summaries <- ssm_list_resource_compliance_summaries

#' Lists your resource data sync configurations
#'
#' Lists your resource data sync configurations. Includes information about
#' the last time a sync attempted to start, the last sync status, and the
#' last time a sync successfully completed.
#' 
#' The number of sync configurations might be too large to return using a
#' single call to `ListResourceDataSync`. You can limit the number of sync
#' configurations returned by using the `MaxResults` parameter. To
#' determine whether there are more sync configurations to list, check the
#' value of `NextToken` in the output. If there are more sync
#' configurations to list, you can request them by specifying the
#' `NextToken` returned in the call to the parameter of a subsequent call.
#'
#' @usage
#' ssm_list_resource_data_sync(SyncType, NextToken, MaxResults)
#'
#' @param SyncType View a list of resource data syncs according to the sync type. Specify
#' `SyncToDestination` to view resource data syncs that synchronize data to
#' an Amazon S3 buckets. Specify `SyncFromSource` to view resource data
#' syncs from AWS Organizations or from multiple AWS Regions.
#' @param NextToken A token to start the list. Use this token to get the next set of
#' results.
#' @param MaxResults The maximum number of items to return for this call. The call also
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#'
#' @section Request syntax:
#' ```
#' svc$list_resource_data_sync(
#'   SyncType = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_resource_data_sync
ssm_list_resource_data_sync <- function(SyncType = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_resource_data_sync_input(SyncType = SyncType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ssm$list_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_resource_data_sync <- ssm_list_resource_data_sync

#' Returns a list of the tags assigned to the specified resource
#'
#' Returns a list of the tags assigned to the specified resource.
#'
#' @usage
#' ssm_list_tags_for_resource(ResourceType, ResourceId)
#'
#' @param ResourceType &#91;required&#93; Returns a list of tags for a specific resource type.
#' @param ResourceId &#91;required&#93; The resource ID for which you want to see a list of tags.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceType = "Document"|"ManagedInstance"|"MaintenanceWindow"|"Parameter"|"PatchBaseline"|"OpsItem",
#'   ResourceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_list_tags_for_resource
ssm_list_tags_for_resource <- function(ResourceType, ResourceId) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$list_tags_for_resource_input(ResourceType = ResourceType, ResourceId = ResourceId)
  output <- .ssm$list_tags_for_resource_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$list_tags_for_resource <- ssm_list_tags_for_resource

#' Shares a Systems Manager document publicly or privately
#'
#' Shares a Systems Manager document publicly or privately. If you share a
#' document privately, you must specify the AWS user account IDs for those
#' people who can use the document. If you share a document publicly, you
#' must specify *All* as the account ID.
#'
#' @usage
#' ssm_modify_document_permission(Name, PermissionType, AccountIdsToAdd,
#'   AccountIdsToRemove, SharedDocumentVersion)
#'
#' @param Name &#91;required&#93; The name of the document that you want to share.
#' @param PermissionType &#91;required&#93; The permission type for the document. The permission type can be
#' *Share*.
#' @param AccountIdsToAdd The AWS user accounts that should have access to the document. The
#' account IDs can either be a group of account IDs or *All*.
#' @param AccountIdsToRemove The AWS user accounts that should no longer have access to the document.
#' The AWS user account can either be a group of account IDs or *All*. This
#' action has a higher priority than *AccountIdsToAdd*. If you specify an
#' account ID to add and the same ID to remove, the system removes access
#' to the document.
#' @param SharedDocumentVersion (Optional) The version of the document to share. If it\'s not specified,
#' the system choose the `Default` version to share.
#'
#' @section Request syntax:
#' ```
#' svc$modify_document_permission(
#'   Name = "string",
#'   PermissionType = "Share",
#'   AccountIdsToAdd = list(
#'     "string"
#'   ),
#'   AccountIdsToRemove = list(
#'     "string"
#'   ),
#'   SharedDocumentVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_modify_document_permission
ssm_modify_document_permission <- function(Name, PermissionType, AccountIdsToAdd = NULL, AccountIdsToRemove = NULL, SharedDocumentVersion = NULL) {
  op <- new_operation(
    name = "ModifyDocumentPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$modify_document_permission_input(Name = Name, PermissionType = PermissionType, AccountIdsToAdd = AccountIdsToAdd, AccountIdsToRemove = AccountIdsToRemove, SharedDocumentVersion = SharedDocumentVersion)
  output <- .ssm$modify_document_permission_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$modify_document_permission <- ssm_modify_document_permission

#' Registers a compliance type and other compliance details on a designated
#' resource
#'
#' Registers a compliance type and other compliance details on a designated
#' resource. This action lets you register custom compliance details with a
#' resource. This call overwrites existing compliance information on the
#' resource, so you must provide a full list of compliance items each time
#' that you send the request.
#' 
#' ComplianceType can be one of the following:
#' 
#' -   ExecutionId: The execution ID when the patch, association, or custom
#'     compliance item was applied.
#' 
#' -   ExecutionType: Specify patch, association, or Custom:`string`.
#' 
#' -   ExecutionTime. The time the patch, association, or custom compliance
#'     item was applied to the instance.
#' 
#' -   Id: The patch, association, or custom compliance ID.
#' 
#' -   Title: A title.
#' 
#' -   Status: The status of the compliance item. For example, `approved`
#'     for patches, or `Failed` for associations.
#' 
#' -   Severity: A patch severity. For example, `critical`.
#' 
#' -   DocumentName: A SSM document name. For example,
#'     AWS-RunPatchBaseline.
#' 
#' -   DocumentVersion: An SSM document version number. For example, 4.
#' 
#' -   Classification: A patch classification. For example,
#'     `security updates`.
#' 
#' -   PatchBaselineId: A patch baseline ID.
#' 
#' -   PatchSeverity: A patch severity. For example, `Critical`.
#' 
#' -   PatchState: A patch state. For example,
#'     `InstancesWithFailedPatches`.
#' 
#' -   PatchGroup: The name of a patch group.
#' 
#' -   InstalledTime: The time the association, patch, or custom compliance
#'     item was applied to the resource. Specify the time by using the
#'     following format: yyyy-MM-dd\'T\'HH:mm:ss\'Z\'
#'
#' @usage
#' ssm_put_compliance_items(ResourceId, ResourceType, ComplianceType,
#'   ExecutionSummary, Items, ItemContentHash)
#'
#' @param ResourceId &#91;required&#93; Specify an ID for this resource. For a managed instance, this is the
#' instance ID.
#' @param ResourceType &#91;required&#93; Specify the type of resource. `ManagedInstance` is currently the only
#' supported resource type.
#' @param ComplianceType &#91;required&#93; Specify the compliance type. For example, specify Association (for a
#' State Manager association), Patch, or Custom:`string`.
#' @param ExecutionSummary &#91;required&#93; A summary of the call execution that includes an execution ID, the type
#' of execution (for example, `Command`), and the date/time of the
#' execution using a datetime object that is saved in the following format:
#' yyyy-MM-dd\'T\'HH:mm:ss\'Z\'.
#' @param Items &#91;required&#93; Information about the compliance as defined by the resource type. For
#' example, for a patch compliance type, `Items` includes information about
#' the PatchSeverity, Classification, etc.
#' @param ItemContentHash MD5 or SHA-256 content hash. The content hash is used to determine if
#' existing information should be overwritten or ignored. If the content
#' hashes match, the request to put compliance information is ignored.
#'
#' @section Request syntax:
#' ```
#' svc$put_compliance_items(
#'   ResourceId = "string",
#'   ResourceType = "string",
#'   ComplianceType = "string",
#'   ExecutionSummary = list(
#'     ExecutionTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     ExecutionId = "string",
#'     ExecutionType = "string"
#'   ),
#'   Items = list(
#'     list(
#'       Id = "string",
#'       Title = "string",
#'       Severity = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
#'       Status = "COMPLIANT"|"NON_COMPLIANT",
#'       Details = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ItemContentHash = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_put_compliance_items
ssm_put_compliance_items <- function(ResourceId, ResourceType, ComplianceType, ExecutionSummary, Items, ItemContentHash = NULL) {
  op <- new_operation(
    name = "PutComplianceItems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$put_compliance_items_input(ResourceId = ResourceId, ResourceType = ResourceType, ComplianceType = ComplianceType, ExecutionSummary = ExecutionSummary, Items = Items, ItemContentHash = ItemContentHash)
  output <- .ssm$put_compliance_items_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$put_compliance_items <- ssm_put_compliance_items

#' Bulk update custom inventory items on one more instance
#'
#' Bulk update custom inventory items on one more instance. The request
#' adds an inventory item, if it doesn\'t already exist, or updates an
#' inventory item, if it does exist.
#'
#' @usage
#' ssm_put_inventory(InstanceId, Items)
#'
#' @param InstanceId &#91;required&#93; An instance ID where you want to add or update inventory items.
#' @param Items &#91;required&#93; The inventory items that you want to add or update on instances.
#'
#' @section Request syntax:
#' ```
#' svc$put_inventory(
#'   InstanceId = "string",
#'   Items = list(
#'     list(
#'       TypeName = "string",
#'       SchemaVersion = "string",
#'       CaptureTime = "string",
#'       ContentHash = "string",
#'       Content = list(
#'         list(
#'           "string"
#'         )
#'       ),
#'       Context = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_put_inventory
ssm_put_inventory <- function(InstanceId, Items) {
  op <- new_operation(
    name = "PutInventory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$put_inventory_input(InstanceId = InstanceId, Items = Items)
  output <- .ssm$put_inventory_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$put_inventory <- ssm_put_inventory

#' Add a parameter to the system
#'
#' Add a parameter to the system.
#'
#' @usage
#' ssm_put_parameter(Name, Description, Value, Type, KeyId, Overwrite,
#'   AllowedPattern, Tags, Tier, Policies)
#'
#' @param Name &#91;required&#93; The fully qualified name of the parameter that you want to add to the
#' system. The fully qualified name includes the complete hierarchy of the
#' parameter path and name. For example: `/Dev/DBServer/MySQL/db-string13`
#' 
#' Naming Constraints:
#' 
#' -   Parameter names are case sensitive.
#' 
#' -   A parameter name must be unique within an AWS Region
#' 
#' -   A parameter name can\'t be prefixed with \"aws\" or \"ssm\"
#'     (case-insensitive).
#' 
#' -   Parameter names can include only the following symbols and letters:
#'     `a-zA-Z0-9_.-/`
#' 
#' -   A parameter name can\'t include spaces.
#' 
#' -   Parameter hierarchies are limited to a maximum depth of fifteen
#'     levels.
#' 
#' For additional information about valid values for parameter names, see
#' [Requirements and Constraints for Parameter
#' Names](http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-parameter-name-constraints.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' The maximum length constraint listed below includes capacity for
#' additional system attributes that are not part of the name. The maximum
#' length for the fully qualified parameter name is 1011 characters,
#' including the full length of the parameter ARN. For example, the
#' following fully qualified parameter name is 65 characters, not 20
#' characters:
#' 
#' `arn:aws:ssm:us-east-2:111122223333:parameter/ExampleParameterName`
#' @param Description Information about the parameter that you want to add to the system.
#' Optional but recommended.
#' 
#' Do not enter personally identifiable information in this field.
#' @param Value &#91;required&#93; The parameter value that you want to add to the system. Standard
#' parameters have a value limit of 4 KB. Advanced parameters have a value
#' limit of 8 KB.
#' @param Type &#91;required&#93; The type of parameter that you want to add to the system.
#' 
#' Items in a `StringList` must be separated by a comma (,). You can\'t use
#' other punctuation or special character to escape items in the list. If
#' you have a parameter value that requires a comma, then use the `String`
#' data type.
#' 
#' `SecureString` is not currently supported for AWS CloudFormation
#' templates or in the China Regions.
#' @param KeyId The KMS Key ID that you want to use to encrypt a parameter. Either the
#' default AWS Key Management Service (AWS KMS) key automatically assigned
#' to your AWS account or a custom key. Required for parameters that use
#' the `SecureString` data type.
#' 
#' If you don\'t specify a key ID, the system uses the default key
#' associated with your AWS account.
#' 
#' -   To use your default AWS KMS key, choose the `SecureString` data
#'     type, and do *not* specify the `Key ID` when you create the
#'     parameter. The system automatically populates `Key ID` with your
#'     default KMS key.
#' 
#' -   To use a custom KMS key, choose the `SecureString` data type with
#'     the `Key ID` parameter.
#' @param Overwrite Overwrite an existing parameter. If not specified, will default to
#' \"false\".
#' @param AllowedPattern A regular expression used to validate the parameter value. For example,
#' for String types with values restricted to numbers, you can specify the
#' following: AllowedPattern=\\^`\\d`+\\$
#' @param Tags Optional metadata that you assign to a resource. Tags enable you to
#' categorize a resource in different ways, such as by purpose, owner, or
#' environment. For example, you might want to tag a Systems Manager
#' parameter to identify the type of resource to which it applies, the
#' environment, or the type of configuration data referenced by the
#' parameter. In this case, you could specify the following key name/value
#' pairs:
#' 
#' -   `Key=Resource,Value=S3bucket`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' -   `Key=ParameterType,Value=LicenseKey`
#' 
#' To add tags to an existing Systems Manager parameter, use the
#' AddTagsToResource action.
#' @param Tier The parameter tier to assign to a parameter.
#' 
#' Parameter Store offers a standard tier and an advanced tier for
#' parameters. Standard parameters have a content size limit of 4 KB and
#' can\'t be configured to use parameter policies. You can create a maximum
#' of 10,000 standard parameters for each Region in an AWS account.
#' Standard parameters are offered at no additional cost.
#' 
#' Advanced parameters have a content size limit of 8 KB and can be
#' configured to use parameter policies. You can create a maximum of
#' 100,000 advanced parameters for each Region in an AWS account. Advanced
#' parameters incur a charge. For more information, see [About Advanced
#' Parameters](http://docs.aws.amazon.com/systems-manager/latest/userguide/parameter-store-advanced-parameters.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' You can change a standard parameter to an advanced parameter any time.
#' But you can\'t revert an advanced parameter to a standard parameter.
#' Reverting an advanced parameter to a standard parameter would result in
#' data loss because the system would truncate the size of the parameter
#' from 8 KB to 4 KB. Reverting would also remove any policies attached to
#' the parameter. Lastly, advanced parameters use a different form of
#' encryption than standard parameters.
#' 
#' If you no longer need an advanced parameter, or if you no longer want to
#' incur charges for an advanced parameter, you must delete it and recreate
#' it as a new standard parameter.
#' 
#' **Using the Default Tier Configuration**
#' 
#' In `PutParameter` requests, you can specify the tier to create the
#' parameter in. Whenever you specify a tier in the request, Parameter
#' Store creates or updates the parameter according to that request.
#' However, if you do not specify a tier in a request, Parameter Store
#' assigns the tier based on the current Parameter Store default tier
#' configuration.
#' 
#' The default tier when you begin using Parameter Store is the
#' standard-parameter tier. If you use the advanced-parameter tier, you can
#' specify one of the following as the default:
#' 
#' -   **Advanced**: With this option, Parameter Store evaluates all
#'     requests as advanced parameters.
#' 
#' -   **Intelligent-Tiering**: With this option, Parameter Store evaluates
#'     each request to determine if the parameter is standard or advanced.
#' 
#'     If the request doesn\'t include any options that require an advanced
#'     parameter, the parameter is created in the standard-parameter tier.
#'     If one or more options requiring an advanced parameter are included
#'     in the request, Parameter Store create a parameter in the
#'     advanced-parameter tier.
#' 
#'     This approach helps control your parameter-related costs by always
#'     creating standard parameters unless an advanced parameter is
#'     necessary.
#' 
#' Options that require an advanced parameter include the following:
#' 
#' -   The content size of the parameter is more than 4 KB.
#' 
#' -   The parameter uses a parameter policy.
#' 
#' -   More than 10,000 parameters already exist in your AWS account in the
#'     current Region.
#' 
#' For more information about configuring the default tier option, see
#' [Specifying a Default Parameter
#' Tier](http://docs.aws.amazon.com/systems-manager/latest/userguide/ps-default-tier.html)
#' in the *AWS Systems Manager User Guide*.
#' @param Policies One or more policies to apply to a parameter. This action takes a JSON
#' array. Parameter Store supports the following policy types:
#' 
#' Expiration: This policy deletes the parameter after it expires. When you
#' create the policy, you specify the expiration date. You can update the
#' expiration date and time by updating the policy. Updating the
#' *parameter* does not affect the expiration date and time. When the
#' expiration time is reached, Parameter Store deletes the parameter.
#' 
#' ExpirationNotification: This policy triggers an event in Amazon
#' CloudWatch Events that notifies you about the expiration. By using this
#' policy, you can receive notification before or after the expiration time
#' is reached, in units of days or hours.
#' 
#' NoChangeNotification: This policy triggers a CloudWatch event if a
#' parameter has not been modified for a specified period of time. This
#' policy type is useful when, for example, a secret needs to be changed
#' within a period of time, but it has not been changed.
#' 
#' All existing policies are preserved until you send new policies or an
#' empty policy. For more information about parameter policies, see
#' [Working with Parameter
#' Policies](http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-paramstore-su-policies.html).
#'
#' @section Request syntax:
#' ```
#' svc$put_parameter(
#'   Name = "string",
#'   Description = "string",
#'   Value = "string",
#'   Type = "String"|"StringList"|"SecureString",
#'   KeyId = "string",
#'   Overwrite = TRUE|FALSE,
#'   AllowedPattern = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Tier = "Standard"|"Advanced"|"Intelligent-Tiering",
#'   Policies = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_put_parameter
ssm_put_parameter <- function(Name, Description = NULL, Value, Type, KeyId = NULL, Overwrite = NULL, AllowedPattern = NULL, Tags = NULL, Tier = NULL, Policies = NULL) {
  op <- new_operation(
    name = "PutParameter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$put_parameter_input(Name = Name, Description = Description, Value = Value, Type = Type, KeyId = KeyId, Overwrite = Overwrite, AllowedPattern = AllowedPattern, Tags = Tags, Tier = Tier, Policies = Policies)
  output <- .ssm$put_parameter_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$put_parameter <- ssm_put_parameter

#' Defines the default patch baseline for the relevant operating system
#'
#' Defines the default patch baseline for the relevant operating system.
#' 
#' To reset the AWS predefined patch baseline as the default, specify the
#' full patch baseline ARN as the baseline ID value. For example, for
#' CentOS, specify
#' `arn:aws:ssm:us-east-2:733109147000:patchbaseline/pb-0574b43a65ea646ed`
#' instead of `pb-0574b43a65ea646ed`.
#'
#' @usage
#' ssm_register_default_patch_baseline(BaselineId)
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline that should be the default patch baseline.
#'
#' @section Request syntax:
#' ```
#' svc$register_default_patch_baseline(
#'   BaselineId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_register_default_patch_baseline
ssm_register_default_patch_baseline <- function(BaselineId) {
  op <- new_operation(
    name = "RegisterDefaultPatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_default_patch_baseline_input(BaselineId = BaselineId)
  output <- .ssm$register_default_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_default_patch_baseline <- ssm_register_default_patch_baseline

#' Registers a patch baseline for a patch group
#'
#' Registers a patch baseline for a patch group.
#'
#' @usage
#' ssm_register_patch_baseline_for_patch_group(BaselineId, PatchGroup)
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to register the patch group with.
#' @param PatchGroup &#91;required&#93; The name of the patch group that should be registered with the patch
#' baseline.
#'
#' @section Request syntax:
#' ```
#' svc$register_patch_baseline_for_patch_group(
#'   BaselineId = "string",
#'   PatchGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_register_patch_baseline_for_patch_group
ssm_register_patch_baseline_for_patch_group <- function(BaselineId, PatchGroup) {
  op <- new_operation(
    name = "RegisterPatchBaselineForPatchGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_patch_baseline_for_patch_group_input(BaselineId = BaselineId, PatchGroup = PatchGroup)
  output <- .ssm$register_patch_baseline_for_patch_group_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_patch_baseline_for_patch_group <- ssm_register_patch_baseline_for_patch_group

#' Registers a target with a maintenance window
#'
#' Registers a target with a maintenance window.
#'
#' @usage
#' ssm_register_target_with_maintenance_window(WindowId, ResourceType,
#'   Targets, OwnerInformation, Name, Description, ClientToken)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the target should be registered with.
#' @param ResourceType &#91;required&#93; The type of target being registered with the maintenance window.
#' @param Targets &#91;required&#93; The targets to register with the maintenance window. In other words, the
#' instances to run commands on when the maintenance window runs.
#' 
#' You can specify targets using instance IDs, resource group names, or
#' tags that have been applied to instances.
#' 
#' **Example 1**: Specify instance IDs
#' 
#' `Key=InstanceIds,Values=<i>instance-id-1</i>,<i>instance-id-2</i>,<i>instance-id-3</i> `
#' 
#' **Example 2**: Use tag key-pairs applied to instances
#' 
#' `Key=tag:<i>my-tag-key</i>,Values=<i>my-tag-value-1</i>,<i>my-tag-value-2</i> `
#' 
#' **Example 3**: Use tag-keys applied to instances
#' 
#' `Key=tag-key,Values=<i>my-tag-key-1</i>,<i>my-tag-key-2</i> `
#' 
#' **Example 4**: Use resource group names
#' 
#' `Key=resource-groups:Name,Values=<i>resource-group-name</i> `
#' 
#' **Example 5**: Use filters for resource group types
#' 
#' `Key=resource-groups:ResourceTypeFilters,Values=<i>resource-type-1</i>,<i>resource-type-2</i> `
#' 
#' For `Key=resource-groups:ResourceTypeFilters`, specify resource types in
#' the following format
#' 
#' `Key=resource-groups:ResourceTypeFilters,Values=<i>AWS::EC2::INSTANCE</i>,<i>AWS::EC2::VPC</i> `
#' 
#' For more information about these examples formats, including the best
#' use case for each one, see [Examples: Register Targets with a
#' Maintenance
#' Window](https://docs.aws.amazon.com/systems-manager/latest/userguide/mw-cli-tutorial-targets-examples.html)
#' in the *AWS Systems Manager User Guide*.
#' @param OwnerInformation User-provided value that will be included in any CloudWatch events
#' raised while running tasks for these targets in this maintenance window.
#' @param Name An optional name for the target.
#' @param Description An optional description for the target.
#' @param ClientToken User-provided idempotency token.
#'
#' @section Request syntax:
#' ```
#' svc$register_target_with_maintenance_window(
#'   WindowId = "string",
#'   ResourceType = "INSTANCE"|"RESOURCE_GROUP",
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   OwnerInformation = "string",
#'   Name = "string",
#'   Description = "string",
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_register_target_with_maintenance_window
ssm_register_target_with_maintenance_window <- function(WindowId, ResourceType, Targets, OwnerInformation = NULL, Name = NULL, Description = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "RegisterTargetWithMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_target_with_maintenance_window_input(WindowId = WindowId, ResourceType = ResourceType, Targets = Targets, OwnerInformation = OwnerInformation, Name = Name, Description = Description, ClientToken = ClientToken)
  output <- .ssm$register_target_with_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_target_with_maintenance_window <- ssm_register_target_with_maintenance_window

#' Adds a new task to a maintenance window
#'
#' Adds a new task to a maintenance window.
#'
#' @usage
#' ssm_register_task_with_maintenance_window(WindowId, Targets, TaskArn,
#'   ServiceRoleArn, TaskType, TaskParameters, TaskInvocationParameters,
#'   Priority, MaxConcurrency, MaxErrors, LoggingInfo, Name, Description,
#'   ClientToken)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window the task should be added to.
#' @param Targets &#91;required&#93; The targets (either instances or maintenance window targets).
#' 
#' Specify instances using the following format:
#' 
#' `Key=InstanceIds,Values=&lt;instance-id-1&gt;,&lt;instance-id-2&gt;`
#' 
#' Specify maintenance window targets using the following format:
#' 
#' `Key=WindowTargetIds;,Values=&lt;window-target-id-1&gt;,&lt;window-target-id-2&gt;`
#' @param TaskArn &#91;required&#93; The ARN of the task to run.
#' @param ServiceRoleArn The ARN of the IAM service role for Systems Manager to assume when
#' running a maintenance window task. If you do not specify a service role
#' ARN, Systems Manager uses your account\'s service-linked role. If no
#' service-linked role for Systems Manager exists in your account, it is
#' created when you run `RegisterTaskWithMaintenanceWindow`.
#' 
#' For more information, see the following topics in the in the *AWS
#' Systems Manager User Guide*:
#' 
#' -   [Service-Linked Role Permissions for Systems
#'     Manager](http://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions)
#' 
#' -   [Should I Use a Service-Linked Role or a Custom Service Role to Run
#'     Maintenance Window
#'     Tasks?](http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role)
#' @param TaskType &#91;required&#93; The type of task being registered.
#' @param TaskParameters The parameters that should be passed to the task when it is run.
#' 
#' `TaskParameters` has been deprecated. To specify parameters to pass to a
#' task when it runs, instead use the `Parameters` option in the
#' `TaskInvocationParameters` structure. For information about how Systems
#' Manager handles these options for the supported maintenance window task
#' types, see MaintenanceWindowTaskInvocationParameters.
#' @param TaskInvocationParameters The parameters that the task should use during execution. Populate only
#' the fields that match the task type. All other fields should be empty.
#' @param Priority The priority of the task in the maintenance window, the lower the number
#' the higher the priority. Tasks in a maintenance window are scheduled in
#' priority order with tasks that have the same priority scheduled in
#' parallel.
#' @param MaxConcurrency &#91;required&#93; The maximum number of targets this task can be run for in parallel.
#' @param MaxErrors &#91;required&#93; The maximum number of errors allowed before this task stops being
#' scheduled.
#' @param LoggingInfo A structure containing information about an Amazon S3 bucket to write
#' instance-level logs to.
#' 
#' `LoggingInfo` has been deprecated. To specify an S3 bucket to contain
#' logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix`
#' options in the `TaskInvocationParameters` structure. For information
#' about how Systems Manager handles these options for the supported
#' maintenance window task types, see
#' MaintenanceWindowTaskInvocationParameters.
#' @param Name An optional name for the task.
#' @param Description An optional description for the task.
#' @param ClientToken User-provided idempotency token.
#'
#' @section Request syntax:
#' ```
#' svc$register_task_with_maintenance_window(
#'   WindowId = "string",
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TaskArn = "string",
#'   ServiceRoleArn = "string",
#'   TaskType = "RUN_COMMAND"|"AUTOMATION"|"STEP_FUNCTIONS"|"LAMBDA",
#'   TaskParameters = list(
#'     list(
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TaskInvocationParameters = list(
#'     RunCommand = list(
#'       Comment = "string",
#'       CloudWatchOutputConfig = list(
#'         CloudWatchLogGroupName = "string",
#'         CloudWatchOutputEnabled = TRUE|FALSE
#'       ),
#'       DocumentHash = "string",
#'       DocumentHashType = "Sha256"|"Sha1",
#'       DocumentVersion = "string",
#'       NotificationConfig = list(
#'         NotificationArn = "string",
#'         NotificationEvents = list(
#'           "All"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed"
#'         ),
#'         NotificationType = "Command"|"Invocation"
#'       ),
#'       OutputS3BucketName = "string",
#'       OutputS3KeyPrefix = "string",
#'       Parameters = list(
#'         list(
#'           "string"
#'         )
#'       ),
#'       ServiceRoleArn = "string",
#'       TimeoutSeconds = 123
#'     ),
#'     Automation = list(
#'       DocumentVersion = "string",
#'       Parameters = list(
#'         list(
#'           "string"
#'         )
#'       )
#'     ),
#'     StepFunctions = list(
#'       Input = "string",
#'       Name = "string"
#'     ),
#'     Lambda = list(
#'       ClientContext = "string",
#'       Qualifier = "string",
#'       Payload = raw
#'     )
#'   ),
#'   Priority = 123,
#'   MaxConcurrency = "string",
#'   MaxErrors = "string",
#'   LoggingInfo = list(
#'     S3BucketName = "string",
#'     S3KeyPrefix = "string",
#'     S3Region = "string"
#'   ),
#'   Name = "string",
#'   Description = "string",
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_register_task_with_maintenance_window
ssm_register_task_with_maintenance_window <- function(WindowId, Targets, TaskArn, ServiceRoleArn = NULL, TaskType, TaskParameters = NULL, TaskInvocationParameters = NULL, Priority = NULL, MaxConcurrency, MaxErrors, LoggingInfo = NULL, Name = NULL, Description = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "RegisterTaskWithMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$register_task_with_maintenance_window_input(WindowId = WindowId, Targets = Targets, TaskArn = TaskArn, ServiceRoleArn = ServiceRoleArn, TaskType = TaskType, TaskParameters = TaskParameters, TaskInvocationParameters = TaskInvocationParameters, Priority = Priority, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, LoggingInfo = LoggingInfo, Name = Name, Description = Description, ClientToken = ClientToken)
  output <- .ssm$register_task_with_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$register_task_with_maintenance_window <- ssm_register_task_with_maintenance_window

#' Removes tag keys from the specified resource
#'
#' Removes tag keys from the specified resource.
#'
#' @usage
#' ssm_remove_tags_from_resource(ResourceType, ResourceId, TagKeys)
#'
#' @param ResourceType &#91;required&#93; The type of resource from which you want to remove a tag.
#' 
#' The ManagedInstance type for this API action is only for on-premises
#' managed instances. Specify the name of the managed instance in the
#' following format: mi-ID\\_number. For example, mi-1a2b3c4d5e6f.
#' @param ResourceId &#91;required&#93; The ID of the resource from which you want to remove tags. For example:
#' 
#' ManagedInstance: mi-012345abcde
#' 
#' MaintenanceWindow: mw-012345abcde
#' 
#' PatchBaseline: pb-012345abcde
#' 
#' For the Document and Parameter values, use the name of the resource.
#' 
#' The ManagedInstance type for this API action is only for on-premises
#' managed instances. Specify the name of the managed instance in the
#' following format: mi-ID\\_number. For example, mi-1a2b3c4d5e6f.
#' @param TagKeys &#91;required&#93; Tag keys that you want to remove from the specified resource.
#'
#' @section Request syntax:
#' ```
#' svc$remove_tags_from_resource(
#'   ResourceType = "Document"|"ManagedInstance"|"MaintenanceWindow"|"Parameter"|"PatchBaseline"|"OpsItem",
#'   ResourceId = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_remove_tags_from_resource
ssm_remove_tags_from_resource <- function(ResourceType, ResourceId, TagKeys) {
  op <- new_operation(
    name = "RemoveTagsFromResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$remove_tags_from_resource_input(ResourceType = ResourceType, ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .ssm$remove_tags_from_resource_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$remove_tags_from_resource <- ssm_remove_tags_from_resource

#' ServiceSetting is an account-level setting for an AWS service
#'
#' `ServiceSetting` is an account-level setting for an AWS service. This
#' setting defines how a user interacts with or uses a service or a feature
#' of a service. For example, if an AWS service charges money to the
#' account based on feature or service usage, then the AWS service team
#' might create a default setting of \"false\". This means the user can\'t
#' use this feature unless they change the setting to \"true\" and
#' intentionally opt in for a paid feature.
#' 
#' Services map a `SettingId` object to a setting value. AWS services teams
#' define the default value for a `SettingId`. You can\'t create a new
#' `SettingId`, but you can overwrite the default value if you have the
#' `ssm:UpdateServiceSetting` permission for the setting. Use the
#' GetServiceSetting API action to view the current value. Use the
#' UpdateServiceSetting API action to change the default setting.
#' 
#' Reset the service setting for the account to the default value as
#' provisioned by the AWS service team.
#'
#' @usage
#' ssm_reset_service_setting(SettingId)
#'
#' @param SettingId &#91;required&#93; The ID of the service setting to reset.
#'
#' @section Request syntax:
#' ```
#' svc$reset_service_setting(
#'   SettingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_reset_service_setting
ssm_reset_service_setting <- function(SettingId) {
  op <- new_operation(
    name = "ResetServiceSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$reset_service_setting_input(SettingId = SettingId)
  output <- .ssm$reset_service_setting_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$reset_service_setting <- ssm_reset_service_setting

#' Reconnects a session to an instance after it has been disconnected
#'
#' Reconnects a session to an instance after it has been disconnected.
#' Connections can be resumed for disconnected sessions, but not terminated
#' sessions.
#' 
#' This command is primarily for use by client machines to automatically
#' reconnect during intermittent network issues. It is not intended for any
#' other use.
#'
#' @usage
#' ssm_resume_session(SessionId)
#'
#' @param SessionId &#91;required&#93; The ID of the disconnected session to resume.
#'
#' @section Request syntax:
#' ```
#' svc$resume_session(
#'   SessionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_resume_session
ssm_resume_session <- function(SessionId) {
  op <- new_operation(
    name = "ResumeSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$resume_session_input(SessionId = SessionId)
  output <- .ssm$resume_session_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$resume_session <- ssm_resume_session

#' Sends a signal to an Automation execution to change the current behavior
#' or status of the execution
#'
#' Sends a signal to an Automation execution to change the current behavior
#' or status of the execution.
#'
#' @usage
#' ssm_send_automation_signal(AutomationExecutionId, SignalType, Payload)
#'
#' @param AutomationExecutionId &#91;required&#93; The unique identifier for an existing Automation execution that you want
#' to send the signal to.
#' @param SignalType &#91;required&#93; The type of signal to send to an Automation execution.
#' @param Payload The data sent with the signal. The data schema depends on the type of
#' signal used in the request.
#' 
#' For `Approve` and `Reject` signal types, the payload is an optional
#' comment that you can send with the signal type. For example:
#' 
#' `Comment="Looks good"`
#' 
#' For `StartStep` and `Resume` signal types, you must send the name of the
#' Automation step to start or resume as the payload. For example:
#' 
#' `StepName="step1"`
#' 
#' For the `StopStep` signal type, you must send the step execution ID as
#' the payload. For example:
#' 
#' `StepExecutionId="97fff367-fc5a-4299-aed8-0123456789ab"`
#'
#' @section Request syntax:
#' ```
#' svc$send_automation_signal(
#'   AutomationExecutionId = "string",
#'   SignalType = "Approve"|"Reject"|"StartStep"|"StopStep"|"Resume",
#'   Payload = list(
#'     list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_send_automation_signal
ssm_send_automation_signal <- function(AutomationExecutionId, SignalType, Payload = NULL) {
  op <- new_operation(
    name = "SendAutomationSignal",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$send_automation_signal_input(AutomationExecutionId = AutomationExecutionId, SignalType = SignalType, Payload = Payload)
  output <- .ssm$send_automation_signal_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$send_automation_signal <- ssm_send_automation_signal

#' Runs commands on one or more managed instances
#'
#' Runs commands on one or more managed instances.
#'
#' @usage
#' ssm_send_command(InstanceIds, Targets, DocumentName, DocumentVersion,
#'   DocumentHash, DocumentHashType, TimeoutSeconds, Comment, Parameters,
#'   OutputS3Region, OutputS3BucketName, OutputS3KeyPrefix, MaxConcurrency,
#'   MaxErrors, ServiceRoleArn, NotificationConfig, CloudWatchOutputConfig)
#'
#' @param InstanceIds The instance IDs where the command should run. You can specify a maximum
#' of 50 IDs. If you prefer not to list individual instance IDs, you can
#' instead send commands to a fleet of instances using the Targets
#' parameter, which accepts EC2 tags. For more information about how to use
#' targets, see [Sending Commands to a
#' Fleet](http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html)
#' in the *AWS Systems Manager User Guide*.
#' @param Targets (Optional) An array of search criteria that targets instances using a
#' Key,Value combination that you specify. Targets is required if you
#' don\'t provide one or more instance IDs in the call. For more
#' information about how to use targets, see [Sending Commands to a
#' Fleet](http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html)
#' in the *AWS Systems Manager User Guide*.
#' @param DocumentName &#91;required&#93; Required. The name of the Systems Manager document to run. This can be a
#' public document or a custom document.
#' @param DocumentVersion The SSM document version to use in the request. You can specify
#' \\$DEFAULT, \\$LATEST, or a specific version number. If you run commands
#' by using the AWS CLI, then you must escape the first two options by
#' using a backslash. If you specify a version number, then you don\'t need
#' to use the backslash. For example:
#' 
#' \\--document-version \"\\\$DEFAULT\"
#' 
#' \\--document-version \"\\\$LATEST\"
#' 
#' \\--document-version \"3\"
#' @param DocumentHash The Sha256 or Sha1 hash created by the system when the document was
#' created.
#' 
#' Sha1 hashes have been deprecated.
#' @param DocumentHashType Sha256 or Sha1.
#' 
#' Sha1 hashes have been deprecated.
#' @param TimeoutSeconds If this time is reached and the command has not already started running,
#' it will not run.
#' @param Comment User-specified information about the command, such as a brief
#' description of what the command should do.
#' @param Parameters The required and optional parameters specified in the document being
#' run.
#' @param OutputS3Region (Deprecated) You can no longer specify this parameter. The system
#' ignores it. Instead, Systems Manager automatically determines the Amazon
#' S3 bucket region.
#' @param OutputS3BucketName The name of the S3 bucket where command execution responses should be
#' stored.
#' @param OutputS3KeyPrefix The directory structure within the S3 bucket where the responses should
#' be stored.
#' @param MaxConcurrency (Optional) The maximum number of instances that are allowed to run the
#' command at the same time. You can specify a number such as 10 or a
#' percentage such as 10%. The default value is 50. For more information
#' about how to use MaxConcurrency, see [Using Concurrency
#' Controls](http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-velocity)
#' in the *AWS Systems Manager User Guide*.
#' @param MaxErrors The maximum number of errors allowed without the command failing. When
#' the command fails one more time beyond the value of MaxErrors, the
#' systems stops sending the command to additional targets. You can specify
#' a number like 10 or a percentage like 10%. The default value is 0. For
#' more information about how to use MaxErrors, see [Using Error
#' Controls](http://docs.aws.amazon.com/systems-manager/latest/userguide/send-commands-multiple.html#send-commands-maxerrors)
#' in the *AWS Systems Manager User Guide*.
#' @param ServiceRoleArn The ARN of the IAM service role to use to publish Amazon Simple
#' Notification Service (Amazon SNS) notifications for Run Command
#' commands.
#' @param NotificationConfig Configurations for sending notifications.
#' @param CloudWatchOutputConfig Enables Systems Manager to send Run Command output to Amazon CloudWatch
#' Logs.
#'
#' @section Request syntax:
#' ```
#' svc$send_command(
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DocumentName = "string",
#'   DocumentVersion = "string",
#'   DocumentHash = "string",
#'   DocumentHashType = "Sha256"|"Sha1",
#'   TimeoutSeconds = 123,
#'   Comment = "string",
#'   Parameters = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   OutputS3Region = "string",
#'   OutputS3BucketName = "string",
#'   OutputS3KeyPrefix = "string",
#'   MaxConcurrency = "string",
#'   MaxErrors = "string",
#'   ServiceRoleArn = "string",
#'   NotificationConfig = list(
#'     NotificationArn = "string",
#'     NotificationEvents = list(
#'       "All"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed"
#'     ),
#'     NotificationType = "Command"|"Invocation"
#'   ),
#'   CloudWatchOutputConfig = list(
#'     CloudWatchLogGroupName = "string",
#'     CloudWatchOutputEnabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_send_command
ssm_send_command <- function(InstanceIds = NULL, Targets = NULL, DocumentName, DocumentVersion = NULL, DocumentHash = NULL, DocumentHashType = NULL, TimeoutSeconds = NULL, Comment = NULL, Parameters = NULL, OutputS3Region = NULL, OutputS3BucketName = NULL, OutputS3KeyPrefix = NULL, MaxConcurrency = NULL, MaxErrors = NULL, ServiceRoleArn = NULL, NotificationConfig = NULL, CloudWatchOutputConfig = NULL) {
  op <- new_operation(
    name = "SendCommand",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$send_command_input(InstanceIds = InstanceIds, Targets = Targets, DocumentName = DocumentName, DocumentVersion = DocumentVersion, DocumentHash = DocumentHash, DocumentHashType = DocumentHashType, TimeoutSeconds = TimeoutSeconds, Comment = Comment, Parameters = Parameters, OutputS3Region = OutputS3Region, OutputS3BucketName = OutputS3BucketName, OutputS3KeyPrefix = OutputS3KeyPrefix, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, ServiceRoleArn = ServiceRoleArn, NotificationConfig = NotificationConfig, CloudWatchOutputConfig = CloudWatchOutputConfig)
  output <- .ssm$send_command_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$send_command <- ssm_send_command

#' Use this API action to run an association immediately and only one time
#'
#' Use this API action to run an association immediately and only one time.
#' This action can be helpful when troubleshooting associations.
#'
#' @usage
#' ssm_start_associations_once(AssociationIds)
#'
#' @param AssociationIds &#91;required&#93; The association IDs that you want to run immediately and only one time.
#'
#' @section Request syntax:
#' ```
#' svc$start_associations_once(
#'   AssociationIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_start_associations_once
ssm_start_associations_once <- function(AssociationIds) {
  op <- new_operation(
    name = "StartAssociationsOnce",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$start_associations_once_input(AssociationIds = AssociationIds)
  output <- .ssm$start_associations_once_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$start_associations_once <- ssm_start_associations_once

#' Initiates execution of an Automation document
#'
#' Initiates execution of an Automation document.
#'
#' @usage
#' ssm_start_automation_execution(DocumentName, DocumentVersion,
#'   Parameters, ClientToken, Mode, TargetParameterName, Targets, TargetMaps,
#'   MaxConcurrency, MaxErrors, TargetLocations, Tags)
#'
#' @param DocumentName &#91;required&#93; The name of the Automation document to use for this execution.
#' @param DocumentVersion The version of the Automation document to use for this execution.
#' @param Parameters A key-value map of execution parameters, which match the declared
#' parameters in the Automation document.
#' @param ClientToken User-provided idempotency token. The token must be unique, is case
#' insensitive, enforces the UUID format, and can\'t be reused.
#' @param Mode The execution mode of the automation. Valid modes include the following:
#' Auto and Interactive. The default mode is Auto.
#' @param TargetParameterName The name of the parameter used as the target resource for the
#' rate-controlled execution. Required if you specify targets.
#' @param Targets A key-value mapping to target resources. Required if you specify
#' TargetParameterName.
#' @param TargetMaps A key-value mapping of document parameters to target resources. Both
#' Targets and TargetMaps cannot be specified together.
#' @param MaxConcurrency The maximum number of targets allowed to run this task in parallel. You
#' can specify a number, such as 10, or a percentage, such as 10%. The
#' default value is 10.
#' @param MaxErrors The number of errors that are allowed before the system stops running
#' the automation on additional targets. You can specify either an absolute
#' number of errors, for example 10, or a percentage of the target set, for
#' example 10%. If you specify 3, for example, the system stops running the
#' automation when the fourth error is received. If you specify 0, then the
#' system stops running the automation on additional targets after the
#' first error result is returned. If you run an automation on 50 resources
#' and set max-errors to 10%, then the system stops running the automation
#' on additional targets when the sixth error is received.
#' 
#' Executions that are already running an automation when max-errors is
#' reached are allowed to complete, but some of these executions may fail
#' as well. If you need to ensure that there won\'t be more than max-errors
#' failed executions, set max-concurrency to 1 so the executions proceed
#' one at a time.
#' @param TargetLocations A location is a combination of AWS Regions and/or AWS accounts where you
#' want to run the Automation. Use this action to start an Automation in
#' multiple Regions and multiple accounts. For more information, see
#' [Executing Automations in Multiple AWS Regions and
#' Accounts](http://docs.aws.amazon.com/systems-manager/latest/userguide/systems-manager-automation-multiple-accounts-and-regions.html)
#' in the *AWS Systems Manager User Guide*.
#' @param Tags Optional metadata that you assign to a resource. You can specify a
#' maximum of five tags for an automation. Tags enable you to categorize a
#' resource in different ways, such as by purpose, owner, or environment.
#' For example, you might want to tag an automation to identify an
#' environment or operating system. In this case, you could specify the
#' following key name/value pairs:
#' 
#' -   `Key=environment,Value=test`
#' 
#' -   `Key=OS,Value=Windows`
#' 
#' To add tags to an existing patch baseline, use the AddTagsToResource
#' action.
#'
#' @section Request syntax:
#' ```
#' svc$start_automation_execution(
#'   DocumentName = "string",
#'   DocumentVersion = "string",
#'   Parameters = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   ClientToken = "string",
#'   Mode = "Auto"|"Interactive",
#'   TargetParameterName = "string",
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TargetMaps = list(
#'     list(
#'       list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxConcurrency = "string",
#'   MaxErrors = "string",
#'   TargetLocations = list(
#'     list(
#'       Accounts = list(
#'         "string"
#'       ),
#'       Regions = list(
#'         "string"
#'       ),
#'       TargetLocationMaxConcurrency = "string",
#'       TargetLocationMaxErrors = "string",
#'       ExecutionRoleName = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_start_automation_execution
ssm_start_automation_execution <- function(DocumentName, DocumentVersion = NULL, Parameters = NULL, ClientToken = NULL, Mode = NULL, TargetParameterName = NULL, Targets = NULL, TargetMaps = NULL, MaxConcurrency = NULL, MaxErrors = NULL, TargetLocations = NULL, Tags = NULL) {
  op <- new_operation(
    name = "StartAutomationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$start_automation_execution_input(DocumentName = DocumentName, DocumentVersion = DocumentVersion, Parameters = Parameters, ClientToken = ClientToken, Mode = Mode, TargetParameterName = TargetParameterName, Targets = Targets, TargetMaps = TargetMaps, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, TargetLocations = TargetLocations, Tags = Tags)
  output <- .ssm$start_automation_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$start_automation_execution <- ssm_start_automation_execution

#' Initiates a connection to a target (for example, an instance) for a
#' Session Manager session
#'
#' Initiates a connection to a target (for example, an instance) for a
#' Session Manager session. Returns a URL and token that can be used to
#' open a WebSocket connection for sending input and receiving outputs.
#' 
#' AWS CLI usage: `start-session` is an interactive command that requires
#' the Session Manager plugin to be installed on the client machine making
#' the call. For information, see [Install the Session Manager Plugin for
#' the AWS
#' CLI](http://docs.aws.amazon.com/systems-manager/latest/userguide/session-manager-working-with-install-plugin.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' AWS Tools for PowerShell usage: Start-SSMSession is not currently
#' supported by AWS Tools for PowerShell on Windows local machines.
#'
#' @usage
#' ssm_start_session(Target, DocumentName, Parameters)
#'
#' @param Target &#91;required&#93; The instance to connect to for the session.
#' @param DocumentName The name of the SSM document to define the parameters and plugin
#' settings for the session. For example, `SSM-SessionManagerRunShell`. If
#' no document name is provided, a shell to the instance is launched by
#' default.
#' @param Parameters Reserved for future use.
#'
#' @section Request syntax:
#' ```
#' svc$start_session(
#'   Target = "string",
#'   DocumentName = "string",
#'   Parameters = list(
#'     list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_start_session
ssm_start_session <- function(Target, DocumentName = NULL, Parameters = NULL) {
  op <- new_operation(
    name = "StartSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$start_session_input(Target = Target, DocumentName = DocumentName, Parameters = Parameters)
  output <- .ssm$start_session_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$start_session <- ssm_start_session

#' Stop an Automation that is currently running
#'
#' Stop an Automation that is currently running.
#'
#' @usage
#' ssm_stop_automation_execution(AutomationExecutionId, Type)
#'
#' @param AutomationExecutionId &#91;required&#93; The execution ID of the Automation to stop.
#' @param Type The stop request type. Valid types include the following: Cancel and
#' Complete. The default type is Cancel.
#'
#' @section Request syntax:
#' ```
#' svc$stop_automation_execution(
#'   AutomationExecutionId = "string",
#'   Type = "Complete"|"Cancel"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_stop_automation_execution
ssm_stop_automation_execution <- function(AutomationExecutionId, Type = NULL) {
  op <- new_operation(
    name = "StopAutomationExecution",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$stop_automation_execution_input(AutomationExecutionId = AutomationExecutionId, Type = Type)
  output <- .ssm$stop_automation_execution_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$stop_automation_execution <- ssm_stop_automation_execution

#' Permanently ends a session and closes the data connection between the
#' Session Manager client and SSM Agent on the instance
#'
#' Permanently ends a session and closes the data connection between the
#' Session Manager client and SSM Agent on the instance. A terminated
#' session cannot be resumed.
#'
#' @usage
#' ssm_terminate_session(SessionId)
#'
#' @param SessionId &#91;required&#93; The ID of the session to terminate.
#'
#' @section Request syntax:
#' ```
#' svc$terminate_session(
#'   SessionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_terminate_session
ssm_terminate_session <- function(SessionId) {
  op <- new_operation(
    name = "TerminateSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$terminate_session_input(SessionId = SessionId)
  output <- .ssm$terminate_session_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$terminate_session <- ssm_terminate_session

#' Updates an association
#'
#' Updates an association. You can update the association name and version,
#' the document version, schedule, parameters, and Amazon S3 output.
#' 
#' In order to call this API action, your IAM user account, group, or role
#' must be configured with permission to call the DescribeAssociation API
#' action. If you don\'t have permission to call DescribeAssociation, then
#' you receive the following error:
#' `An error occurred (AccessDeniedException) when calling the UpdateAssociation operation: User: &lt;user_arn&gt; is not authorized to perform: ssm:DescribeAssociation on resource: &lt;resource_arn&gt;`
#' 
#' When you update an association, the association immediately runs against
#' the specified targets.
#'
#' @usage
#' ssm_update_association(AssociationId, Parameters, DocumentVersion,
#'   ScheduleExpression, OutputLocation, Name, Targets, AssociationName,
#'   AssociationVersion, AutomationTargetParameterName, MaxErrors,
#'   MaxConcurrency, ComplianceSeverity)
#'
#' @param AssociationId &#91;required&#93; The ID of the association you want to update.
#' @param Parameters The parameters you want to update for the association. If you create a
#' parameter using Parameter Store, you can reference the parameter using
#' \{\{ssm:parameter-name\}\}
#' @param DocumentVersion The document version you want update for the association.
#' @param ScheduleExpression The cron expression used to schedule the association that you want to
#' update.
#' @param OutputLocation An Amazon S3 bucket where you want to store the results of this request.
#' @param Name The name of the SSM document that contains the configuration information
#' for the instance. You can specify Command or Automation documents.
#' 
#' You can specify AWS-predefined documents, documents you created, or a
#' document that is shared with you from another account.
#' 
#' For SSM documents that are shared with you from other AWS accounts, you
#' must specify the complete SSM document ARN, in the following format:
#' 
#' `arn:aws:ssm:<i>region</i>:<i>account-id</i>:document/<i>document-name</i> `
#' 
#' For example:
#' 
#' `arn:aws:ssm:us-east-2:12345678912:document/My-Shared-Document`
#' 
#' For AWS-predefined documents and SSM documents you created in your
#' account, you only need to specify the document name. For example,
#' `AWS-ApplyPatchBaseline` or `My-Document`.
#' @param Targets The targets of the association.
#' @param AssociationName The name of the association that you want to update.
#' @param AssociationVersion This parameter is provided for concurrency control purposes. You must
#' specify the latest association version in the service. If you want to
#' ensure that this request succeeds, either specify `$LATEST`, or omit
#' this parameter.
#' @param AutomationTargetParameterName Specify the target for the association. This target is required for
#' associations that use an Automation document and target resources by
#' using rate controls.
#' @param MaxErrors The number of errors that are allowed before the system stops sending
#' requests to run the association on additional targets. You can specify
#' either an absolute number of errors, for example 10, or a percentage of
#' the target set, for example 10%. If you specify 3, for example, the
#' system stops sending requests when the fourth error is received. If you
#' specify 0, then the system stops sending requests after the first error
#' is returned. If you run an association on 50 instances and set MaxError
#' to 10%, then the system stops sending the request when the sixth error
#' is received.
#' 
#' Executions that are already running an association when MaxErrors is
#' reached are allowed to complete, but some of these executions may fail
#' as well. If you need to ensure that there won\'t be more than max-errors
#' failed executions, set MaxConcurrency to 1 so that executions proceed
#' one at a time.
#' @param MaxConcurrency The maximum number of targets allowed to run the association at the same
#' time. You can specify a number, for example 10, or a percentage of the
#' target set, for example 10%. The default value is 100%, which means all
#' targets run the association at the same time.
#' 
#' If a new instance starts and attempts to run an association while
#' Systems Manager is running MaxConcurrency associations, the association
#' is allowed to run. During the next association interval, the new
#' instance will process its association within the limit specified for
#' MaxConcurrency.
#' @param ComplianceSeverity The severity level to assign to the association.
#'
#' @section Request syntax:
#' ```
#' svc$update_association(
#'   AssociationId = "string",
#'   Parameters = list(
#'     list(
#'       "string"
#'     )
#'   ),
#'   DocumentVersion = "string",
#'   ScheduleExpression = "string",
#'   OutputLocation = list(
#'     S3Location = list(
#'       OutputS3Region = "string",
#'       OutputS3BucketName = "string",
#'       OutputS3KeyPrefix = "string"
#'     )
#'   ),
#'   Name = "string",
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   AssociationName = "string",
#'   AssociationVersion = "string",
#'   AutomationTargetParameterName = "string",
#'   MaxErrors = "string",
#'   MaxConcurrency = "string",
#'   ComplianceSeverity = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"UNSPECIFIED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_association
ssm_update_association <- function(AssociationId, Parameters = NULL, DocumentVersion = NULL, ScheduleExpression = NULL, OutputLocation = NULL, Name = NULL, Targets = NULL, AssociationName = NULL, AssociationVersion = NULL, AutomationTargetParameterName = NULL, MaxErrors = NULL, MaxConcurrency = NULL, ComplianceSeverity = NULL) {
  op <- new_operation(
    name = "UpdateAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_association_input(AssociationId = AssociationId, Parameters = Parameters, DocumentVersion = DocumentVersion, ScheduleExpression = ScheduleExpression, OutputLocation = OutputLocation, Name = Name, Targets = Targets, AssociationName = AssociationName, AssociationVersion = AssociationVersion, AutomationTargetParameterName = AutomationTargetParameterName, MaxErrors = MaxErrors, MaxConcurrency = MaxConcurrency, ComplianceSeverity = ComplianceSeverity)
  output <- .ssm$update_association_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_association <- ssm_update_association

#' Updates the status of the Systems Manager document associated with the
#' specified instance
#'
#' Updates the status of the Systems Manager document associated with the
#' specified instance.
#'
#' @usage
#' ssm_update_association_status(Name, InstanceId, AssociationStatus)
#'
#' @param Name &#91;required&#93; The name of the Systems Manager document.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param AssociationStatus &#91;required&#93; The association status.
#'
#' @section Request syntax:
#' ```
#' svc$update_association_status(
#'   Name = "string",
#'   InstanceId = "string",
#'   AssociationStatus = list(
#'     Date = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Name = "Pending"|"Success"|"Failed",
#'     Message = "string",
#'     AdditionalInfo = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_association_status
ssm_update_association_status <- function(Name, InstanceId, AssociationStatus) {
  op <- new_operation(
    name = "UpdateAssociationStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_association_status_input(Name = Name, InstanceId = InstanceId, AssociationStatus = AssociationStatus)
  output <- .ssm$update_association_status_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_association_status <- ssm_update_association_status

#' Updates one or more values for an SSM document
#'
#' Updates one or more values for an SSM document.
#'
#' @usage
#' ssm_update_document(Content, Attachments, Name, VersionName,
#'   DocumentVersion, DocumentFormat, TargetType)
#'
#' @param Content &#91;required&#93; A valid JSON or YAML string.
#' @param Attachments A list of key and value pairs that describe attachments to a version of
#' a document.
#' @param Name &#91;required&#93; The name of the document that you want to update.
#' @param VersionName An optional field specifying the version of the artifact you are
#' updating with the document. For example, \"Release 12, Update 6\". This
#' value is unique across all versions of a document, and cannot be
#' changed.
#' @param DocumentVersion (Required) The version of the document that you want to update.
#' @param DocumentFormat Specify the document format for the new document version. Systems
#' Manager supports JSON and YAML documents. JSON is the default format.
#' @param TargetType Specify a new target type for the document.
#'
#' @section Request syntax:
#' ```
#' svc$update_document(
#'   Content = "string",
#'   Attachments = list(
#'     list(
#'       Key = "SourceUrl"|"S3FileUrl"|"AttachmentReference",
#'       Values = list(
#'         "string"
#'       ),
#'       Name = "string"
#'     )
#'   ),
#'   Name = "string",
#'   VersionName = "string",
#'   DocumentVersion = "string",
#'   DocumentFormat = "YAML"|"JSON"|"TEXT",
#'   TargetType = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_document
ssm_update_document <- function(Content, Attachments = NULL, Name, VersionName = NULL, DocumentVersion = NULL, DocumentFormat = NULL, TargetType = NULL) {
  op <- new_operation(
    name = "UpdateDocument",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_document_input(Content = Content, Attachments = Attachments, Name = Name, VersionName = VersionName, DocumentVersion = DocumentVersion, DocumentFormat = DocumentFormat, TargetType = TargetType)
  output <- .ssm$update_document_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_document <- ssm_update_document

#' Set the default version of a document
#'
#' Set the default version of a document.
#'
#' @usage
#' ssm_update_document_default_version(Name, DocumentVersion)
#'
#' @param Name &#91;required&#93; The name of a custom document that you want to set as the default
#' version.
#' @param DocumentVersion &#91;required&#93; The version of a custom document that you want to set as the default
#' version.
#'
#' @section Request syntax:
#' ```
#' svc$update_document_default_version(
#'   Name = "string",
#'   DocumentVersion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_document_default_version
ssm_update_document_default_version <- function(Name, DocumentVersion) {
  op <- new_operation(
    name = "UpdateDocumentDefaultVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_document_default_version_input(Name = Name, DocumentVersion = DocumentVersion)
  output <- .ssm$update_document_default_version_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_document_default_version <- ssm_update_document_default_version

#' Updates an existing maintenance window
#'
#' Updates an existing maintenance window. Only specified parameters are
#' modified.
#' 
#' The value you specify for `Duration` determines the specific end time
#' for the maintenance window based on the time it begins. No maintenance
#' window tasks are permitted to start after the resulting endtime minus
#' the number of hours you specify for `Cutoff`. For example, if the
#' maintenance window starts at 3 PM, the duration is three hours, and the
#' value you specify for `Cutoff` is one hour, no maintenance window tasks
#' can start after 5 PM.
#'
#' @usage
#' ssm_update_maintenance_window(WindowId, Name, Description, StartDate,
#'   EndDate, Schedule, ScheduleTimezone, Duration, Cutoff,
#'   AllowUnassociatedTargets, Enabled, Replace)
#'
#' @param WindowId &#91;required&#93; The ID of the maintenance window to update.
#' @param Name The name of the maintenance window.
#' @param Description An optional description for the update request.
#' @param StartDate The time zone that the scheduled maintenance window executions are based
#' on, in Internet Assigned Numbers Authority (IANA) format. For example:
#' \"America/Los\\_Angeles\", \"etc/UTC\", or \"Asia/Seoul\". For more
#' information, see the [Time Zone
#' Database](https://www.iana.org/time-zones) on the IANA website.
#' @param EndDate The date and time, in ISO-8601 Extended format, for when you want the
#' maintenance window to become inactive. EndDate allows you to set a date
#' and time in the future when the maintenance window will no longer run.
#' @param Schedule The schedule of the maintenance window in the form of a cron or rate
#' expression.
#' @param ScheduleTimezone The time zone that the scheduled maintenance window executions are based
#' on, in Internet Assigned Numbers Authority (IANA) format. For example:
#' \"America/Los\\_Angeles\", \"etc/UTC\", or \"Asia/Seoul\". For more
#' information, see the [Time Zone
#' Database](https://www.iana.org/time-zones) on the IANA website.
#' @param Duration The duration of the maintenance window in hours.
#' @param Cutoff The number of hours before the end of the maintenance window that
#' Systems Manager stops scheduling new tasks for execution.
#' @param AllowUnassociatedTargets Whether targets must be registered with the maintenance window before
#' tasks can be defined for those targets.
#' @param Enabled Whether the maintenance window is enabled.
#' @param Replace If True, then all fields that are required by the
#' CreateMaintenanceWindow action are also required for this API request.
#' Optional fields that are not specified are set to null.
#'
#' @section Request syntax:
#' ```
#' svc$update_maintenance_window(
#'   WindowId = "string",
#'   Name = "string",
#'   Description = "string",
#'   StartDate = "string",
#'   EndDate = "string",
#'   Schedule = "string",
#'   ScheduleTimezone = "string",
#'   Duration = 123,
#'   Cutoff = 123,
#'   AllowUnassociatedTargets = TRUE|FALSE,
#'   Enabled = TRUE|FALSE,
#'   Replace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_maintenance_window
ssm_update_maintenance_window <- function(WindowId, Name = NULL, Description = NULL, StartDate = NULL, EndDate = NULL, Schedule = NULL, ScheduleTimezone = NULL, Duration = NULL, Cutoff = NULL, AllowUnassociatedTargets = NULL, Enabled = NULL, Replace = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceWindow",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_maintenance_window_input(WindowId = WindowId, Name = Name, Description = Description, StartDate = StartDate, EndDate = EndDate, Schedule = Schedule, ScheduleTimezone = ScheduleTimezone, Duration = Duration, Cutoff = Cutoff, AllowUnassociatedTargets = AllowUnassociatedTargets, Enabled = Enabled, Replace = Replace)
  output <- .ssm$update_maintenance_window_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_maintenance_window <- ssm_update_maintenance_window

#' Modifies the target of an existing maintenance window
#'
#' Modifies the target of an existing maintenance window. You can change
#' the following:
#' 
#' -   Name
#' 
#' -   Description
#' 
#' -   Owner
#' 
#' -   IDs for an ID target
#' 
#' -   Tags for a Tag target
#' 
#' -   From any supported tag type to another. The three supported tag
#'     types are ID target, Tag target, and resource group. For more
#'     information, see Target.
#' 
#' If a parameter is null, then the corresponding field is not modified.
#'
#' @usage
#' ssm_update_maintenance_window_target(WindowId, WindowTargetId, Targets,
#'   OwnerInformation, Name, Description, Replace)
#'
#' @param WindowId &#91;required&#93; The maintenance window ID with which to modify the target.
#' @param WindowTargetId &#91;required&#93; The target ID to modify.
#' @param Targets The targets to add or replace.
#' @param OwnerInformation User-provided value that will be included in any CloudWatch events
#' raised while running tasks for these targets in this maintenance window.
#' @param Name A name for the update.
#' @param Description An optional description for the update.
#' @param Replace If True, then all fields that are required by the
#' RegisterTargetWithMaintenanceWindow action are also required for this
#' API request. Optional fields that are not specified are set to null.
#'
#' @section Request syntax:
#' ```
#' svc$update_maintenance_window_target(
#'   WindowId = "string",
#'   WindowTargetId = "string",
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   OwnerInformation = "string",
#'   Name = "string",
#'   Description = "string",
#'   Replace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_maintenance_window_target
ssm_update_maintenance_window_target <- function(WindowId, WindowTargetId, Targets = NULL, OwnerInformation = NULL, Name = NULL, Description = NULL, Replace = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceWindowTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_maintenance_window_target_input(WindowId = WindowId, WindowTargetId = WindowTargetId, Targets = Targets, OwnerInformation = OwnerInformation, Name = Name, Description = Description, Replace = Replace)
  output <- .ssm$update_maintenance_window_target_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_maintenance_window_target <- ssm_update_maintenance_window_target

#' Modifies a task assigned to a maintenance window
#'
#' Modifies a task assigned to a maintenance window. You can\'t change the
#' task type, but you can change the following values:
#' 
#' -   TaskARN. For example, you can change a RUN\\_COMMAND task from
#'     AWS-RunPowerShellScript to AWS-RunShellScript.
#' 
#' -   ServiceRoleArn
#' 
#' -   TaskInvocationParameters
#' 
#' -   Priority
#' 
#' -   MaxConcurrency
#' 
#' -   MaxErrors
#' 
#' If a parameter is null, then the corresponding field is not modified.
#' Also, if you set Replace to true, then all fields required by the
#' RegisterTaskWithMaintenanceWindow action are required for this request.
#' Optional fields that aren\'t specified are set to null.
#'
#' @usage
#' ssm_update_maintenance_window_task(WindowId, WindowTaskId, Targets,
#'   TaskArn, ServiceRoleArn, TaskParameters, TaskInvocationParameters,
#'   Priority, MaxConcurrency, MaxErrors, LoggingInfo, Name, Description,
#'   Replace)
#'
#' @param WindowId &#91;required&#93; The maintenance window ID that contains the task to modify.
#' @param WindowTaskId &#91;required&#93; The task ID to modify.
#' @param Targets The targets (either instances or tags) to modify. Instances are
#' specified using Key=instanceids,Values=instanceID\\_1,instanceID\\_2. Tags
#' are specified using Key=tag\\_name,Values=tag\\_value.
#' @param TaskArn The task ARN to modify.
#' @param ServiceRoleArn The ARN of the IAM service role for Systems Manager to assume when
#' running a maintenance window task. If you do not specify a service role
#' ARN, Systems Manager uses your account\'s service-linked role. If no
#' service-linked role for Systems Manager exists in your account, it is
#' created when you run `RegisterTaskWithMaintenanceWindow`.
#' 
#' For more information, see the following topics in the in the *AWS
#' Systems Manager User Guide*:
#' 
#' -   [Service-Linked Role Permissions for Systems
#'     Manager](http://docs.aws.amazon.com/systems-manager/latest/userguide/using-service-linked-roles.html#slr-permissions)
#' 
#' -   [Should I Use a Service-Linked Role or a Custom Service Role to Run
#'     Maintenance Window
#'     Tasks?](http://docs.aws.amazon.com/systems-manager/latest/userguide/sysman-maintenance-permissions.html#maintenance-window-tasks-service-role)
#' @param TaskParameters The parameters to modify.
#' 
#' `TaskParameters` has been deprecated. To specify parameters to pass to a
#' task when it runs, instead use the `Parameters` option in the
#' `TaskInvocationParameters` structure. For information about how Systems
#' Manager handles these options for the supported maintenance window task
#' types, see MaintenanceWindowTaskInvocationParameters.
#' 
#' The map has the following format:
#' 
#' Key: string, between 1 and 255 characters
#' 
#' Value: an array of strings, each string is between 1 and 255 characters
#' @param TaskInvocationParameters The parameters that the task should use during execution. Populate only
#' the fields that match the task type. All other fields should be empty.
#' @param Priority The new task priority to specify. The lower the number, the higher the
#' priority. Tasks that have the same priority are scheduled in parallel.
#' @param MaxConcurrency The new `MaxConcurrency` value you want to specify. `MaxConcurrency` is
#' the number of targets that are allowed to run this task in parallel.
#' @param MaxErrors The new `MaxErrors` value to specify. `MaxErrors` is the maximum number
#' of errors that are allowed before the task stops being scheduled.
#' @param LoggingInfo The new logging location in Amazon S3 to specify.
#' 
#' `LoggingInfo` has been deprecated. To specify an S3 bucket to contain
#' logs, instead use the `OutputS3BucketName` and `OutputS3KeyPrefix`
#' options in the `TaskInvocationParameters` structure. For information
#' about how Systems Manager handles these options for the supported
#' maintenance window task types, see
#' MaintenanceWindowTaskInvocationParameters.
#' @param Name The new task name to specify.
#' @param Description The new task description to specify.
#' @param Replace If True, then all fields that are required by the
#' RegisterTaskWithMaintenanceWndow action are also required for this API
#' request. Optional fields that are not specified are set to null.
#'
#' @section Request syntax:
#' ```
#' svc$update_maintenance_window_task(
#'   WindowId = "string",
#'   WindowTaskId = "string",
#'   Targets = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TaskArn = "string",
#'   ServiceRoleArn = "string",
#'   TaskParameters = list(
#'     list(
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TaskInvocationParameters = list(
#'     RunCommand = list(
#'       Comment = "string",
#'       CloudWatchOutputConfig = list(
#'         CloudWatchLogGroupName = "string",
#'         CloudWatchOutputEnabled = TRUE|FALSE
#'       ),
#'       DocumentHash = "string",
#'       DocumentHashType = "Sha256"|"Sha1",
#'       DocumentVersion = "string",
#'       NotificationConfig = list(
#'         NotificationArn = "string",
#'         NotificationEvents = list(
#'           "All"|"InProgress"|"Success"|"TimedOut"|"Cancelled"|"Failed"
#'         ),
#'         NotificationType = "Command"|"Invocation"
#'       ),
#'       OutputS3BucketName = "string",
#'       OutputS3KeyPrefix = "string",
#'       Parameters = list(
#'         list(
#'           "string"
#'         )
#'       ),
#'       ServiceRoleArn = "string",
#'       TimeoutSeconds = 123
#'     ),
#'     Automation = list(
#'       DocumentVersion = "string",
#'       Parameters = list(
#'         list(
#'           "string"
#'         )
#'       )
#'     ),
#'     StepFunctions = list(
#'       Input = "string",
#'       Name = "string"
#'     ),
#'     Lambda = list(
#'       ClientContext = "string",
#'       Qualifier = "string",
#'       Payload = raw
#'     )
#'   ),
#'   Priority = 123,
#'   MaxConcurrency = "string",
#'   MaxErrors = "string",
#'   LoggingInfo = list(
#'     S3BucketName = "string",
#'     S3KeyPrefix = "string",
#'     S3Region = "string"
#'   ),
#'   Name = "string",
#'   Description = "string",
#'   Replace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_maintenance_window_task
ssm_update_maintenance_window_task <- function(WindowId, WindowTaskId, Targets = NULL, TaskArn = NULL, ServiceRoleArn = NULL, TaskParameters = NULL, TaskInvocationParameters = NULL, Priority = NULL, MaxConcurrency = NULL, MaxErrors = NULL, LoggingInfo = NULL, Name = NULL, Description = NULL, Replace = NULL) {
  op <- new_operation(
    name = "UpdateMaintenanceWindowTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_maintenance_window_task_input(WindowId = WindowId, WindowTaskId = WindowTaskId, Targets = Targets, TaskArn = TaskArn, ServiceRoleArn = ServiceRoleArn, TaskParameters = TaskParameters, TaskInvocationParameters = TaskInvocationParameters, Priority = Priority, MaxConcurrency = MaxConcurrency, MaxErrors = MaxErrors, LoggingInfo = LoggingInfo, Name = Name, Description = Description, Replace = Replace)
  output <- .ssm$update_maintenance_window_task_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_maintenance_window_task <- ssm_update_maintenance_window_task

#' Assigns or changes an Amazon Identity and Access Management (IAM) role
#' for the managed instance
#'
#' Assigns or changes an Amazon Identity and Access Management (IAM) role
#' for the managed instance.
#'
#' @usage
#' ssm_update_managed_instance_role(InstanceId, IamRole)
#'
#' @param InstanceId &#91;required&#93; The ID of the managed instance where you want to update the role.
#' @param IamRole &#91;required&#93; The IAM role you want to assign or change.
#'
#' @section Request syntax:
#' ```
#' svc$update_managed_instance_role(
#'   InstanceId = "string",
#'   IamRole = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_managed_instance_role
ssm_update_managed_instance_role <- function(InstanceId, IamRole) {
  op <- new_operation(
    name = "UpdateManagedInstanceRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_managed_instance_role_input(InstanceId = InstanceId, IamRole = IamRole)
  output <- .ssm$update_managed_instance_role_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_managed_instance_role <- ssm_update_managed_instance_role

#' Edit or change an OpsItem
#'
#' Edit or change an OpsItem. You must have permission in AWS Identity and
#' Access Management (IAM) to update an OpsItem. For more information, see
#' [Getting Started with
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-getting-started.html)
#' in the *AWS Systems Manager User Guide*.
#' 
#' Operations engineers and IT professionals use OpsCenter to view,
#' investigate, and remediate operational issues impacting the performance
#' and health of their AWS resources. For more information, see [AWS
#' Systems Manager
#' OpsCenter](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter.html)
#' in the *AWS Systems Manager User Guide*.
#'
#' @usage
#' ssm_update_ops_item(Description, OperationalData,
#'   OperationalDataToDelete, Notifications, Priority, RelatedOpsItems,
#'   Status, OpsItemId, Title, Category, Severity)
#'
#' @param Description Update the information about the OpsItem. Provide enough information so
#' that users reading this OpsItem for the first time understand the issue.
#' @param OperationalData Add new keys or edit existing key-value pairs of the OperationalData map
#' in the OpsItem object.
#' 
#' Operational data is custom data that provides useful reference details
#' about the OpsItem. For example, you can specify log files, error
#' strings, license keys, troubleshooting tips, or other relevant data. You
#' enter operational data as key-value pairs. The key has a maximum length
#' of 128 characters. The value has a maximum size of 20 KB.
#' 
#' Operational data keys *can\'t* begin with the following: amazon, aws,
#' amzn, ssm, /amazon, /aws, /amzn, /ssm.
#' 
#' You can choose to make the data searchable by other users in the account
#' or you can restrict search access. Searchable data means that all users
#' with access to the OpsItem Overview page (as provided by the
#' DescribeOpsItems API action) can view and search on the specified data.
#' Operational data that is not searchable is only viewable by users who
#' have access to the OpsItem (as provided by the GetOpsItem API action).
#' 
#' Use the `/aws/resources` key in OperationalData to specify a related
#' resource in the request. Use the `/aws/automations` key in
#' OperationalData to associate an Automation runbook with the OpsItem. To
#' view AWS CLI example commands that use these keys, see [Creating
#' OpsItems
#' Manually](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-creating-OpsItems.html#OpsCenter-manually-create-OpsItems)
#' in the *AWS Systems Manager User Guide*.
#' @param OperationalDataToDelete Keys that you want to remove from the OperationalData map.
#' @param Notifications The Amazon Resource Name (ARN) of an SNS topic where notifications are
#' sent when this OpsItem is edited or changed.
#' @param Priority The importance of this OpsItem in relation to other OpsItems in the
#' system.
#' @param RelatedOpsItems One or more OpsItems that share something in common with the current
#' OpsItems. For example, related OpsItems can include OpsItems with
#' similar error messages, impacted resources, or statuses for the impacted
#' resource.
#' @param Status The OpsItem status. Status can be `Open`, `In Progress`, or `Resolved`.
#' For more information, see [Editing OpsItem
#' Details](http://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-working-with-OpsItems-editing-details.html)
#' in the *AWS Systems Manager User Guide*.
#' @param OpsItemId &#91;required&#93; The ID of the OpsItem.
#' @param Title A short heading that describes the nature of the OpsItem and the
#' impacted resource.
#' @param Category Specify a new category for an OpsItem.
#' @param Severity Specify a new severity for an OpsItem.
#'
#' @section Request syntax:
#' ```
#' svc$update_ops_item(
#'   Description = "string",
#'   OperationalData = list(
#'     list(
#'       Value = "string",
#'       Type = "SearchableString"|"String"
#'     )
#'   ),
#'   OperationalDataToDelete = list(
#'     "string"
#'   ),
#'   Notifications = list(
#'     list(
#'       Arn = "string"
#'     )
#'   ),
#'   Priority = 123,
#'   RelatedOpsItems = list(
#'     list(
#'       OpsItemId = "string"
#'     )
#'   ),
#'   Status = "Open"|"InProgress"|"Resolved",
#'   OpsItemId = "string",
#'   Title = "string",
#'   Category = "string",
#'   Severity = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_ops_item
ssm_update_ops_item <- function(Description = NULL, OperationalData = NULL, OperationalDataToDelete = NULL, Notifications = NULL, Priority = NULL, RelatedOpsItems = NULL, Status = NULL, OpsItemId, Title = NULL, Category = NULL, Severity = NULL) {
  op <- new_operation(
    name = "UpdateOpsItem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_ops_item_input(Description = Description, OperationalData = OperationalData, OperationalDataToDelete = OperationalDataToDelete, Notifications = Notifications, Priority = Priority, RelatedOpsItems = RelatedOpsItems, Status = Status, OpsItemId = OpsItemId, Title = Title, Category = Category, Severity = Severity)
  output <- .ssm$update_ops_item_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_ops_item <- ssm_update_ops_item

#' Modifies an existing patch baseline
#'
#' Modifies an existing patch baseline. Fields not specified in the request
#' are left unchanged.
#' 
#' For information about valid key and value pairs in `PatchFilters` for
#' each supported operating system type, see
#' [PatchFilter](http://docs.aws.amazon.com/systems-manager/latest/APIReference/API_PatchFilter.html).
#'
#' @usage
#' ssm_update_patch_baseline(BaselineId, Name, GlobalFilters,
#'   ApprovalRules, ApprovedPatches, ApprovedPatchesComplianceLevel,
#'   ApprovedPatchesEnableNonSecurity, RejectedPatches,
#'   RejectedPatchesAction, Description, Sources, Replace)
#'
#' @param BaselineId &#91;required&#93; The ID of the patch baseline to update.
#' @param Name The name of the patch baseline.
#' @param GlobalFilters A set of global filters used to include patches in the baseline.
#' @param ApprovalRules A set of rules used to include patches in the baseline.
#' @param ApprovedPatches A list of explicitly approved patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [Package Name Formats for Approved and Rejected
#' Patch
#' Lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *AWS Systems Manager User Guide*.
#' @param ApprovedPatchesComplianceLevel Assigns a new compliance severity level to an existing patch baseline.
#' @param ApprovedPatchesEnableNonSecurity Indicates whether the list of approved patches includes non-security
#' updates that should be applied to the instances. The default value is
#' \'false\'. Applies to Linux instances only.
#' @param RejectedPatches A list of explicitly rejected patches for the baseline.
#' 
#' For information about accepted formats for lists of approved patches and
#' rejected patches, see [Package Name Formats for Approved and Rejected
#' Patch
#' Lists](https://docs.aws.amazon.com/systems-manager/latest/userguide/patch-manager-approved-rejected-package-name-formats.html)
#' in the *AWS Systems Manager User Guide*.
#' @param RejectedPatchesAction The action for Patch Manager to take on patches included in the
#' RejectedPackages list.
#' 
#' -   **ALLOW\\_AS\\_DEPENDENCY**: A package in the Rejected patches list is
#'     installed only if it is a dependency of another package. It is
#'     considered compliant with the patch baseline, and its status is
#'     reported as *InstalledOther*. This is the default action if no
#'     option is specified.
#' 
#' -   **BLOCK**: Packages in the RejectedPatches list, and packages that
#'     include them as dependencies, are not installed under any
#'     circumstances. If a package was installed before it was added to the
#'     Rejected patches list, it is considered non-compliant with the patch
#'     baseline, and its status is reported as *InstalledRejected*.
#' @param Description A description of the patch baseline.
#' @param Sources Information about the patches to use to update the instances, including
#' target operating systems and source repositories. Applies to Linux
#' instances only.
#' @param Replace If True, then all fields that are required by the CreatePatchBaseline
#' action are also required for this API request. Optional fields that are
#' not specified are set to null.
#'
#' @section Request syntax:
#' ```
#' svc$update_patch_baseline(
#'   BaselineId = "string",
#'   Name = "string",
#'   GlobalFilters = list(
#'     PatchFilters = list(
#'       list(
#'         Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
#'         Values = list(
#'           "string"
#'         )
#'       )
#'     )
#'   ),
#'   ApprovalRules = list(
#'     PatchRules = list(
#'       list(
#'         PatchFilterGroup = list(
#'           PatchFilters = list(
#'             list(
#'               Key = "PATCH_SET"|"PRODUCT"|"PRODUCT_FAMILY"|"CLASSIFICATION"|"MSRC_SEVERITY"|"PATCH_ID"|"SECTION"|"PRIORITY"|"SEVERITY",
#'               Values = list(
#'                 "string"
#'               )
#'             )
#'           )
#'         ),
#'         ComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
#'         ApproveAfterDays = 123,
#'         EnableNonSecurity = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   ApprovedPatches = list(
#'     "string"
#'   ),
#'   ApprovedPatchesComplianceLevel = "CRITICAL"|"HIGH"|"MEDIUM"|"LOW"|"INFORMATIONAL"|"UNSPECIFIED",
#'   ApprovedPatchesEnableNonSecurity = TRUE|FALSE,
#'   RejectedPatches = list(
#'     "string"
#'   ),
#'   RejectedPatchesAction = "ALLOW_AS_DEPENDENCY"|"BLOCK",
#'   Description = "string",
#'   Sources = list(
#'     list(
#'       Name = "string",
#'       Products = list(
#'         "string"
#'       ),
#'       Configuration = "string"
#'     )
#'   ),
#'   Replace = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_patch_baseline
ssm_update_patch_baseline <- function(BaselineId, Name = NULL, GlobalFilters = NULL, ApprovalRules = NULL, ApprovedPatches = NULL, ApprovedPatchesComplianceLevel = NULL, ApprovedPatchesEnableNonSecurity = NULL, RejectedPatches = NULL, RejectedPatchesAction = NULL, Description = NULL, Sources = NULL, Replace = NULL) {
  op <- new_operation(
    name = "UpdatePatchBaseline",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_patch_baseline_input(BaselineId = BaselineId, Name = Name, GlobalFilters = GlobalFilters, ApprovalRules = ApprovalRules, ApprovedPatches = ApprovedPatches, ApprovedPatchesComplianceLevel = ApprovedPatchesComplianceLevel, ApprovedPatchesEnableNonSecurity = ApprovedPatchesEnableNonSecurity, RejectedPatches = RejectedPatches, RejectedPatchesAction = RejectedPatchesAction, Description = Description, Sources = Sources, Replace = Replace)
  output <- .ssm$update_patch_baseline_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_patch_baseline <- ssm_update_patch_baseline

#' Update a resource data sync
#'
#' Update a resource data sync. After you create a resource data sync for a
#' Region, you can\'t change the account options for that sync. For
#' example, if you create a sync in the us-east-2 (Ohio) Region and you
#' choose the Include only the current account option, you can\'t edit that
#' sync later and choose the Include all accounts from my AWS Organizations
#' configuration option. Instead, you must delete the first resource data
#' sync, and create a new one.
#'
#' @usage
#' ssm_update_resource_data_sync(SyncName, SyncType, SyncSource)
#'
#' @param SyncName &#91;required&#93; The name of the resource data sync you want to update.
#' @param SyncType &#91;required&#93; The type of resource data sync. If `SyncType` is `SyncToDestination`,
#' then the resource data sync synchronizes data to an Amazon S3 bucket. If
#' the `SyncType` is `SyncFromSource` then the resource data sync
#' synchronizes data from AWS Organizations or from multiple AWS Regions.
#' @param SyncSource &#91;required&#93; Specify information about the data sources to synchronize.
#'
#' @section Request syntax:
#' ```
#' svc$update_resource_data_sync(
#'   SyncName = "string",
#'   SyncType = "string",
#'   SyncSource = list(
#'     SourceType = "string",
#'     AwsOrganizationsSource = list(
#'       OrganizationSourceType = "string",
#'       OrganizationalUnits = list(
#'         list(
#'           OrganizationalUnitId = "string"
#'         )
#'       )
#'     ),
#'     SourceRegions = list(
#'       "string"
#'     ),
#'     IncludeFutureRegions = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_resource_data_sync
ssm_update_resource_data_sync <- function(SyncName, SyncType, SyncSource) {
  op <- new_operation(
    name = "UpdateResourceDataSync",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_resource_data_sync_input(SyncName = SyncName, SyncType = SyncType, SyncSource = SyncSource)
  output <- .ssm$update_resource_data_sync_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_resource_data_sync <- ssm_update_resource_data_sync

#' ServiceSetting is an account-level setting for an AWS service
#'
#' `ServiceSetting` is an account-level setting for an AWS service. This
#' setting defines how a user interacts with or uses a service or a feature
#' of a service. For example, if an AWS service charges money to the
#' account based on feature or service usage, then the AWS service team
#' might create a default setting of \"false\". This means the user can\'t
#' use this feature unless they change the setting to \"true\" and
#' intentionally opt in for a paid feature.
#' 
#' Services map a `SettingId` object to a setting value. AWS services teams
#' define the default value for a `SettingId`. You can\'t create a new
#' `SettingId`, but you can overwrite the default value if you have the
#' `ssm:UpdateServiceSetting` permission for the setting. Use the
#' GetServiceSetting API action to view the current value. Or, use the
#' ResetServiceSetting to change the value back to the original value
#' defined by the AWS service team.
#' 
#' Update the service setting for the account.
#'
#' @usage
#' ssm_update_service_setting(SettingId, SettingValue)
#'
#' @param SettingId &#91;required&#93; The ID of the service setting to update.
#' @param SettingValue &#91;required&#93; The new value to specify for the service setting.
#'
#' @section Request syntax:
#' ```
#' svc$update_service_setting(
#'   SettingId = "string",
#'   SettingValue = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ssm_update_service_setting
ssm_update_service_setting <- function(SettingId, SettingValue) {
  op <- new_operation(
    name = "UpdateServiceSetting",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ssm$update_service_setting_input(SettingId = SettingId, SettingValue = SettingValue)
  output <- .ssm$update_service_setting_output()
  config <- get_config()
  svc <- .ssm$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ssm$operations$update_service_setting <- ssm_update_service_setting
