% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoscaling_operations.R
\name{autoscaling_attach_load_balancers}
\alias{autoscaling_attach_load_balancers}
\title{Attaches one or more Classic Load Balancers to the specified Auto
Scaling group}
\usage{
autoscaling_attach_load_balancers(AutoScalingGroupName,
  LoadBalancerNames)
}
\arguments{
\item{AutoScalingGroupName}{[required] The name of the Auto Scaling group.}

\item{LoadBalancerNames}{[required] The names of the load balancers. You can specify up to 10 load
balancers.}
}
\description{
Attaches one or more Classic Load Balancers to the specified Auto
Scaling group.
}
\details{
To attach an Application Load Balancer or a Network Load Balancer
instead, see AttachLoadBalancerTargetGroups.

To describe the load balancers for an Auto Scaling group, use
DescribeLoadBalancers. To detach the load balancer from the Auto Scaling
group, use DetachLoadBalancers.

For more information, see \href{https://docs.aws.amazon.com/autoscaling/ec2/userguide/attach-load-balancer-asg.html}{Attaching a Load Balancer to Your Auto Scaling Group}
in the \emph{Amazon EC2 Auto Scaling User Guide}.
}
\section{Request syntax}{
\preformatted{svc$attach_load_balancers(
  AutoScalingGroupName = "string",
  LoadBalancerNames = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# This example attaches the specified load balancer to the specified Auto
# Scaling group.
svc$attach_load_balancers(
  AutoScalingGroupName = "my-auto-scaling-group",
  LoadBalancerNames = list(
    "my-load-balancer"
  )
)
}

}
\keyword{internal}
