% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/configservice_operations.R
\name{configservice_put_conformance_pack}
\alias{configservice_put_conformance_pack}
\title{Creates or updates a conformance pack}
\usage{
configservice_put_conformance_pack(ConformancePackName, TemplateS3Uri,
  TemplateBody, DeliveryS3Bucket, DeliveryS3KeyPrefix,
  ConformancePackInputParameters)
}
\arguments{
\item{ConformancePackName}{[required] Name of the conformance pack you want to create.}

\item{TemplateS3Uri}{Location of file containing the template body
(\verb{s3://bucketname/prefix}). The uri must point to the conformance pack
template (max size: 300 KB) that is located in an Amazon S3 bucket in
the same region as the conformance pack.

You must have access to read Amazon S3 bucket.}

\item{TemplateBody}{A string containing full conformance pack template body. Structure
containing the template body with a minimum length of 1 byte and a
maximum length of 51,200 bytes.

You can only use a YAML template with one resource type, that is, config
rule and a remediation action.}

\item{DeliveryS3Bucket}{[required] AWS Config stores intermediate files while processing conformance pack
template.}

\item{DeliveryS3KeyPrefix}{The prefix for the Amazon S3 bucket.}

\item{ConformancePackInputParameters}{A list of \code{ConformancePackInputParameter} objects.}
}
\description{
Creates or updates a conformance pack. A conformance pack is a
collection of AWS Config rules that can be easily deployed in an account
and a region and across AWS Organization.
}
\details{
This API creates a service linked role \code{AWSServiceRoleForConfigConforms}
in your account. The service linked role is created only when the role
does not exist in your account. AWS Config verifies the existence of
role with \code{GetRole} action.

You must specify either the \code{TemplateS3Uri} or the \code{TemplateBody}
parameter, but not both. If you provide both AWS Config uses the
\code{TemplateS3Uri} parameter and ignores the \code{TemplateBody} parameter.
}
\section{Request syntax}{
\preformatted{svc$put_conformance_pack(
  ConformancePackName = "string",
  TemplateS3Uri = "string",
  TemplateBody = "string",
  DeliveryS3Bucket = "string",
  DeliveryS3KeyPrefix = "string",
  ConformancePackInputParameters = list(
    list(
      ParameterName = "string",
      ParameterValue = "string"
    )
  )
)
}
}

\keyword{internal}
