% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/licensemanager_operations.R
\name{licensemanager_create_license_configuration}
\alias{licensemanager_create_license_configuration}
\title{Creates a license configuration}
\usage{
licensemanager_create_license_configuration(
  Name,
  Description = NULL,
  LicenseCountingType,
  LicenseCount = NULL,
  LicenseCountHardLimit = NULL,
  LicenseRules = NULL,
  Tags = NULL,
  DisassociateWhenNotFound = NULL,
  ProductInformationList = NULL
)
}
\arguments{
\item{Name}{[required] Name of the license configuration.}

\item{Description}{Description of the license configuration.}

\item{LicenseCountingType}{[required] Dimension used to track the license inventory.}

\item{LicenseCount}{Number of licenses managed by the license configuration.}

\item{LicenseCountHardLimit}{Indicates whether hard or soft license enforcement is used. Exceeding a
hard limit blocks the launch of new instances.}

\item{LicenseRules}{License rules. The syntax is #name=value (for example,
#allowedTenancy=EC2-DedicatedHost). The available rules vary by
dimension, as follows.
\itemize{
\item \code{Cores} dimension: \code{allowedTenancy} | \code{licenseAffinityToHost} |
\code{maximumCores} | \code{minimumCores}
\item \code{Instances} dimension: \code{allowedTenancy} | \code{maximumCores} |
\code{minimumCores} | \code{maximumSockets} | \code{minimumSockets} |
\code{maximumVcpus} | \code{minimumVcpus}
\item \code{Sockets} dimension: \code{allowedTenancy} | \code{licenseAffinityToHost} |
\code{maximumSockets} | \code{minimumSockets}
\item \code{vCPUs} dimension: \code{allowedTenancy} | \code{honorVcpuOptimization} |
\code{maximumVcpus} | \code{minimumVcpus}
}

The unit for \code{licenseAffinityToHost} is days and the range is 1 to 180.
The possible values for \code{allowedTenancy} are \code{EC2-Default},
\code{EC2-DedicatedHost}, and \code{EC2-DedicatedInstance}. The possible values
for \code{honorVcpuOptimization} are \code{True} and \code{False}.}

\item{Tags}{Tags to add to the license configuration.}

\item{DisassociateWhenNotFound}{When true, disassociates a resource when software is uninstalled.}

\item{ProductInformationList}{Product information.}
}
\description{
Creates a license configuration.

See \url{https://www.paws-r-sdk.com/docs/licensemanager_create_license_configuration/} for full documentation.
}
\keyword{internal}
