% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resiliencehub_operations.R
\name{resiliencehub_start_app_assessment}
\alias{resiliencehub_start_app_assessment}
\title{Creates a new application assessment for an application}
\usage{
resiliencehub_start_app_assessment(
  appArn,
  appVersion,
  assessmentName,
  clientToken = NULL,
  tags = NULL
)
}
\arguments{
\item{appArn}{[required] Amazon Resource Name (ARN) of the Resilience Hub application. The format
for this ARN is:
arn:\code{partition}:resiliencehub:\code{region}:\code{account}:app/\code{app-id}. For more
information about ARNs, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names (ARNs)}
in the \emph{AWS General Reference} guide.}

\item{appVersion}{[required] The version of the application.}

\item{assessmentName}{[required] The name for the assessment.}

\item{clientToken}{Used for an idempotency token. A client token is a unique,
case-sensitive string of up to 64 ASCII characters. You should not reuse
the same client token for other API requests.}

\item{tags}{Tags assigned to the resource. A tag is a label that you assign to an
Amazon Web Services resource. Each tag consists of a key/value pair.}
}
\description{
Creates a new application assessment for an application.

See \url{https://www.paws-r-sdk.com/docs/resiliencehub_start_app_assessment/} for full documentation.
}
\keyword{internal}
