% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_create_kx_volume}
\alias{finspace_create_kx_volume}
\title{Creates a new volume with a specific amount of throughput and storage
capacity}
\usage{
finspace_create_kx_volume(
  clientToken = NULL,
  environmentId,
  volumeType,
  volumeName,
  description = NULL,
  nas1Configuration = NULL,
  azMode,
  availabilityZoneIds,
  tags = NULL
)
}
\arguments{
\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{environmentId}{[required] A unique identifier for the kdb environment, whose clusters can attach
to the volume.}

\item{volumeType}{[required] The type of file system volume. Currently, FinSpace only supports
\code{NAS_1} volume type. When you select \code{NAS_1} volume type, you must also
provide \code{nas1Configuration}.}

\item{volumeName}{[required] A unique identifier for the volume.}

\item{description}{A description of the volume.}

\item{nas1Configuration}{Specifies the configuration for the Network attached storage (NAS_1)
file system volume. This parameter is required when you choose
\code{volumeType} as \emph{NAS_1}.}

\item{azMode}{[required] The number of availability zones you want to assign per cluster.
Currently, FinSpace only support \code{SINGLE} for volumes.}

\item{availabilityZoneIds}{[required] The identifier of the availability zones.}

\item{tags}{A list of key-value pairs to label the volume. You can add up to 50 tags
to a volume.}
}
\description{
Creates a new volume with a specific amount of throughput and storage capacity.

See \url{https://www.paws-r-sdk.com/docs/finspace_create_kx_volume/} for full documentation.
}
\keyword{internal}
