% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssm_operations.R
\name{ssm_create_ops_item}
\alias{ssm_create_ops_item}
\title{Creates a new OpsItem}
\usage{
ssm_create_ops_item(
  Description,
  OpsItemType = NULL,
  OperationalData = NULL,
  Notifications = NULL,
  Priority = NULL,
  RelatedOpsItems = NULL,
  Source,
  Title,
  Tags = NULL,
  Category = NULL,
  Severity = NULL,
  ActualStartTime = NULL,
  ActualEndTime = NULL,
  PlannedStartTime = NULL,
  PlannedEndTime = NULL,
  AccountId = NULL
)
}
\arguments{
\item{Description}{[required] User-defined text that contains information about the OpsItem, in
Markdown format.

Provide enough information so that users viewing this OpsItem for the
first time understand the issue.}

\item{OpsItemType}{The type of OpsItem to create. Systems Manager supports the following
types of OpsItems:
\itemize{
\item \verb{/aws/issue}

This type of OpsItem is used for default OpsItems created by
OpsCenter.
\item \verb{/aws/changerequest}

This type of OpsItem is used by Change Manager for reviewing and
approving or rejecting change requests.
\item \verb{/aws/insight}

This type of OpsItem is used by OpsCenter for aggregating and
reporting on duplicate OpsItems.
}}

\item{OperationalData}{Operational data is custom data that provides useful reference details
about the OpsItem. For example, you can specify log files, error
strings, license keys, troubleshooting tips, or other relevant data. You
enter operational data as key-value pairs. The key has a maximum length
of 128 characters. The value has a maximum size of 20 KB.

Operational data keys \emph{can't} begin with the following: \code{amazon}, \code{aws},
\code{amzn}, \code{ssm}, \verb{/amazon}, \verb{/aws}, \verb{/amzn}, \verb{/ssm}.

You can choose to make the data searchable by other users in the account
or you can restrict search access. Searchable data means that all users
with access to the OpsItem Overview page (as provided by the
\code{\link[=ssm_describe_ops_items]{describe_ops_items}} API operation) can view
and search on the specified data. Operational data that isn't searchable
is only viewable by users who have access to the OpsItem (as provided by
the \code{\link[=ssm_get_ops_item]{get_ops_item}} API operation).

Use the \verb{/aws/resources} key in OperationalData to specify a related
resource in the request. Use the \verb{/aws/automations} key in
OperationalData to associate an Automation runbook with the OpsItem. To
view Amazon Web Services CLI example commands that use these keys, see
\href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-manually-create-OpsItems.html}{Creating OpsItems manually}
in the \emph{Amazon Web Services Systems Manager User Guide}.}

\item{Notifications}{The Amazon Resource Name (ARN) of an SNS topic where notifications are
sent when this OpsItem is edited or changed.}

\item{Priority}{The importance of this OpsItem in relation to other OpsItems in the
system.}

\item{RelatedOpsItems}{One or more OpsItems that share something in common with the current
OpsItems. For example, related OpsItems can include OpsItems with
similar error messages, impacted resources, or statuses for the impacted
resource.}

\item{Source}{[required] The origin of the OpsItem, such as Amazon EC2 or Systems Manager.

The source name can't contain the following strings: \code{aws}, \code{amazon},
and \code{amzn}.}

\item{Title}{[required] A short heading that describes the nature of the OpsItem and the
impacted resource.}

\item{Tags}{Optional metadata that you assign to a resource.

Tags use a key-value pair. For example:

\verb{Key=Department,Value=Finance}

To add tags to a new OpsItem, a user must have IAM permissions for both
the \code{ssm:CreateOpsItems} operation and the \code{ssm:AddTagsToResource}
operation. To add tags to an existing OpsItem, use the
\code{\link[=ssm_add_tags_to_resource]{add_tags_to_resource}} operation.}

\item{Category}{Specify a category to assign to an OpsItem.}

\item{Severity}{Specify a severity to assign to an OpsItem.}

\item{ActualStartTime}{The time a runbook workflow started. Currently reported only for the
OpsItem type \verb{/aws/changerequest}.}

\item{ActualEndTime}{The time a runbook workflow ended. Currently reported only for the
OpsItem type \verb{/aws/changerequest}.}

\item{PlannedStartTime}{The time specified in a change request for a runbook workflow to start.
Currently supported only for the OpsItem type \verb{/aws/changerequest}.}

\item{PlannedEndTime}{The time specified in a change request for a runbook workflow to end.
Currently supported only for the OpsItem type \verb{/aws/changerequest}.}

\item{AccountId}{The target Amazon Web Services account where you want to create an
OpsItem. To make this call, your account must be configured to work with
OpsItems across accounts. For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html}{Set up OpsCenter}
in the \emph{Amazon Web Services Systems Manager User Guide}.}
}
\description{
Creates a new OpsItem. You must have permission in Identity and Access Management (IAM) to create a new OpsItem. For more information, see \href{https://docs.aws.amazon.com/systems-manager/latest/userguide/OpsCenter-setup.html}{Set up OpsCenter} in the \emph{Amazon Web Services Systems Manager User Guide}.

See \url{https://www.paws-r-sdk.com/docs/ssm_create_ops_item/} for full documentation.
}
\keyword{internal}
