% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_create_generated_template}
\alias{cloudformation_create_generated_template}
\title{Creates a template from existing resources that are not already managed
with CloudFormation}
\usage{
cloudformation_create_generated_template(
  Resources = NULL,
  GeneratedTemplateName,
  StackName = NULL,
  TemplateConfiguration = NULL
)
}
\arguments{
\item{Resources}{An optional list of resources to be included in the generated template.

If no resources are specified,the template will be created without any
resources. Resources can be added to the template using the
\code{\link[=cloudformation_update_generated_template]{update_generated_template}}
API action.}

\item{GeneratedTemplateName}{[required] The name assigned to the generated template.}

\item{StackName}{An optional name or ARN of a stack to use as the base stack for the
generated template.}

\item{TemplateConfiguration}{The configuration details of the generated template, including the
\code{DeletionPolicy} and \code{UpdateReplacePolicy}.}
}
\description{
Creates a template from existing resources that are not already managed with CloudFormation. You can check the status of the template generation using the \code{\link[=cloudformation_describe_generated_template]{describe_generated_template}} API action.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_create_generated_template/} for full documentation.
}
\keyword{internal}
