% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_stack_drift_detection_status}
\alias{cloudformation_describe_stack_drift_detection_status}
\title{Returns information about a stack drift detection operation}
\usage{
cloudformation_describe_stack_drift_detection_status(StackDriftDetectionId)
}
\arguments{
\item{StackDriftDetectionId}{[required] The ID of the drift detection results of this operation.

CloudFormation generates new results, with a new drift detection ID,
each time this operation is run. However, the number of drift results
CloudFormation retains for any given stack, and for how long, may vary.}
}
\description{
Returns information about a stack drift detection operation. A stack drift detection operation detects whether a stack's actual configuration differs, or has \emph{drifted}, from its expected configuration, as defined in the stack template and any values specified as template parameters. A stack is considered to have drifted if one or more of its resources have drifted. For more information about stack and resource drift, see \href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/using-cfn-stack-drift.html}{Detecting Unregulated Configuration Changes to Stacks and Resources}.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_drift_detection_status/} for full documentation.
}
\keyword{internal}
