% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_stack_set_operation}
\alias{cloudformation_describe_stack_set_operation}
\title{Returns the description of the specified StackSet operation}
\usage{
cloudformation_describe_stack_set_operation(
  StackSetName,
  OperationId,
  CallAs = NULL
)
}
\arguments{
\item{StackSetName}{[required] The name or the unique stack ID of the stack set for the stack
operation.}

\item{OperationId}{[required] The unique ID of the stack set operation.}

\item{CallAs}{[Service-managed permissions] Specifies whether you are acting as an
account administrator in the organization's management account or as a
delegated administrator in a member account.

By default, \code{SELF} is specified. Use \code{SELF} for stack sets with
self-managed permissions.
\itemize{
\item If you are signed in to the management account, specify \code{SELF}.
\item If you are signed in to a delegated administrator account, specify
\code{DELEGATED_ADMIN}.

Your Amazon Web Services account must be registered as a delegated
administrator in the management account. For more information, see
\href{https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/stacksets-orgs-delegated-admin.html}{Register a delegated administrator}
in the \emph{CloudFormation User Guide}.
}}
}
\description{
Returns the description of the specified StackSet operation.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_describe_stack_set_operation/} for full documentation.
}
\keyword{internal}
