% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudformation_operations.R
\name{cloudformation_describe_type}
\alias{cloudformation_describe_type}
\title{Returns detailed information about an extension that has been registered}
\usage{
cloudformation_describe_type(
  Type = NULL,
  TypeName = NULL,
  Arn = NULL,
  VersionId = NULL,
  PublisherId = NULL,
  PublicVersionNumber = NULL
)
}
\arguments{
\item{Type}{The kind of extension.

Conditional: You must specify either \code{TypeName} and \code{Type}, or \code{Arn}.}

\item{TypeName}{The name of the extension.

Conditional: You must specify either \code{TypeName} and \code{Type}, or \code{Arn}.}

\item{Arn}{The Amazon Resource Name (ARN) of the extension.

Conditional: You must specify either \code{TypeName} and \code{Type}, or \code{Arn}.}

\item{VersionId}{The ID of a specific version of the extension. The version ID is the
value at the end of the Amazon Resource Name (ARN) assigned to the
extension version when it is registered.

If you specify a \code{VersionId},
\code{\link[=cloudformation_describe_type]{describe_type}} returns information
about that specific extension version. Otherwise, it returns information
about the default extension version.}

\item{PublisherId}{The publisher ID of the extension publisher.

Extensions provided by Amazon Web Services are not assigned a publisher
ID.}

\item{PublicVersionNumber}{The version number of a public third-party extension.}
}
\description{
Returns detailed information about an extension that has been registered.

See \url{https://www.paws-r-sdk.com/docs/cloudformation_describe_type/} for full documentation.
}
\keyword{internal}
