% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudtrail_operations.R
\name{cloudtrail_lookup_events}
\alias{cloudtrail_lookup_events}
\title{Looks up management events or CloudTrail Insights events that are
captured by CloudTrail}
\usage{
cloudtrail_lookup_events(
  LookupAttributes = NULL,
  StartTime = NULL,
  EndTime = NULL,
  EventCategory = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{LookupAttributes}{Contains a list of lookup attributes. Currently the list can contain
only one item.}

\item{StartTime}{Specifies that only events that occur after or at the specified time are
returned. If the specified start time is after the specified end time,
an error is returned.}

\item{EndTime}{Specifies that only events that occur before or at the specified time
are returned. If the specified end time is before the specified start
time, an error is returned.}

\item{EventCategory}{Specifies the event category. If you do not specify an event category,
events of the category are not returned in the response. For example, if
you do not specify \code{insight} as the value of \code{EventCategory}, no
Insights events are returned.}

\item{MaxResults}{The number of events to return. Possible values are 1 through 50. The
default is 50.}

\item{NextToken}{The token to use to get the next page of results after a previous API
call. This token must be passed in with the same parameters that were
specified in the original call. For example, if the original call
specified an AttributeKey of 'Username' with a value of 'root', the call
with NextToken should include those same parameters.}
}
\description{
Looks up \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-management-events}{management events} or \href{https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-concepts.html#cloudtrail-concepts-insights-events}{CloudTrail Insights events} that are captured by CloudTrail. You can look up events that occurred in a Region within the last 90 days.

See \url{https://www.paws-r-sdk.com/docs/cloudtrail_lookup_events/} for full documentation.
}
\keyword{internal}
