% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspace_operations.R
\name{finspace_update_kx_environment_network}
\alias{finspace_update_kx_environment_network}
\title{Updates environment network to connect to your internal network by using
a transit gateway}
\usage{
finspace_update_kx_environment_network(
  environmentId,
  transitGatewayConfiguration = NULL,
  customDNSConfiguration = NULL,
  clientToken = NULL
)
}
\arguments{
\item{environmentId}{[required] A unique identifier for the kdb environment.}

\item{transitGatewayConfiguration}{Specifies the transit gateway and network configuration to connect the
kdb environment to an internal network.}

\item{customDNSConfiguration}{A list of DNS server name and server IP. This is used to set up Route-53
outbound resolvers.}

\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}
}
\description{
Updates environment network to connect to your internal network by using a transit gateway. This API supports request to create a transit gateway attachment from FinSpace VPC to your transit gateway ID and create a custom Route-53 outbound resolvers.

See \url{https://www.paws-r-sdk.com/docs/finspace_update_kx_environment_network/} for full documentation.
}
\keyword{internal}
