% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchevidently_operations.R
\name{cloudwatchevidently_create_segment}
\alias{cloudwatchevidently_create_segment}
\title{Use this operation to define a segment of your audience}
\usage{
cloudwatchevidently_create_segment(
  description = NULL,
  name,
  pattern,
  tags = NULL
)
}
\arguments{
\item{description}{An optional description for this segment.}

\item{name}{[required] A name for the segment.}

\item{pattern}{[required] The pattern to use for the segment. For more information about pattern
syntax, see \href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Evidently-segments.html#CloudWatch-Evidently-segments-syntax.html}{Segment rule pattern syntax}.}

\item{tags}{Assigns one or more tags (key-value pairs) to the segment.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.

Tags don't have any semantic meaning to Amazon Web Services and are
interpreted strictly as strings of characters.

You can associate as many as 50 tags with a segment.

For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services resources}.}
}
\description{
Use this operation to define a \emph{segment} of your audience. A segment is a portion of your audience that share one or more characteristics. Examples could be Chrome browser users, users in Europe, or Firefox browser users in Europe who also fit other criteria that your application collects, such as age.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchevidently_create_segment/} for full documentation.
}
\keyword{internal}
