% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchapplicationsignals_operations.R
\name{cloudwatchapplicationsignals_create_service_level_objective}
\alias{cloudwatchapplicationsignals_create_service_level_objective}
\title{Creates a service level objective (SLO), which can help you ensure that
your critical business operations are meeting customer expectations}
\usage{
cloudwatchapplicationsignals_create_service_level_objective(
  Name,
  Description = NULL,
  SliConfig = NULL,
  RequestBasedSliConfig = NULL,
  Goal = NULL,
  Tags = NULL,
  BurnRateConfigurations = NULL
)
}
\arguments{
\item{Name}{[required] A name for this SLO.}

\item{Description}{An optional description for this SLO.}

\item{SliConfig}{If this SLO is a period-based SLO, this structure defines the
information about what performance metric this SLO will monitor.

You can't specify both \code{RequestBasedSliConfig} and \code{SliConfig} in the
same operation.}

\item{RequestBasedSliConfig}{If this SLO is a request-based SLO, this structure defines the
information about what performance metric this SLO will monitor.

You can't specify both \code{RequestBasedSliConfig} and \code{SliConfig} in the
same operation.}

\item{Goal}{This structure contains the attributes that determine the goal of the
SLO.}

\item{Tags}{A list of key-value pairs to associate with the SLO. You can associate
as many as 50 tags with an SLO. To be able to associate tags with the
SLO when you create the SLO, you must have the \code{cloudwatch:TagResource}
permission.

Tags can help you organize and categorize your resources. You can also
use them to scope user permissions by granting a user permission to
access or change only resources with certain tag values.}

\item{BurnRateConfigurations}{Use this array to create \emph{burn rates} for this SLO. Each burn rate is a
metric that indicates how fast the service is consuming the error
budget, relative to the attainment goal of the SLO.}
}
\description{
Creates a service level objective (SLO), which can help you ensure that your critical business operations are meeting customer expectations. Use SLOs to set and track specific target levels for the reliability and availability of your applications and services. SLOs use service level indicators (SLIs) to calculate whether the application is performing at the level that you want.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchapplicationsignals_create_service_level_objective/} for full documentation.
}
\keyword{internal}
