% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchlogs_operations.R
\name{cloudwatchlogs_put_log_events}
\alias{cloudwatchlogs_put_log_events}
\title{Uploads a batch of log events to the specified log stream}
\usage{
cloudwatchlogs_put_log_events(
  logGroupName,
  logStreamName,
  logEvents,
  sequenceToken = NULL,
  entity = NULL
)
}
\arguments{
\item{logGroupName}{[required] The name of the log group.}

\item{logStreamName}{[required] The name of the log stream.}

\item{logEvents}{[required] The log events.}

\item{sequenceToken}{The sequence token obtained from the response of the previous
\code{\link[=cloudwatchlogs_put_log_events]{put_log_events}} call.

The \code{sequenceToken} parameter is now ignored in
\code{\link[=cloudwatchlogs_put_log_events]{put_log_events}} actions.
\code{\link[=cloudwatchlogs_put_log_events]{put_log_events}} actions are now
accepted and never return \code{InvalidSequenceTokenException} or
\code{DataAlreadyAcceptedException} even if the sequence token is not valid.}

\item{entity}{The entity associated with the log events.}
}
\description{
Uploads a batch of log events to the specified log stream.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchlogs_put_log_events/} for full documentation.
}
\keyword{internal}
