% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudwatchrum_operations.R
\name{cloudwatchrum_get_app_monitor_data}
\alias{cloudwatchrum_get_app_monitor_data}
\title{Retrieves the raw performance events that RUM has collected from your
web application, so that you can do your own processing or analysis of
this data}
\usage{
cloudwatchrum_get_app_monitor_data(
  Filters = NULL,
  MaxResults = NULL,
  Name,
  NextToken = NULL,
  TimeRange
)
}
\arguments{
\item{Filters}{An array of structures that you can use to filter the results to those
that match one or more sets of key-value pairs that you specify.}

\item{MaxResults}{The maximum number of results to return in one operation.}

\item{Name}{[required] The name of the app monitor that collected the data that you want to
retrieve.}

\item{NextToken}{Use the token returned by the previous operation to request the next
page of results.}

\item{TimeRange}{[required] A structure that defines the time range that you want to retrieve
results from.}
}
\description{
Retrieves the raw performance events that RUM has collected from your web application, so that you can do your own processing or analysis of this data.

See \url{https://www.paws-r-sdk.com/docs/cloudwatchrum_get_app_monitor_data/} for full documentation.
}
\keyword{internal}
