% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_health_checks}
\alias{route53_list_health_checks}
\title{Retrieve a list of the health checks that are associated with the
current AWS account}
\usage{
route53_list_health_checks(Marker, MaxItems)
}
\arguments{
\item{Marker}{If the value of \code{IsTruncated} in the previous response was \code{true}, you
have more health checks. To get another group, submit another
\code{ListHealthChecks} request.

For the value of \code{marker}, specify the value of \code{NextMarker} from the
previous response, which is the ID of the first health check that Amazon
Route 53 will return if you submit another request.

If the value of \code{IsTruncated} in the previous response was \code{false},
there are no more health checks to get.}

\item{MaxItems}{The maximum number of health checks that you want \code{ListHealthChecks} to
return in response to the current request. Amazon Route 53 returns a
maximum of 100 items. If you set \code{MaxItems} to a value greater than 100,
Route 53 returns only the first 100 health checks.}
}
\description{
Retrieve a list of the health checks that are associated with the
current AWS account.
}
\section{Request syntax}{
\preformatted{svc$list_health_checks(
  Marker = "string",
  MaxItems = "string"
)
}
}

\keyword{internal}
