% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_list_gateway_routes}
\alias{appmesh_list_gateway_routes}
\title{Returns a list of existing gateway routes that are associated to a
virtual gateway}
\usage{
appmesh_list_gateway_routes(limit, meshName, meshOwner, nextToken,
  virtualGatewayName)
}
\arguments{
\item{limit}{The maximum number of results returned by
\code{\link[=appmesh_list_gateway_routes]{list_gateway_routes}} in paginated
output. When you use this parameter,
\code{\link[=appmesh_list_gateway_routes]{list_gateway_routes}} returns only
\code{limit} results in a single page along with a \code{nextToken} response
element. You can see the remaining results of the initial request by
sending another \code{\link[=appmesh_list_gateway_routes]{list_gateway_routes}}
request with the returned \code{nextToken} value. This value can be between 1
and 100. If you don't use this parameter,
\code{\link[=appmesh_list_gateway_routes]{list_gateway_routes}} returns up to 100
results and a \code{nextToken} value if applicable.}

\item{meshName}{[required] The name of the service mesh to list gateway routes in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it's the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{nextToken}{The \code{nextToken} value returned from a previous paginated
\code{\link[=appmesh_list_gateway_routes]{list_gateway_routes}} request where
\code{limit} was used and the results exceeded the value of that parameter.
Pagination continues from the end of the previous results that returned
the \code{nextToken} value.}

\item{virtualGatewayName}{[required] The name of the virtual gateway to list gateway routes in.}
}
\value{
A list with the following syntax:\preformatted{list(
  gatewayRoutes = list(
    list(
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      gatewayRouteName = "string",
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      meshName = "string",
      meshOwner = "string",
      resourceOwner = "string",
      version = 123,
      virtualGatewayName = "string"
    )
  ),
  nextToken = "string"
)
}
}
\description{
Returns a list of existing gateway routes that are associated to a
virtual gateway.
}
\section{Request syntax}{
\preformatted{svc$list_gateway_routes(
  limit = 123,
  meshName = "string",
  meshOwner = "string",
  nextToken = "string",
  virtualGatewayName = "string"
)
}
}

\keyword{internal}
