% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_update_resolver_rule}
\alias{route53resolver_update_resolver_rule}
\title{Updates settings for a specified Resolver rule}
\usage{
route53resolver_update_resolver_rule(ResolverRuleId, Config)
}
\arguments{
\item{ResolverRuleId}{[required] The ID of the Resolver rule that you want to update.}

\item{Config}{[required] The new settings for the Resolver rule.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResolverRule = list(
    Id = "string",
    CreatorRequestId = "string",
    Arn = "string",
    DomainName = "string",
    Status = "COMPLETE"|"DELETING"|"UPDATING"|"FAILED",
    StatusMessage = "string",
    RuleType = "FORWARD"|"SYSTEM"|"RECURSIVE",
    Name = "string",
    TargetIps = list(
      list(
        Ip = "string",
        Port = 123
      )
    ),
    ResolverEndpointId = "string",
    OwnerId = "string",
    ShareStatus = "NOT_SHARED"|"SHARED_WITH_ME"|"SHARED_BY_ME",
    CreationTime = "string",
    ModificationTime = "string"
  )
)
}
}
\description{
Updates settings for a specified Resolver rule. \code{ResolverRuleId} is
required, and all other parameters are optional. If you don't specify a
parameter, it retains its current value.
}
\section{Request syntax}{
\preformatted{svc$update_resolver_rule(
  ResolverRuleId = "string",
  Config = list(
    Name = "string",
    TargetIps = list(
      list(
        Ip = "string",
        Port = 123
      )
    ),
    ResolverEndpointId = "string"
  )
)
}
}

\keyword{internal}
