% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appmesh_operations.R
\name{appmesh_delete_route}
\alias{appmesh_delete_route}
\title{Deletes an existing route}
\usage{
appmesh_delete_route(meshName, meshOwner, routeName, virtualRouterName)
}
\arguments{
\item{meshName}{[required] The name of the service mesh to delete the route in.}

\item{meshOwner}{The AWS IAM account ID of the service mesh owner. If the account ID is
not your own, then it's the ID of the account that shared the mesh with
your account. For more information about mesh sharing, see \href{https://docs.aws.amazon.com/app-mesh/latest/userguide/sharing.html}{Working with shared meshes}.}

\item{routeName}{[required] The name of the route to delete.}

\item{virtualRouterName}{[required] The name of the virtual router to delete the route in.}
}
\value{
A list with the following syntax:\preformatted{list(
  route = list(
    meshName = "string",
    metadata = list(
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      lastUpdatedAt = as.POSIXct(
        "2015-01-01"
      ),
      meshOwner = "string",
      resourceOwner = "string",
      uid = "string",
      version = 123
    ),
    routeName = "string",
    spec = list(
      grpcRoute = list(
        action = list(
          weightedTargets = list(
            list(
              virtualNode = "string",
              weight = 123
            )
          )
        ),
        match = list(
          metadata = list(
            list(
              invert = TRUE|FALSE,
              match = list(
                exact = "string",
                prefix = "string",
                range = list(
                  end = 123,
                  start = 123
                ),
                regex = "string",
                suffix = "string"
              ),
              name = "string"
            )
          ),
          methodName = "string",
          serviceName = "string"
        ),
        retryPolicy = list(
          grpcRetryEvents = list(
            "cancelled"|"deadline-exceeded"|"internal"|"resource-exhausted"|"unavailable"
          ),
          httpRetryEvents = list(
            "string"
          ),
          maxRetries = 123,
          perRetryTimeout = list(
            unit = "s"|"ms",
            value = 123
          ),
          tcpRetryEvents = list(
            "connection-error"
          )
        ),
        timeout = list(
          idle = list(
            unit = "s"|"ms",
            value = 123
          ),
          perRequest = list(
            unit = "s"|"ms",
            value = 123
          )
        )
      ),
      http2Route = list(
        action = list(
          weightedTargets = list(
            list(
              virtualNode = "string",
              weight = 123
            )
          )
        ),
        match = list(
          headers = list(
            list(
              invert = TRUE|FALSE,
              match = list(
                exact = "string",
                prefix = "string",
                range = list(
                  end = 123,
                  start = 123
                ),
                regex = "string",
                suffix = "string"
              ),
              name = "string"
            )
          ),
          method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
          prefix = "string",
          scheme = "http"|"https"
        ),
        retryPolicy = list(
          httpRetryEvents = list(
            "string"
          ),
          maxRetries = 123,
          perRetryTimeout = list(
            unit = "s"|"ms",
            value = 123
          ),
          tcpRetryEvents = list(
            "connection-error"
          )
        ),
        timeout = list(
          idle = list(
            unit = "s"|"ms",
            value = 123
          ),
          perRequest = list(
            unit = "s"|"ms",
            value = 123
          )
        )
      ),
      httpRoute = list(
        action = list(
          weightedTargets = list(
            list(
              virtualNode = "string",
              weight = 123
            )
          )
        ),
        match = list(
          headers = list(
            list(
              invert = TRUE|FALSE,
              match = list(
                exact = "string",
                prefix = "string",
                range = list(
                  end = 123,
                  start = 123
                ),
                regex = "string",
                suffix = "string"
              ),
              name = "string"
            )
          ),
          method = "GET"|"HEAD"|"POST"|"PUT"|"DELETE"|"CONNECT"|"OPTIONS"|"TRACE"|"PATCH",
          prefix = "string",
          scheme = "http"|"https"
        ),
        retryPolicy = list(
          httpRetryEvents = list(
            "string"
          ),
          maxRetries = 123,
          perRetryTimeout = list(
            unit = "s"|"ms",
            value = 123
          ),
          tcpRetryEvents = list(
            "connection-error"
          )
        ),
        timeout = list(
          idle = list(
            unit = "s"|"ms",
            value = 123
          ),
          perRequest = list(
            unit = "s"|"ms",
            value = 123
          )
        )
      ),
      priority = 123,
      tcpRoute = list(
        action = list(
          weightedTargets = list(
            list(
              virtualNode = "string",
              weight = 123
            )
          )
        ),
        timeout = list(
          idle = list(
            unit = "s"|"ms",
            value = 123
          )
        )
      )
    ),
    status = list(
      status = "ACTIVE"|"INACTIVE"|"DELETED"
    ),
    virtualRouterName = "string"
  )
)
}
}
\description{
Deletes an existing route.
}
\section{Request syntax}{
\preformatted{svc$delete_route(
  meshName = "string",
  meshOwner = "string",
  routeName = "string",
  virtualRouterName = "string"
)
}
}

\keyword{internal}
