% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_describe_connections}
\alias{directconnect_describe_connections}
\title{Displays the specified connection or all connections in this Region}
\usage{
directconnect_describe_connections(connectionId)
}
\arguments{
\item{connectionId}{The ID of the connection.}
}
\value{
A list with the following syntax:\preformatted{list(
  connections = list(
    list(
      ownerAccount = "string",
      connectionId = "string",
      connectionName = "string",
      connectionState = "ordering"|"requested"|"pending"|"available"|"down"|"deleting"|"deleted"|"rejected"|"unknown",
      region = "string",
      location = "string",
      bandwidth = "string",
      vlan = 123,
      partnerName = "string",
      loaIssueTime = as.POSIXct(
        "2015-01-01"
      ),
      lagId = "string",
      awsDevice = "string",
      jumboFrameCapable = TRUE|FALSE,
      awsDeviceV2 = "string",
      hasLogicalRedundancy = "unknown"|"yes"|"no",
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      ),
      providerName = "string"
    )
  )
)
}
}
\description{
Displays the specified connection or all connections in this Region.
}
\section{Request syntax}{
\preformatted{svc$describe_connections(
  connectionId = "string"
)
}
}

\keyword{internal}
