% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_list_byoip_cidrs}
\alias{globalaccelerator_list_byoip_cidrs}
\title{Lists the IP address ranges that were specified in calls to
ProvisionByoipCidr, including the current state and a history of state
changes}
\usage{
globalaccelerator_list_byoip_cidrs(MaxResults, NextToken)
}
\arguments{
\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  ByoipCidrs = list(
    list(
      Cidr = "string",
      State = "PENDING_PROVISIONING"|"READY"|"PENDING_ADVERTISING"|"ADVERTISING"|"PENDING_WITHDRAWING"|"PENDING_DEPROVISIONING"|"DEPROVISIONED"|"FAILED_PROVISION"|"FAILED_ADVERTISING"|"FAILED_WITHDRAW"|"FAILED_DEPROVISION",
      Events = list(
        list(
          Message = "string",
          Timestamp = as.POSIXct(
            "2015-01-01"
          )
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Lists the IP address ranges that were specified in calls to
\code{\link[=globalaccelerator_provision_byoip_cidr]{provision_byoip_cidr}},
including the current state and a history of state changes.
}
\section{Request syntax}{
\preformatted{svc$list_byoip_cidrs(
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
