% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_update_health_check}
\alias{route53_update_health_check}
\title{Updates an existing health check}
\usage{
route53_update_health_check(HealthCheckId, HealthCheckVersion,
  IPAddress, Port, ResourcePath, FullyQualifiedDomainName, SearchString,
  FailureThreshold, Inverted, Disabled, HealthThreshold,
  ChildHealthChecks, EnableSNI, Regions, AlarmIdentifier,
  InsufficientDataHealthStatus, ResetElements)
}
\arguments{
\item{HealthCheckId}{[required] The ID for the health check for which you want detailed information.
When you created the health check,
\code{\link[=route53_create_health_check]{create_health_check}} returned the ID in
the response, in the \code{HealthCheckId} element.}

\item{HealthCheckVersion}{A sequential counter that Amazon Route 53 sets to \code{1} when you create a
health check and increments by 1 each time you update settings for the
health check.

We recommend that you use \code{\link[=route53_get_health_check]{get_health_check}}
or \code{\link[=route53_list_health_checks]{list_health_checks}} to get the current
value of \code{HealthCheckVersion} for the health check that you want to
update, and that you include that value in your
\code{\link[=route53_update_health_check]{update_health_check}} request. This
prevents Route 53 from overwriting an intervening update:
\itemize{
\item If the value in the
\code{\link[=route53_update_health_check]{update_health_check}} request matches
the value of \code{HealthCheckVersion} in the health check, Route 53
updates the health check with the new settings.
\item If the value of \code{HealthCheckVersion} in the health check is greater,
the health check was changed after you got the version number. Route
53 does not update the health check, and it returns a
\code{HealthCheckVersionMismatch} error.
}}

\item{IPAddress}{The IPv4 or IPv6 IP address for the endpoint that you want Amazon Route
53 to perform health checks on. If you don't specify a value for
\code{IPAddress}, Route 53 sends a DNS request to resolve the domain name
that you specify in \code{FullyQualifiedDomainName} at the interval that you
specify in \code{RequestInterval}. Using an IP address that is returned by
DNS, Route 53 then checks the health of the endpoint.

Use one of the following formats for the value of \code{IPAddress}:
\itemize{
\item \strong{IPv4 address}: four values between 0 and 255, separated by
periods (.), for example, \verb{192.0.2.44}.
\item \strong{IPv6 address}: eight groups of four hexadecimal values, separated
by colons (:), for example,
\verb{2001:0db8:85a3:0000:0000:abcd:0001:2345}. You can also shorten IPv6
addresses as described in RFC 5952, for example,
\verb{2001:db8:85a3::abcd:1:2345}.
}

If the endpoint is an EC2 instance, we recommend that you create an
Elastic IP address, associate it with your EC2 instance, and specify the
Elastic IP address for \code{IPAddress}. This ensures that the IP address of
your instance never changes. For more information, see the applicable
documentation:
\itemize{
\item Linux: \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html}{Elastic IP Addresses (EIP)}
in the \emph{Amazon EC2 User Guide for Linux Instances}
\item Windows: \href{https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-ip-addresses-eip.html}{Elastic IP Addresses (EIP)}
in the \emph{Amazon EC2 User Guide for Windows Instances}
}

If a health check already has a value for \code{IPAddress}, you can change
the value. However, you can't update an existing health check to add or
remove the value of \code{IPAddress}.

For more information, see
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName}{FullyQualifiedDomainName}.

Constraints: Route 53 can't check the health of endpoints for which the
IP address is in local, private, non-routable, or multicast ranges. For
more information about IP addresses for which you can't create health
checks, see the following documents:
\itemize{
\item \href{https://datatracker.ietf.org/doc/html/rfc5735}{RFC 5735, Special Use IPv4 Addresses}
\item \href{https://datatracker.ietf.org/doc/html/rfc6598}{RFC 6598, IANA-Reserved IPv4 Prefix for Shared Address Space}
\item \href{https://datatracker.ietf.org/doc/html/rfc5156}{RFC 5156, Special-Use IPv6 Addresses}
}}

\item{Port}{The port on the endpoint that you want Amazon Route 53 to perform health
checks on.

Don't specify a value for \code{Port} when you specify a value for \code{Type} of
\code{CLOUDWATCH_METRIC} or \code{CALCULATED}.}

\item{ResourcePath}{The path that you want Amazon Route 53 to request when performing health
checks. The path can be any value for which your endpoint will return an
HTTP status code of 2xx or 3xx when the endpoint is healthy, for example
the file /docs/route53-health-check.html. You can also include query
string parameters, for example, \verb{/welcome.html?language=jp&login=y}.

Specify this value only if you want to change it.}

\item{FullyQualifiedDomainName}{Amazon Route 53 behavior depends on whether you specify a value for
\code{IPAddress}.

If a health check already has a value for \code{IPAddress}, you can change
the value. However, you can't update an existing health check to add or
remove the value of \code{IPAddress}.

\strong{If you specify a value for} \code{IPAddress}:

Route 53 sends health check requests to the specified IPv4 or IPv6
address and passes the value of \code{FullyQualifiedDomainName} in the \code{Host}
header for all health checks except TCP health checks. This is typically
the fully qualified DNS name of the endpoint on which you want Route 53
to perform health checks.

When Route 53 checks the health of an endpoint, here is how it
constructs the \code{Host} header:
\itemize{
\item If you specify a value of \code{80} for \code{Port} and \code{HTTP} or
\code{HTTP_STR_MATCH} for \code{Type}, Route 53 passes the value of
\code{FullyQualifiedDomainName} to the endpoint in the \code{Host} header.
\item If you specify a value of \code{443} for \code{Port} and \code{HTTPS} or
\code{HTTPS_STR_MATCH} for \code{Type}, Route 53 passes the value of
\code{FullyQualifiedDomainName} to the endpoint in the \code{Host} header.
\item If you specify another value for \code{Port} and any value except \code{TCP}
for \code{Type}, Route 53 passes \emph{\code{FullyQualifiedDomainName}:\code{Port}} to
the endpoint in the \code{Host} header.
}

If you don't specify a value for \code{FullyQualifiedDomainName}, Route 53
substitutes the value of \code{IPAddress} in the \code{Host} header in each of the
above cases.

\strong{If you don't specify a value for} \code{IPAddress}:

If you don't specify a value for \code{IPAddress}, Route 53 sends a DNS
request to the domain that you specify in \code{FullyQualifiedDomainName} at
the interval you specify in \code{RequestInterval}. Using an IPv4 address
that is returned by DNS, Route 53 then checks the health of the
endpoint.

If you don't specify a value for \code{IPAddress}, Route 53 uses only IPv4 to
send health checks to the endpoint. If there's no resource record set
with a type of A for the name that you specify for
\code{FullyQualifiedDomainName}, the health check fails with a "DNS
resolution failed" error.

If you want to check the health of weighted, latency, or failover
resource record sets and you choose to specify the endpoint only by
\code{FullyQualifiedDomainName}, we recommend that you create a separate
health check for each endpoint. For example, create a health check for
each HTTP server that is serving content for www.example.com. For the
value of \code{FullyQualifiedDomainName}, specify the domain name of the
server (such as \code{us-east-2-www.example.com}), not the name of the
resource record sets (www.example.com).

In this configuration, if the value of \code{FullyQualifiedDomainName}
matches the name of the resource record sets and you then associate the
health check with those resource record sets, health check results will
be unpredictable.

In addition, if the value of \code{Type} is \code{HTTP}, \code{HTTPS},
\code{HTTP_STR_MATCH}, or \code{HTTPS_STR_MATCH}, Route 53 passes the value of
\code{FullyQualifiedDomainName} in the \code{Host} header, as it does when you
specify a value for \code{IPAddress}. If the value of \code{Type} is \code{TCP}, Route
53 doesn't pass a \code{Host} header.}

\item{SearchString}{If the value of \code{Type} is \code{HTTP_STR_MATCH} or \code{HTTPS_STR_MATCH}, the
string that you want Amazon Route 53 to search for in the response body
from the specified resource. If the string appears in the response body,
Route 53 considers the resource healthy. (You can't change the value of
\code{Type} when you update a health check.)}

\item{FailureThreshold}{The number of consecutive health checks that an endpoint must pass or
fail for Amazon Route 53 to change the current status of the endpoint
from unhealthy to healthy or vice versa. For more information, see \href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/dns-failover-determining-health-of-endpoints.html}{How Amazon Route 53 Determines Whether an Endpoint Is Healthy}
in the \emph{Amazon Route 53 Developer Guide}.

If you don't specify a value for \code{FailureThreshold}, the default value
is three health checks.}

\item{Inverted}{Specify whether you want Amazon Route 53 to invert the status of a
health check, for example, to consider a health check unhealthy when it
otherwise would be considered healthy.}

\item{Disabled}{Stops Route 53 from performing health checks. When you disable a health
check, here's what happens:
\itemize{
\item \strong{Health checks that check the health of endpoints:} Route 53 stops
submitting requests to your application, server, or other resource.
\item \strong{Calculated health checks:} Route 53 stops aggregating the status
of the referenced health checks.
\item \strong{Health checks that monitor CloudWatch alarms:} Route 53 stops
monitoring the corresponding CloudWatch metrics.
}

After you disable a health check, Route 53 considers the status of the
health check to always be healthy. If you configured DNS failover, Route
53 continues to route traffic to the corresponding resources. If you
want to stop routing traffic to a resource, change the value of
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-Inverted}{Inverted}.

Charges for a health check still apply when the health check is
disabled. For more information, see \href{https://aws.amazon.com/route53/pricing/}{Amazon Route 53 Pricing}.}

\item{HealthThreshold}{The number of child health checks that are associated with a
\code{CALCULATED} health that Amazon Route 53 must consider healthy for the
\code{CALCULATED} health check to be considered healthy. To specify the child
health checks that you want to associate with a \code{CALCULATED} health
check, use the \code{ChildHealthChecks} and \code{ChildHealthCheck} elements.

Note the following:
\itemize{
\item If you specify a number greater than the number of child health
checks, Route 53 always considers this health check to be unhealthy.
\item If you specify \code{0}, Route 53 always considers this health check to
be healthy.
}}

\item{ChildHealthChecks}{A complex type that contains one \code{ChildHealthCheck} element for each
health check that you want to associate with a \code{CALCULATED} health
check.}

\item{EnableSNI}{Specify whether you want Amazon Route 53 to send the value of
\code{FullyQualifiedDomainName} to the endpoint in the \code{client_hello} message
during \code{TLS} negotiation. This allows the endpoint to respond to \code{HTTPS}
health check requests with the applicable SSL/TLS certificate.

Some endpoints require that HTTPS requests include the host name in the
\code{client_hello} message. If you don't enable SNI, the status of the
health check will be SSL alert \code{handshake_failure}. A health check can
also have that status for other reasons. If SNI is enabled and you're
still getting the error, check the SSL/TLS configuration on your
endpoint and confirm that your certificate is valid.

The SSL/TLS certificate on your endpoint includes a domain name in the
\verb{Common Name} field and possibly several more in the
\verb{Subject Alternative Names} field. One of the domain names in the
certificate should match the value that you specify for
\code{FullyQualifiedDomainName}. If the endpoint responds to the
\code{client_hello} message with a certificate that does not include the
domain name that you specified in \code{FullyQualifiedDomainName}, a health
checker will retry the handshake. In the second attempt, the health
checker will omit \code{FullyQualifiedDomainName} from the \code{client_hello}
message.}

\item{Regions}{A complex type that contains one \code{Region} element for each region that
you want Amazon Route 53 health checkers to check the specified endpoint
from.}

\item{AlarmIdentifier}{A complex type that identifies the CloudWatch alarm that you want Amazon
Route 53 health checkers to use to determine whether the specified
health check is healthy.}

\item{InsufficientDataHealthStatus}{When CloudWatch has insufficient data about the metric to determine the
alarm state, the status that you want Amazon Route 53 to assign to the
health check:
\itemize{
\item \code{Healthy}: Route 53 considers the health check to be healthy.
\item \code{Unhealthy}: Route 53 considers the health check to be unhealthy.
\item \code{LastKnownStatus}: Route 53 uses the status of the health check from
the last time CloudWatch had sufficient data to determine the alarm
state. For new health checks that have no last known status, the
default status for the health check is healthy.
}}

\item{ResetElements}{A complex type that contains one \code{ResettableElementName} element for
each element that you want to reset to the default value. Valid values
for \code{ResettableElementName} include the following:
\itemize{
\item \code{ChildHealthChecks}: Amazon Route 53 resets
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ChildHealthChecks}{ChildHealthChecks}
to null.
\item \code{FullyQualifiedDomainName}: Route 53 resets
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_UpdateHealthCheck.html#Route53-UpdateHealthCheck-request-FullyQualifiedDomainName}{FullyQualifiedDomainName}.
to null.
\item \code{Regions}: Route 53 resets the
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-Regions}{Regions}
list to the default set of regions.
\item \code{ResourcePath}: Route 53 resets
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_HealthCheckConfig.html#Route53-Type-HealthCheckConfig-ResourcePath}{ResourcePath}
to null.
}}
}
\value{
A list with the following syntax:\preformatted{list(
  HealthCheck = list(
    Id = "string",
    CallerReference = "string",
    LinkedService = list(
      ServicePrincipal = "string",
      Description = "string"
    ),
    HealthCheckConfig = list(
      IPAddress = "string",
      Port = 123,
      Type = "HTTP"|"HTTPS"|"HTTP_STR_MATCH"|"HTTPS_STR_MATCH"|"TCP"|"CALCULATED"|"CLOUDWATCH_METRIC",
      ResourcePath = "string",
      FullyQualifiedDomainName = "string",
      SearchString = "string",
      RequestInterval = 123,
      FailureThreshold = 123,
      MeasureLatency = TRUE|FALSE,
      Inverted = TRUE|FALSE,
      Disabled = TRUE|FALSE,
      HealthThreshold = 123,
      ChildHealthChecks = list(
        "string"
      ),
      EnableSNI = TRUE|FALSE,
      Regions = list(
        "us-east-1"|"us-west-1"|"us-west-2"|"eu-west-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"
      ),
      AlarmIdentifier = list(
        Region = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"ca-central-1"|"eu-central-1"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"ap-east-1"|"me-south-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"cn-northwest-1"|"cn-north-1"|"af-south-1"|"eu-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1",
        Name = "string"
      ),
      InsufficientDataHealthStatus = "Healthy"|"Unhealthy"|"LastKnownStatus"
    ),
    HealthCheckVersion = 123,
    CloudWatchAlarmConfiguration = list(
      EvaluationPeriods = 123,
      Threshold = 123.0,
      ComparisonOperator = "GreaterThanOrEqualToThreshold"|"GreaterThanThreshold"|"LessThanThreshold"|"LessThanOrEqualToThreshold",
      Period = 123,
      MetricName = "string",
      Namespace = "string",
      Statistic = "Average"|"Sum"|"SampleCount"|"Maximum"|"Minimum",
      Dimensions = list(
        list(
          Name = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}
\description{
Updates an existing health check. Note that some values can't be
updated.

For more information about updating health checks, see \href{https://docs.aws.amazon.com/Route53/latest/DeveloperGuide/health-checks-creating-deleting.html}{Creating, Updating, and Deleting Health Checks}
in the \emph{Amazon Route 53 Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_health_check(
  HealthCheckId = "string",
  HealthCheckVersion = 123,
  IPAddress = "string",
  Port = 123,
  ResourcePath = "string",
  FullyQualifiedDomainName = "string",
  SearchString = "string",
  FailureThreshold = 123,
  Inverted = TRUE|FALSE,
  Disabled = TRUE|FALSE,
  HealthThreshold = 123,
  ChildHealthChecks = list(
    "string"
  ),
  EnableSNI = TRUE|FALSE,
  Regions = list(
    "us-east-1"|"us-west-1"|"us-west-2"|"eu-west-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"sa-east-1"
  ),
  AlarmIdentifier = list(
    Region = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"ca-central-1"|"eu-central-1"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"ap-east-1"|"me-south-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"|"ap-northeast-3"|"eu-north-1"|"sa-east-1"|"cn-northwest-1"|"cn-north-1"|"af-south-1"|"eu-south-1"|"us-gov-west-1"|"us-gov-east-1"|"us-iso-east-1"|"us-isob-east-1",
    Name = "string"
  ),
  InsufficientDataHealthStatus = "Healthy"|"Unhealthy"|"LastKnownStatus",
  ResetElements = list(
    "FullyQualifiedDomainName"|"Regions"|"ResourcePath"|"ChildHealthChecks"
  )
)
}
}

\keyword{internal}
