# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include cloudfront_service.R
NULL

#' Creates a new origin access identity
#'
#' Creates a new origin access identity. If you\'re using Amazon S3 for
#' your origin, you can use an origin access identity to require users to
#' access your content using a CloudFront URL instead of the Amazon S3 URL.
#' For more information about how to use origin access identities, see
#' [Serving Private Content through
#' CloudFront](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig)
#'
#' @param CloudFrontOriginAccessIdentityConfig &#91;required&#93; The current configuration information for the identity.
#'
#' @section Request syntax:
#' ```
#' svc$create_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig = list(
#'     CallerReference = "string",
#'     Comment = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_cloud_front_origin_access_identity
cloudfront_create_cloud_front_origin_access_identity <- function(CloudFrontOriginAccessIdentityConfig) {
  op <- new_operation(
    name = "CreateCloudFrontOriginAccessIdentity",
    http_method = "POST",
    http_path = "/2019-03-26/origin-access-identity/cloudfront",
    paginator = list()
  )
  input <- .cloudfront$create_cloud_front_origin_access_identity_input(CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig)
  output <- .cloudfront$create_cloud_front_origin_access_identity_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_cloud_front_origin_access_identity <- cloudfront_create_cloud_front_origin_access_identity

#' Creates a new web distribution
#'
#' Creates a new web distribution. You create a CloudFront distribution to
#' tell CloudFront where you want content to be delivered from, and the
#' details about how to track and manage content delivery. Send a `POST`
#' request to the
#' `/<i>CloudFront API version</i>/distribution`/`distribution ID`
#' resource.
#' 
#' When you update a distribution, there are more required fields than when
#' you create a distribution. When you update your distribution by using
#' [UpdateDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_UpdateDistribution.html),
#' follow the steps included in the documentation to get the current
#' configuration and then make your updates. This helps to make sure that
#' you include all of the required fields. To view a summary, see [Required
#' Fields for Create Distribution and Update
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_create_distribution(DistributionConfig)
#'
#' @param DistributionConfig &#91;required&#93; The distribution\'s configuration information.
#'
#' @section Request syntax:
#' ```
#' svc$create_distribution(
#'   DistributionConfig = list(
#'     CallerReference = "string",
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     DefaultRootObject = "string",
#'     Origins = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           DomainName = "string",
#'           OriginPath = "string",
#'           CustomHeaders = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 HeaderName = "string",
#'                 HeaderValue = "string"
#'               )
#'             )
#'           ),
#'           S3OriginConfig = list(
#'             OriginAccessIdentity = "string"
#'           ),
#'           CustomOriginConfig = list(
#'             HTTPPort = 123,
#'             HTTPSPort = 123,
#'             OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'             OriginSslProtocols = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'               )
#'             ),
#'             OriginReadTimeout = 123,
#'             OriginKeepaliveTimeout = 123
#'           )
#'         )
#'       )
#'     ),
#'     OriginGroups = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           FailoverCriteria = list(
#'             StatusCodes = list(
#'               Quantity = 123,
#'               Items = list(
#'                 123
#'               )
#'             )
#'           ),
#'           Members = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 OriginId = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DefaultCacheBehavior = list(
#'       TargetOriginId = "string",
#'       ForwardedValues = list(
#'         QueryString = TRUE|FALSE,
#'         Cookies = list(
#'           Forward = "none"|"whitelist"|"all",
#'           WhitelistedNames = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         QueryStringCacheKeys = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'       MinTTL = 123,
#'       AllowedMethods = list(
#'         Quantity = 123,
#'         Items = list(
#'           "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'         ),
#'         CachedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           )
#'         )
#'       ),
#'       SmoothStreaming = TRUE|FALSE,
#'       DefaultTTL = 123,
#'       MaxTTL = 123,
#'       Compress = TRUE|FALSE,
#'       LambdaFunctionAssociations = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             LambdaFunctionARN = "string",
#'             EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'             IncludeBody = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       FieldLevelEncryptionId = "string"
#'     ),
#'     CacheBehaviors = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PathPattern = "string",
#'           TargetOriginId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           MinTTL = 123,
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           DefaultTTL = 123,
#'           MaxTTL = 123,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string"
#'         )
#'       )
#'     ),
#'     CustomErrorResponses = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           ErrorCode = 123,
#'           ResponsePagePath = "string",
#'           ResponseCode = "string",
#'           ErrorCachingMinTTL = 123
#'         )
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       IncludeCookies = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE,
#'     ViewerCertificate = list(
#'       CloudFrontDefaultCertificate = TRUE|FALSE,
#'       IAMCertificateId = "string",
#'       ACMCertificateArn = "string",
#'       SSLSupportMethod = "sni-only"|"vip",
#'       MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018",
#'       Certificate = "string",
#'       CertificateSource = "cloudfront"|"iam"|"acm"
#'     ),
#'     Restrictions = list(
#'       GeoRestriction = list(
#'         RestrictionType = "blacklist"|"whitelist"|"none",
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     WebACLId = "string",
#'     HttpVersion = "http1.1"|"http2",
#'     IsIPV6Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_distribution
cloudfront_create_distribution <- function(DistributionConfig) {
  op <- new_operation(
    name = "CreateDistribution",
    http_method = "POST",
    http_path = "/2019-03-26/distribution",
    paginator = list()
  )
  input <- .cloudfront$create_distribution_input(DistributionConfig = DistributionConfig)
  output <- .cloudfront$create_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_distribution <- cloudfront_create_distribution

#' Create a new distribution with tags
#'
#' Create a new distribution with tags.
#'
#' @usage
#' cloudfront_create_distribution_with_tags(DistributionConfigWithTags)
#'
#' @param DistributionConfigWithTags &#91;required&#93; The distribution\'s configuration information.
#'
#' @section Request syntax:
#' ```
#' svc$create_distribution_with_tags(
#'   DistributionConfigWithTags = list(
#'     DistributionConfig = list(
#'       CallerReference = "string",
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       DefaultRootObject = "string",
#'       Origins = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             DomainName = "string",
#'             OriginPath = "string",
#'             CustomHeaders = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   HeaderName = "string",
#'                   HeaderValue = "string"
#'                 )
#'               )
#'             ),
#'             S3OriginConfig = list(
#'               OriginAccessIdentity = "string"
#'             ),
#'             CustomOriginConfig = list(
#'               HTTPPort = 123,
#'               HTTPSPort = 123,
#'               OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'               OriginSslProtocols = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'                 )
#'               ),
#'               OriginReadTimeout = 123,
#'               OriginKeepaliveTimeout = 123
#'             )
#'           )
#'         )
#'       ),
#'       OriginGroups = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Id = "string",
#'             FailoverCriteria = list(
#'               StatusCodes = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   123
#'                 )
#'               )
#'             ),
#'             Members = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   OriginId = "string"
#'                 )
#'               )
#'             )
#'           )
#'         )
#'       ),
#'       DefaultCacheBehavior = list(
#'         TargetOriginId = "string",
#'         ForwardedValues = list(
#'           QueryString = TRUE|FALSE,
#'           Cookies = list(
#'             Forward = "none"|"whitelist"|"all",
#'             WhitelistedNames = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           Headers = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           QueryStringCacheKeys = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         TrustedSigners = list(
#'           Enabled = TRUE|FALSE,
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'         MinTTL = 123,
#'         AllowedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           ),
#'           CachedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             )
#'           )
#'         ),
#'         SmoothStreaming = TRUE|FALSE,
#'         DefaultTTL = 123,
#'         MaxTTL = 123,
#'         Compress = TRUE|FALSE,
#'         LambdaFunctionAssociations = list(
#'           Quantity = 123,
#'           Items = list(
#'             list(
#'               LambdaFunctionARN = "string",
#'               EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'               IncludeBody = TRUE|FALSE
#'             )
#'           )
#'         ),
#'         FieldLevelEncryptionId = "string"
#'       ),
#'       CacheBehaviors = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             PathPattern = "string",
#'             TargetOriginId = "string",
#'             ForwardedValues = list(
#'               QueryString = TRUE|FALSE,
#'               Cookies = list(
#'                 Forward = "none"|"whitelist"|"all",
#'                 WhitelistedNames = list(
#'                   Quantity = 123,
#'                   Items = list(
#'                     "string"
#'                   )
#'                 )
#'               ),
#'               Headers = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               ),
#'               QueryStringCacheKeys = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             TrustedSigners = list(
#'               Enabled = TRUE|FALSE,
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'             MinTTL = 123,
#'             AllowedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               ),
#'               CachedMethods = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'                 )
#'               )
#'             ),
#'             SmoothStreaming = TRUE|FALSE,
#'             DefaultTTL = 123,
#'             MaxTTL = 123,
#'             Compress = TRUE|FALSE,
#'             LambdaFunctionAssociations = list(
#'               Quantity = 123,
#'               Items = list(
#'                 list(
#'                   LambdaFunctionARN = "string",
#'                   EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                   IncludeBody = TRUE|FALSE
#'                 )
#'               )
#'             ),
#'             FieldLevelEncryptionId = "string"
#'           )
#'         )
#'       ),
#'       CustomErrorResponses = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             ErrorCode = 123,
#'             ResponsePagePath = "string",
#'             ResponseCode = "string",
#'             ErrorCachingMinTTL = 123
#'           )
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         IncludeCookies = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE,
#'       ViewerCertificate = list(
#'         CloudFrontDefaultCertificate = TRUE|FALSE,
#'         IAMCertificateId = "string",
#'         ACMCertificateArn = "string",
#'         SSLSupportMethod = "sni-only"|"vip",
#'         MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018",
#'         Certificate = "string",
#'         CertificateSource = "cloudfront"|"iam"|"acm"
#'       ),
#'       Restrictions = list(
#'         GeoRestriction = list(
#'           RestrictionType = "blacklist"|"whitelist"|"none",
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       WebACLId = "string",
#'       HttpVersion = "http1.1"|"http2",
#'       IsIPV6Enabled = TRUE|FALSE
#'     ),
#'     Tags = list(
#'       Items = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_distribution_with_tags
cloudfront_create_distribution_with_tags <- function(DistributionConfigWithTags) {
  op <- new_operation(
    name = "CreateDistributionWithTags",
    http_method = "POST",
    http_path = "/2019-03-26/distribution?WithTags",
    paginator = list()
  )
  input <- .cloudfront$create_distribution_with_tags_input(DistributionConfigWithTags = DistributionConfigWithTags)
  output <- .cloudfront$create_distribution_with_tags_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_distribution_with_tags <- cloudfront_create_distribution_with_tags

#' Create a new field-level encryption configuration
#'
#' Create a new field-level encryption configuration.
#'
#' @usage
#' cloudfront_create_field_level_encryption_config(
#'   FieldLevelEncryptionConfig)
#'
#' @param FieldLevelEncryptionConfig &#91;required&#93; The request to create a new field-level encryption configuration.
#'
#' @section Request syntax:
#' ```
#' svc$create_field_level_encryption_config(
#'   FieldLevelEncryptionConfig = list(
#'     CallerReference = "string",
#'     Comment = "string",
#'     QueryArgProfileConfig = list(
#'       ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'       QueryArgProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             QueryArg = "string",
#'             ProfileId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ContentTypeProfileConfig = list(
#'       ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'       ContentTypeProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Format = "URLEncoded",
#'             ProfileId = "string",
#'             ContentType = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_field_level_encryption_config
cloudfront_create_field_level_encryption_config <- function(FieldLevelEncryptionConfig) {
  op <- new_operation(
    name = "CreateFieldLevelEncryptionConfig",
    http_method = "POST",
    http_path = "/2019-03-26/field-level-encryption",
    paginator = list()
  )
  input <- .cloudfront$create_field_level_encryption_config_input(FieldLevelEncryptionConfig = FieldLevelEncryptionConfig)
  output <- .cloudfront$create_field_level_encryption_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_field_level_encryption_config <- cloudfront_create_field_level_encryption_config

#' Create a field-level encryption profile
#'
#' Create a field-level encryption profile.
#'
#' @usage
#' cloudfront_create_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig)
#'
#' @param FieldLevelEncryptionProfileConfig &#91;required&#93; The request to create a field-level encryption profile.
#'
#' @section Request syntax:
#' ```
#' svc$create_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig = list(
#'     Name = "string",
#'     CallerReference = "string",
#'     Comment = "string",
#'     EncryptionEntities = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PublicKeyId = "string",
#'           ProviderId = "string",
#'           FieldPatterns = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_field_level_encryption_profile
cloudfront_create_field_level_encryption_profile <- function(FieldLevelEncryptionProfileConfig) {
  op <- new_operation(
    name = "CreateFieldLevelEncryptionProfile",
    http_method = "POST",
    http_path = "/2019-03-26/field-level-encryption-profile",
    paginator = list()
  )
  input <- .cloudfront$create_field_level_encryption_profile_input(FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig)
  output <- .cloudfront$create_field_level_encryption_profile_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_field_level_encryption_profile <- cloudfront_create_field_level_encryption_profile

#' Create a new invalidation
#'
#' Create a new invalidation.
#'
#' @usage
#' cloudfront_create_invalidation(DistributionId, InvalidationBatch)
#'
#' @param DistributionId &#91;required&#93; The distribution\'s id.
#' @param InvalidationBatch &#91;required&#93; The batch information for the invalidation.
#'
#' @section Request syntax:
#' ```
#' svc$create_invalidation(
#'   DistributionId = "string",
#'   InvalidationBatch = list(
#'     Paths = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     CallerReference = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_invalidation
cloudfront_create_invalidation <- function(DistributionId, InvalidationBatch) {
  op <- new_operation(
    name = "CreateInvalidation",
    http_method = "POST",
    http_path = "/2019-03-26/distribution/{DistributionId}/invalidation",
    paginator = list()
  )
  input <- .cloudfront$create_invalidation_input(DistributionId = DistributionId, InvalidationBatch = InvalidationBatch)
  output <- .cloudfront$create_invalidation_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_invalidation <- cloudfront_create_invalidation

#' Add a new public key to CloudFront to use, for example, for field-level
#' encryption
#'
#' Add a new public key to CloudFront to use, for example, for field-level
#' encryption. You can add a maximum of 10 public keys with one AWS
#' account.
#'
#' @usage
#' cloudfront_create_public_key(PublicKeyConfig)
#'
#' @param PublicKeyConfig &#91;required&#93; The request to add a public key to CloudFront.
#'
#' @section Request syntax:
#' ```
#' svc$create_public_key(
#'   PublicKeyConfig = list(
#'     CallerReference = "string",
#'     Name = "string",
#'     EncodedKey = "string",
#'     Comment = "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_public_key
cloudfront_create_public_key <- function(PublicKeyConfig) {
  op <- new_operation(
    name = "CreatePublicKey",
    http_method = "POST",
    http_path = "/2019-03-26/public-key",
    paginator = list()
  )
  input <- .cloudfront$create_public_key_input(PublicKeyConfig = PublicKeyConfig)
  output <- .cloudfront$create_public_key_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_public_key <- cloudfront_create_public_key

#' Creates a new RTMP distribution
#'
#' Creates a new RTMP distribution. An RTMP distribution is similar to a
#' web distribution, but an RTMP distribution streams media files using the
#' Adobe Real-Time Messaging Protocol (RTMP) instead of serving files using
#' HTTP.
#' 
#' To create a new distribution, submit a `POST` request to the *CloudFront
#' API version*/distribution resource. The request body must include a
#' document with a *StreamingDistributionConfig* element. The response
#' echoes the `StreamingDistributionConfig` element and returns other
#' information about the RTMP distribution.
#' 
#' To get the status of your request, use the *GET StreamingDistribution*
#' API action. When the value of `Enabled` is `true` and the value of
#' `Status` is `Deployed`, your distribution is ready. A distribution
#' usually deploys in less than 15 minutes.
#' 
#' For more information about web distributions, see [Working with RTMP
#' Distributions](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-rtmp.html)
#' in the *Amazon CloudFront Developer Guide*.
#' 
#' Beginning with the 2012-05-05 version of the CloudFront API, we made
#' substantial changes to the format of the XML document that you include
#' in the request body when you create or update a web distribution or an
#' RTMP distribution, and when you invalidate objects. With previous
#' versions of the API, we discovered that it was too easy to accidentally
#' delete one or more values for an element that accepts multiple values,
#' for example, CNAMEs and trusted signers. Our changes for the 2012-05-05
#' release are intended to prevent these accidental deletions and to notify
#' you when there\'s a mismatch between the number of values you say
#' you\'re specifying in the `Quantity` element and the number of values
#' specified.
#'
#' @usage
#' cloudfront_create_streaming_distribution(StreamingDistributionConfig)
#'
#' @param StreamingDistributionConfig &#91;required&#93; The streaming distribution\'s configuration information.
#'
#' @section Request syntax:
#' ```
#' svc$create_streaming_distribution(
#'   StreamingDistributionConfig = list(
#'     CallerReference = "string",
#'     S3Origin = list(
#'       DomainName = "string",
#'       OriginAccessIdentity = "string"
#'     ),
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     TrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_streaming_distribution
cloudfront_create_streaming_distribution <- function(StreamingDistributionConfig) {
  op <- new_operation(
    name = "CreateStreamingDistribution",
    http_method = "POST",
    http_path = "/2019-03-26/streaming-distribution",
    paginator = list()
  )
  input <- .cloudfront$create_streaming_distribution_input(StreamingDistributionConfig = StreamingDistributionConfig)
  output <- .cloudfront$create_streaming_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_streaming_distribution <- cloudfront_create_streaming_distribution

#' Create a new streaming distribution with tags
#'
#' Create a new streaming distribution with tags.
#'
#' @usage
#' cloudfront_create_streaming_distribution_with_tags(
#'   StreamingDistributionConfigWithTags)
#'
#' @param StreamingDistributionConfigWithTags &#91;required&#93; The streaming distribution\'s configuration information.
#'
#' @section Request syntax:
#' ```
#' svc$create_streaming_distribution_with_tags(
#'   StreamingDistributionConfigWithTags = list(
#'     StreamingDistributionConfig = list(
#'       CallerReference = "string",
#'       S3Origin = list(
#'         DomainName = "string",
#'         OriginAccessIdentity = "string"
#'       ),
#'       Aliases = list(
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       Comment = "string",
#'       Logging = list(
#'         Enabled = TRUE|FALSE,
#'         Bucket = "string",
#'         Prefix = "string"
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'       Enabled = TRUE|FALSE
#'     ),
#'     Tags = list(
#'       Items = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_create_streaming_distribution_with_tags
cloudfront_create_streaming_distribution_with_tags <- function(StreamingDistributionConfigWithTags) {
  op <- new_operation(
    name = "CreateStreamingDistributionWithTags",
    http_method = "POST",
    http_path = "/2019-03-26/streaming-distribution?WithTags",
    paginator = list()
  )
  input <- .cloudfront$create_streaming_distribution_with_tags_input(StreamingDistributionConfigWithTags = StreamingDistributionConfigWithTags)
  output <- .cloudfront$create_streaming_distribution_with_tags_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$create_streaming_distribution_with_tags <- cloudfront_create_streaming_distribution_with_tags

#' Delete an origin access identity
#'
#' Delete an origin access identity.
#'
#' @usage
#' cloudfront_delete_cloud_front_origin_access_identity(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The origin access identity\'s ID.
#' @param IfMatch The value of the `ETag` header you received from a previous `GET` or
#' `PUT` request. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_cloud_front_origin_access_identity(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_cloud_front_origin_access_identity
cloudfront_delete_cloud_front_origin_access_identity <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteCloudFrontOriginAccessIdentity",
    http_method = "DELETE",
    http_path = "/2019-03-26/origin-access-identity/cloudfront/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_cloud_front_origin_access_identity_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_cloud_front_origin_access_identity_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_cloud_front_origin_access_identity <- cloudfront_delete_cloud_front_origin_access_identity

#' Delete a distribution
#'
#' Delete a distribution.
#'
#' @usage
#' cloudfront_delete_distribution(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The distribution ID.
#' @param IfMatch The value of the `ETag` header that you received when you disabled the
#' distribution. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_distribution(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_distribution
cloudfront_delete_distribution <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteDistribution",
    http_method = "DELETE",
    http_path = "/2019-03-26/distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_distribution_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_distribution <- cloudfront_delete_distribution

#' Remove a field-level encryption configuration
#'
#' Remove a field-level encryption configuration.
#'
#' @usage
#' cloudfront_delete_field_level_encryption_config(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The ID of the configuration you want to delete from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' configuration identity to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_field_level_encryption_config(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_field_level_encryption_config
cloudfront_delete_field_level_encryption_config <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteFieldLevelEncryptionConfig",
    http_method = "DELETE",
    http_path = "/2019-03-26/field-level-encryption/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_field_level_encryption_config_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_field_level_encryption_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_field_level_encryption_config <- cloudfront_delete_field_level_encryption_config

#' Remove a field-level encryption profile
#'
#' Remove a field-level encryption profile.
#'
#' @usage
#' cloudfront_delete_field_level_encryption_profile(Id, IfMatch)
#'
#' @param Id &#91;required&#93; Request the ID of the profile you want to delete from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' profile to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_field_level_encryption_profile(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_field_level_encryption_profile
cloudfront_delete_field_level_encryption_profile <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteFieldLevelEncryptionProfile",
    http_method = "DELETE",
    http_path = "/2019-03-26/field-level-encryption-profile/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_field_level_encryption_profile_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_field_level_encryption_profile_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_field_level_encryption_profile <- cloudfront_delete_field_level_encryption_profile

#' Remove a public key you previously added to CloudFront
#'
#' Remove a public key you previously added to CloudFront.
#'
#' @usage
#' cloudfront_delete_public_key(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The ID of the public key you want to remove from CloudFront.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' public key identity to delete. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_public_key(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_public_key
cloudfront_delete_public_key <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeletePublicKey",
    http_method = "DELETE",
    http_path = "/2019-03-26/public-key/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_public_key_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_public_key_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_public_key <- cloudfront_delete_public_key

#' Delete a streaming distribution
#'
#' Delete a streaming distribution. To delete an RTMP distribution using
#' the CloudFront API, perform the following steps.
#' 
#' **To delete an RTMP distribution using the CloudFront API**:
#' 
#' 1.  Disable the RTMP distribution.
#' 
#' 2.  Submit a `GET Streaming Distribution Config` request to get the
#'     current configuration and the `Etag` header for the distribution.
#' 
#' 3.  Update the XML document that was returned in the response to your
#'     `GET Streaming Distribution Config` request to change the value of
#'     `Enabled` to `false`.
#' 
#' 4.  Submit a `PUT Streaming Distribution Config` request to update the
#'     configuration for your distribution. In the request body, include
#'     the XML document that you updated in Step 3. Then set the value of
#'     the HTTP `If-Match` header to the value of the `ETag` header that
#'     CloudFront returned when you submitted the
#'     `GET Streaming Distribution Config` request in Step 2.
#' 
#' 5.  Review the response to the `PUT Streaming Distribution Config`
#'     request to confirm that the distribution was successfully disabled.
#' 
#' 6.  Submit a `GET Streaming Distribution Config` request to confirm that
#'     your changes have propagated. When propagation is complete, the
#'     value of `Status` is `Deployed`.
#' 
#' 7.  Submit a `DELETE Streaming Distribution` request. Set the value of
#'     the HTTP `If-Match` header to the value of the `ETag` header that
#'     CloudFront returned when you submitted the
#'     `GET Streaming Distribution Config` request in Step 2.
#' 
#' 8.  Review the response to your `DELETE Streaming Distribution` request
#'     to confirm that the distribution was successfully deleted.
#' 
#' For information about deleting a distribution using the CloudFront
#' console, see [Deleting a
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/HowToDeleteDistribution.html)
#' in the *Amazon CloudFront Developer Guide*.
#'
#' @usage
#' cloudfront_delete_streaming_distribution(Id, IfMatch)
#'
#' @param Id &#91;required&#93; The distribution ID.
#' @param IfMatch The value of the `ETag` header that you received when you disabled the
#' streaming distribution. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_streaming_distribution(
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_delete_streaming_distribution
cloudfront_delete_streaming_distribution <- function(Id, IfMatch = NULL) {
  op <- new_operation(
    name = "DeleteStreamingDistribution",
    http_method = "DELETE",
    http_path = "/2019-03-26/streaming-distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$delete_streaming_distribution_input(Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$delete_streaming_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$delete_streaming_distribution <- cloudfront_delete_streaming_distribution

#' Get the information about an origin access identity
#'
#' Get the information about an origin access identity.
#'
#' @usage
#' cloudfront_get_cloud_front_origin_access_identity(Id)
#'
#' @param Id &#91;required&#93; The identity\'s ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_cloud_front_origin_access_identity(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cloud_front_origin_access_identity
cloudfront_get_cloud_front_origin_access_identity <- function(Id) {
  op <- new_operation(
    name = "GetCloudFrontOriginAccessIdentity",
    http_method = "GET",
    http_path = "/2019-03-26/origin-access-identity/cloudfront/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_cloud_front_origin_access_identity_input(Id = Id)
  output <- .cloudfront$get_cloud_front_origin_access_identity_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cloud_front_origin_access_identity <- cloudfront_get_cloud_front_origin_access_identity

#' Get the configuration information about an origin access identity
#'
#' Get the configuration information about an origin access identity.
#'
#' @usage
#' cloudfront_get_cloud_front_origin_access_identity_config(Id)
#'
#' @param Id &#91;required&#93; The identity\'s ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_cloud_front_origin_access_identity_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_cloud_front_origin_access_identity_config
cloudfront_get_cloud_front_origin_access_identity_config <- function(Id) {
  op <- new_operation(
    name = "GetCloudFrontOriginAccessIdentityConfig",
    http_method = "GET",
    http_path = "/2019-03-26/origin-access-identity/cloudfront/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_cloud_front_origin_access_identity_config_input(Id = Id)
  output <- .cloudfront$get_cloud_front_origin_access_identity_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_cloud_front_origin_access_identity_config <- cloudfront_get_cloud_front_origin_access_identity_config

#' Get the information about a distribution
#'
#' Get the information about a distribution.
#'
#' @usage
#' cloudfront_get_distribution(Id)
#'
#' @param Id &#91;required&#93; The distribution\'s ID. If the ID is empty, an empty distribution
#' configuration is returned.
#'
#' @section Request syntax:
#' ```
#' svc$get_distribution(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_distribution
cloudfront_get_distribution <- function(Id) {
  op <- new_operation(
    name = "GetDistribution",
    http_method = "GET",
    http_path = "/2019-03-26/distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_distribution_input(Id = Id)
  output <- .cloudfront$get_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_distribution <- cloudfront_get_distribution

#' Get the configuration information about a distribution
#'
#' Get the configuration information about a distribution.
#'
#' @usage
#' cloudfront_get_distribution_config(Id)
#'
#' @param Id &#91;required&#93; The distribution\'s ID. If the ID is empty, an empty distribution
#' configuration is returned.
#'
#' @section Request syntax:
#' ```
#' svc$get_distribution_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_distribution_config
cloudfront_get_distribution_config <- function(Id) {
  op <- new_operation(
    name = "GetDistributionConfig",
    http_method = "GET",
    http_path = "/2019-03-26/distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_distribution_config_input(Id = Id)
  output <- .cloudfront$get_distribution_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_distribution_config <- cloudfront_get_distribution_config

#' Get the field-level encryption configuration information
#'
#' Get the field-level encryption configuration information.
#'
#' @usage
#' cloudfront_get_field_level_encryption(Id)
#'
#' @param Id &#91;required&#93; Request the ID for the field-level encryption configuration information.
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption
cloudfront_get_field_level_encryption <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryption",
    http_method = "GET",
    http_path = "/2019-03-26/field-level-encryption/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption <- cloudfront_get_field_level_encryption

#' Get the field-level encryption configuration information
#'
#' Get the field-level encryption configuration information.
#'
#' @usage
#' cloudfront_get_field_level_encryption_config(Id)
#'
#' @param Id &#91;required&#93; Request the ID for the field-level encryption configuration information.
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_config
cloudfront_get_field_level_encryption_config <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionConfig",
    http_method = "GET",
    http_path = "/2019-03-26/field-level-encryption/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_config_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_config <- cloudfront_get_field_level_encryption_config

#' Get the field-level encryption profile information
#'
#' Get the field-level encryption profile information.
#'
#' @usage
#' cloudfront_get_field_level_encryption_profile(Id)
#'
#' @param Id &#91;required&#93; Get the ID for the field-level encryption profile information.
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption_profile(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_profile
cloudfront_get_field_level_encryption_profile <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionProfile",
    http_method = "GET",
    http_path = "/2019-03-26/field-level-encryption-profile/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_profile_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_profile_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_profile <- cloudfront_get_field_level_encryption_profile

#' Get the field-level encryption profile configuration information
#'
#' Get the field-level encryption profile configuration information.
#'
#' @usage
#' cloudfront_get_field_level_encryption_profile_config(Id)
#'
#' @param Id &#91;required&#93; Get the ID for the field-level encryption profile configuration
#' information.
#'
#' @section Request syntax:
#' ```
#' svc$get_field_level_encryption_profile_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_field_level_encryption_profile_config
cloudfront_get_field_level_encryption_profile_config <- function(Id) {
  op <- new_operation(
    name = "GetFieldLevelEncryptionProfileConfig",
    http_method = "GET",
    http_path = "/2019-03-26/field-level-encryption-profile/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_field_level_encryption_profile_config_input(Id = Id)
  output <- .cloudfront$get_field_level_encryption_profile_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_field_level_encryption_profile_config <- cloudfront_get_field_level_encryption_profile_config

#' Get the information about an invalidation
#'
#' Get the information about an invalidation.
#'
#' @usage
#' cloudfront_get_invalidation(DistributionId, Id)
#'
#' @param DistributionId &#91;required&#93; The distribution\'s ID.
#' @param Id &#91;required&#93; The identifier for the invalidation request, for example,
#' `IDFDVBD632BHDS5`.
#'
#' @section Request syntax:
#' ```
#' svc$get_invalidation(
#'   DistributionId = "string",
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_invalidation
cloudfront_get_invalidation <- function(DistributionId, Id) {
  op <- new_operation(
    name = "GetInvalidation",
    http_method = "GET",
    http_path = "/2019-03-26/distribution/{DistributionId}/invalidation/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_invalidation_input(DistributionId = DistributionId, Id = Id)
  output <- .cloudfront$get_invalidation_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_invalidation <- cloudfront_get_invalidation

#' Get the public key information
#'
#' Get the public key information.
#'
#' @usage
#' cloudfront_get_public_key(Id)
#'
#' @param Id &#91;required&#93; Request the ID for the public key.
#'
#' @section Request syntax:
#' ```
#' svc$get_public_key(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_public_key
cloudfront_get_public_key <- function(Id) {
  op <- new_operation(
    name = "GetPublicKey",
    http_method = "GET",
    http_path = "/2019-03-26/public-key/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_public_key_input(Id = Id)
  output <- .cloudfront$get_public_key_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_public_key <- cloudfront_get_public_key

#' Return public key configuration informaation
#'
#' Return public key configuration informaation
#'
#' @usage
#' cloudfront_get_public_key_config(Id)
#'
#' @param Id &#91;required&#93; Request the ID for the public key configuration.
#'
#' @section Request syntax:
#' ```
#' svc$get_public_key_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_public_key_config
cloudfront_get_public_key_config <- function(Id) {
  op <- new_operation(
    name = "GetPublicKeyConfig",
    http_method = "GET",
    http_path = "/2019-03-26/public-key/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_public_key_config_input(Id = Id)
  output <- .cloudfront$get_public_key_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_public_key_config <- cloudfront_get_public_key_config

#' Gets information about a specified RTMP distribution, including the
#' distribution configuration
#'
#' Gets information about a specified RTMP distribution, including the
#' distribution configuration.
#'
#' @usage
#' cloudfront_get_streaming_distribution(Id)
#'
#' @param Id &#91;required&#93; The streaming distribution\'s ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_streaming_distribution(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_streaming_distribution
cloudfront_get_streaming_distribution <- function(Id) {
  op <- new_operation(
    name = "GetStreamingDistribution",
    http_method = "GET",
    http_path = "/2019-03-26/streaming-distribution/{Id}",
    paginator = list()
  )
  input <- .cloudfront$get_streaming_distribution_input(Id = Id)
  output <- .cloudfront$get_streaming_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_streaming_distribution <- cloudfront_get_streaming_distribution

#' Get the configuration information about a streaming distribution
#'
#' Get the configuration information about a streaming distribution.
#'
#' @usage
#' cloudfront_get_streaming_distribution_config(Id)
#'
#' @param Id &#91;required&#93; The streaming distribution\'s ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_streaming_distribution_config(
#'   Id = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_get_streaming_distribution_config
cloudfront_get_streaming_distribution_config <- function(Id) {
  op <- new_operation(
    name = "GetStreamingDistributionConfig",
    http_method = "GET",
    http_path = "/2019-03-26/streaming-distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$get_streaming_distribution_config_input(Id = Id)
  output <- .cloudfront$get_streaming_distribution_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$get_streaming_distribution_config <- cloudfront_get_streaming_distribution_config

#' Lists origin access identities
#'
#' Lists origin access identities.
#'
#' @usage
#' cloudfront_list_cloud_front_origin_access_identities(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of origin access identities. The results include identities in the list
#' that occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page\'s
#' response (which is also the ID of the last identity on that page).
#' @param MaxItems The maximum number of origin access identities you want in the response
#' body.
#'
#' @section Request syntax:
#' ```
#' svc$list_cloud_front_origin_access_identities(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_cloud_front_origin_access_identities
cloudfront_list_cloud_front_origin_access_identities <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListCloudFrontOriginAccessIdentities",
    http_method = "GET",
    http_path = "/2019-03-26/origin-access-identity/cloudfront",
    paginator = list()
  )
  input <- .cloudfront$list_cloud_front_origin_access_identities_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_cloud_front_origin_access_identities_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_cloud_front_origin_access_identities <- cloudfront_list_cloud_front_origin_access_identities

#' List CloudFront distributions
#'
#' List CloudFront distributions.
#'
#' @usage
#' cloudfront_list_distributions(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of distributions. The results include distributions in the list that
#' occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page\'s
#' response (which is also the ID of the last distribution on that page).
#' @param MaxItems The maximum number of distributions you want in the response body.
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions
cloudfront_list_distributions <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListDistributions",
    http_method = "GET",
    http_path = "/2019-03-26/distribution",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_distributions_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions <- cloudfront_list_distributions

#' List the distributions that are associated with a specified AWS WAF web
#' ACL
#'
#' List the distributions that are associated with a specified AWS WAF web
#' ACL.
#'
#' @usage
#' cloudfront_list_distributions_by_web_acl_id(Marker, MaxItems, WebACLId)
#'
#' @param Marker Use `Marker` and `MaxItems` to control pagination of results. If you
#' have more than `MaxItems` distributions that satisfy the request, the
#' response includes a `NextMarker` element. To get the next page of
#' results, submit another request. For the value of `Marker`, specify the
#' value of `NextMarker` from the last response. (For the first request,
#' omit `Marker`.)
#' @param MaxItems The maximum number of distributions that you want CloudFront to return
#' in the response body. The maximum and default values are both 100.
#' @param WebACLId &#91;required&#93; The ID of the AWS WAF web ACL that you want to list the associated
#' distributions. If you specify \"null\" for the ID, the request returns a
#' list of the distributions that aren\'t associated with a web ACL.
#'
#' @section Request syntax:
#' ```
#' svc$list_distributions_by_web_acl_id(
#'   Marker = "string",
#'   MaxItems = "string",
#'   WebACLId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_distributions_by_web_acl_id
cloudfront_list_distributions_by_web_acl_id <- function(Marker = NULL, MaxItems = NULL, WebACLId) {
  op <- new_operation(
    name = "ListDistributionsByWebACLId",
    http_method = "GET",
    http_path = "/2019-03-26/distributionsByWebACLId/{WebACLId}",
    paginator = list()
  )
  input <- .cloudfront$list_distributions_by_web_acl_id_input(Marker = Marker, MaxItems = MaxItems, WebACLId = WebACLId)
  output <- .cloudfront$list_distributions_by_web_acl_id_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_distributions_by_web_acl_id <- cloudfront_list_distributions_by_web_acl_id

#' List all field-level encryption configurations that have been created in
#' CloudFront for this account
#'
#' List all field-level encryption configurations that have been created in
#' CloudFront for this account.
#'
#' @usage
#' cloudfront_list_field_level_encryption_configs(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of configurations. The results include configurations in the list that
#' occur after the marker. To get the next page of results, set the
#' `Marker` to the value of the `NextMarker` from the current page\'s
#' response (which is also the ID of the last configuration on that page).
#' @param MaxItems The maximum number of field-level encryption configurations you want in
#' the response body.
#'
#' @section Request syntax:
#' ```
#' svc$list_field_level_encryption_configs(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_field_level_encryption_configs
cloudfront_list_field_level_encryption_configs <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFieldLevelEncryptionConfigs",
    http_method = "GET",
    http_path = "/2019-03-26/field-level-encryption",
    paginator = list()
  )
  input <- .cloudfront$list_field_level_encryption_configs_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_field_level_encryption_configs_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_field_level_encryption_configs <- cloudfront_list_field_level_encryption_configs

#' Request a list of field-level encryption profiles that have been created
#' in CloudFront for this account
#'
#' Request a list of field-level encryption profiles that have been created
#' in CloudFront for this account.
#'
#' @usage
#' cloudfront_list_field_level_encryption_profiles(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of profiles. The results include profiles in the list that occur after
#' the marker. To get the next page of results, set the `Marker` to the
#' value of the `NextMarker` from the current page\'s response (which is
#' also the ID of the last profile on that page).
#' @param MaxItems The maximum number of field-level encryption profiles you want in the
#' response body.
#'
#' @section Request syntax:
#' ```
#' svc$list_field_level_encryption_profiles(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_field_level_encryption_profiles
cloudfront_list_field_level_encryption_profiles <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListFieldLevelEncryptionProfiles",
    http_method = "GET",
    http_path = "/2019-03-26/field-level-encryption-profile",
    paginator = list()
  )
  input <- .cloudfront$list_field_level_encryption_profiles_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_field_level_encryption_profiles_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_field_level_encryption_profiles <- cloudfront_list_field_level_encryption_profiles

#' Lists invalidation batches
#'
#' Lists invalidation batches.
#'
#' @usage
#' cloudfront_list_invalidations(DistributionId, Marker, MaxItems)
#'
#' @param DistributionId &#91;required&#93; The distribution\'s ID.
#' @param Marker Use this parameter when paginating results to indicate where to begin in
#' your list of invalidation batches. Because the results are returned in
#' decreasing order from most recent to oldest, the most recent results are
#' on the first page, the second page will contain earlier results, and so
#' on. To get the next page of results, set `Marker` to the value of the
#' `NextMarker` from the current page\'s response. This value is the same
#' as the ID of the last invalidation batch on that page.
#' @param MaxItems The maximum number of invalidation batches that you want in the response
#' body.
#'
#' @section Request syntax:
#' ```
#' svc$list_invalidations(
#'   DistributionId = "string",
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_invalidations
cloudfront_list_invalidations <- function(DistributionId, Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListInvalidations",
    http_method = "GET",
    http_path = "/2019-03-26/distribution/{DistributionId}/invalidation",
    paginator = list()
  )
  input <- .cloudfront$list_invalidations_input(DistributionId = DistributionId, Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_invalidations_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_invalidations <- cloudfront_list_invalidations

#' List all public keys that have been added to CloudFront for this account
#'
#' List all public keys that have been added to CloudFront for this
#' account.
#'
#' @usage
#' cloudfront_list_public_keys(Marker, MaxItems)
#'
#' @param Marker Use this when paginating results to indicate where to begin in your list
#' of public keys. The results include public keys in the list that occur
#' after the marker. To get the next page of results, set the `Marker` to
#' the value of the `NextMarker` from the current page\'s response (which
#' is also the ID of the last public key on that page).
#' @param MaxItems The maximum number of public keys you want in the response body.
#'
#' @section Request syntax:
#' ```
#' svc$list_public_keys(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_public_keys
cloudfront_list_public_keys <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListPublicKeys",
    http_method = "GET",
    http_path = "/2019-03-26/public-key",
    paginator = list()
  )
  input <- .cloudfront$list_public_keys_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_public_keys_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_public_keys <- cloudfront_list_public_keys

#' List streaming distributions
#'
#' List streaming distributions.
#'
#' @usage
#' cloudfront_list_streaming_distributions(Marker, MaxItems)
#'
#' @param Marker The value that you provided for the `Marker` request parameter.
#' @param MaxItems The value that you provided for the `MaxItems` request parameter.
#'
#' @section Request syntax:
#' ```
#' svc$list_streaming_distributions(
#'   Marker = "string",
#'   MaxItems = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_streaming_distributions
cloudfront_list_streaming_distributions <- function(Marker = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "ListStreamingDistributions",
    http_method = "GET",
    http_path = "/2019-03-26/streaming-distribution",
    paginator = list()
  )
  input <- .cloudfront$list_streaming_distributions_input(Marker = Marker, MaxItems = MaxItems)
  output <- .cloudfront$list_streaming_distributions_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_streaming_distributions <- cloudfront_list_streaming_distributions

#' List tags for a CloudFront resource
#'
#' List tags for a CloudFront resource.
#'
#' @usage
#' cloudfront_list_tags_for_resource(Resource)
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   Resource = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_list_tags_for_resource
cloudfront_list_tags_for_resource <- function(Resource) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/2019-03-26/tagging",
    paginator = list()
  )
  input <- .cloudfront$list_tags_for_resource_input(Resource = Resource)
  output <- .cloudfront$list_tags_for_resource_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$list_tags_for_resource <- cloudfront_list_tags_for_resource

#' Add tags to a CloudFront resource
#'
#' Add tags to a CloudFront resource.
#'
#' @usage
#' cloudfront_tag_resource(Resource, Tags)
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#' @param Tags &#91;required&#93; A complex type that contains zero or more `Tag` elements.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   Resource = "string",
#'   Tags = list(
#'     Items = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_tag_resource
cloudfront_tag_resource <- function(Resource, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/2019-03-26/tagging?Operation=Tag",
    paginator = list()
  )
  input <- .cloudfront$tag_resource_input(Resource = Resource, Tags = Tags)
  output <- .cloudfront$tag_resource_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$tag_resource <- cloudfront_tag_resource

#' Remove tags from a CloudFront resource
#'
#' Remove tags from a CloudFront resource.
#'
#' @usage
#' cloudfront_untag_resource(Resource, TagKeys)
#'
#' @param Resource &#91;required&#93; An ARN of a CloudFront resource.
#' @param TagKeys &#91;required&#93; A complex type that contains zero or more `Tag` key elements.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   Resource = "string",
#'   TagKeys = list(
#'     Items = list(
#'       "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_untag_resource
cloudfront_untag_resource <- function(Resource, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/2019-03-26/tagging?Operation=Untag",
    paginator = list()
  )
  input <- .cloudfront$untag_resource_input(Resource = Resource, TagKeys = TagKeys)
  output <- .cloudfront$untag_resource_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$untag_resource <- cloudfront_untag_resource

#' Update an origin access identity
#'
#' Update an origin access identity.
#'
#' @usage
#' cloudfront_update_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig, Id, IfMatch)
#'
#' @param CloudFrontOriginAccessIdentityConfig &#91;required&#93; The identity\'s configuration information.
#' @param Id &#91;required&#93; The identity\'s id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' identity\'s configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$update_cloud_front_origin_access_identity(
#'   CloudFrontOriginAccessIdentityConfig = list(
#'     CallerReference = "string",
#'     Comment = "string"
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_cloud_front_origin_access_identity
cloudfront_update_cloud_front_origin_access_identity <- function(CloudFrontOriginAccessIdentityConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateCloudFrontOriginAccessIdentity",
    http_method = "PUT",
    http_path = "/2019-03-26/origin-access-identity/cloudfront/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_cloud_front_origin_access_identity_input(CloudFrontOriginAccessIdentityConfig = CloudFrontOriginAccessIdentityConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_cloud_front_origin_access_identity_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_cloud_front_origin_access_identity <- cloudfront_update_cloud_front_origin_access_identity

#' Updates the configuration for a web distribution
#'
#' Updates the configuration for a web distribution.
#' 
#' When you update a distribution, there are more required fields than when
#' you create a distribution. When you update your distribution by using
#' this API action, follow the steps here to get the current configuration
#' and then make your updates, to make sure that you include all of the
#' required fields. To view a summary, see [Required Fields for Create
#' Distribution and Update
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-overview-required-fields.html)
#' in the *Amazon CloudFront Developer Guide*.
#' 
#' The update process includes getting the current distribution
#' configuration, updating the XML document that is returned to make your
#' changes, and then submitting an `UpdateDistribution` request to make the
#' updates.
#' 
#' For information about updating a distribution using the CloudFront
#' console instead, see [Creating a
#' Distribution](https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-creating-console.html)
#' in the *Amazon CloudFront Developer Guide*.
#' 
#' **To update a web distribution using the CloudFront API**
#' 
#' 1.  Submit a
#'     [GetDistributionConfig](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistributionConfig.html)
#'     request to get the current configuration and an `Etag` header for
#'     the distribution.
#' 
#'     If you update the distribution again, you must get a new `Etag`
#'     header.
#' 
#' 2.  Update the XML document that was returned in the response to your
#'     `GetDistributionConfig` request to include your changes.
#' 
#'     When you edit the XML file, be aware of the following:
#' 
#'     -   You must strip out the ETag parameter that is returned.
#' 
#'     -   Additional fields are required when you update a distribution.
#'         There may be fields included in the XML file for features that
#'         you haven\'t configured for your distribution. This is expected
#'         and required to successfully update the distribution.
#' 
#'     -   You can\'t change the value of `CallerReference`. If you try to
#'         change this value, CloudFront returns an `IllegalUpdate` error.
#' 
#'     -   The new configuration replaces the existing configuration; the
#'         values that you specify in an `UpdateDistribution` request are
#'         not merged into your existing configuration. When you add,
#'         delete, or replace values in an element that allows multiple
#'         values (for example, `CNAME`), you must specify all of the
#'         values that you want to appear in the updated distribution. In
#'         addition, you must update the corresponding `Quantity` element.
#' 
#' 3.  Submit an `UpdateDistribution` request to update the configuration
#'     for your distribution:
#' 
#'     -   In the request body, include the XML document that you updated
#'         in Step 2. The request body must include an XML document with a
#'         `DistributionConfig` element.
#' 
#'     -   Set the value of the HTTP `If-Match` header to the value of the
#'         `ETag` header that CloudFront returned when you submitted the
#'         `GetDistributionConfig` request in Step 1.
#' 
#' 4.  Review the response to the `UpdateDistribution` request to confirm
#'     that the configuration was successfully updated.
#' 
#' 5.  Optional: Submit a
#'     [GetDistribution](https://docs.aws.amazon.com/cloudfront/latest/APIReference/API_GetDistribution.html)
#'     request to confirm that your changes have propagated. When
#'     propagation is complete, the value of `Status` is `Deployed`.
#'
#' @usage
#' cloudfront_update_distribution(DistributionConfig, Id, IfMatch)
#'
#' @param DistributionConfig &#91;required&#93; The distribution\'s configuration information.
#' @param Id &#91;required&#93; The distribution\'s id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' distribution\'s configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$update_distribution(
#'   DistributionConfig = list(
#'     CallerReference = "string",
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     DefaultRootObject = "string",
#'     Origins = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           DomainName = "string",
#'           OriginPath = "string",
#'           CustomHeaders = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 HeaderName = "string",
#'                 HeaderValue = "string"
#'               )
#'             )
#'           ),
#'           S3OriginConfig = list(
#'             OriginAccessIdentity = "string"
#'           ),
#'           CustomOriginConfig = list(
#'             HTTPPort = 123,
#'             HTTPSPort = 123,
#'             OriginProtocolPolicy = "http-only"|"match-viewer"|"https-only",
#'             OriginSslProtocols = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "SSLv3"|"TLSv1"|"TLSv1.1"|"TLSv1.2"
#'               )
#'             ),
#'             OriginReadTimeout = 123,
#'             OriginKeepaliveTimeout = 123
#'           )
#'         )
#'       )
#'     ),
#'     OriginGroups = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           Id = "string",
#'           FailoverCriteria = list(
#'             StatusCodes = list(
#'               Quantity = 123,
#'               Items = list(
#'                 123
#'               )
#'             )
#'           ),
#'           Members = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 OriginId = "string"
#'               )
#'             )
#'           )
#'         )
#'       )
#'     ),
#'     DefaultCacheBehavior = list(
#'       TargetOriginId = "string",
#'       ForwardedValues = list(
#'         QueryString = TRUE|FALSE,
#'         Cookies = list(
#'           Forward = "none"|"whitelist"|"all",
#'           WhitelistedNames = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         ),
#'         Headers = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         ),
#'         QueryStringCacheKeys = list(
#'           Quantity = 123,
#'           Items = list(
#'             "string"
#'           )
#'         )
#'       ),
#'       TrustedSigners = list(
#'         Enabled = TRUE|FALSE,
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       ),
#'       ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'       MinTTL = 123,
#'       AllowedMethods = list(
#'         Quantity = 123,
#'         Items = list(
#'           "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'         ),
#'         CachedMethods = list(
#'           Quantity = 123,
#'           Items = list(
#'             "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'           )
#'         )
#'       ),
#'       SmoothStreaming = TRUE|FALSE,
#'       DefaultTTL = 123,
#'       MaxTTL = 123,
#'       Compress = TRUE|FALSE,
#'       LambdaFunctionAssociations = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             LambdaFunctionARN = "string",
#'             EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'             IncludeBody = TRUE|FALSE
#'           )
#'         )
#'       ),
#'       FieldLevelEncryptionId = "string"
#'     ),
#'     CacheBehaviors = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PathPattern = "string",
#'           TargetOriginId = "string",
#'           ForwardedValues = list(
#'             QueryString = TRUE|FALSE,
#'             Cookies = list(
#'               Forward = "none"|"whitelist"|"all",
#'               WhitelistedNames = list(
#'                 Quantity = 123,
#'                 Items = list(
#'                   "string"
#'                 )
#'               )
#'             ),
#'             Headers = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             ),
#'             QueryStringCacheKeys = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "string"
#'               )
#'             )
#'           ),
#'           TrustedSigners = list(
#'             Enabled = TRUE|FALSE,
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           ),
#'           ViewerProtocolPolicy = "allow-all"|"https-only"|"redirect-to-https",
#'           MinTTL = 123,
#'           AllowedMethods = list(
#'             Quantity = 123,
#'             Items = list(
#'               "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'             ),
#'             CachedMethods = list(
#'               Quantity = 123,
#'               Items = list(
#'                 "GET"|"HEAD"|"POST"|"PUT"|"PATCH"|"OPTIONS"|"DELETE"
#'               )
#'             )
#'           ),
#'           SmoothStreaming = TRUE|FALSE,
#'           DefaultTTL = 123,
#'           MaxTTL = 123,
#'           Compress = TRUE|FALSE,
#'           LambdaFunctionAssociations = list(
#'             Quantity = 123,
#'             Items = list(
#'               list(
#'                 LambdaFunctionARN = "string",
#'                 EventType = "viewer-request"|"viewer-response"|"origin-request"|"origin-response",
#'                 IncludeBody = TRUE|FALSE
#'               )
#'             )
#'           ),
#'           FieldLevelEncryptionId = "string"
#'         )
#'       )
#'     ),
#'     CustomErrorResponses = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           ErrorCode = 123,
#'           ResponsePagePath = "string",
#'           ResponseCode = "string",
#'           ErrorCachingMinTTL = 123
#'         )
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       IncludeCookies = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE,
#'     ViewerCertificate = list(
#'       CloudFrontDefaultCertificate = TRUE|FALSE,
#'       IAMCertificateId = "string",
#'       ACMCertificateArn = "string",
#'       SSLSupportMethod = "sni-only"|"vip",
#'       MinimumProtocolVersion = "SSLv3"|"TLSv1"|"TLSv1_2016"|"TLSv1.1_2016"|"TLSv1.2_2018",
#'       Certificate = "string",
#'       CertificateSource = "cloudfront"|"iam"|"acm"
#'     ),
#'     Restrictions = list(
#'       GeoRestriction = list(
#'         RestrictionType = "blacklist"|"whitelist"|"none",
#'         Quantity = 123,
#'         Items = list(
#'           "string"
#'         )
#'       )
#'     ),
#'     WebACLId = "string",
#'     HttpVersion = "http1.1"|"http2",
#'     IsIPV6Enabled = TRUE|FALSE
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_distribution
cloudfront_update_distribution <- function(DistributionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateDistribution",
    http_method = "PUT",
    http_path = "/2019-03-26/distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_distribution_input(DistributionConfig = DistributionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_distribution <- cloudfront_update_distribution

#' Update a field-level encryption configuration
#'
#' Update a field-level encryption configuration.
#'
#' @usage
#' cloudfront_update_field_level_encryption_config(
#'   FieldLevelEncryptionConfig, Id, IfMatch)
#'
#' @param FieldLevelEncryptionConfig &#91;required&#93; Request to update a field-level encryption configuration.
#' @param Id &#91;required&#93; The ID of the configuration you want to update.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' configuration identity to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$update_field_level_encryption_config(
#'   FieldLevelEncryptionConfig = list(
#'     CallerReference = "string",
#'     Comment = "string",
#'     QueryArgProfileConfig = list(
#'       ForwardWhenQueryArgProfileIsUnknown = TRUE|FALSE,
#'       QueryArgProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             QueryArg = "string",
#'             ProfileId = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ContentTypeProfileConfig = list(
#'       ForwardWhenContentTypeIsUnknown = TRUE|FALSE,
#'       ContentTypeProfiles = list(
#'         Quantity = 123,
#'         Items = list(
#'           list(
#'             Format = "URLEncoded",
#'             ProfileId = "string",
#'             ContentType = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_field_level_encryption_config
cloudfront_update_field_level_encryption_config <- function(FieldLevelEncryptionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateFieldLevelEncryptionConfig",
    http_method = "PUT",
    http_path = "/2019-03-26/field-level-encryption/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_field_level_encryption_config_input(FieldLevelEncryptionConfig = FieldLevelEncryptionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_field_level_encryption_config_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_field_level_encryption_config <- cloudfront_update_field_level_encryption_config

#' Update a field-level encryption profile
#'
#' Update a field-level encryption profile.
#'
#' @usage
#' cloudfront_update_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig, Id, IfMatch)
#'
#' @param FieldLevelEncryptionProfileConfig &#91;required&#93; Request to update a field-level encryption profile.
#' @param Id &#91;required&#93; The ID of the field-level encryption profile request.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' profile identity to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$update_field_level_encryption_profile(
#'   FieldLevelEncryptionProfileConfig = list(
#'     Name = "string",
#'     CallerReference = "string",
#'     Comment = "string",
#'     EncryptionEntities = list(
#'       Quantity = 123,
#'       Items = list(
#'         list(
#'           PublicKeyId = "string",
#'           ProviderId = "string",
#'           FieldPatterns = list(
#'             Quantity = 123,
#'             Items = list(
#'               "string"
#'             )
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_field_level_encryption_profile
cloudfront_update_field_level_encryption_profile <- function(FieldLevelEncryptionProfileConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateFieldLevelEncryptionProfile",
    http_method = "PUT",
    http_path = "/2019-03-26/field-level-encryption-profile/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_field_level_encryption_profile_input(FieldLevelEncryptionProfileConfig = FieldLevelEncryptionProfileConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_field_level_encryption_profile_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_field_level_encryption_profile <- cloudfront_update_field_level_encryption_profile

#' Update public key information
#'
#' Update public key information. Note that the only value you can change
#' is the comment.
#'
#' @usage
#' cloudfront_update_public_key(PublicKeyConfig, Id, IfMatch)
#'
#' @param PublicKeyConfig &#91;required&#93; Request to update public key information.
#' @param Id &#91;required&#93; ID of the public key to be updated.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' public key to update. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$update_public_key(
#'   PublicKeyConfig = list(
#'     CallerReference = "string",
#'     Name = "string",
#'     EncodedKey = "string",
#'     Comment = "string"
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_public_key
cloudfront_update_public_key <- function(PublicKeyConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdatePublicKey",
    http_method = "PUT",
    http_path = "/2019-03-26/public-key/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_public_key_input(PublicKeyConfig = PublicKeyConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_public_key_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_public_key <- cloudfront_update_public_key

#' Update a streaming distribution
#'
#' Update a streaming distribution.
#'
#' @usage
#' cloudfront_update_streaming_distribution(StreamingDistributionConfig,
#'   Id, IfMatch)
#'
#' @param StreamingDistributionConfig &#91;required&#93; The streaming distribution\'s configuration information.
#' @param Id &#91;required&#93; The streaming distribution\'s id.
#' @param IfMatch The value of the `ETag` header that you received when retrieving the
#' streaming distribution\'s configuration. For example: `E2QWRUHAPOMQZL`.
#'
#' @section Request syntax:
#' ```
#' svc$update_streaming_distribution(
#'   StreamingDistributionConfig = list(
#'     CallerReference = "string",
#'     S3Origin = list(
#'       DomainName = "string",
#'       OriginAccessIdentity = "string"
#'     ),
#'     Aliases = list(
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     Comment = "string",
#'     Logging = list(
#'       Enabled = TRUE|FALSE,
#'       Bucket = "string",
#'       Prefix = "string"
#'     ),
#'     TrustedSigners = list(
#'       Enabled = TRUE|FALSE,
#'       Quantity = 123,
#'       Items = list(
#'         "string"
#'       )
#'     ),
#'     PriceClass = "PriceClass_100"|"PriceClass_200"|"PriceClass_All",
#'     Enabled = TRUE|FALSE
#'   ),
#'   Id = "string",
#'   IfMatch = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname cloudfront_update_streaming_distribution
cloudfront_update_streaming_distribution <- function(StreamingDistributionConfig, Id, IfMatch = NULL) {
  op <- new_operation(
    name = "UpdateStreamingDistribution",
    http_method = "PUT",
    http_path = "/2019-03-26/streaming-distribution/{Id}/config",
    paginator = list()
  )
  input <- .cloudfront$update_streaming_distribution_input(StreamingDistributionConfig = StreamingDistributionConfig, Id = Id, IfMatch = IfMatch)
  output <- .cloudfront$update_streaming_distribution_output()
  svc <- .cloudfront$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.cloudfront$operations$update_streaming_distribution <- cloudfront_update_streaming_distribution
