% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_deregister_targets}
\alias{elbv2_deregister_targets}
\title{Deregisters the specified targets from the specified target group}
\usage{
elbv2_deregister_targets(TargetGroupArn, Targets)
}
\arguments{
\item{TargetGroupArn}{[required] The Amazon Resource Name (ARN) of the target group.}

\item{Targets}{[required] The targets. If you specified a port override when you registered a
target, you must specify both the target ID and the port when you
deregister it.}
}
\description{
Deregisters the specified targets from the specified target group. After
the targets are deregistered, they no longer receive traffic from the
load balancer.
}
\section{Request syntax}{
\preformatted{svc$deregister_targets(
  TargetGroupArn = "string",
  Targets = list(
    list(
      Id = "string",
      Port = 123,
      AvailabilityZone = "string"
    )
  )
)
}
}

\examples{
# This example deregisters the specified instance from the specified
# target group.
\donttest{svc$deregister_targets(
  TargetGroupArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:targetgroup/my-targe...",
  Targets = list(
    list(
      Id = "i-0f76fade"
    )
  )
)}

}
\keyword{internal}
