% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_deprovision_byoip_cidr}
\alias{globalaccelerator_deprovision_byoip_cidr}
\title{Releases the specified address range that you provisioned to use with
your AWS resources through bring your own IP addresses (BYOIP) and
deletes the corresponding address pool}
\usage{
globalaccelerator_deprovision_byoip_cidr(Cidr)
}
\arguments{
\item{Cidr}{[required] The address range, in CIDR notation. The prefix must be the same prefix
that you specified when you provisioned the address range.}
}
\description{
Releases the specified address range that you provisioned to use with
your AWS resources through bring your own IP addresses (BYOIP) and
deletes the corresponding address pool. To see an AWS CLI example of
deprovisioning an address range, scroll down to \strong{Example}.
}
\details{
Before you can release an address range, you must stop advertising it by
using
\href{https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html}{WithdrawByoipCidr}
and you must not have any accelerators that are using static IP
addresses allocated from its address range.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html}{Bring Your Own IP Addresses (BYOIP)}
in the \emph{AWS Global Accelerator Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$deprovision_byoip_cidr(
  Cidr = "string"
)
}
}

\keyword{internal}
