# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53recoveryreadiness_service.R
NULL

#' Creates a cell in an account
#'
#' @description
#' Creates a cell in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_cell/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_cell/) for full documentation.
#'
#' @param CellName &#91;required&#93; The name of the cell to create.
#' @param Cells A list of cell Amazon Resource Names (ARNs) contained within this cell,
#' for use in nested cells. For example, Availability Zones within specific
#' Amazon Web Services Regions.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_create_cell
route53recoveryreadiness_create_cell <- function(CellName, Cells = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCell",
    http_method = "POST",
    http_path = "/cells",
    paginator = list()
  )
  input <- .route53recoveryreadiness$create_cell_input(CellName = CellName, Cells = Cells, Tags = Tags)
  output <- .route53recoveryreadiness$create_cell_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$create_cell <- route53recoveryreadiness_create_cell

#' Creates a cross-account readiness authorization
#'
#' @description
#' Creates a cross-account readiness authorization. This lets you authorize another account to work with Route 53 Application Recovery Controller, for example, to check the readiness status of resources in a separate account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_cross_account_authorization/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_cross_account_authorization/) for full documentation.
#'
#' @param CrossAccountAuthorization &#91;required&#93; The cross-account authorization.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_create_cross_account_authorization
route53recoveryreadiness_create_cross_account_authorization <- function(CrossAccountAuthorization) {
  op <- new_operation(
    name = "CreateCrossAccountAuthorization",
    http_method = "POST",
    http_path = "/crossaccountauthorizations",
    paginator = list()
  )
  input <- .route53recoveryreadiness$create_cross_account_authorization_input(CrossAccountAuthorization = CrossAccountAuthorization)
  output <- .route53recoveryreadiness$create_cross_account_authorization_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$create_cross_account_authorization <- route53recoveryreadiness_create_cross_account_authorization

#' Creates a readiness check in an account
#'
#' @description
#' Creates a readiness check in an account. A readiness check monitors a resource set in your application, such as a set of Amazon Aurora instances, that Application Recovery Controller is auditing recovery readiness for. The audits run once every minute on every resource that's associated with a readiness check.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_readiness_check/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_readiness_check/) for full documentation.
#'
#' @param ReadinessCheckName &#91;required&#93; The name of the readiness check to create.
#' @param ResourceSetName &#91;required&#93; The name of the resource set to check.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_create_readiness_check
route53recoveryreadiness_create_readiness_check <- function(ReadinessCheckName, ResourceSetName, Tags = NULL) {
  op <- new_operation(
    name = "CreateReadinessCheck",
    http_method = "POST",
    http_path = "/readinesschecks",
    paginator = list()
  )
  input <- .route53recoveryreadiness$create_readiness_check_input(ReadinessCheckName = ReadinessCheckName, ResourceSetName = ResourceSetName, Tags = Tags)
  output <- .route53recoveryreadiness$create_readiness_check_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$create_readiness_check <- route53recoveryreadiness_create_readiness_check

#' Creates a recovery group in an account
#'
#' @description
#' Creates a recovery group in an account. A recovery group corresponds to an application and includes a list of the cells that make up the application.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_recovery_group/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_recovery_group/) for full documentation.
#'
#' @param Cells A list of the cell Amazon Resource Names (ARNs) in the recovery group.
#' @param RecoveryGroupName &#91;required&#93; The name of the recovery group to create.
#' @param Tags 
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_create_recovery_group
route53recoveryreadiness_create_recovery_group <- function(Cells = NULL, RecoveryGroupName, Tags = NULL) {
  op <- new_operation(
    name = "CreateRecoveryGroup",
    http_method = "POST",
    http_path = "/recoverygroups",
    paginator = list()
  )
  input <- .route53recoveryreadiness$create_recovery_group_input(Cells = Cells, RecoveryGroupName = RecoveryGroupName, Tags = Tags)
  output <- .route53recoveryreadiness$create_recovery_group_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$create_recovery_group <- route53recoveryreadiness_create_recovery_group

#' Creates a resource set
#'
#' @description
#' Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_resource_set/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_resource_set/) for full documentation.
#'
#' @param ResourceSetName &#91;required&#93; The name of the resource set to create.
#' @param ResourceSetType &#91;required&#93; The resource type of the resources in the resource set. Enter one of the
#' following values for resource type:
#' 
#' AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage,
#' AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm,
#' AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume,
#' AWS::ElasticLoadBalancing::LoadBalancer,
#' AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function,
#' AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
#' AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
#' AWS::EC2::VPNConnection, AWS::EC2::VPNGateway,
#' AWS::Route53RecoveryReadiness::DNSTargetResource
#' @param Resources &#91;required&#93; A list of resource objects in the resource set.
#' @param Tags A tag to associate with the parameters for a resource set.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_create_resource_set
route53recoveryreadiness_create_resource_set <- function(ResourceSetName, ResourceSetType, Resources, Tags = NULL) {
  op <- new_operation(
    name = "CreateResourceSet",
    http_method = "POST",
    http_path = "/resourcesets",
    paginator = list()
  )
  input <- .route53recoveryreadiness$create_resource_set_input(ResourceSetName = ResourceSetName, ResourceSetType = ResourceSetType, Resources = Resources, Tags = Tags)
  output <- .route53recoveryreadiness$create_resource_set_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$create_resource_set <- route53recoveryreadiness_create_resource_set

#' Delete a cell
#'
#' @description
#' Delete a cell. When successful, the response code is 204, with no response body.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_cell/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_cell/) for full documentation.
#'
#' @param CellName &#91;required&#93; The name of the cell.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_delete_cell
route53recoveryreadiness_delete_cell <- function(CellName) {
  op <- new_operation(
    name = "DeleteCell",
    http_method = "DELETE",
    http_path = "/cells/{cellName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$delete_cell_input(CellName = CellName)
  output <- .route53recoveryreadiness$delete_cell_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$delete_cell <- route53recoveryreadiness_delete_cell

#' Deletes cross account readiness authorization
#'
#' @description
#' Deletes cross account readiness authorization.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_cross_account_authorization/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_cross_account_authorization/) for full documentation.
#'
#' @param CrossAccountAuthorization &#91;required&#93; The cross-account authorization.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_delete_cross_account_authorization
route53recoveryreadiness_delete_cross_account_authorization <- function(CrossAccountAuthorization) {
  op <- new_operation(
    name = "DeleteCrossAccountAuthorization",
    http_method = "DELETE",
    http_path = "/crossaccountauthorizations/{crossAccountAuthorization}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$delete_cross_account_authorization_input(CrossAccountAuthorization = CrossAccountAuthorization)
  output <- .route53recoveryreadiness$delete_cross_account_authorization_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$delete_cross_account_authorization <- route53recoveryreadiness_delete_cross_account_authorization

#' Deletes a readiness check
#'
#' @description
#' Deletes a readiness check.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_readiness_check/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_readiness_check/) for full documentation.
#'
#' @param ReadinessCheckName &#91;required&#93; Name of a readiness check.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_delete_readiness_check
route53recoveryreadiness_delete_readiness_check <- function(ReadinessCheckName) {
  op <- new_operation(
    name = "DeleteReadinessCheck",
    http_method = "DELETE",
    http_path = "/readinesschecks/{readinessCheckName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$delete_readiness_check_input(ReadinessCheckName = ReadinessCheckName)
  output <- .route53recoveryreadiness$delete_readiness_check_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$delete_readiness_check <- route53recoveryreadiness_delete_readiness_check

#' Deletes a recovery group
#'
#' @description
#' Deletes a recovery group.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_recovery_group/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_recovery_group/) for full documentation.
#'
#' @param RecoveryGroupName &#91;required&#93; The name of a recovery group.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_delete_recovery_group
route53recoveryreadiness_delete_recovery_group <- function(RecoveryGroupName) {
  op <- new_operation(
    name = "DeleteRecoveryGroup",
    http_method = "DELETE",
    http_path = "/recoverygroups/{recoveryGroupName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$delete_recovery_group_input(RecoveryGroupName = RecoveryGroupName)
  output <- .route53recoveryreadiness$delete_recovery_group_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$delete_recovery_group <- route53recoveryreadiness_delete_recovery_group

#' Deletes a resource set
#'
#' @description
#' Deletes a resource set.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_resource_set/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_delete_resource_set/) for full documentation.
#'
#' @param ResourceSetName &#91;required&#93; Name of a resource set.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_delete_resource_set
route53recoveryreadiness_delete_resource_set <- function(ResourceSetName) {
  op <- new_operation(
    name = "DeleteResourceSet",
    http_method = "DELETE",
    http_path = "/resourcesets/{resourceSetName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$delete_resource_set_input(ResourceSetName = ResourceSetName)
  output <- .route53recoveryreadiness$delete_resource_set_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$delete_resource_set <- route53recoveryreadiness_delete_resource_set

#' Gets recommendations about architecture designs for improving resiliency
#' for an application, based on a recovery group
#'
#' @description
#' Gets recommendations about architecture designs for improving resiliency for an application, based on a recovery group.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_architecture_recommendations/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_architecture_recommendations/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#' @param RecoveryGroupName &#91;required&#93; The name of a recovery group.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_architecture_recommendations
route53recoveryreadiness_get_architecture_recommendations <- function(MaxResults = NULL, NextToken = NULL, RecoveryGroupName) {
  op <- new_operation(
    name = "GetArchitectureRecommendations",
    http_method = "GET",
    http_path = "/recoverygroups/{recoveryGroupName}/architectureRecommendations",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_architecture_recommendations_input(MaxResults = MaxResults, NextToken = NextToken, RecoveryGroupName = RecoveryGroupName)
  output <- .route53recoveryreadiness$get_architecture_recommendations_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_architecture_recommendations <- route53recoveryreadiness_get_architecture_recommendations

#' Gets information about a cell including cell name, cell Amazon Resource
#' Name (ARN), ARNs of nested cells for this cell, and a list of those cell
#' ARNs with their associated recovery group ARNs
#'
#' @description
#' Gets information about a cell including cell name, cell Amazon Resource Name (ARN), ARNs of nested cells for this cell, and a list of those cell ARNs with their associated recovery group ARNs.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_cell/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_cell/) for full documentation.
#'
#' @param CellName &#91;required&#93; The name of the cell.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_cell
route53recoveryreadiness_get_cell <- function(CellName) {
  op <- new_operation(
    name = "GetCell",
    http_method = "GET",
    http_path = "/cells/{cellName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_cell_input(CellName = CellName)
  output <- .route53recoveryreadiness$get_cell_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_cell <- route53recoveryreadiness_get_cell

#' Gets readiness for a cell
#'
#' @description
#' Gets readiness for a cell. Aggregates the readiness of all the resources that are associated with the cell into a single value.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_cell_readiness_summary/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_cell_readiness_summary/) for full documentation.
#'
#' @param CellName &#91;required&#93; The name of the cell.
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_cell_readiness_summary
route53recoveryreadiness_get_cell_readiness_summary <- function(CellName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetCellReadinessSummary",
    http_method = "GET",
    http_path = "/cellreadiness/{cellName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_cell_readiness_summary_input(CellName = CellName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoveryreadiness$get_cell_readiness_summary_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_cell_readiness_summary <- route53recoveryreadiness_get_cell_readiness_summary

#' Gets details about a readiness check
#'
#' @description
#' Gets details about a readiness check.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_readiness_check/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_readiness_check/) for full documentation.
#'
#' @param ReadinessCheckName &#91;required&#93; Name of a readiness check.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_readiness_check
route53recoveryreadiness_get_readiness_check <- function(ReadinessCheckName) {
  op <- new_operation(
    name = "GetReadinessCheck",
    http_method = "GET",
    http_path = "/readinesschecks/{readinessCheckName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_readiness_check_input(ReadinessCheckName = ReadinessCheckName)
  output <- .route53recoveryreadiness$get_readiness_check_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_readiness_check <- route53recoveryreadiness_get_readiness_check

#' Gets individual readiness status for a readiness check
#'
#' @description
#' Gets individual readiness status for a readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in the recovery group, use GetRecoveryGroupReadinessSummary.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_readiness_check_resource_status/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_readiness_check_resource_status/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#' @param ReadinessCheckName &#91;required&#93; Name of a readiness check.
#' @param ResourceIdentifier &#91;required&#93; The resource identifier, which is the Amazon Resource Name (ARN) or the
#' identifier generated for the resource by Application Recovery Controller
#' (for example, for a DNS target resource).
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_readiness_check_resource_status
route53recoveryreadiness_get_readiness_check_resource_status <- function(MaxResults = NULL, NextToken = NULL, ReadinessCheckName, ResourceIdentifier) {
  op <- new_operation(
    name = "GetReadinessCheckResourceStatus",
    http_method = "GET",
    http_path = "/readinesschecks/{readinessCheckName}/resource/{resourceIdentifier}/status",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_readiness_check_resource_status_input(MaxResults = MaxResults, NextToken = NextToken, ReadinessCheckName = ReadinessCheckName, ResourceIdentifier = ResourceIdentifier)
  output <- .route53recoveryreadiness$get_readiness_check_resource_status_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_readiness_check_resource_status <- route53recoveryreadiness_get_readiness_check_resource_status

#' Gets the readiness status for an individual readiness check
#'
#' @description
#' Gets the readiness status for an individual readiness check. To see the overall readiness status for a recovery group, that considers the readiness status for all the readiness checks in a recovery group, use GetRecoveryGroupReadinessSummary.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_readiness_check_status/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_readiness_check_status/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#' @param ReadinessCheckName &#91;required&#93; Name of a readiness check.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_readiness_check_status
route53recoveryreadiness_get_readiness_check_status <- function(MaxResults = NULL, NextToken = NULL, ReadinessCheckName) {
  op <- new_operation(
    name = "GetReadinessCheckStatus",
    http_method = "GET",
    http_path = "/readinesschecks/{readinessCheckName}/status",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_readiness_check_status_input(MaxResults = MaxResults, NextToken = NextToken, ReadinessCheckName = ReadinessCheckName)
  output <- .route53recoveryreadiness$get_readiness_check_status_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_readiness_check_status <- route53recoveryreadiness_get_readiness_check_status

#' Gets details about a recovery group, including a list of the cells that
#' are included in it
#'
#' @description
#' Gets details about a recovery group, including a list of the cells that are included in it.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_recovery_group/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_recovery_group/) for full documentation.
#'
#' @param RecoveryGroupName &#91;required&#93; The name of a recovery group.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_recovery_group
route53recoveryreadiness_get_recovery_group <- function(RecoveryGroupName) {
  op <- new_operation(
    name = "GetRecoveryGroup",
    http_method = "GET",
    http_path = "/recoverygroups/{recoveryGroupName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_recovery_group_input(RecoveryGroupName = RecoveryGroupName)
  output <- .route53recoveryreadiness$get_recovery_group_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_recovery_group <- route53recoveryreadiness_get_recovery_group

#' Displays a summary of information about a recovery group's readiness
#' status
#'
#' @description
#' Displays a summary of information about a recovery group's readiness status. Includes the readiness checks for resources in the recovery group and the readiness status of each one.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_recovery_group_readiness_summary/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_recovery_group_readiness_summary/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#' @param RecoveryGroupName &#91;required&#93; The name of a recovery group.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_reco_grou_read_summ
route53recoveryreadiness_get_recovery_group_readiness_summary <- function(MaxResults = NULL, NextToken = NULL, RecoveryGroupName) {
  op <- new_operation(
    name = "GetRecoveryGroupReadinessSummary",
    http_method = "GET",
    http_path = "/recoverygroupreadiness/{recoveryGroupName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_recovery_group_readiness_summary_input(MaxResults = MaxResults, NextToken = NextToken, RecoveryGroupName = RecoveryGroupName)
  output <- .route53recoveryreadiness$get_recovery_group_readiness_summary_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_recovery_group_readiness_summary <- route53recoveryreadiness_get_recovery_group_readiness_summary

#' Displays the details about a resource set, including a list of the
#' resources in the set
#'
#' @description
#' Displays the details about a resource set, including a list of the resources in the set.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_resource_set/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_get_resource_set/) for full documentation.
#'
#' @param ResourceSetName &#91;required&#93; Name of a resource set.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_get_resource_set
route53recoveryreadiness_get_resource_set <- function(ResourceSetName) {
  op <- new_operation(
    name = "GetResourceSet",
    http_method = "GET",
    http_path = "/resourcesets/{resourceSetName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$get_resource_set_input(ResourceSetName = ResourceSetName)
  output <- .route53recoveryreadiness$get_resource_set_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$get_resource_set <- route53recoveryreadiness_get_resource_set

#' Lists the cells for an account
#'
#' @description
#' Lists the cells for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_cells/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_cells/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_list_cells
route53recoveryreadiness_list_cells <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCells",
    http_method = "GET",
    http_path = "/cells",
    paginator = list()
  )
  input <- .route53recoveryreadiness$list_cells_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoveryreadiness$list_cells_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$list_cells <- route53recoveryreadiness_list_cells

#' Lists the cross-account readiness authorizations that are in place for
#' an account
#'
#' @description
#' Lists the cross-account readiness authorizations that are in place for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_cross_account_authorizations/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_cross_account_authorizations/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_list_cross_account_authorizations
route53recoveryreadiness_list_cross_account_authorizations <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListCrossAccountAuthorizations",
    http_method = "GET",
    http_path = "/crossaccountauthorizations",
    paginator = list()
  )
  input <- .route53recoveryreadiness$list_cross_account_authorizations_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoveryreadiness$list_cross_account_authorizations_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$list_cross_account_authorizations <- route53recoveryreadiness_list_cross_account_authorizations

#' Lists the readiness checks for an account
#'
#' @description
#' Lists the readiness checks for an account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_readiness_checks/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_readiness_checks/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_list_readiness_checks
route53recoveryreadiness_list_readiness_checks <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListReadinessChecks",
    http_method = "GET",
    http_path = "/readinesschecks",
    paginator = list()
  )
  input <- .route53recoveryreadiness$list_readiness_checks_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoveryreadiness$list_readiness_checks_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$list_readiness_checks <- route53recoveryreadiness_list_readiness_checks

#' Lists the recovery groups in an account
#'
#' @description
#' Lists the recovery groups in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_recovery_groups/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_recovery_groups/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_list_recovery_groups
route53recoveryreadiness_list_recovery_groups <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRecoveryGroups",
    http_method = "GET",
    http_path = "/recoverygroups",
    paginator = list()
  )
  input <- .route53recoveryreadiness$list_recovery_groups_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoveryreadiness$list_recovery_groups_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$list_recovery_groups <- route53recoveryreadiness_list_recovery_groups

#' Lists the resource sets in an account
#'
#' @description
#' Lists the resource sets in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_resource_sets/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_resource_sets/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_list_resource_sets
route53recoveryreadiness_list_resource_sets <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListResourceSets",
    http_method = "GET",
    http_path = "/resourcesets",
    paginator = list()
  )
  input <- .route53recoveryreadiness$list_resource_sets_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoveryreadiness$list_resource_sets_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$list_resource_sets <- route53recoveryreadiness_list_resource_sets

#' Lists all readiness rules, or lists the readiness rules for a specific
#' resource type
#'
#' @description
#' Lists all readiness rules, or lists the readiness rules for a specific resource type.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_rules/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_rules/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#' @param ResourceType The resource type that a readiness rule applies to.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_list_rules
route53recoveryreadiness_list_rules <- function(MaxResults = NULL, NextToken = NULL, ResourceType = NULL) {
  op <- new_operation(
    name = "ListRules",
    http_method = "GET",
    http_path = "/rules",
    paginator = list()
  )
  input <- .route53recoveryreadiness$list_rules_input(MaxResults = MaxResults, NextToken = NextToken, ResourceType = ResourceType)
  output <- .route53recoveryreadiness$list_rules_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$list_rules <- route53recoveryreadiness_list_rules

#' Lists the tags for a resource
#'
#' @description
#' Lists the tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_tags_for_resources/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_list_tags_for_resources/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a resource.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_list_tags_for_resources
route53recoveryreadiness_list_tags_for_resources <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResources",
    http_method = "GET",
    http_path = "/tags/{resource-arn}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$list_tags_for_resources_input(ResourceArn = ResourceArn)
  output <- .route53recoveryreadiness$list_tags_for_resources_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$list_tags_for_resources <- route53recoveryreadiness_list_tags_for_resources

#' Adds a tag to a resource
#'
#' @description
#' Adds a tag to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_tag_resource/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a resource.
#' @param Tags &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_tag_resource
route53recoveryreadiness_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resource-arn}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .route53recoveryreadiness$tag_resource_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$tag_resource <- route53recoveryreadiness_tag_resource

#' Removes a tag from a resource
#'
#' @description
#' Removes a tag from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_untag_resource/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for a resource.
#' @param TagKeys &#91;required&#93; The keys for tags you add to resources.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_untag_resource
route53recoveryreadiness_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resource-arn}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .route53recoveryreadiness$untag_resource_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$untag_resource <- route53recoveryreadiness_untag_resource

#' Updates a cell to replace the list of nested cells with a new list of
#' nested cells
#'
#' @description
#' Updates a cell to replace the list of nested cells with a new list of nested cells.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_cell/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_cell/) for full documentation.
#'
#' @param CellName &#91;required&#93; The name of the cell.
#' @param Cells &#91;required&#93; A list of cell Amazon Resource Names (ARNs), which completely replaces
#' the previous list.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_update_cell
route53recoveryreadiness_update_cell <- function(CellName, Cells) {
  op <- new_operation(
    name = "UpdateCell",
    http_method = "PUT",
    http_path = "/cells/{cellName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$update_cell_input(CellName = CellName, Cells = Cells)
  output <- .route53recoveryreadiness$update_cell_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$update_cell <- route53recoveryreadiness_update_cell

#' Updates a readiness check
#'
#' @description
#' Updates a readiness check.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_readiness_check/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_readiness_check/) for full documentation.
#'
#' @param ReadinessCheckName &#91;required&#93; Name of a readiness check.
#' @param ResourceSetName &#91;required&#93; The name of the resource set to be checked.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_update_readiness_check
route53recoveryreadiness_update_readiness_check <- function(ReadinessCheckName, ResourceSetName) {
  op <- new_operation(
    name = "UpdateReadinessCheck",
    http_method = "PUT",
    http_path = "/readinesschecks/{readinessCheckName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$update_readiness_check_input(ReadinessCheckName = ReadinessCheckName, ResourceSetName = ResourceSetName)
  output <- .route53recoveryreadiness$update_readiness_check_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$update_readiness_check <- route53recoveryreadiness_update_readiness_check

#' Updates a recovery group
#'
#' @description
#' Updates a recovery group.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_recovery_group/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_recovery_group/) for full documentation.
#'
#' @param Cells &#91;required&#93; A list of cell Amazon Resource Names (ARNs). This list completely
#' replaces the previous list.
#' @param RecoveryGroupName &#91;required&#93; The name of a recovery group.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_update_recovery_group
route53recoveryreadiness_update_recovery_group <- function(Cells, RecoveryGroupName) {
  op <- new_operation(
    name = "UpdateRecoveryGroup",
    http_method = "PUT",
    http_path = "/recoverygroups/{recoveryGroupName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$update_recovery_group_input(Cells = Cells, RecoveryGroupName = RecoveryGroupName)
  output <- .route53recoveryreadiness$update_recovery_group_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$update_recovery_group <- route53recoveryreadiness_update_recovery_group

#' Updates a resource set
#'
#' @description
#' Updates a resource set.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_resource_set/](https://www.paws-r-sdk.com/docs/route53recoveryreadiness_update_resource_set/) for full documentation.
#'
#' @param ResourceSetName &#91;required&#93; Name of a resource set.
#' @param ResourceSetType &#91;required&#93; The resource type of the resources in the resource set. Enter one of the
#' following values for resource type:
#' 
#' AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage,
#' AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm,
#' AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume,
#' AWS::ElasticLoadBalancing::LoadBalancer,
#' AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function,
#' AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
#' AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
#' AWS::EC2::VPNConnection, AWS::EC2::VPNGateway,
#' AWS::Route53RecoveryReadiness::DNSTargetResource
#' @param Resources &#91;required&#93; A list of resource objects.
#'
#' @keywords internal
#'
#' @rdname route53recoveryreadiness_update_resource_set
route53recoveryreadiness_update_resource_set <- function(ResourceSetName, ResourceSetType, Resources) {
  op <- new_operation(
    name = "UpdateResourceSet",
    http_method = "PUT",
    http_path = "/resourcesets/{resourceSetName}",
    paginator = list()
  )
  input <- .route53recoveryreadiness$update_resource_set_input(ResourceSetName = ResourceSetName, ResourceSetType = ResourceSetType, Resources = Resources)
  output <- .route53recoveryreadiness$update_resource_set_output()
  config <- get_config()
  svc <- .route53recoveryreadiness$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoveryreadiness$operations$update_resource_set <- route53recoveryreadiness_update_resource_set
