% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_put_integration_response}
\alias{apigateway_put_integration_response}
\title{Represents a put integration}
\usage{
apigateway_put_integration_response(
  restApiId,
  resourceId,
  httpMethod,
  statusCode,
  selectionPattern = NULL,
  responseParameters = NULL,
  responseTemplates = NULL,
  contentHandling = NULL
)
}
\arguments{
\item{restApiId}{[required] The string identifier of the associated RestApi.}

\item{resourceId}{[required] Specifies a put integration response request's resource identifier.}

\item{httpMethod}{[required] Specifies a put integration response request's HTTP method.}

\item{statusCode}{[required] Specifies the status code that is used to map the integration response
to an existing MethodResponse.}

\item{selectionPattern}{Specifies the selection pattern of a put integration response.}

\item{responseParameters}{A key-value map specifying response parameters that are passed to the
method response from the back end. The key is a method response header
parameter name and the mapped value is an integration response header
value, a static value enclosed within a pair of single quotes, or a JSON
expression from the integration response body. The mapping key must
match the pattern of \verb{method.response.header.\{name\}}, where \code{name} is a
valid and unique header name. The mapped non-static value must match the
pattern of \verb{integration.response.header.\{name\}} or
\verb{integration.response.body.\{JSON-expression\}}, where \code{name} must be a
valid and unique response header name and \code{JSON-expression} a valid JSON
expression without the \code{$} prefix.}

\item{responseTemplates}{Specifies a put integration response's templates.}

\item{contentHandling}{Specifies how to handle response payload content type conversions.
Supported values are \code{CONVERT_TO_BINARY} and \code{CONVERT_TO_TEXT}, with the
following behaviors:

If this property is not defined, the response payload will be passed
through from the integration response to the method response without
modification.}
}
\description{
Represents a put integration.

See \url{https://www.paws-r-sdk.com/docs/apigateway_put_integration_response/} for full documentation.
}
\keyword{internal}
