% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53recoveryreadiness_operations.R
\name{route53recoveryreadiness_create_resource_set}
\alias{route53recoveryreadiness_create_resource_set}
\title{Creates a resource set}
\usage{
route53recoveryreadiness_create_resource_set(
  ResourceSetName,
  ResourceSetType,
  Resources,
  Tags = NULL
)
}
\arguments{
\item{ResourceSetName}{[required] The name of the resource set to create.}

\item{ResourceSetType}{[required] The resource type of the resources in the resource set. Enter one of the
following values for resource type:

AWS::ApiGateway::Stage, AWS::ApiGatewayV2::Stage,
AWS::AutoScaling::AutoScalingGroup, AWS::CloudWatch::Alarm,
AWS::EC2::CustomerGateway, AWS::DynamoDB::Table, AWS::EC2::Volume,
AWS::ElasticLoadBalancing::LoadBalancer,
AWS::ElasticLoadBalancingV2::LoadBalancer, AWS::Lambda::Function,
AWS::MSK::Cluster, AWS::RDS::DBCluster, AWS::Route53::HealthCheck,
AWS::SQS::Queue, AWS::SNS::Topic, AWS::SNS::Subscription, AWS::EC2::VPC,
AWS::EC2::VPNConnection, AWS::EC2::VPNGateway,
AWS::Route53RecoveryReadiness::DNSTargetResource}

\item{Resources}{[required] A list of resource objects in the resource set.}

\item{Tags}{A tag to associate with the parameters for a resource set.}
}
\description{
Creates a resource set. A resource set is a set of resources of one type that span multiple cells. You can associate a resource set with a readiness check to monitor the resources for failover readiness.

See \url{https://www.paws-r-sdk.com/docs/route53recoveryreadiness_create_resource_set/} for full documentation.
}
\keyword{internal}
