% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_test_invoke_method}
\alias{apigateway_test_invoke_method}
\title{Simulate the invocation of a Method in your RestApi with headers,
parameters, and an incoming request body}
\usage{
apigateway_test_invoke_method(
  restApiId,
  resourceId,
  httpMethod,
  pathWithQueryString = NULL,
  body = NULL,
  headers = NULL,
  multiValueHeaders = NULL,
  clientCertificateId = NULL,
  stageVariables = NULL
)
}
\arguments{
\item{restApiId}{[required] The string identifier of the associated RestApi.}

\item{resourceId}{[required] Specifies a test invoke method request's resource ID.}

\item{httpMethod}{[required] Specifies a test invoke method request's HTTP method.}

\item{pathWithQueryString}{The URI path, including query string, of the simulated invocation
request. Use this to specify path parameters and query string
parameters.}

\item{body}{The simulated request body of an incoming invocation request.}

\item{headers}{A key-value map of headers to simulate an incoming invocation request.}

\item{multiValueHeaders}{The headers as a map from string to list of values to simulate an
incoming invocation request.}

\item{clientCertificateId}{A ClientCertificate identifier to use in the test invocation. API
Gateway will use the certificate when making the HTTPS request to the
defined back-end endpoint.}

\item{stageVariables}{A key-value map of stage variables to simulate an invocation on a
deployed Stage.}
}
\description{
Simulate the invocation of a Method in your RestApi with headers, parameters, and an incoming request body.

See \url{https://www.paws-r-sdk.com/docs/apigateway_test_invoke_method/} for full documentation.
}
\keyword{internal}
