% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_delete_hsm}
\alias{cloudhsmv2_delete_hsm}
\title{Deletes the specified HSM}
\usage{
cloudhsmv2_delete_hsm(ClusterId, HsmId, EniId, EniIp)
}
\arguments{
\item{ClusterId}{[required] The identifier (ID) of the cluster that contains the HSM that you are
deleting.}

\item{HsmId}{The identifier (ID) of the HSM that you are deleting.}

\item{EniId}{The identifier (ID) of the elastic network interface (ENI) of the HSM
that you are deleting.}

\item{EniIp}{The IP address of the elastic network interface (ENI) of the HSM that
you are deleting.}
}
\description{
Deletes the specified HSM. To specify an HSM, you can use its identifier
(ID), the IP address of the HSM's elastic network interface (ENI), or
the ID of the HSM's ENI. You need to specify only one of these values.
To find these values, use DescribeClusters.
}
\section{Request syntax}{
\preformatted{svc$delete_hsm(
  ClusterId = "string",
  HsmId = "string",
  EniId = "string",
  EniIp = "string"
)
}
}

\keyword{internal}
