% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_rule_group}
\alias{wafregional_update_rule_group}
\title{Inserts or deletes ActivatedRule objects in a RuleGroup}
\usage{
wafregional_update_rule_group(RuleGroupId, Updates, ChangeToken)
}
\arguments{
\item{RuleGroupId}{[required] The \code{RuleGroupId} of the RuleGroup that you want to update.
\code{RuleGroupId} is returned by CreateRuleGroup and by ListRuleGroups.}

\item{Updates}{[required] An array of \code{RuleGroupUpdate} objects that you want to insert into or
delete from a RuleGroup.

You can only insert \code{REGULAR} rules into a rule group.

\code{ActivatedRule|OverrideAction} applies only when updating or adding a
\code{RuleGroup} to a \code{WebACL}. In this case you do not use
\code{ActivatedRule|Action}. For all other update requests,
\code{ActivatedRule|Action} is used instead of
\code{ActivatedRule|OverrideAction}.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}
}
\description{
Inserts or deletes ActivatedRule objects in a \code{RuleGroup}.
}
\details{
You can only insert \code{REGULAR} rules into a rule group.

You can have a maximum of ten rules per rule group.

To create and configure a \code{RuleGroup}, perform the following steps:
\enumerate{
\item Create and update the \code{Rules} that you want to include in the
\code{RuleGroup}. See CreateRule.
\item Use \code{GetChangeToken} to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateRuleGroup request.
\item Submit an \code{UpdateRuleGroup} request to add \code{Rules} to the
\code{RuleGroup}.
\item Create and update a \code{WebACL} that contains the \code{RuleGroup}. See
CreateWebACL.
}

If you want to replace one \code{Rule} with another, you delete the existing
one and add the new one.

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_rule_group(
  RuleGroupId = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      ActivatedRule = list(
        Priority = 123,
        RuleId = "string",
        Action = list(
          Type = "BLOCK"|"ALLOW"|"COUNT"
        ),
        OverrideAction = list(
          Type = "NONE"|"COUNT"
        ),
        Type = "REGULAR"|"RATE_BASED"|"GROUP",
        ExcludedRules = list(
          list(
            RuleId = "string"
          )
        )
      )
    )
  ),
  ChangeToken = "string"
)
}
}

\keyword{internal}
