# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include acmpca_service.R
NULL

#' Creates a root or subordinate private certificate authority (CA)
#'
#' @description
#' Creates a root or subordinate private certificate authority (CA). You
#' must specify the CA configuration, the certificate revocation list (CRL)
#' configuration, the CA type, and an optional idempotency token to avoid
#' accidental creation of multiple CAs. The CA configuration specifies the
#' name of the algorithm and key size to be used to create the CA private
#' key, the type of signing algorithm that the CA uses, and X.500 subject
#' information. The CRL configuration specifies the CRL expiration period
#' in days (the validity period of the CRL), the Amazon S3 bucket that will
#' contain the CRL, and a CNAME alias for the S3 bucket that is included in
#' certificates issued by the CA. If successful, this action returns the
#' Amazon Resource Name (ARN) of the CA.
#' 
#' ACM Private CAA assets that are stored in Amazon S3 can be protected
#' with encryption. For more information, see [Encrypting Your
#' CRLs](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCreateCa.html#crl-encryption).
#' 
#' Both PCA and the IAM principal must have permission to write to the S3
#' bucket that you specify. If the IAM principal making the call does not
#' have permission to write to the bucket, then an exception is thrown. For
#' more information, see [Configure Access to ACM Private
#' CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/).
#'
#' @usage
#' acmpca_create_certificate_authority(CertificateAuthorityConfiguration,
#'   RevocationConfiguration, CertificateAuthorityType, IdempotencyToken,
#'   Tags)
#'
#' @param CertificateAuthorityConfiguration &#91;required&#93; Name and bit size of the private key algorithm, the name of the signing
#' algorithm, and X.500 certificate subject information.
#' @param RevocationConfiguration Contains a Boolean value that you can use to enable a certification
#' revocation list (CRL) for the CA, the name of the S3 bucket to which ACM
#' Private CA will write the CRL, and an optional CNAME alias that you can
#' use to hide the name of your bucket in the **CRL Distribution Points**
#' extension of your CA certificate. For more information, see the
#' [CrlConfiguration](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CrlConfiguration.html)
#' structure.
#' @param CertificateAuthorityType &#91;required&#93; The type of the certificate authority.
#' @param IdempotencyToken Alphanumeric string that can be used to distinguish between calls to
#' **CreateCertificateAuthority**. For a given token, ACM Private CA
#' creates exactly one CA. If you issue a subsequent call using the same
#' token, ACM Private CA returns the ARN of the existing CA and takes no
#' further action. If you change the idempotency token across multiple
#' calls, ACM Private CA creates a unique CA for each unique token.
#' @param Tags Key-value pairs that will be attached to the new private CA. You can
#' associate up to 50 tags with a private CA. For information using tags
#' with IAM to manage permissions, see [Controlling Access Using IAM
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_iam-tags.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_certificate_authority(
#'   CertificateAuthorityConfiguration = list(
#'     KeyAlgorithm = "RSA_2048"|"RSA_4096"|"EC_prime256v1"|"EC_secp384r1",
#'     SigningAlgorithm = "SHA256WITHECDSA"|"SHA384WITHECDSA"|"SHA512WITHECDSA"|"SHA256WITHRSA"|"SHA384WITHRSA"|"SHA512WITHRSA",
#'     Subject = list(
#'       Country = "string",
#'       Organization = "string",
#'       OrganizationalUnit = "string",
#'       DistinguishedNameQualifier = "string",
#'       State = "string",
#'       CommonName = "string",
#'       SerialNumber = "string",
#'       Locality = "string",
#'       Title = "string",
#'       Surname = "string",
#'       GivenName = "string",
#'       Initials = "string",
#'       Pseudonym = "string",
#'       GenerationQualifier = "string"
#'     ),
#'     CsrExtensions = list(
#'       KeyUsage = list(
#'         DigitalSignature = TRUE|FALSE,
#'         NonRepudiation = TRUE|FALSE,
#'         KeyEncipherment = TRUE|FALSE,
#'         DataEncipherment = TRUE|FALSE,
#'         KeyAgreement = TRUE|FALSE,
#'         KeyCertSign = TRUE|FALSE,
#'         CRLSign = TRUE|FALSE,
#'         EncipherOnly = TRUE|FALSE,
#'         DecipherOnly = TRUE|FALSE
#'       ),
#'       SubjectInformationAccess = list(
#'         list(
#'           AccessMethod = list(
#'             CustomObjectIdentifier = "string",
#'             AccessMethodType = "CA_REPOSITORY"|"RESOURCE_PKI_MANIFEST"|"RESOURCE_PKI_NOTIFY"
#'           ),
#'           AccessLocation = list(
#'             OtherName = list(
#'               TypeId = "string",
#'               Value = "string"
#'             ),
#'             Rfc822Name = "string",
#'             DnsName = "string",
#'             DirectoryName = list(
#'               Country = "string",
#'               Organization = "string",
#'               OrganizationalUnit = "string",
#'               DistinguishedNameQualifier = "string",
#'               State = "string",
#'               CommonName = "string",
#'               SerialNumber = "string",
#'               Locality = "string",
#'               Title = "string",
#'               Surname = "string",
#'               GivenName = "string",
#'               Initials = "string",
#'               Pseudonym = "string",
#'               GenerationQualifier = "string"
#'             ),
#'             EdiPartyName = list(
#'               PartyName = "string",
#'               NameAssigner = "string"
#'             ),
#'             UniformResourceIdentifier = "string",
#'             IpAddress = "string",
#'             RegisteredId = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   RevocationConfiguration = list(
#'     CrlConfiguration = list(
#'       Enabled = TRUE|FALSE,
#'       ExpirationInDays = 123,
#'       CustomCname = "string",
#'       S3BucketName = "string"
#'     )
#'   ),
#'   CertificateAuthorityType = "ROOT"|"SUBORDINATE",
#'   IdempotencyToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_create_certificate_authority
acmpca_create_certificate_authority <- function(CertificateAuthorityConfiguration, RevocationConfiguration = NULL, CertificateAuthorityType, IdempotencyToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_certificate_authority_input(CertificateAuthorityConfiguration = CertificateAuthorityConfiguration, RevocationConfiguration = RevocationConfiguration, CertificateAuthorityType = CertificateAuthorityType, IdempotencyToken = IdempotencyToken, Tags = Tags)
  output <- .acmpca$create_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_certificate_authority <- acmpca_create_certificate_authority

#' Creates an audit report that lists every time that your CA private key
#' is used
#'
#' @description
#' Creates an audit report that lists every time that your CA private key
#' is used. The report is saved in the Amazon S3 bucket that you specify on
#' input. The
#' [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html)
#' and
#' [RevokeCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html)
#' actions use the private key.
#' 
#' Both PCA and the IAM principal must have permission to write to the S3
#' bucket that you specify. If the IAM principal making the call does not
#' have permission to write to the bucket, then an exception is thrown. For
#' more information, see [Configure Access to ACM Private
#' CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/).
#' 
#' ACM Private CAA assets that are stored in Amazon S3 can be protected
#' with encryption. For more information, see [Encrypting Your Audit
#' Reports](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaAuditReport.html#audit-report-encryption).
#'
#' @usage
#' acmpca_create_certificate_authority_audit_report(
#'   CertificateAuthorityArn, S3BucketName, AuditReportResponseFormat)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the CA to be audited. This is of the
#' form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param S3BucketName &#91;required&#93; The name of the S3 bucket that will contain the audit report.
#' @param AuditReportResponseFormat &#91;required&#93; The format in which to create the report. This can be either **JSON** or
#' **CSV**.
#'
#' @section Request syntax:
#' ```
#' svc$create_certificate_authority_audit_report(
#'   CertificateAuthorityArn = "string",
#'   S3BucketName = "string",
#'   AuditReportResponseFormat = "JSON"|"CSV"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_create_certificate_authority_audit_report
acmpca_create_certificate_authority_audit_report <- function(CertificateAuthorityArn, S3BucketName, AuditReportResponseFormat) {
  op <- new_operation(
    name = "CreateCertificateAuthorityAuditReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_certificate_authority_audit_report_input(CertificateAuthorityArn = CertificateAuthorityArn, S3BucketName = S3BucketName, AuditReportResponseFormat = AuditReportResponseFormat)
  output <- .acmpca$create_certificate_authority_audit_report_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_certificate_authority_audit_report <- acmpca_create_certificate_authority_audit_report

#' Grants one or more permissions on a private CA to the AWS Certificate
#' Manager (ACM) service principal (acm
#'
#' @description
#' Grants one or more permissions on a private CA to the AWS Certificate
#' Manager (ACM) service principal (`acm.amazonaws.com`). These permissions
#' allow ACM to issue and renew ACM certificates that reside in the same
#' AWS account as the CA.
#' 
#' You can list current permissions with the
#' [ListPermissions](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html)
#' action and revoke them with the
#' [DeletePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html)
#' action.
#' 
#' **About Permissions**
#' 
#' -   If the private CA and the certificates it issues reside in the same
#'     account, you can use `CreatePermission` to grant permissions for ACM
#'     to carry out automatic certificate renewals.
#' 
#' -   For automatic certificate renewal to succeed, the ACM service
#'     principal needs permissions to create, retrieve, and list
#'     certificates.
#' 
#' -   If the private CA and the ACM certificates reside in different
#'     accounts, then permissions cannot be used to enable automatic
#'     renewals. Instead, the ACM certificate owner must set up a
#'     resource-based policy to enable cross-account issuance and renewals.
#'     For more information, see [Using a Resource Based Policy with ACM
#'     Private
#'     CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
#'
#' @usage
#' acmpca_create_permission(CertificateAuthorityArn, Principal,
#'   SourceAccount, Actions)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the CA that grants the permissions.
#' You can find the ARN by calling the
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' action. This must have the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param Principal &#91;required&#93; The AWS service or identity that receives the permission. At this time,
#' the only valid principal is `acm.amazonaws.com`.
#' @param SourceAccount The ID of the calling account.
#' @param Actions &#91;required&#93; The actions that the specified AWS service principal can use. These
#' include `IssueCertificate`, `GetCertificate`, and `ListPermissions`.
#'
#' @section Request syntax:
#' ```
#' svc$create_permission(
#'   CertificateAuthorityArn = "string",
#'   Principal = "string",
#'   SourceAccount = "string",
#'   Actions = list(
#'     "IssueCertificate"|"GetCertificate"|"ListPermissions"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_create_permission
acmpca_create_permission <- function(CertificateAuthorityArn, Principal, SourceAccount = NULL, Actions) {
  op <- new_operation(
    name = "CreatePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$create_permission_input(CertificateAuthorityArn = CertificateAuthorityArn, Principal = Principal, SourceAccount = SourceAccount, Actions = Actions)
  output <- .acmpca$create_permission_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$create_permission <- acmpca_create_permission

#' Deletes a private certificate authority (CA)
#'
#' @description
#' Deletes a private certificate authority (CA). You must provide the
#' Amazon Resource Name (ARN) of the private CA that you want to delete.
#' You can find the ARN by calling the
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' action.
#' 
#' Deleting a CA will invalidate other CAs and certificates below it in
#' your CA hierarchy.
#' 
#' Before you can delete a CA that you have created and activated, you must
#' disable it. To do this, call the
#' [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html)
#' action and set the **CertificateAuthorityStatus** parameter to
#' `DISABLED`.
#' 
#' Additionally, you can delete a CA if you are waiting for it to be
#' created (that is, the status of the CA is `CREATING`). You can also
#' delete it if the CA has been created but you haven't yet imported the
#' signed certificate into ACM Private CA (that is, the status of the CA is
#' `PENDING_CERTIFICATE`).
#' 
#' When you successfully call
#' [DeleteCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html),
#' the CA's status changes to `DELETED`. However, the CA won't be
#' permanently deleted until the restoration period has passed. By default,
#' if you do not set the `PermanentDeletionTimeInDays` parameter, the CA
#' remains restorable for 30 days. You can set the parameter from 7 to 30
#' days. The
#' [DescribeCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html)
#' action returns the time remaining in the restoration window of a private
#' CA in the `DELETED` state. To restore an eligible CA, call the
#' [RestoreCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RestoreCertificateAuthority.html)
#' action.
#'
#' @usage
#' acmpca_delete_certificate_authority(CertificateAuthorityArn,
#'   PermanentDeletionTimeInDays)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
#' This must have the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param PermanentDeletionTimeInDays The number of days to make a CA restorable after it has been deleted.
#' This can be anywhere from 7 to 30 days, with 30 being the default.
#'
#' @section Request syntax:
#' ```
#' svc$delete_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   PermanentDeletionTimeInDays = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_certificate_authority
acmpca_delete_certificate_authority <- function(CertificateAuthorityArn, PermanentDeletionTimeInDays = NULL) {
  op <- new_operation(
    name = "DeleteCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, PermanentDeletionTimeInDays = PermanentDeletionTimeInDays)
  output <- .acmpca$delete_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_certificate_authority <- acmpca_delete_certificate_authority

#' Revokes permissions on a private CA granted to the AWS Certificate
#' Manager (ACM) service principal (acm
#'
#' @description
#' Revokes permissions on a private CA granted to the AWS Certificate
#' Manager (ACM) service principal (acm.amazonaws.com).
#' 
#' These permissions allow ACM to issue and renew ACM certificates that
#' reside in the same AWS account as the CA. If you revoke these
#' permissions, ACM will no longer renew the affected certificates
#' automatically.
#' 
#' Permissions can be granted with the
#' [CreatePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html)
#' action and listed with the
#' [ListPermissions](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListPermissions.html)
#' action.
#' 
#' **About Permissions**
#' 
#' -   If the private CA and the certificates it issues reside in the same
#'     account, you can use `CreatePermission` to grant permissions for ACM
#'     to carry out automatic certificate renewals.
#' 
#' -   For automatic certificate renewal to succeed, the ACM service
#'     principal needs permissions to create, retrieve, and list
#'     certificates.
#' 
#' -   If the private CA and the ACM certificates reside in different
#'     accounts, then permissions cannot be used to enable automatic
#'     renewals. Instead, the ACM certificate owner must set up a
#'     resource-based policy to enable cross-account issuance and renewals.
#'     For more information, see [Using a Resource Based Policy with ACM
#'     Private
#'     CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
#'
#' @usage
#' acmpca_delete_permission(CertificateAuthorityArn, Principal,
#'   SourceAccount)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA that issued the
#' permissions. You can find the CA's ARN by calling the
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' action. This must have the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param Principal &#91;required&#93; The AWS service or identity that will have its CA permissions revoked.
#' At this time, the only valid service principal is `acm.amazonaws.com`
#' @param SourceAccount The AWS account that calls this action.
#'
#' @section Request syntax:
#' ```
#' svc$delete_permission(
#'   CertificateAuthorityArn = "string",
#'   Principal = "string",
#'   SourceAccount = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_permission
acmpca_delete_permission <- function(CertificateAuthorityArn, Principal, SourceAccount = NULL) {
  op <- new_operation(
    name = "DeletePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_permission_input(CertificateAuthorityArn = CertificateAuthorityArn, Principal = Principal, SourceAccount = SourceAccount)
  output <- .acmpca$delete_permission_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_permission <- acmpca_delete_permission

#' Deletes the resource-based policy attached to a private CA
#'
#' @description
#' Deletes the resource-based policy attached to a private CA. Deletion
#' will remove any access that the policy has granted. If there is no
#' policy attached to the private CA, this action will return successful.
#' 
#' If you delete a policy that was applied through AWS Resource Access
#' Manager (RAM), the CA will be removed from all shares in which it was
#' included.
#' 
#' The AWS Certificate Manager Service Linked Role that the policy supports
#' is not affected when you delete the policy.
#' 
#' The current policy can be shown with
#' [GetPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html)
#' and updated with
#' [PutPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html).
#' 
#' **About Policies**
#' 
#' -   A policy grants access on a private CA to an AWS customer account,
#'     to AWS Organizations, or to an AWS Organizations unit. Policies are
#'     under the control of a CA administrator. For more information, see
#'     [Using a Resource Based Policy with ACM Private
#'     CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
#' 
#' -   A policy permits a user of AWS Certificate Manager (ACM) to issue
#'     ACM certificates signed by a CA in another account.
#' 
#' -   For ACM to manage automatic renewal of these certificates, the ACM
#'     user must configure a Service Linked Role (SLR). The SLR allows the
#'     ACM service to assume the identity of the user, subject to
#'     confirmation against the ACM Private CA policy. For more
#'     information, see [Using a Service Linked Role with
#'     ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
#' 
#' -   Updates made in AWS Resource Manager (RAM) are reflected in
#'     policies. For more information, see [Attach a Policy for
#'     Cross-Account
#'     Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
#'
#' @usage
#' acmpca_delete_policy(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA that will have its
#' policy deleted. You can find the CA's ARN by calling the
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' action. The ARN value must have the form
#' `arn:aws:acm-pca:region:account:certificate-authority/01234567-89ab-cdef-0123-0123456789ab`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_policy(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_delete_policy
acmpca_delete_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$delete_policy_input(ResourceArn = ResourceArn)
  output <- .acmpca$delete_policy_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$delete_policy <- acmpca_delete_policy

#' Lists information about your private certificate authority (CA) or one
#' that has been shared with you
#'
#' @description
#' Lists information about your private certificate authority (CA) or one
#' that has been shared with you. You specify the private CA on input by
#' its ARN (Amazon Resource Name). The output contains the status of your
#' CA. This can be any of the following:
#' 
#' -   `CREATING` - ACM Private CA is creating your private certificate
#'     authority.
#' 
#' -   `PENDING_CERTIFICATE` - The certificate is pending. You must use
#'     your ACM Private CA-hosted or on-premises root or subordinate CA to
#'     sign your private CA CSR and then import it into PCA.
#' 
#' -   `ACTIVE` - Your private CA is active.
#' 
#' -   `DISABLED` - Your private CA has been disabled.
#' 
#' -   `EXPIRED` - Your private CA certificate has expired.
#' 
#' -   `FAILED` - Your private CA has failed. Your CA can fail because of
#'     problems such a network outage or backend AWS failure or other
#'     errors. A failed CA can never return to the pending state. You must
#'     create a new CA.
#' 
#' -   `DELETED` - Your private CA is within the restoration period, after
#'     which it is permanently deleted. The length of time remaining in the
#'     CA's restoration period is also included in this action's output.
#'
#' @usage
#' acmpca_describe_certificate_authority(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#'
#' @section Request syntax:
#' ```
#' svc$describe_certificate_authority(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_describe_certificate_authority
acmpca_describe_certificate_authority <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "DescribeCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$describe_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$describe_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$describe_certificate_authority <- acmpca_describe_certificate_authority

#' Lists information about a specific audit report created by calling the
#' CreateCertificateAuthorityAuditReport action
#'
#' @description
#' Lists information about a specific audit report created by calling the
#' [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html)
#' action. Audit information is created every time the certificate
#' authority (CA) private key is used. The private key is used when you
#' call the
#' [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html)
#' action or the
#' [RevokeCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_RevokeCertificate.html)
#' action.
#'
#' @usage
#' acmpca_describe_certificate_authority_audit_report(
#'   CertificateAuthorityArn, AuditReportId)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of the private CA. This must be of the
#' form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param AuditReportId &#91;required&#93; The report ID returned by calling the
#' [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html)
#' action.
#'
#' @section Request syntax:
#' ```
#' svc$describe_certificate_authority_audit_report(
#'   CertificateAuthorityArn = "string",
#'   AuditReportId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_describe_certificate_authority_audit_report
acmpca_describe_certificate_authority_audit_report <- function(CertificateAuthorityArn, AuditReportId) {
  op <- new_operation(
    name = "DescribeCertificateAuthorityAuditReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$describe_certificate_authority_audit_report_input(CertificateAuthorityArn = CertificateAuthorityArn, AuditReportId = AuditReportId)
  output <- .acmpca$describe_certificate_authority_audit_report_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$describe_certificate_authority_audit_report <- acmpca_describe_certificate_authority_audit_report

#' Retrieves a certificate from your private CA or one that has been shared
#' with you
#'
#' @description
#' Retrieves a certificate from your private CA or one that has been shared
#' with you. The ARN of the certificate is returned when you call the
#' [IssueCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_IssueCertificate.html)
#' action. You must specify both the ARN of your private CA and the ARN of
#' the issued certificate when calling the **GetCertificate** action. You
#' can retrieve the certificate if it is in the **ISSUED** state. You can
#' call the
#' [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html)
#' action to create a report that contains information about all of the
#' certificates issued and revoked by your private CA.
#'
#' @usage
#' acmpca_get_certificate(CertificateAuthorityArn, CertificateArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#' @param CertificateArn &#91;required&#93; The ARN of the issued certificate. The ARN contains the certificate
#' serial number and must be in the following form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i>/certificate/<i>286535153982981100925020015808220737245</i> `
#'
#' @section Request syntax:
#' ```
#' svc$get_certificate(
#'   CertificateAuthorityArn = "string",
#'   CertificateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate
acmpca_get_certificate <- function(CertificateAuthorityArn, CertificateArn) {
  op <- new_operation(
    name = "GetCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, CertificateArn = CertificateArn)
  output <- .acmpca$get_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate <- acmpca_get_certificate

#' Retrieves the certificate and certificate chain for your private
#' certificate authority (CA) or one that has been shared with you
#'
#' @description
#' Retrieves the certificate and certificate chain for your private
#' certificate authority (CA) or one that has been shared with you. Both
#' the certificate and the chain are base64 PEM-encoded. The chain does not
#' include the CA certificate. Each certificate in the chain signs the one
#' before it.
#'
#' @usage
#' acmpca_get_certificate_authority_certificate(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) of your private CA. This is of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `.
#'
#' @section Request syntax:
#' ```
#' svc$get_certificate_authority_certificate(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate_authority_certificate
acmpca_get_certificate_authority_certificate <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "GetCertificateAuthorityCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_authority_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$get_certificate_authority_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate_authority_certificate <- acmpca_get_certificate_authority_certificate

#' Retrieves the certificate signing request (CSR) for your private
#' certificate authority (CA)
#'
#' @description
#' Retrieves the certificate signing request (CSR) for your private
#' certificate authority (CA). The CSR is created when you call the
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
#' action. Sign the CSR with your ACM Private CA-hosted or on-premises root
#' or subordinate CA. Then import the signed certificate back into ACM
#' Private CA by calling the
#' [ImportCertificateAuthorityCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html)
#' action. The CSR is returned as a base64 PEM-encoded string.
#'
#' @usage
#' acmpca_get_certificate_authority_csr(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
#' action. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#'
#' @section Request syntax:
#' ```
#' svc$get_certificate_authority_csr(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_get_certificate_authority_csr
acmpca_get_certificate_authority_csr <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "GetCertificateAuthorityCsr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_certificate_authority_csr_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$get_certificate_authority_csr_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_certificate_authority_csr <- acmpca_get_certificate_authority_csr

#' Retrieves the resource-based policy attached to a private CA
#'
#' @description
#' Retrieves the resource-based policy attached to a private CA. If either
#' the private CA resource or the policy cannot be found, this action
#' returns a `ResourceNotFoundException`.
#' 
#' The policy can be attached or updated with
#' [PutPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_PutPolicy.html)
#' and removed with
#' [DeletePolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
#' 
#' **About Policies**
#' 
#' -   A policy grants access on a private CA to an AWS customer account,
#'     to AWS Organizations, or to an AWS Organizations unit. Policies are
#'     under the control of a CA administrator. For more information, see
#'     [Using a Resource Based Policy with ACM Private
#'     CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
#' 
#' -   A policy permits a user of AWS Certificate Manager (ACM) to issue
#'     ACM certificates signed by a CA in another account.
#' 
#' -   For ACM to manage automatic renewal of these certificates, the ACM
#'     user must configure a Service Linked Role (SLR). The SLR allows the
#'     ACM service to assume the identity of the user, subject to
#'     confirmation against the ACM Private CA policy. For more
#'     information, see [Using a Service Linked Role with
#'     ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
#' 
#' -   Updates made in AWS Resource Manager (RAM) are reflected in
#'     policies. For more information, see [Attach a Policy for
#'     Cross-Account
#'     Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
#'
#' @usage
#' acmpca_get_policy(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA that will have its
#' policy retrieved. You can find the CA's ARN by calling the
#' ListCertificateAuthorities action.
#'
#' @section Request syntax:
#' ```
#' svc$get_policy(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_get_policy
acmpca_get_policy <- function(ResourceArn) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$get_policy_input(ResourceArn = ResourceArn)
  output <- .acmpca$get_policy_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$get_policy <- acmpca_get_policy

#' Imports a signed private CA certificate into ACM Private CA
#'
#' @description
#' Imports a signed private CA certificate into ACM Private CA. This action
#' is used when you are using a chain of trust whose root is located
#' outside ACM Private CA. Before you can call this action, the following
#' preparations must in place:
#' 
#' 1.  In ACM Private CA, call the
#'     [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
#'     action to create the private CA that that you plan to back with the
#'     imported certificate.
#' 
#' 2.  Call the
#'     [GetCertificateAuthorityCsr](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificateAuthorityCsr.html)
#'     action to generate a certificate signing request (CSR).
#' 
#' 3.  Sign the CSR using a root or intermediate CA hosted by either an
#'     on-premises PKI hierarchy or by a commercial CA.
#' 
#' 4.  Create a certificate chain and copy the signed certificate and the
#'     certificate chain to your working directory.
#' 
#' ACM Private CA supports three scenarios for installing a CA certificate:
#' 
#' -   Installing a certificate for a root CA hosted by ACM Private CA.
#' 
#' -   Installing a subordinate CA certificate whose parent authority is
#'     hosted by ACM Private CA.
#' 
#' -   Installing a subordinate CA certificate whose parent authority is
#'     externally hosted.
#' 
#' The following addtitional requirements apply when you import a CA
#' certificate.
#' 
#' -   Only a self-signed certificate can be imported as a root CA.
#' 
#' -   A self-signed certificate cannot be imported as a subordinate CA.
#' 
#' -   Your certificate chain must not include the private CA certificate
#'     that you are importing.
#' 
#' -   Your root CA must be the last certificate in your chain. The
#'     subordinate certificate, if any, that your root CA signed must be
#'     next to last. The subordinate certificate signed by the preceding
#'     subordinate CA must come next, and so on until your chain is built.
#' 
#' -   The chain must be PEM-encoded.
#' 
#' -   The maximum allowed size of a certificate is 32 KB.
#' 
#' -   The maximum allowed size of a certificate chain is 2 MB.
#' 
#' *Enforcement of Critical Constraints*
#' 
#' ACM Private CA allows the following extensions to be marked critical in
#' the imported CA certificate or chain.
#' 
#' -   Basic constraints (*must* be marked critical)
#' 
#' -   Subject alternative names
#' 
#' -   Key usage
#' 
#' -   Extended key usage
#' 
#' -   Authority key identifier
#' 
#' -   Subject key identifier
#' 
#' -   Issuer alternative name
#' 
#' -   Subject directory attributes
#' 
#' -   Subject information access
#' 
#' -   Certificate policies
#' 
#' -   Policy mappings
#' 
#' -   Inhibit anyPolicy
#' 
#' ACM Private CA rejects the following extensions when they are marked
#' critical in an imported CA certificate or chain.
#' 
#' -   Name constraints
#' 
#' -   Policy constraints
#' 
#' -   CRL distribution points
#' 
#' -   Authority information access
#' 
#' -   Freshest CRL
#' 
#' -   Any other extension
#'
#' @usage
#' acmpca_import_certificate_authority_certificate(CertificateAuthorityArn,
#'   Certificate, CertificateChain)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Certificate &#91;required&#93; The PEM-encoded certificate for a private CA. This may be a self-signed
#' certificate in the case of a root CA, or it may be signed by another CA
#' that you control.
#' @param CertificateChain A PEM-encoded file that contains all of your certificates, other than
#' the certificate you're importing, chaining up to your root CA. Your ACM
#' Private CA-hosted or on-premises root certificate is the last in the
#' chain, and each certificate in the chain signs the one preceding.
#' 
#' This parameter must be supplied when you import a subordinate CA. When
#' you import a root CA, there is no chain.
#'
#' @section Request syntax:
#' ```
#' svc$import_certificate_authority_certificate(
#'   CertificateAuthorityArn = "string",
#'   Certificate = raw,
#'   CertificateChain = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_import_certificate_authority_certificate
acmpca_import_certificate_authority_certificate <- function(CertificateAuthorityArn, Certificate, CertificateChain = NULL) {
  op <- new_operation(
    name = "ImportCertificateAuthorityCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$import_certificate_authority_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, Certificate = Certificate, CertificateChain = CertificateChain)
  output <- .acmpca$import_certificate_authority_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$import_certificate_authority_certificate <- acmpca_import_certificate_authority_certificate

#' Uses your private certificate authority (CA), or one that has been
#' shared with you, to issue a client certificate
#'
#' @description
#' Uses your private certificate authority (CA), or one that has been
#' shared with you, to issue a client certificate. This action returns the
#' Amazon Resource Name (ARN) of the certificate. You can retrieve the
#' certificate by calling the
#' [GetCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html)
#' action and specifying the ARN.
#' 
#' You cannot use the ACM **ListCertificateAuthorities** action to retrieve
#' the ARNs of the certificates that you issue by using ACM Private CA.
#'
#' @usage
#' acmpca_issue_certificate(CertificateAuthorityArn, Csr, SigningAlgorithm,
#'   TemplateArn, Validity, IdempotencyToken)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Csr &#91;required&#93; The certificate signing request (CSR) for the certificate you want to
#' issue. You can use the following OpenSSL command to create the CSR and a
#' 2048 bit RSA private key.
#' 
#' `openssl req -new -newkey rsa:2048 -days 365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
#' 
#' If you have a configuration file, you can use the following OpenSSL
#' command. The `usr_cert` block in the configuration file contains your
#' X509 version 3 extensions.
#' 
#' `openssl req -new -config openssl_rsa.cnf -extensions usr_cert -newkey rsa:2048 -days -365 -keyout private/test_cert_priv_key.pem -out csr/test_cert_.csr`
#' 
#' Note: A CSR must provide either a *subject name* or a *subject
#' alternative name* or the request will be rejected.
#' @param SigningAlgorithm &#91;required&#93; The name of the algorithm that will be used to sign the certificate to
#' be issued.
#' 
#' This parameter should not be confused with the `SigningAlgorithm`
#' parameter used to sign a CSR.
#' @param TemplateArn Specifies a custom configuration template to use when issuing a
#' certificate. If this parameter is not provided, ACM Private CA defaults
#' to the `EndEntityCertificate/V1` template. For CA certificates, you
#' should choose the shortest path length that meets your needs. The path
#' length is indicated by the PathLen*N* portion of the ARN, where *N* is
#' the [CA
#' depth](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaTerms.html#terms-cadepth).
#' 
#' Note: The CA depth configured on a subordinate CA certificate must not
#' exceed the limit set by its parents in the CA hierarchy.
#' 
#' The following service-owned `TemplateArn` values are supported by ACM
#' Private CA:
#' 
#' -   arn:aws:acm-pca:::template/CodeSigningCertificate/V1
#' 
#' -   arn:aws:acm-pca:::template/CodeSigningCertificate\\_CSRPassthrough/V1
#' 
#' -   arn:aws:acm-pca:::template/EndEntityCertificate/V1
#' 
#' -   arn:aws:acm-pca:::template/EndEntityCertificate\\_CSRPassthrough/V1
#' 
#' -   arn:aws:acm-pca:::template/EndEntityClientAuthCertificate/V1
#' 
#' -   arn:aws:acm-pca:::template/EndEntityClientAuthCertificate\\_CSRPassthrough/V1
#' 
#' -   arn:aws:acm-pca:::template/EndEntityServerAuthCertificate/V1
#' 
#' -   arn:aws:acm-pca:::template/EndEntityServerAuthCertificate\\_CSRPassthrough/V1
#' 
#' -   arn:aws:acm-pca:::template/OCSPSigningCertificate/V1
#' 
#' -   arn:aws:acm-pca:::template/OCSPSigningCertificate\\_CSRPassthrough/V1
#' 
#' -   arn:aws:acm-pca:::template/RootCACertificate/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen0/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen1/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen2/V1
#' 
#' -   arn:aws:acm-pca:::template/SubordinateCACertificate\\_PathLen3/V1
#' 
#' For more information, see [Using
#' Templates](https://docs.aws.amazon.com/acm-pca/latest/userguide/UsingTemplates.html).
#' @param Validity &#91;required&#93; Information describing the validity period of the certificate.
#' 
#' When issuing a certificate, ACM Private CA sets the "Not Before" date in
#' the validity field to date and time minus 60 minutes. This is intended
#' to compensate for time inconsistencies across systems of 60 minutes or
#' less.
#' 
#' The validity period configured on a certificate must not exceed the
#' limit set by its parents in the CA hierarchy.
#' @param IdempotencyToken Custom string that can be used to distinguish between calls to the
#' **IssueCertificate** action. Idempotency tokens time out after one hour.
#' Therefore, if you call **IssueCertificate** multiple times with the same
#' idempotency token within 5 minutes, ACM Private CA recognizes that you
#' are requesting only one certificate and will issue only one. If you
#' change the idempotency token for each call, PCA recognizes that you are
#' requesting multiple certificates.
#'
#' @section Request syntax:
#' ```
#' svc$issue_certificate(
#'   CertificateAuthorityArn = "string",
#'   Csr = raw,
#'   SigningAlgorithm = "SHA256WITHECDSA"|"SHA384WITHECDSA"|"SHA512WITHECDSA"|"SHA256WITHRSA"|"SHA384WITHRSA"|"SHA512WITHRSA",
#'   TemplateArn = "string",
#'   Validity = list(
#'     Value = 123,
#'     Type = "END_DATE"|"ABSOLUTE"|"DAYS"|"MONTHS"|"YEARS"
#'   ),
#'   IdempotencyToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_issue_certificate
acmpca_issue_certificate <- function(CertificateAuthorityArn, Csr, SigningAlgorithm, TemplateArn = NULL, Validity, IdempotencyToken = NULL) {
  op <- new_operation(
    name = "IssueCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$issue_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, Csr = Csr, SigningAlgorithm = SigningAlgorithm, TemplateArn = TemplateArn, Validity = Validity, IdempotencyToken = IdempotencyToken)
  output <- .acmpca$issue_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$issue_certificate <- acmpca_issue_certificate

#' Lists the private certificate authorities that you created by using the
#' CreateCertificateAuthority action
#'
#' @description
#' Lists the private certificate authorities that you created by using the
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
#' action.
#'
#' @usage
#' acmpca_list_certificate_authorities(NextToken, MaxResults,
#'   ResourceOwner)
#'
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' the `NextToken` parameter from the response you just received.
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response on each page. If additional items
#' exist beyond the number you specify, the `NextToken` element is sent in
#' the response. Use this `NextToken` value in a subsequent request to
#' retrieve additional items.
#' @param ResourceOwner Use this parameter to filter the returned set of certificate authorities
#' based on their owner. The default is SELF.
#'
#' @section Request syntax:
#' ```
#' svc$list_certificate_authorities(
#'   NextToken = "string",
#'   MaxResults = 123,
#'   ResourceOwner = "SELF"|"OTHER_ACCOUNTS"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_list_certificate_authorities
acmpca_list_certificate_authorities <- function(NextToken = NULL, MaxResults = NULL, ResourceOwner = NULL) {
  op <- new_operation(
    name = "ListCertificateAuthorities",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$list_certificate_authorities_input(NextToken = NextToken, MaxResults = MaxResults, ResourceOwner = ResourceOwner)
  output <- .acmpca$list_certificate_authorities_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_certificate_authorities <- acmpca_list_certificate_authorities

#' List all permissions on a private CA, if any, granted to the AWS
#' Certificate Manager (ACM) service principal (acm
#'
#' @description
#' List all permissions on a private CA, if any, granted to the AWS
#' Certificate Manager (ACM) service principal (acm.amazonaws.com).
#' 
#' These permissions allow ACM to issue and renew ACM certificates that
#' reside in the same AWS account as the CA.
#' 
#' Permissions can be granted with the
#' [CreatePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreatePermission.html)
#' action and revoked with the
#' [DeletePermission](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePermission.html)
#' action.
#' 
#' **About Permissions**
#' 
#' -   If the private CA and the certificates it issues reside in the same
#'     account, you can use `CreatePermission` to grant permissions for ACM
#'     to carry out automatic certificate renewals.
#' 
#' -   For automatic certificate renewal to succeed, the ACM service
#'     principal needs permissions to create, retrieve, and list
#'     certificates.
#' 
#' -   If the private CA and the ACM certificates reside in different
#'     accounts, then permissions cannot be used to enable automatic
#'     renewals. Instead, the ACM certificate owner must set up a
#'     resource-based policy to enable cross-account issuance and renewals.
#'     For more information, see [Using a Resource Based Policy with ACM
#'     Private
#'     CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
#'
#' @usage
#' acmpca_list_permissions(CertificateAuthorityArn, NextToken, MaxResults)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA to inspect. You can
#' find the ARN by calling the
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' action. This must be of the form:
#' `arn:aws:acm-pca:region:account:certificate-authority/12345678-1234-1234-1234-123456789012`
#' You can get a private CA's ARN by running the
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' action.
#' @param NextToken When paginating results, use this parameter in a subsequent request
#' after you receive a response with truncated results. Set it to the value
#' of **NextToken** from the response you just received.
#' @param MaxResults When paginating results, use this parameter to specify the maximum
#' number of items to return in the response. If additional items exist
#' beyond the number you specify, the **NextToken** element is sent in the
#' response. Use this **NextToken** value in a subsequent request to
#' retrieve additional items.
#'
#' @section Request syntax:
#' ```
#' svc$list_permissions(
#'   CertificateAuthorityArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_list_permissions
acmpca_list_permissions <- function(CertificateAuthorityArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$list_permissions_input(CertificateAuthorityArn = CertificateAuthorityArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .acmpca$list_permissions_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_permissions <- acmpca_list_permissions

#' Lists the tags, if any, that are associated with your private CA or one
#' that has been shared with you
#'
#' @description
#' Lists the tags, if any, that are associated with your private CA or one
#' that has been shared with you. Tags are labels that you can use to
#' identify and organize your CAs. Each tag consists of a key and an
#' optional value. Call the
#' [TagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html)
#' action to add one or more tags to your CA. Call the
#' [UntagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html)
#' action to remove tags.
#'
#' @usage
#' acmpca_list_tags(CertificateAuthorityArn, NextToken, MaxResults)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
#' action. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param NextToken Use this parameter when paginating results in a subsequent request after
#' you receive a response with truncated results. Set it to the value of
#' **NextToken** from the response you just received.
#' @param MaxResults Use this parameter when paginating results to specify the maximum number
#' of items to return in the response. If additional items exist beyond the
#' number you specify, the **NextToken** element is sent in the response.
#' Use this **NextToken** value in a subsequent request to retrieve
#' additional items.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags(
#'   CertificateAuthorityArn = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_list_tags
acmpca_list_tags <- function(CertificateAuthorityArn, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$list_tags_input(CertificateAuthorityArn = CertificateAuthorityArn, NextToken = NextToken, MaxResults = MaxResults)
  output <- .acmpca$list_tags_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$list_tags <- acmpca_list_tags

#' Attaches a resource-based policy to a private CA
#'
#' @description
#' Attaches a resource-based policy to a private CA.
#' 
#' A policy can also be applied by sharing a private CA through AWS
#' Resource Access Manager (RAM). For more information, see [Attach a
#' Policy for Cross-Account
#' Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
#' 
#' The policy can be displayed with
#' [GetPolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetPolicy.html)
#' and removed with
#' [DeletePolicy](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeletePolicy.html).
#' 
#' **About Policies**
#' 
#' -   A policy grants access on a private CA to an AWS customer account,
#'     to AWS Organizations, or to an AWS Organizations unit. Policies are
#'     under the control of a CA administrator. For more information, see
#'     [Using a Resource Based Policy with ACM Private
#'     CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-rbp.html).
#' 
#' -   A policy permits a user of AWS Certificate Manager (ACM) to issue
#'     ACM certificates signed by a CA in another account.
#' 
#' -   For ACM to manage automatic renewal of these certificates, the ACM
#'     user must configure a Service Linked Role (SLR). The SLR allows the
#'     ACM service to assume the identity of the user, subject to
#'     confirmation against the ACM Private CA policy. For more
#'     information, see [Using a Service Linked Role with
#'     ACM](https://docs.aws.amazon.com/acm/latest/userguide/acm-slr.html).
#' 
#' -   Updates made in AWS Resource Manager (RAM) are reflected in
#'     policies. For more information, see [Attach a Policy for
#'     Cross-Account
#'     Access](https://docs.aws.amazon.com/acm-pca/latest/userguide/pca-ram.html).
#'
#' @usage
#' acmpca_put_policy(ResourceArn, Policy)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Number (ARN) of the private CA to associate with the
#' policy. The ARN of the CA can be found by calling the
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' action.
#' @param Policy &#91;required&#93; The path and filename of a JSON-formatted IAM policy to attach to the
#' specified private CA resource. If this policy does not contain all
#' required statements or if it includes any statement that is not allowed,
#' the `PutPolicy` action returns an `InvalidPolicyException`. For
#' information about IAM policy and statement structure, see [Overview of
#' JSON
#' Policies](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_policies.html#access_policies-json).
#'
#' @section Request syntax:
#' ```
#' svc$put_policy(
#'   ResourceArn = "string",
#'   Policy = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_put_policy
acmpca_put_policy <- function(ResourceArn, Policy) {
  op <- new_operation(
    name = "PutPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$put_policy_input(ResourceArn = ResourceArn, Policy = Policy)
  output <- .acmpca$put_policy_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$put_policy <- acmpca_put_policy

#' Restores a certificate authority (CA) that is in the DELETED state
#'
#' @description
#' Restores a certificate authority (CA) that is in the `DELETED` state.
#' You can restore a CA during the period that you defined in the
#' **PermanentDeletionTimeInDays** parameter of the
#' [DeleteCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DeleteCertificateAuthority.html)
#' action. Currently, you can specify 7 to 30 days. If you did not specify
#' a **PermanentDeletionTimeInDays** value, by default you can restore the
#' CA at any time in a 30 day period. You can check the time remaining in
#' the restoration period of a private CA in the `DELETED` state by calling
#' the
#' [DescribeCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_DescribeCertificateAuthority.html)
#' or
#' [ListCertificateAuthorities](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListCertificateAuthorities.html)
#' actions. The status of a restored CA is set to its pre-deletion status
#' when the **RestoreCertificateAuthority** action returns. To change its
#' status to `ACTIVE`, call the
#' [UpdateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UpdateCertificateAuthority.html)
#' action. If the private CA was in the `PENDING_CERTIFICATE` state at
#' deletion, you must use the
#' [ImportCertificateAuthorityCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ImportCertificateAuthorityCertificate.html)
#' action to import a certificate authority into the private CA before it
#' can be activated. You cannot restore a CA after the restoration period
#' has ended.
#'
#' @usage
#' acmpca_restore_certificate_authority(CertificateAuthorityArn)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called the
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html)
#' action. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#'
#' @section Request syntax:
#' ```
#' svc$restore_certificate_authority(
#'   CertificateAuthorityArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_restore_certificate_authority
acmpca_restore_certificate_authority <- function(CertificateAuthorityArn) {
  op <- new_operation(
    name = "RestoreCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$restore_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn)
  output <- .acmpca$restore_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$restore_certificate_authority <- acmpca_restore_certificate_authority

#' Revokes a certificate that was issued inside ACM Private CA
#'
#' @description
#' Revokes a certificate that was issued inside ACM Private CA. If you
#' enable a certificate revocation list (CRL) when you create or update
#' your private CA, information about the revoked certificates will be
#' included in the CRL. ACM Private CA writes the CRL to an S3 bucket that
#' you specify. A CRL is typically updated approximately 30 minutes after a
#' certificate is revoked. If for any reason the CRL update fails, ACM
#' Private CA attempts makes further attempts every 15 minutes. With Amazon
#' CloudWatch, you can create alarms for the metrics `CRLGenerated` and
#' `MisconfiguredCRLBucket`. For more information, see [Supported
#' CloudWatch
#' Metrics](https://docs.aws.amazon.com/acm-pca/latest/userguide/PcaCloudWatch.html).
#' 
#' Both PCA and the IAM principal must have permission to write to the S3
#' bucket that you specify. If the IAM principal making the call does not
#' have permission to write to the bucket, then an exception is thrown. For
#' more information, see [Configure Access to ACM Private
#' CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/).
#' 
#' ACM Private CA also writes revocation information to the audit report.
#' For more information, see
#' [CreateCertificateAuthorityAuditReport](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthorityAuditReport.html).
#' 
#' You cannot revoke a root CA self-signed certificate.
#'
#' @usage
#' acmpca_revoke_certificate(CertificateAuthorityArn, CertificateSerial,
#'   RevocationReason)
#'
#' @param CertificateAuthorityArn &#91;required&#93; Amazon Resource Name (ARN) of the private CA that issued the certificate
#' to be revoked. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param CertificateSerial &#91;required&#93; Serial number of the certificate to be revoked. This must be in
#' hexadecimal format. You can retrieve the serial number by calling
#' [GetCertificate](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_GetCertificate.html)
#' with the Amazon Resource Name (ARN) of the certificate you want and the
#' ARN of your private CA. The **GetCertificate** action retrieves the
#' certificate in the PEM format. You can use the following OpenSSL command
#' to list the certificate in text format and copy the hexadecimal serial
#' number.
#' 
#' `openssl x509 -in <i>file_path</i> -text -noout`
#' 
#' You can also copy the serial number from the console or use the
#' [DescribeCertificate](https://docs.aws.amazon.com/acm/latest/APIReference/API_DescribeCertificate.html)
#' action in the *AWS Certificate Manager API Reference*.
#' @param RevocationReason &#91;required&#93; Specifies why you revoked the certificate.
#'
#' @section Request syntax:
#' ```
#' svc$revoke_certificate(
#'   CertificateAuthorityArn = "string",
#'   CertificateSerial = "string",
#'   RevocationReason = "UNSPECIFIED"|"KEY_COMPROMISE"|"CERTIFICATE_AUTHORITY_COMPROMISE"|"AFFILIATION_CHANGED"|"SUPERSEDED"|"CESSATION_OF_OPERATION"|"PRIVILEGE_WITHDRAWN"|"A_A_COMPROMISE"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_revoke_certificate
acmpca_revoke_certificate <- function(CertificateAuthorityArn, CertificateSerial, RevocationReason) {
  op <- new_operation(
    name = "RevokeCertificate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$revoke_certificate_input(CertificateAuthorityArn = CertificateAuthorityArn, CertificateSerial = CertificateSerial, RevocationReason = RevocationReason)
  output <- .acmpca$revoke_certificate_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$revoke_certificate <- acmpca_revoke_certificate

#' Adds one or more tags to your private CA
#'
#' @description
#' Adds one or more tags to your private CA. Tags are labels that you can
#' use to identify and organize your AWS resources. Each tag consists of a
#' key and an optional value. You specify the private CA on input by its
#' Amazon Resource Name (ARN). You specify the tag by using a key-value
#' pair. You can apply a tag to just one private CA if you want to identify
#' a specific characteristic of that CA, or you can apply the same tag to
#' multiple private CAs if you want to filter for a common relationship
#' among those CAs. To remove one or more tags, use the
#' [UntagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_UntagCertificateAuthority.html)
#' action. Call the
#' [ListTags](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html)
#' action to see what tags are associated with your CA.
#'
#' @usage
#' acmpca_tag_certificate_authority(CertificateAuthorityArn, Tags)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Tags &#91;required&#93; List of tags to be associated with the CA.
#'
#' @section Request syntax:
#' ```
#' svc$tag_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_tag_certificate_authority
acmpca_tag_certificate_authority <- function(CertificateAuthorityArn, Tags) {
  op <- new_operation(
    name = "TagCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$tag_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags)
  output <- .acmpca$tag_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$tag_certificate_authority <- acmpca_tag_certificate_authority

#' Remove one or more tags from your private CA
#'
#' @description
#' Remove one or more tags from your private CA. A tag consists of a
#' key-value pair. If you do not specify the value portion of the tag when
#' calling this action, the tag will be removed regardless of value. If you
#' specify a value, the tag is removed only if it is associated with the
#' specified value. To add tags to a private CA, use the
#' [TagCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_TagCertificateAuthority.html).
#' Call the
#' [ListTags](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_ListTags.html)
#' action to see what tags are associated with your CA.
#'
#' @usage
#' acmpca_untag_certificate_authority(CertificateAuthorityArn, Tags)
#'
#' @param CertificateAuthorityArn &#91;required&#93; The Amazon Resource Name (ARN) that was returned when you called
#' [CreateCertificateAuthority](https://docs.aws.amazon.com/acm-pca/latest/APIReference/API_CreateCertificateAuthority.html).
#' This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param Tags &#91;required&#93; List of tags to be removed from the CA.
#'
#' @section Request syntax:
#' ```
#' svc$untag_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_untag_certificate_authority
acmpca_untag_certificate_authority <- function(CertificateAuthorityArn, Tags) {
  op <- new_operation(
    name = "UntagCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$untag_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, Tags = Tags)
  output <- .acmpca$untag_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$untag_certificate_authority <- acmpca_untag_certificate_authority

#' Updates the status or configuration of a private certificate authority
#' (CA)
#'
#' @description
#' Updates the status or configuration of a private certificate authority
#' (CA). Your private CA must be in the `ACTIVE` or `DISABLED` state before
#' you can update it. You can disable a private CA that is in the `ACTIVE`
#' state or make a CA that is in the `DISABLED` state active again.
#' 
#' Both PCA and the IAM principal must have permission to write to the S3
#' bucket that you specify. If the IAM principal making the call does not
#' have permission to write to the bucket, then an exception is thrown. For
#' more information, see [Configure Access to ACM Private
#' CA](https://docs.aws.amazon.com/acm-pca/latest/userguide/).
#'
#' @usage
#' acmpca_update_certificate_authority(CertificateAuthorityArn,
#'   RevocationConfiguration, Status)
#'
#' @param CertificateAuthorityArn &#91;required&#93; Amazon Resource Name (ARN) of the private CA that issued the certificate
#' to be revoked. This must be of the form:
#' 
#' `arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> `
#' @param RevocationConfiguration Revocation information for your private CA.
#' @param Status Status of your private CA.
#'
#' @section Request syntax:
#' ```
#' svc$update_certificate_authority(
#'   CertificateAuthorityArn = "string",
#'   RevocationConfiguration = list(
#'     CrlConfiguration = list(
#'       Enabled = TRUE|FALSE,
#'       ExpirationInDays = 123,
#'       CustomCname = "string",
#'       S3BucketName = "string"
#'     )
#'   ),
#'   Status = "CREATING"|"PENDING_CERTIFICATE"|"ACTIVE"|"DELETED"|"DISABLED"|"EXPIRED"|"FAILED"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname acmpca_update_certificate_authority
acmpca_update_certificate_authority <- function(CertificateAuthorityArn, RevocationConfiguration = NULL, Status = NULL) {
  op <- new_operation(
    name = "UpdateCertificateAuthority",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .acmpca$update_certificate_authority_input(CertificateAuthorityArn = CertificateAuthorityArn, RevocationConfiguration = RevocationConfiguration, Status = Status)
  output <- .acmpca$update_certificate_authority_output()
  config <- get_config()
  svc <- .acmpca$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.acmpca$operations$update_certificate_authority <- acmpca_update_certificate_authority
