% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clouddirectory_operations.R
\name{clouddirectory_detach_object}
\alias{clouddirectory_detach_object}
\title{Detaches a given object from the parent object}
\usage{
clouddirectory_detach_object(DirectoryArn, ParentReference, LinkName)
}
\arguments{
\item{DirectoryArn}{[required] The Amazon Resource Name (ARN) that is associated with the Directory
where objects reside. For more information, see arns.}

\item{ParentReference}{[required] The parent reference from which the object with the specified link name
is detached.}

\item{LinkName}{[required] The link name associated with the object that needs to be detached.}
}
\value{
A list with the following syntax:\preformatted{list(
  DetachedObjectIdentifier = "string"
)
}
}
\description{
Detaches a given object from the parent object. The object that is to be
detached from the parent is specified by the link name.
}
\section{Request syntax}{
\preformatted{svc$detach_object(
  DirectoryArn = "string",
  ParentReference = list(
    Selector = "string"
  ),
  LinkName = "string"
)
}
}

\keyword{internal}
