% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directoryservice_operations.R
\name{directoryservice_describe_trusts}
\alias{directoryservice_describe_trusts}
\title{Obtains information about the trust relationships for this account}
\usage{
directoryservice_describe_trusts(DirectoryId, TrustIds, NextToken,
  Limit)
}
\arguments{
\item{DirectoryId}{The Directory ID of the AWS directory that is a part of the requested
trust relationship.}

\item{TrustIds}{A list of identifiers of the trust relationships for which to obtain the
information. If this member is null, all trust relationships that belong
to the current account are returned.

An empty list results in an \code{InvalidParameterException} being thrown.}

\item{NextToken}{The \emph{DescribeTrustsResult.NextToken} value from a previous call to
\code{\link[=directoryservice_describe_trusts]{describe_trusts}}. Pass null if this
is the first call.}

\item{Limit}{The maximum number of objects to return.}
}
\value{
A list with the following syntax:\preformatted{list(
  Trusts = list(
    list(
      DirectoryId = "string",
      TrustId = "string",
      RemoteDomainName = "string",
      TrustType = "Forest"|"External",
      TrustDirection = "One-Way: Outgoing"|"One-Way: Incoming"|"Two-Way",
      TrustState = "Creating"|"Created"|"Verifying"|"VerifyFailed"|"Verified"|"Updating"|"UpdateFailed"|"Updated"|"Deleting"|"Deleted"|"Failed",
      CreatedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      LastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      StateLastUpdatedDateTime = as.POSIXct(
        "2015-01-01"
      ),
      TrustStateReason = "string",
      SelectiveAuth = "Enabled"|"Disabled"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Obtains information about the trust relationships for this account.

If no input parameters are provided, such as DirectoryId or TrustIds,
this request describes all the trust relationships belonging to the
account.
}
\section{Request syntax}{
\preformatted{svc$describe_trusts(
  DirectoryId = "string",
  TrustIds = list(
    "string"
  ),
  NextToken = "string",
  Limit = 123
)
}
}

\keyword{internal}
