% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/guardduty_operations.R
\name{guardduty_create_detector}
\alias{guardduty_create_detector}
\title{Creates a single Amazon GuardDuty detector}
\usage{
guardduty_create_detector(Enable, ClientToken,
  FindingPublishingFrequency, DataSources, Tags)
}
\arguments{
\item{Enable}{[required] A Boolean value that specifies whether the detector is to be enabled.}

\item{ClientToken}{The idempotency token for the create request.}

\item{FindingPublishingFrequency}{A value that specifies how frequently updated findings are exported.}

\item{DataSources}{Describes which data sources will be enabled for the detector.}

\item{Tags}{The tags to be added to a new detector resource.}
}
\value{
A list with the following syntax:\preformatted{list(
  DetectorId = "string"
)
}
}
\description{
Creates a single Amazon GuardDuty detector. A detector is a resource
that represents the GuardDuty service. To start using GuardDuty, you
must create a detector in each Region where you enable the service. You
can have only one detector per account per Region. All data sources are
enabled in a new detector by default.
}
\section{Request syntax}{
\preformatted{svc$create_detector(
  Enable = TRUE|FALSE,
  ClientToken = "string",
  FindingPublishingFrequency = "FIFTEEN_MINUTES"|"ONE_HOUR"|"SIX_HOURS",
  DataSources = list(
    S3Logs = list(
      Enable = TRUE|FALSE
    )
  ),
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
