% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_instance_profile}
\alias{iam_create_instance_profile}
\title{Creates a new instance profile}
\usage{
iam_create_instance_profile(InstanceProfileName, Path)
}
\arguments{
\item{InstanceProfileName}{[required] The name of the instance profile to create.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: _+=,.@-}

\item{Path}{The path to the instance profile. For more information about paths, see
\href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_identifiers.html}{IAM Identifiers}
in the \emph{IAM User Guide}.

This parameter is optional. If it is not included, it defaults to a
slash (/).

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of either a forward slash (/) by itself or a string that must
begin and end with forward slashes. In addition, it can contain any
ASCII character from the ! (\verb{\\u0021}) through the DEL character
(\verb{\\u007F}), including most punctuation characters, digits, and upper and
lowercased letters.}
}
\value{
A list with the following syntax:\preformatted{list(
  InstanceProfile = list(
    Path = "string",
    InstanceProfileName = "string",
    InstanceProfileId = "string",
    Arn = "string",
    CreateDate = as.POSIXct(
      "2015-01-01"
    ),
    Roles = list(
      list(
        Path = "string",
        RoleName = "string",
        RoleId = "string",
        Arn = "string",
        CreateDate = as.POSIXct(
          "2015-01-01"
        ),
        AssumeRolePolicyDocument = "string",
        Description = "string",
        MaxSessionDuration = 123,
        PermissionsBoundary = list(
          PermissionsBoundaryType = "PermissionsBoundaryPolicy",
          PermissionsBoundaryArn = "string"
        ),
        Tags = list(
          list(
            Key = "string",
            Value = "string"
          )
        ),
        RoleLastUsed = list(
          LastUsedDate = as.POSIXct(
            "2015-01-01"
          ),
          Region = "string"
        )
      )
    )
  )
)
}
}
\description{
Creates a new instance profile. For information about instance profiles,
go to \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_use_switch-role-ec2_instance-profiles.html}{About Instance Profiles}.

The number and size of IAM resources in an AWS account are limited. For
more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_iam-quotas.html}{IAM and STS Quotas}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_instance_profile(
  InstanceProfileName = "string",
  Path = "string"
)
}
}

\examples{
\dontrun{
# The following command creates an instance profile named Webserver that
# is ready to have a role attached and then be associated with an EC2
# instance.
svc$create_instance_profile(
  InstanceProfileName = "Webserver"
)
}

}
\keyword{internal}
