% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shield_operations.R
\name{shield_associate_health_check}
\alias{shield_associate_health_check}
\title{Adds health-based detection to the Shield Advanced protection for a
resource}
\usage{
shield_associate_health_check(ProtectionId, HealthCheckArn)
}
\arguments{
\item{ProtectionId}{[required] The unique identifier (ID) for the Protection object to add the health
check association to.}

\item{HealthCheckArn}{[required] The Amazon Resource Name (ARN) of the health check to associate with the
protection.}
}
\value{
An empty list.
}
\description{
Adds health-based detection to the Shield Advanced protection for a
resource. Shield Advanced health-based detection uses the health of your
AWS resource to improve responsiveness and accuracy in attack detection
and mitigation.

You define the health check in Route 53 and then associate it with your
Shield Advanced protection. For more information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/ddos-overview.html#ddos-advanced-health-check-option}{Shield Advanced Health-Based Detection}
in the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF and AWS Shield Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$associate_health_check(
  ProtectionId = "string",
  HealthCheckArn = "string"
)
}
}

\keyword{internal}
